/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.PropertySource;
import net.sourceforge.pmd.util.CollectionUtil;

public abstract class AbstractPropertySource
implements PropertySource {
    protected List<PropertyDescriptor<?>> propertyDescriptors = new ArrayList();
    protected Map<PropertyDescriptor<?>, Object> propertyValuesByDescriptor = new HashMap();

    protected List<PropertyDescriptor<?>> copyPropertyDescriptors() {
        return new ArrayList(this.propertyDescriptors);
    }

    protected Map<PropertyDescriptor<?>, Object> copyPropertyValues() {
        return new HashMap(this.propertyValuesByDescriptor);
    }

    @Override
    public Set<PropertyDescriptor<?>> ignoredProperties() {
        return Collections.emptySet();
    }

    @Override
    public void definePropertyDescriptor(PropertyDescriptor<?> propertyDescriptor) {
        for (PropertyDescriptor<?> descriptor : this.propertyDescriptors) {
            if (!descriptor.name().equals(propertyDescriptor.name())) continue;
            throw new IllegalArgumentException("There is already a PropertyDescriptor with name '" + propertyDescriptor.name() + "' defined on Rule " + this.getName() + ".");
        }
        this.propertyDescriptors.add(propertyDescriptor);
        Collections.sort(this.propertyDescriptors);
    }

    public abstract String getName();

    @Override
    public PropertyDescriptor<?> getPropertyDescriptor(String name) {
        for (PropertyDescriptor<?> propertyDescriptor : this.propertyDescriptors) {
            if (!name.equals(propertyDescriptor.name())) continue;
            return propertyDescriptor;
        }
        return null;
    }

    @Override
    public boolean hasDescriptor(PropertyDescriptor<?> descriptor) {
        if (this.propertyValuesByDescriptor.isEmpty()) {
            this.propertyValuesByDescriptor = this.getPropertiesByPropertyDescriptor();
        }
        return this.propertyValuesByDescriptor.containsKey(descriptor);
    }

    @Override
    public List<PropertyDescriptor<?>> getPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    @Override
    public <T> T getProperty(PropertyDescriptor<T> propertyDescriptor) {
        this.checkValidPropertyDescriptor(propertyDescriptor);
        Object result = propertyDescriptor.defaultValue();
        if (this.propertyValuesByDescriptor.containsKey(propertyDescriptor)) {
            Object value = this.propertyValuesByDescriptor.get(propertyDescriptor);
            result = value;
        }
        return result;
    }

    @Override
    public <T> void setProperty(PropertyDescriptor<T> propertyDescriptor, T value) {
        this.checkValidPropertyDescriptor(propertyDescriptor);
        this.propertyValuesByDescriptor.put(propertyDescriptor, value);
    }

    private void checkValidPropertyDescriptor(PropertyDescriptor<?> propertyDescriptor) {
        if (!this.propertyDescriptors.contains(propertyDescriptor)) {
            throw new IllegalArgumentException("Property descriptor not defined for Rule " + this.getName() + ": " + propertyDescriptor);
        }
    }

    @Override
    public Map<PropertyDescriptor<?>, Object> getPropertiesByPropertyDescriptor() {
        if (this.propertyDescriptors.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap propertiesByPropertyDescriptor = new HashMap(this.propertyDescriptors.size());
        propertiesByPropertyDescriptor.putAll(this.propertyValuesByDescriptor);
        for (PropertyDescriptor<?> propertyDescriptor : this.propertyDescriptors) {
            if (propertiesByPropertyDescriptor.containsKey(propertyDescriptor)) continue;
            propertiesByPropertyDescriptor.put(propertyDescriptor, propertyDescriptor.defaultValue());
        }
        return propertiesByPropertyDescriptor;
    }

    @Override
    public boolean usesDefaultValues() {
        Map<PropertyDescriptor<?>, Object> valuesByProperty = this.getPropertiesByPropertyDescriptor();
        if (valuesByProperty.isEmpty()) {
            return true;
        }
        for (Map.Entry<PropertyDescriptor<?>, Object> entry : valuesByProperty.entrySet()) {
            if (CollectionUtil.areEqual(entry.getKey().defaultValue(), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void useDefaultValueFor(PropertyDescriptor<?> desc) {
        this.propertyValuesByDescriptor.remove(desc);
    }

    @Override
    public String dysfunctionReason() {
        return null;
    }
}

