/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.framework.commons;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateTimeHelper {
    private Calendar __calendar = Calendar.getInstance();

    public static DateTimeHelper bind(Date date) {
        return new DateTimeHelper(date);
    }

    public static DateTimeHelper bind(long date) {
        return new DateTimeHelper(date);
    }

    public static DateTimeHelper bind(String dateStr, String dateFormat) throws ParseException {
        return new DateTimeHelper(dateStr, dateFormat);
    }

    public static DateTimeHelper now() {
        return new DateTimeHelper();
    }

    private DateTimeHelper() {
    }

    private DateTimeHelper(Date date) {
        this.__calendar.setTime(date);
    }

    private DateTimeHelper(long date) {
        if (String.valueOf(date).length() <= 10) {
            date *= 1000L;
        }
        this.__calendar.setTimeInMillis(date);
    }

    private DateTimeHelper(String dateStr, String dateFormat) throws ParseException {
        this.__calendar.setTime(new SimpleDateFormat(dateFormat).parse(dateStr));
    }

    private DateTimeHelper(int year, int month, int day) {
        this.__calendar.set(year, month - 1, day);
    }

    private DateTimeHelper(int year, int month, int day, int hour, int minute, int second) {
        this.__calendar.set(year, month - 1, day, hour, minute, second);
    }

    public DateTimeHelper timeZone(TimeZone timeZone) {
        this.__calendar.setTimeZone(timeZone);
        return this;
    }

    public TimeZone timeZone() {
        return this.__calendar.getTimeZone();
    }

    public Date time() {
        return this.__calendar.getTime();
    }

    public DateTimeHelper time(Date date) {
        this.__calendar.setTime(date);
        return this;
    }

    public int year() {
        return this.__calendar.get(1);
    }

    public DateTimeHelper year(int year) {
        this.__calendar.set(1, year);
        return this;
    }

    public int month() {
        return this.__calendar.get(2) + 1;
    }

    public DateTimeHelper month(int month) {
        this.__calendar.set(2, month - 1);
        return this;
    }

    public int day() {
        return this.__calendar.get(5);
    }

    public DateTimeHelper day(int day) {
        this.__calendar.set(5, day);
        return this;
    }

    public int hour() {
        return this.__calendar.get(11);
    }

    public DateTimeHelper hour(int hour) {
        this.__calendar.set(11, hour);
        return this;
    }

    public int minute() {
        return this.__calendar.get(12);
    }

    public DateTimeHelper minute(int minute) {
        this.__calendar.set(12, minute);
        return this;
    }

    public int second() {
        return this.__calendar.get(13);
    }

    public DateTimeHelper second(int second) {
        this.__calendar.set(13, second);
        return this;
    }

    public int dayOfWeek() {
        return this.__calendar.get(7) - 1;
    }

    public int weekOfMonth() {
        return this.__calendar.get(4);
    }

    public int weekOfYear() {
        return this.__calendar.get(3);
    }

    public int dayOfWeekInMonth() {
        return this.__calendar.get(8);
    }

    public long timeMillis() {
        return this.__calendar.getTimeInMillis();
    }

    public DateTimeHelper timeMillis(long timeMillis) {
        this.__calendar.setTimeInMillis(timeMillis);
        return this;
    }

    public int timeUTC() {
        return (int)(this.timeMillis() / 1000L);
    }

    public DateTimeHelper timeUTC(long timeUTC) {
        if (String.valueOf(timeUTC).length() <= 10) {
            timeUTC *= 1000L;
        }
        this.__calendar.setTimeInMillis(timeUTC);
        return this;
    }

    public int daysOfMonth() {
        return this.__calendar.getActualMaximum(5);
    }

    public long subtract(Date date) {
        return this.__calendar.getTimeInMillis() - date.getTime();
    }

    public long subtract(DateTimeHelper dateTimeHelper) {
        return this.subtract(dateTimeHelper.time());
    }

    public DateTimeHelper secondsAdd(int seconds) {
        this.__calendar.add(13, seconds);
        return this;
    }

    public DateTimeHelper minutesAdd(int minutes) {
        this.__calendar.add(12, minutes);
        return this;
    }

    public DateTimeHelper hoursAdd(int hours) {
        this.__calendar.add(10, hours);
        return this;
    }

    public DateTimeHelper daysAdd(int days) {
        this.__calendar.add(5, days);
        return this;
    }

    public DateTimeHelper weeksAdd(int weeks) {
        this.__calendar.add(4, weeks);
        return this;
    }

    public DateTimeHelper monthsAdd(int months) {
        this.__calendar.add(2, months);
        return this;
    }

    public DateTimeHelper yearsAdd(int years) {
        this.__calendar.add(1, years);
        return this;
    }

    public String toString() {
        return this.toString("yyyy-MM-dd HH:mm:ss.SSS");
    }

    public String toString(String dateFormat) {
        SimpleDateFormat fmt = new SimpleDateFormat(dateFormat);
        fmt.setTimeZone(this.__calendar.getTimeZone());
        return fmt.format(this.__calendar.getTime());
    }
}

