/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.framework.commons;

import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class GeoUtils {
    private static final double EARTH_RADIUS = 6378.137;

    private static double __rad(double d) {
        return d * Math.PI / 180.0;
    }

    public static double distance(Point p1, Point p2) {
        double _lat1 = GeoUtils.__rad(p1.getLatitude());
        double _lat2 = GeoUtils.__rad(p2.getLatitude());
        return Math.round(2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin((_lat1 - _lat2) / 2.0), 2.0) + Math.cos(_lat1) * Math.cos(_lat2) * Math.pow(Math.sin((GeoUtils.__rad(p1.getLongitude()) - GeoUtils.__rad(p2.getLongitude())) / 2.0), 2.0))) * 6378.137 * 10000.0) / 10L;
    }

    public static Bounds rectangle(Point point, long distance) {
        if (point == null || distance <= 0L) {
            return new Bounds();
        }
        float _delta = 111000.0f;
        if (point.getLatitude() != 0.0 && point.getLongitude() != 0.0) {
            double lng1 = point.getLongitude() - (double)distance / Math.abs(Math.cos(Math.toRadians(point.getLatitude())) * (double)_delta);
            double lng2 = point.getLongitude() + (double)distance / Math.abs(Math.cos(Math.toRadians(point.getLatitude())) * (double)_delta);
            double lat1 = point.getLatitude() - (double)((float)distance / _delta);
            double lat2 = point.getLatitude() + (double)((float)distance / _delta);
            return new Bounds(new Point(lng1, lat1), new Point(lng2, lat2));
        }
        double lng1 = point.getLongitude() - (double)((float)distance / _delta);
        double lng2 = point.getLongitude() + (double)((float)distance / _delta);
        double lat1 = point.getLatitude() - (double)((float)distance / _delta);
        double lat2 = point.getLatitude() + (double)((float)distance / _delta);
        return new Bounds(new Point(lng1, lat1), new Point(lng2, lat2));
    }

    public static class Bounds {
        private Point southWest;
        private Point northEast;

        public Bounds() {
        }

        public Bounds(Bounds first, Bounds other) {
            if (first == null || first.isEmpty() || other == null || other.isEmpty()) {
                throw new NullArgumentException("bounds");
            }
            this.southWest = new Point(Math.min(first.southWest.getLongitude(), other.southWest.getLongitude()), Math.min(first.southWest.getLatitude(), other.southWest.getLatitude()));
            this.northEast = new Point(Math.max(first.northEast.getLongitude(), other.northEast.getLongitude()), Math.max(first.northEast.getLatitude(), other.northEast.getLatitude()));
        }

        public Bounds(Point southWest, Point northEast) {
            this.southWest = southWest;
            this.northEast = northEast;
        }

        public Point getSouthWest() {
            return this.southWest;
        }

        public void setSouthWest(Point southWest) {
            this.southWest = southWest;
        }

        public Point getNorthEast() {
            return this.northEast;
        }

        public void setNorthEast(Point northEast) {
            this.northEast = northEast;
        }

        public Point getCenter() {
            return new Point((this.southWest.getLongitude() + this.northEast.getLongitude()) / 2.0, (this.southWest.getLatitude() + this.northEast.getLatitude()) / 2.0);
        }

        public boolean isEmpty() {
            return this.southWest == null || this.northEast == null;
        }

        public boolean containsPoint(Point point) {
            return !this.isEmpty() && point.getLongitude() >= this.southWest.getLongitude() && point.getLongitude() <= this.northEast.getLongitude() && point.getLatitude() >= this.southWest.getLatitude() && point.getLatitude() <= this.northEast.getLatitude();
        }

        public boolean containsBounds(Bounds bounds) {
            return this.containsPoint(bounds.getSouthWest()) && this.containsPoint(bounds.getNorthEast());
        }

        public Bounds intersects(Bounds bounds) {
            if (bounds != null && !bounds.isEmpty() && !this.isEmpty()) {
                double _y2;
                Bounds _merged = new Bounds(this, bounds);
                double _x1 = this.southWest.getLongitude() == _merged.southWest.getLongitude() ? bounds.southWest.getLongitude() : this.southWest.getLongitude();
                double _y1 = this.southWest.getLatitude() == _merged.southWest.getLatitude() ? bounds.southWest.getLatitude() : this.southWest.getLatitude();
                double _x2 = this.northEast.getLongitude() == _merged.northEast.getLongitude() ? bounds.northEast.getLongitude() : this.northEast.getLongitude();
                double d = _y2 = this.northEast.getLatitude() == _merged.northEast.getLatitude() ? bounds.northEast.getLatitude() : this.northEast.getLatitude();
                if (_x1 < _x2 && _y1 < _y2) {
                    return new Bounds(new Point(_x1, _y1), new Point(_x2, _y2));
                }
            }
            return new Bounds();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bounds bounds = (Bounds)o;
            return new EqualsBuilder().append((Object)this.southWest, (Object)bounds.southWest).append((Object)this.northEast, (Object)bounds.northEast).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.southWest).append((Object)this.northEast).toHashCode();
        }

        public String toString() {
            return "Bounds{southWest=" + this.southWest + ", northEast=" + this.northEast + '}';
        }
    }

    public static class Point {
        private double longitude;
        private double latitude;

        public Point(double longitude, double latitude) {
            this.longitude = longitude;
            this.latitude = latitude;
        }

        public double getLongitude() {
            return this.longitude;
        }

        public void setLongitude(double longitude) {
            this.longitude = longitude;
        }

        public double getLatitude() {
            return this.latitude;
        }

        public void setLatitude(double latitude) {
            this.latitude = latitude;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Point point = (Point)o;
            return new EqualsBuilder().append(this.longitude, point.longitude).append(this.latitude, point.latitude).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append(this.longitude).append(this.latitude).toHashCode();
        }

        public String toString() {
            return "Point{longitude=" + this.longitude + ", latitude=" + this.latitude + '}';
        }
    }
}

