/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.framework.commons;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.ymate.framework.commons.IFileHandler;
import net.ymate.framework.commons.IFileWrapper;
import net.ymate.framework.commons.IHttpResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;

public class HttpClientHelper {
    private static final Log _LOG = LogFactory.getLog(HttpClientHelper.class);
    public static final String DEFAULT_CHARSET = "UTF-8";
    private int __connectionTimeout = -1;
    private int __requestTimeout = -1;
    private int __socketTimeout = -1;
    private SSLConnectionSocketFactory __socketFactory;

    public static HttpClientHelper create() {
        return new HttpClientHelper();
    }

    private HttpClientHelper() {
    }

    public HttpClientHelper customSSL(SSLConnectionSocketFactory socketFactory) {
        this.__socketFactory = socketFactory;
        return this;
    }

    public HttpClientHelper connectionTimeout(int connectionTimeout) {
        this.__connectionTimeout = connectionTimeout;
        return this;
    }

    public HttpClientHelper requestTimeout(int requestTimeout) {
        this.__requestTimeout = requestTimeout;
        return this;
    }

    public HttpClientHelper socketTimeout(int socketTimeout) {
        this.__socketTimeout = socketTimeout;
        return this;
    }

    private CloseableHttpClient __doBuildHttpClient() throws KeyManagementException, NoSuchAlgorithmException {
        HttpClientBuilder _builder = HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(this.__connectionTimeout).setSocketTimeout(this.__socketTimeout).setConnectionRequestTimeout(this.__requestTimeout).build());
        if (this.__socketFactory == null) {
            this.__socketFactory = new SSLConnectionSocketFactory(SSLContexts.custom().useSSL().build(), SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        }
        return _builder.setSSLSocketFactory((LayeredConnectionSocketFactory)this.__socketFactory).build();
    }

    public IHttpResponse get(String url) throws Exception {
        return this.get(url, new Header[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IHttpResponse get(String url, Header[] headers) throws Exception {
        CloseableHttpClient _httpClient = this.__doBuildHttpClient();
        try {
            RequestBuilder _reqBuilder = RequestBuilder.get().setUri(url);
            if (headers != null && headers.length > 0) {
                for (Header _header : headers) {
                    _reqBuilder.addHeader(_header);
                }
            }
            IHttpResponse iHttpResponse = (IHttpResponse)_httpClient.execute(_reqBuilder.build(), (ResponseHandler)new ResponseHandler<IHttpResponse>(){

                public IHttpResponse handleResponse(HttpResponse response) throws IOException {
                    return new IHttpResponse.NEW(response);
                }
            });
            return iHttpResponse;
        }
        finally {
            _httpClient.close();
        }
    }

    public IHttpResponse get(String url, Map<String, String> params) throws Exception {
        return this.get(url, params, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IHttpResponse get(String url, Map<String, String> params, Header[] headers) throws Exception {
        RequestBuilder _request = RequestBuilder.get().setUri(url);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            _request.addParameter(entry.getKey(), entry.getValue());
        }
        if (headers != null && headers.length > 0) {
            for (Header _header : headers) {
                _request.addHeader(_header);
            }
        }
        CloseableHttpClient _httpClient = this.__doBuildHttpClient();
        try {
            IHttpResponse iHttpResponse = (IHttpResponse)_httpClient.execute(_request.build(), (ResponseHandler)new ResponseHandler<IHttpResponse>(){

                public IHttpResponse handleResponse(HttpResponse response) throws IOException {
                    return new IHttpResponse.NEW(response);
                }
            });
            return iHttpResponse;
        }
        finally {
            _httpClient.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IHttpResponse post(String url, ContentType contentType, String content, Header[] headers) throws Exception {
        CloseableHttpClient _httpClient = this.__doBuildHttpClient();
        try {
            RequestBuilder _reqBuilder = RequestBuilder.post().setUri(url).setEntity(EntityBuilder.create().setContentEncoding(DEFAULT_CHARSET).setContentType(contentType).setText(content).build());
            if (headers != null && headers.length > 0) {
                for (Header _header : headers) {
                    _reqBuilder.addHeader(_header);
                }
            }
            IHttpResponse iHttpResponse = (IHttpResponse)_httpClient.execute(_reqBuilder.build(), (ResponseHandler)new ResponseHandler<IHttpResponse>(){

                public IHttpResponse handleResponse(HttpResponse response) throws IOException {
                    return new IHttpResponse.NEW(response);
                }
            });
            return iHttpResponse;
        }
        finally {
            _httpClient.close();
        }
    }

    public IHttpResponse post(String url, ContentType contentType, String content) throws Exception {
        return this.post(url, contentType, content, null);
    }

    public IHttpResponse post(String url, String content) throws Exception {
        return this.post(url, ContentType.create((String)"text/plain", (String)DEFAULT_CHARSET), content, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IHttpResponse post(String url, ContentType contentType, byte[] content, Header[] headers) throws Exception {
        CloseableHttpClient _httpClient = this.__doBuildHttpClient();
        try {
            RequestBuilder _reqBuilder = RequestBuilder.post().setUri(url).setEntity(EntityBuilder.create().setContentEncoding(DEFAULT_CHARSET).setContentType(contentType).setBinary(content).build());
            if (headers != null && headers.length > 0) {
                for (Header _header : headers) {
                    _reqBuilder.addHeader(_header);
                }
            }
            IHttpResponse iHttpResponse = (IHttpResponse)_httpClient.execute(_reqBuilder.build(), (ResponseHandler)new ResponseHandler<IHttpResponse>(){

                public IHttpResponse handleResponse(HttpResponse response) throws IOException {
                    return new IHttpResponse.NEW(response);
                }
            });
            return iHttpResponse;
        }
        finally {
            _httpClient.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IHttpResponse post(String url, ContentType contentType, InputStream content, Header[] headers) throws Exception {
        CloseableHttpClient _httpClient = this.__doBuildHttpClient();
        try {
            RequestBuilder _reqBuilder = RequestBuilder.post().setUri(url).setEntity(EntityBuilder.create().setContentEncoding(DEFAULT_CHARSET).setContentType(contentType).setStream(content).build());
            if (headers != null && headers.length > 0) {
                for (Header _header : headers) {
                    _reqBuilder.addHeader(_header);
                }
            }
            IHttpResponse iHttpResponse = (IHttpResponse)_httpClient.execute(_reqBuilder.build(), (ResponseHandler)new ResponseHandler<IHttpResponse>(){

                public IHttpResponse handleResponse(HttpResponse response) throws IOException {
                    return new IHttpResponse.NEW(response);
                }
            });
            return iHttpResponse;
        }
        finally {
            _httpClient.close();
        }
    }

    public IHttpResponse post(String url, ContentType contentType, byte[] content) throws Exception {
        return this.post(url, contentType, content, null);
    }

    public IHttpResponse post(String url, byte[] content) throws Exception {
        return this.post(url, ContentType.create((String)"application/octet-stream", (String)DEFAULT_CHARSET), content, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IHttpResponse post(String url, Map<String, String> params, Header[] headers) throws Exception {
        CloseableHttpClient _httpClient = this.__doBuildHttpClient();
        try {
            RequestBuilder _reqBuilder = RequestBuilder.post().setUri(url).setEntity(EntityBuilder.create().setContentEncoding(DEFAULT_CHARSET).setParameters(HttpClientHelper.__doBuildNameValuePairs(params)).build());
            if (headers != null && headers.length > 0) {
                for (Header _header : headers) {
                    _reqBuilder.addHeader(_header);
                }
            }
            IHttpResponse iHttpResponse = (IHttpResponse)_httpClient.execute(_reqBuilder.build(), (ResponseHandler)new ResponseHandler<IHttpResponse>(){

                public IHttpResponse handleResponse(HttpResponse response) throws IOException {
                    return new IHttpResponse.NEW(response);
                }
            });
            return iHttpResponse;
        }
        finally {
            _httpClient.close();
        }
    }

    public IHttpResponse post(String url, Map<String, String> params) throws Exception {
        return this.post(url, params, null);
    }

    private static List<NameValuePair> __doBuildNameValuePairs(Map<String, String> params) {
        ArrayList<NameValuePair> nameValuePair = new ArrayList<NameValuePair>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (!StringUtils.isNotBlank((String)entry.getValue())) continue;
            nameValuePair.add((NameValuePair)new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        return nameValuePair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IHttpResponse upload(String url, String fieldName, ContentBody uploadFile, Header[] headers) throws Exception {
        CloseableHttpClient _httpClient = this.__doBuildHttpClient();
        try {
            RequestBuilder _reqBuilder = RequestBuilder.post().setUri(url).setEntity(MultipartEntityBuilder.create().addPart(fieldName, uploadFile).build());
            if (headers != null && headers.length > 0) {
                for (Header _header : headers) {
                    _reqBuilder.addHeader(_header);
                }
            }
            IHttpResponse.NEW nEW = new IHttpResponse.NEW((HttpResponse)_httpClient.execute(_reqBuilder.build()));
            return nEW;
        }
        finally {
            _httpClient.close();
        }
    }

    public IHttpResponse upload(String url, String fieldName, File uploadFile, Header[] headers) throws Exception {
        return this.upload(url, fieldName, (ContentBody)new FileBody(uploadFile), headers);
    }

    public IHttpResponse upload(String url, File uploadFile, Header[] headers) throws Exception {
        return this.upload(url, "media", uploadFile, headers);
    }

    public IHttpResponse upload(String url, String fieldName, File uploadFile) throws Exception {
        return this.upload(url, fieldName, uploadFile, null);
    }

    public IHttpResponse upload(String url, File uploadFile) throws Exception {
        return this.upload(url, uploadFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __doExecHttpDownload(RequestBuilder requestBuilder, final IFileHandler handler) throws Exception {
        CloseableHttpClient _httpClient = this.__doBuildHttpClient();
        try {
            _httpClient.execute(requestBuilder.build(), (ResponseHandler)new ResponseHandler<Void>(){

                public Void handleResponse(HttpResponse response) throws IOException {
                    String _fileName = null;
                    if (response.getStatusLine().getStatusCode() == 200 && response.containsHeader("Content-disposition")) {
                        _fileName = StringUtils.substringAfter((String)response.getFirstHeader("Content-disposition").getValue(), (String)"filename=");
                    }
                    handler.handle(response, new IFileWrapper.NEW(_fileName, response.getEntity().getContentType().getValue(), response.getEntity().getContentLength(), new BufferedInputStream(response.getEntity().getContent())));
                    return null;
                }
            });
        }
        finally {
            _httpClient.close();
        }
    }

    public void download(String url, ContentType contentType, String content, Header[] headers, IFileHandler handler) throws Exception {
        RequestBuilder _reqBuilder = RequestBuilder.post().setUri(url).setEntity(EntityBuilder.create().setContentEncoding(DEFAULT_CHARSET).setContentType(contentType).setText(content).build());
        if (headers != null && headers.length > 0) {
            for (Header _header : headers) {
                _reqBuilder.addHeader(_header);
            }
        }
        this.__doExecHttpDownload(_reqBuilder, handler);
    }

    public void download(String url, String content, IFileHandler handler) throws Exception {
        this.download(url, ContentType.create((String)"application/x-www-form-urlencoded", (String)DEFAULT_CHARSET), content, null, handler);
    }

    public void download(String url, Header[] headers, IFileHandler handler) throws Exception {
        RequestBuilder _reqBuilder = RequestBuilder.get().setUri(url);
        if (headers != null && headers.length > 0) {
            for (Header _header : headers) {
                _reqBuilder.addHeader(_header);
            }
        }
        this.__doExecHttpDownload(_reqBuilder, handler);
    }

    public void download(String url, IFileHandler handler) throws Exception {
        this.download(url, new Header[0], handler);
    }
}

