/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.framework.commons;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.apache.commons.lang.StringUtils;

public class QRCodeHelper {
    private static final int BLACK = -16777216;
    private static final int WHITE = -1;
    private BitMatrix __matrix;
    private String __format = "png";

    private QRCodeHelper(BitMatrix matrix) {
        this.__matrix = matrix;
    }

    public static QRCodeHelper create(String content, String characterSet, int width, int height, int margin, ErrorCorrectionLevel level) throws WriterException {
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        hints.put(EncodeHintType.CHARACTER_SET, StringUtils.defaultIfEmpty((String)characterSet, (String)"UTF-8"));
        hints.put(EncodeHintType.MARGIN, margin <= 0 ? 3 : margin);
        if (level != null) {
            hints.put(EncodeHintType.ERROR_CORRECTION, level);
        }
        return new QRCodeHelper(new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, width, height, hints));
    }

    public static QRCodeHelper create(String content, int width, int height, ErrorCorrectionLevel level) throws WriterException {
        return QRCodeHelper.create(content, null, width, height, 0, level);
    }

    public static QRCodeHelper create(String content, int width, int height) throws WriterException {
        return QRCodeHelper.create(content, null, width, height, 0, null);
    }

    public QRCodeHelper setFormat(String format) {
        this.__format = StringUtils.defaultIfEmpty((String)format, (String)"png");
        return this;
    }

    public BufferedImage toBufferedImage() {
        int width = this.__matrix.getWidth();
        int height = this.__matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, this.__matrix.get(x, y) ? -16777216 : -1);
            }
        }
        return image;
    }

    public void writeToFile(File file) throws IOException {
        BufferedImage image = this.toBufferedImage();
        if (!ImageIO.write((RenderedImage)image, this.__format, file)) {
            throw new IOException("Could not write an image of format " + this.__format + " to " + file);
        }
    }

    public void writeToStream(OutputStream stream) throws IOException {
        BufferedImage image = this.toBufferedImage();
        if (!ImageIO.write((RenderedImage)image, this.__format, stream)) {
            throw new IOException("Could not write an image of format " + this.__format);
        }
    }
}

