/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.validation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.ymate.platform.core.util.ClassUtils;
import net.ymate.platform.validation.IValidation;
import net.ymate.platform.validation.annotation.VField;
import net.ymate.platform.validation.annotation.VModel;
import net.ymate.platform.validation.annotation.Validation;
import org.apache.commons.lang.StringUtils;

public class ValidationMeta {
    private IValidation __validation;
    private Validation.MODE __mode;
    private String __resourcesName;
    private Class<?> __targetClass;
    private Map<String, Annotation[]> __fields;
    private Map<String, String> __labels;
    private Map<Method, Map<String, String>> __methodLabels;
    private Map<Method, Validation> __methods;
    private Map<Method, Map<String, Annotation[]>> __methodParams;

    public ValidationMeta(IValidation validation, Class<?> targetClass) {
        this.__validation = validation;
        Validation _classValidation = targetClass.getAnnotation(Validation.class);
        if (_classValidation != null) {
            this.__mode = _classValidation.mode();
            this.__resourcesName = _classValidation.resourcesName();
        } else {
            this.__mode = Validation.MODE.NORMAL;
        }
        this.__targetClass = targetClass;
        this.__fields = new LinkedHashMap<String, Annotation[]>();
        this.__labels = new LinkedHashMap<String, String>();
        this.__methodLabels = new LinkedHashMap<Method, Map<String, String>>();
        this.__methods = new LinkedHashMap<Method, Validation>();
        this.__methodParams = new LinkedHashMap<Method, Map<String, Annotation[]>>();
        this.__fields.putAll(this.__doGetMetaFromFields(null, targetClass, this.__labels));
        for (Method _method : targetClass.getDeclaredMethods()) {
            LinkedHashMap<String, String> _paramLabels = new LinkedHashMap<String, String>();
            this.__methodLabels.put(_method, _paramLabels);
            Validation _methodValidation = _method.getAnnotation(Validation.class);
            if (_methodValidation != null) {
                this.__methods.put(_method, _methodValidation);
            }
            LinkedHashMap<String, Annotation[]> _paramAnnos = new LinkedHashMap<String, Annotation[]>();
            String[] _paramNames = ClassUtils.getMethodParamNames((Method)_method);
            if (_paramNames == null || _paramNames.length <= 0) continue;
            Annotation[][] _params = _method.getParameterAnnotations();
            for (int _idx = 0; _idx < _paramNames.length; ++_idx) {
                ArrayList<Annotation> _tmpAnnoList = new ArrayList<Annotation>();
                String _paramName = _paramNames[_idx];
                for (Annotation _vField : _params[_idx]) {
                    if (!(_vField instanceof VField)) continue;
                    VField _vF = (VField)_vField;
                    if (StringUtils.isNotBlank((String)_vF.name())) {
                        _paramName = ((VField)_vField).name();
                    }
                    if (!StringUtils.isNotBlank((String)_vF.label())) break;
                    _paramLabels.put(_paramName, _vF.label());
                    break;
                }
                for (Annotation _annotation : _params[_idx]) {
                    if (this.__doIsValid(_annotation)) {
                        _tmpAnnoList.add(_annotation);
                        continue;
                    }
                    if (!(_annotation instanceof VModel)) continue;
                    _paramAnnos.putAll(this.__doGetMetaFromFields(_paramName, _method.getParameterTypes()[_idx], _paramLabels));
                }
                if (_tmpAnnoList.isEmpty()) continue;
                _paramAnnos.put(_paramName, _tmpAnnoList.toArray(new Annotation[_tmpAnnoList.size()]));
            }
            if (_paramAnnos.isEmpty()) continue;
            this.__methodParams.put(_method, _paramAnnos);
        }
    }

    public Map<String, Annotation[]> __doGetMetaFromFields(String parentFieldName, Class<?> targetClass, Map<String, String> paramLabels) {
        LinkedHashMap<String, Annotation[]> _returnValues = new LinkedHashMap<String, Annotation[]>();
        parentFieldName = StringUtils.trimToEmpty((String)parentFieldName);
        ClassUtils.BeanWrapper _beanWrapper = ClassUtils.wrapper(targetClass);
        if (_beanWrapper != null) {
            for (String _fieldName : _beanWrapper.getFieldNames()) {
                VField _vField = null;
                Field _field = _beanWrapper.getField(_fieldName);
                if (_field.isAnnotationPresent(VField.class)) {
                    _vField = _field.getAnnotation(VField.class);
                    if (StringUtils.isNotBlank((String)_vField.name())) {
                        _fieldName = _vField.name();
                    }
                    if (StringUtils.isNotBlank((String)_vField.label())) {
                        this.__labels.put(_fieldName, _vField.label());
                        paramLabels.put(this.__doGetFieldName(parentFieldName, _fieldName), _vField.label());
                    }
                }
                ArrayList<Annotation> _annotations = new ArrayList<Annotation>();
                for (Annotation _annotation : _beanWrapper.getFieldAnnotations(_field.getName())) {
                    if (this.__doIsValid(_annotation)) {
                        _annotations.add(_annotation);
                        continue;
                    }
                    if (!(_annotation instanceof VModel)) continue;
                    String _fieldNamePR = this.__doGetFieldName(parentFieldName, _fieldName);
                    if (_vField != null && StringUtils.isNotBlank((String)_vField.label())) {
                        paramLabels.put(_fieldNamePR, _vField.label());
                    }
                    _returnValues.putAll(this.__doGetMetaFromFields(_fieldNamePR, _field.getType(), paramLabels));
                }
                if (_annotations.isEmpty()) continue;
                String _fieldNamePR = this.__doGetFieldName(parentFieldName, _fieldName);
                _returnValues.put(_fieldNamePR, _annotations.toArray(new Annotation[_annotations.size()]));
            }
        }
        return _returnValues;
    }

    private String __doGetFieldName(String parentFieldName, String fieldName) {
        if (StringUtils.isNotBlank((String)parentFieldName)) {
            return parentFieldName.concat(".").concat(fieldName);
        }
        return fieldName;
    }

    private boolean __doIsValid(Annotation _annotation) {
        return this.__validation.containsValidator(_annotation.annotationType());
    }

    public Validation.MODE getMode() {
        return this.__mode;
    }

    public String getResourcesName() {
        return this.__resourcesName;
    }

    public Class<?> getTargetClass() {
        return this.__targetClass;
    }

    public Set<String> getFieldNames() {
        return Collections.unmodifiableSet(this.__fields.keySet());
    }

    public String getFieldLabel(String fieldName) {
        return this.__labels.get(fieldName);
    }

    public String getFieldLabel(Method method, String fieldName) {
        return this.__methodLabels.get(method).get(fieldName);
    }

    public Annotation[] getFieldAnnotations(String fieldName) {
        return this.__fields.get(fieldName);
    }

    public Validation getMethodValidation(Method method) {
        return this.__methods.get(method);
    }

    public Map<String, Annotation[]> getMethodParamAnnotations(Method method) {
        if (this.__methodParams.containsKey(method)) {
            return Collections.unmodifiableMap(this.__methodParams.get(method));
        }
        return Collections.emptyMap();
    }
}

