/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.validation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.ymate.platform.core.Version;
import net.ymate.platform.core.YMP;
import net.ymate.platform.core.beans.IBeanHandler;
import net.ymate.platform.core.beans.intercept.InterceptAnnoHelper;
import net.ymate.platform.core.module.IModule;
import net.ymate.platform.core.module.annotation.Module;
import net.ymate.platform.core.util.RuntimeUtils;
import net.ymate.platform.validation.IValidation;
import net.ymate.platform.validation.IValidator;
import net.ymate.platform.validation.ValidateContext;
import net.ymate.platform.validation.ValidateResult;
import net.ymate.platform.validation.ValidationMeta;
import net.ymate.platform.validation.annotation.Validation;
import net.ymate.platform.validation.annotation.Validator;
import net.ymate.platform.validation.handle.ValidateHandler;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Module
public class Validations
implements IModule,
IValidation {
    public static final Version VERSION = new Version(2, 0, 1, Validations.class.getPackage().getImplementationVersion(), Version.VersionType.Release);
    private final Log _LOG = LogFactory.getLog(Validations.class);
    private static volatile IValidation __instance;
    private YMP __owner;
    private boolean __inited;
    private Map<Class<? extends Annotation>, Class<? extends IValidator>> __validators;
    private Map<Class<?>, ValidationMeta> __VALIDATION_META_CACHES;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IValidation get() {
        if (__instance == null) {
            Version version = VERSION;
            synchronized (version) {
                if (__instance == null) {
                    __instance = (IValidation)YMP.get().getModule(Validations.class);
                }
            }
        }
        return __instance;
    }

    public static IValidation get(YMP owner) {
        return (IValidation)owner.getModule(Validations.class);
    }

    public String getName() {
        return "validation";
    }

    public void init(YMP owner) throws Exception {
        if (!this.__inited) {
            this._LOG.info((Object)("Initializing ymate-platform-validation-" + VERSION));
            this.__owner = owner;
            this.__validators = new HashMap<Class<? extends Annotation>, Class<? extends IValidator>>();
            this.__VALIDATION_META_CACHES = new HashMap();
            this.__owner.registerHandler(Validator.class, (IBeanHandler)new ValidateHandler(this));
            this.__inited = true;
        }
    }

    public boolean isInited() {
        return this.__inited;
    }

    @Override
    public YMP getOwner() {
        return this.__owner;
    }

    @Override
    public void registerValidator(Class<? extends Annotation> annotationClass, Class<? extends IValidator> validatorClass) {
        try {
            this.__owner.registerBean(validatorClass, (Object)validatorClass.newInstance());
            this.__validators.put(annotationClass, validatorClass);
        }
        catch (Exception e) {
            this._LOG.error((Object)"", RuntimeUtils.unwrapThrow((Throwable)e));
        }
    }

    @Override
    public boolean containsValidator(Class<? extends Annotation> annotationClass) {
        return this.__validators.containsKey(annotationClass);
    }

    @Override
    public Map<String, ValidateResult> validate(Class<?> targetClass, Map<String, Object> paramValues) {
        LinkedHashMap<String, ValidateResult> _returnValues = new LinkedHashMap<String, ValidateResult>();
        ValidationMeta _meta = this.__doGetCachedMeta(targetClass);
        Map _contextParams = InterceptAnnoHelper.getContextParams((YMP)this.__owner, targetClass, null);
        for (String _fieldName : _meta.getFieldNames()) {
            ValidateResult _result = this.__doValidate(_meta.getFieldAnnotations(_fieldName), _fieldName, _meta.getFieldLabel(_fieldName), paramValues, _contextParams, _meta.getResourcesName());
            if (_result == null) continue;
            _returnValues.put(_fieldName, _result);
            if (_meta.getMode() != Validation.MODE.NORMAL) continue;
            break;
        }
        return _returnValues;
    }

    @Override
    public Map<String, ValidateResult> validate(Class<?> targetClass, Method targetMethod, Map<String, Object> paramValues) {
        LinkedHashMap<String, ValidateResult> _returnValues = new LinkedHashMap<String, ValidateResult>();
        ValidationMeta _meta = this.__doGetCachedMeta(targetClass);
        Validation _validation = _meta.getMethodValidation(targetMethod);
        Validation.MODE _mode = _validation == null ? _meta.getMode() : _validation.mode();
        String _resourceName = _validation == null ? _meta.getResourcesName() : StringUtils.defaultIfBlank((String)_validation.resourcesName(), (String)_meta.getResourcesName());
        Map<String, Annotation[]> _paramAnnoMap = _meta.getMethodParamAnnotations(targetMethod);
        Map _contextParams = InterceptAnnoHelper.getContextParams((YMP)this.__owner, targetClass, (Method)targetMethod);
        for (Map.Entry<String, Annotation[]> _entry : _paramAnnoMap.entrySet()) {
            ValidateResult _result = this.__doValidate(_entry.getValue(), _entry.getKey(), _meta.getFieldLabel(targetMethod, _entry.getKey()), paramValues, _contextParams, _resourceName);
            if (_result == null) continue;
            _returnValues.put(_entry.getKey(), _result);
            if (_mode != Validation.MODE.NORMAL) continue;
            break;
        }
        return _returnValues;
    }

    protected ValidationMeta __doGetCachedMeta(Class<?> targetClass) {
        ValidationMeta _meta = this.__VALIDATION_META_CACHES.get(targetClass);
        if (_meta == null) {
            _meta = new ValidationMeta(this, targetClass);
            this.__VALIDATION_META_CACHES.put(targetClass, _meta);
        }
        return _meta;
    }

    protected ValidateResult __doValidate(Annotation[] annotations, String paramName, String paramLabel, Map<String, Object> paramValues, Map<String, String> contextParams, String resourceName) {
        Annotation _ann;
        IValidator _validator;
        ValidateResult _result = null;
        Annotation[] annotationArray = annotations;
        int n = annotationArray.length;
        for (int i = 0; i < n && (_result = (_validator = (IValidator)this.__owner.getBean(this.__validators.get((_ann = annotationArray[i]).annotationType()))).validate(new ValidateContext(this.__owner, _ann, paramName, paramLabel, paramValues, contextParams, resourceName))) == null; ++i) {
        }
        return _result;
    }

    public void destroy() throws Exception {
        if (this.__inited) {
            this.__inited = false;
            this.__VALIDATION_META_CACHES = null;
            this.__validators = null;
            this.__owner = null;
        }
    }
}

