/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.validation.validate;

import net.ymate.platform.core.beans.annotation.CleanProxy;
import net.ymate.platform.core.lang.BlurObject;
import net.ymate.platform.validation.AbstractValidator;
import net.ymate.platform.validation.ValidateContext;
import net.ymate.platform.validation.ValidateResult;
import net.ymate.platform.validation.annotation.Validator;
import net.ymate.platform.validation.validate.VLength;
import org.apache.commons.lang.StringUtils;

@Validator(value=VLength.class)
@CleanProxy
public class LengthValidator
extends AbstractValidator {
    @Override
    public ValidateResult validate(ValidateContext context) {
        boolean _matched = false;
        VLength _vLength = (VLength)context.getAnnotation();
        Object _paramValue = context.getParamValue();
        if (_paramValue != null) {
            int _length = 0;
            if (!_paramValue.getClass().isArray()) {
                String _value = BlurObject.bind((Object)_paramValue).toStringValue();
                if (StringUtils.isNotBlank((String)_value)) {
                    _length = _value.length();
                }
            } else {
                Object[] _values = (Object[])_paramValue;
                _length = _values.length;
            }
            if (_vLength.min() > 0 && _vLength.max() == _vLength.min() && _length != _vLength.max()) {
                _matched = true;
            } else if (_vLength.min() > 0 && _length < _vLength.min()) {
                _matched = true;
            } else if (_vLength.max() > 0 && _length > _vLength.max()) {
                _matched = true;
            }
        }
        if (_matched) {
            String _pName = StringUtils.defaultIfBlank((String)context.getParamLabel(), (String)context.getParamName());
            _pName = this.__doGetI18nFormatMessage(context, _pName, _pName, new Object[0]);
            String _msg = StringUtils.trimToNull((String)_vLength.msg());
            _msg = _msg != null ? this.__doGetI18nFormatMessage(context, _msg, _msg, _pName) : (_vLength.max() > 0 && _vLength.min() > 0 ? (_vLength.max() == _vLength.min() ? this.__doGetI18nFormatMessage(context, "ymp.validation.length_eq", "{0} length must be eq {1}.", _pName, _vLength.max()) : this.__doGetI18nFormatMessage(context, "ymp.validation.length_between", "{0} length must be between {1} and {2}.", _pName, _vLength.min(), _vLength.max())) : (_vLength.max() > 0 ? this.__doGetI18nFormatMessage(context, "ymp.validation.length_max", "{0} length must be lt {1}.", _pName, _vLength.max()) : this.__doGetI18nFormatMessage(context, "ymp.validation.length_min", "{0} length must be gt {1}.", _pName, _vLength.min())));
            return new ValidateResult(context.getParamName(), _msg);
        }
        return null;
    }
}

