/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.validation.validate;

import net.ymate.platform.core.beans.annotation.CleanProxy;
import net.ymate.platform.core.lang.BlurObject;
import net.ymate.platform.validation.AbstractValidator;
import net.ymate.platform.validation.ValidateContext;
import net.ymate.platform.validation.ValidateResult;
import net.ymate.platform.validation.annotation.Validator;
import net.ymate.platform.validation.validate.VNumeric;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

@Validator(value=VNumeric.class)
@CleanProxy
public class NumericValidator
extends AbstractValidator {
    @Override
    public ValidateResult validate(ValidateContext context) {
        Object _paramValue = context.getParamValue();
        if (_paramValue != null) {
            boolean _matched = false;
            boolean _flag = false;
            VNumeric _vNumeric = (VNumeric)context.getAnnotation();
            try {
                Number _number = NumberUtils.createNumber((String)BlurObject.bind((Object)_paramValue).toStringValue());
                if (_number == null) {
                    _matched = true;
                    _flag = true;
                } else if (_vNumeric.min() > 0.0 && _number.doubleValue() < _vNumeric.min()) {
                    _matched = true;
                } else if (_vNumeric.max() > 0.0 && _number.doubleValue() > _vNumeric.max()) {
                    _matched = true;
                }
            }
            catch (Exception e) {
                _matched = true;
                _flag = true;
            }
            if (_matched) {
                String _pName = StringUtils.defaultIfBlank((String)context.getParamLabel(), (String)context.getParamName());
                _pName = this.__doGetI18nFormatMessage(context, _pName, _pName, new Object[0]);
                String _msg = StringUtils.trimToNull((String)_vNumeric.msg());
                if (_msg != null) {
                    _msg = this.__doGetI18nFormatMessage(context, _msg, _msg, _pName);
                } else if (_flag) {
                    String __NUMERIC = "ymp.validation.numeric";
                    _msg = this.__doGetI18nFormatMessage(context, __NUMERIC, "{0} not a valid numeric.", _pName);
                } else if (_vNumeric.max() > 0.0 && _vNumeric.min() > 0.0) {
                    String __NUMERIC_BETWEEN = "ymp.validation.numeric_between";
                    _msg = this.__doGetI18nFormatMessage(context, __NUMERIC_BETWEEN, "{0} numeric must be between {1} and {2}.", _pName, _vNumeric.min(), _vNumeric.max());
                } else if (_vNumeric.max() > 0.0) {
                    String __NUMERIC_MAX = "ymp.validation.numeric_max";
                    _msg = this.__doGetI18nFormatMessage(context, __NUMERIC_MAX, "{0} numeric must be lt {1}.", _pName, _vNumeric.max());
                } else {
                    String __NUMERIC_MIN = "ymp.validation.numeric_min";
                    _msg = this.__doGetI18nFormatMessage(context, __NUMERIC_MIN, "{0} numeric must be gt {1}.", _pName, _vNumeric.min());
                }
                return new ValidateResult(context.getParamName(), _msg);
            }
        }
        return null;
    }
}

