/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.DeploymentEntity;
import org.activiti.engine.repository.Deployment;

public class SetDeploymentKeyCmd
implements Command<Void> {
    protected String deploymentId;
    protected String key;

    public SetDeploymentKeyCmd(String deploymentId, String key) {
        this.deploymentId = deploymentId;
        this.key = key;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.deploymentId == null) {
            throw new ActivitiIllegalArgumentException("Deployment id is null");
        }
        DeploymentEntity deployment = (DeploymentEntity)commandContext.getDeploymentEntityManager().findById(this.deploymentId);
        if (deployment == null) {
            throw new ActivitiObjectNotFoundException("No deployment found for id = '" + this.deploymentId + "'", Deployment.class);
        }
        if (commandContext.getProcessEngineConfiguration().isActiviti5CompatibilityEnabled() && "activiti-5".equals(deployment.getEngineVersion())) {
            return null;
        }
        deployment.setKey(this.key);
        if (commandContext.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_UPDATED, deployment));
        }
        return null;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }
}

