/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.anyline.adapter.EnvironmentWorker;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.generator.GeneratorConfig;
import org.anyline.log.Log;
import org.anyline.log.LogProxy;
import org.anyline.util.AnylineConfig;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.FileUtil;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ConfigTable {
    private static final Log log = LogProxy.get(ConfigTable.class);
    public static EnvironmentWorker environment;
    private static boolean IS_LOG;
    private static final Map<String, Long> listener_files;
    protected static String root;
    protected static String webRoot;
    protected static String classpath;
    protected static String libpath;
    protected static Hashtable<String, Object> configs;
    protected static long lastLoadTime;
    protected static int reload;
    protected static final String version = "8.7.2-20250603";
    protected static final String minVersion = "000";
    protected static boolean isLoading;
    private static boolean listener_running;
    public static String CONFIG_NAME;
    public static String ENVIRONMENT_CONFIG_FILE_NAMES;
    public static Class DEFAULT_JDBC_ENTITY_CLASS;
    public static Class DEFAULT_MONGO_ENTITY_CLASS;
    public static Class DEFAULT_ELASTIC_SEARCH_ENTITY_CLASS;
    public static Class DEFAULT_NEO4J_ENTITY_CLASS;
    public static boolean IS_DEBUG;
    public static int KEEP_ADAPTER;
    public static int DEBUG_LVL;
    public static boolean IS_DISABLED_DEFAULT_LOG;
    public static boolean IS_LOG_SQL;
    public static boolean IS_LOG_SLOW_SQL;
    public static boolean IS_LOG_SQL_TIME;
    public static boolean IS_LOG_QUERY_RESULT;
    public static boolean IS_LOG_QUERY_RESULT_EXCLUDE_METADATA;
    public static String LOG_QUERY_RESULT_ALT;
    public static int LOG_QUERY_RESULT_ROWS;
    public static int LOG_QUERY_RESULT_TABLE_MAX_WIDTH;
    public static int LOG_QUERY_RESULT_CUT_WIDTH;
    public static boolean IS_LOG_ADAPTER_MATCH;
    public static boolean IS_LOG_CONVERT_EXCEPTION;
    public static boolean IS_THROW_CONVERT_EXCEPTION;
    public static boolean IS_PRINT_EXCEPTION_STACK_TRACE;
    public static long SLOW_SQL_MILLIS;
    public static boolean IS_LOG_SQL_PARAM;
    public static boolean IS_LOG_BATCH_SQL_PARAM;
    public static boolean IS_LOG_SQL_WHEN_ERROR;
    public static boolean IS_LOG_SQL_WARN;
    public static boolean IS_LOG_SQL_PARAM_WHEN_ERROR;
    public static boolean IS_SQL_LOG_PLACEHOLDER;
    public static boolean IS_ENABLE_PLACEHOLDER_REGEX_EXT;
    public static boolean IS_ENABLE_SQL_DATATYPE_CONVERT;
    public static boolean IS_SQL_DEBUG;
    public static boolean IS_HTTP_LOG;
    public static boolean IS_HTTP_PARAM_AUTO_TRIM;
    public static boolean IS_IGNORE_EMPTY_HTTP_KEY;
    public static int HTTP_PARAM_ENCODE;
    public static boolean IS_MULTIPLE_SERVICE;
    public static boolean IS_ENABLE_COMMON_JDBC_ADAPTER;
    public static boolean IS_ENABLE_ADAPTER_FAST_MATCH;
    public static boolean IS_ENABLE_COLUMN_POSITION;
    public static boolean IS_AUTO_CONVERT_BYTES;
    public static boolean IS_AUTO_SPLIT_ARRAY;
    public static boolean IS_METADATA_IGNORE_CASE;
    public static boolean IS_UPPER_KEY;
    public static boolean IS_LOWER_KEY;
    public static boolean IS_KEY_IGNORE_CASE;
    public static boolean IS_THROW_SQL_QUERY_EXCEPTION;
    public static boolean IS_THROW_SQL_UPDATE_EXCEPTION;
    public static boolean IS_UPDATE_NULL_COLUMN;
    public static boolean IS_UPDATE_EMPTY_COLUMN;
    public static boolean IS_INSERT_NULL_COLUMN;
    public static boolean IS_INSERT_EMPTY_COLUMN;
    public static boolean IS_UPDATE_NULL_FIELD;
    public static boolean IS_UPDATE_EMPTY_FIELD;
    public static boolean IS_INSERT_NULL_FIELD;
    public static boolean IS_INSERT_EMPTY_FIELD;
    public static boolean IS_CHECK_ALL_INSERT_COLUMN;
    public static boolean IS_CHECK_ALL_UPDATE_COLUMN;
    public static String LIST2STRING_FORMAT;
    public static boolean IS_REPLACE_EMPTY_NULL;
    public static boolean IS_SQL_DELIMITER_OPEN;
    public static boolean IS_AUTO_CHECK_KEYWORD;
    public static boolean IS_AUTO_CHECK_EL_VALUE;
    public static boolean IS_SQL_DELIMITER_PLACEHOLDER_OPEN;
    public static String SQL_DELIMITER_PLACEHOLDER;
    public static boolean IS_RETURN_EMPTY_STRING_REPLACE_NULL;
    public static boolean IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL;
    public static boolean IS_AUTO_CHECK_METADATA;
    public static boolean IS_AUTO_CHECK_PARAMETER_METADATA;
    public static int METADATA_CACHE_SCOPE;
    public static String METADATA_CACHE_KEY;
    public static int METADATA_CACHE_SECOND;
    public static int CHECK_METADATA_SAMPLE;
    public static boolean IS_CHECK_EMPTY_SET_METADATA;
    public static boolean IS_DISABLED_DEFAULT_ENTITY_ADAPTER;
    public static boolean IS_REMOVE_EMPTY_HTTP_KEY;
    public static boolean IS_CACHE_DISABLED;
    public static String DEFAULT_PRIMARY_KEY;
    public static boolean IS_OPEN_TRANSACTION_MANAGER;
    public static boolean IS_OPEN_PRIMARY_TRANSACTION_MANAGER;
    public static String ALTER_COLUMN_TYPE_SUFFIX;
    public static int AFTER_ALTER_COLUMN_EXCEPTION_ACTION;
    public static int SQL_QUERY_TIMEOUT;
    public static int SQL_UPDATE_TIMEOUT;
    public static boolean IS_DDL_AUTO_DROP_COLUMN;
    public static boolean IS_METADATA_AUTO_CHECK_COLUMN_PRIMARY;
    public static String SQL_STORE_DIR;
    public static boolean IS_OPEN_PARSE_MYBATIS;
    public static String ENTITY_FIELD_COLUMN_MAP;
    public static String ENTITY_CLASS_TABLE_MAP;
    public static String ENTITY_TABLE_ANNOTATION;
    public static String ENTITY_COLUMN_ANNOTATION;
    public static String ENTITY_PRIMARY_KEY_ANNOTATION;
    public static int ENTITY_FIELD_SELECT_DEPENDENCY;
    public static int ENTITY_FIELD_INSERT_DEPENDENCY;
    public static int ENTITY_FIELD_UPDATE_DEPENDENCY;
    public static int ENTITY_FIELD_DELETE_DEPENDENCY;
    public static Compare ENTITY_FIELD_SELECT_DEPENDENCY_COMPARE;
    public static int IGNORE_GRAPH_QUERY_RESULT_TOP_KEY;
    public static int IGNORE_GRAPH_QUERY_RESULT_TABLE;
    public static int MERGE_GRAPH_QUERY_RESULT_TABLE;
    public static String HTTP_PARAM_KEY_CASE;
    public static String MIX_DEFAULT_SEED;
    public static String EL_ATTRIBUTE_PREFIX;
    public static boolean PRIMARY_GENERATOR_UUID_ACTIVE;
    public static boolean PRIMARY_GENERATOR_SNOWFLAKE_ACTIVE;
    public static boolean PRIMARY_GENERATOR_RANDOM_ACTIVE;
    public static boolean PRIMARY_GENERATOR_TIMESTAMP_ACTIVE;
    public static boolean PRIMARY_GENERATOR_TIME_ACTIVE;
    public static int PRIMARY_GENERATOR_WORKER_ID;
    public static String PRIMARY_GENERATOR_PREFIX;
    public static int PRIMARY_GENERATOR_RANDOM_LENGTH;
    public static boolean PRIMARY_GENERATOR_UPPER;
    public static boolean PRIMARY_GENERATOR_LOWER;
    public static String PRIMARY_GENERATOR_TIME_FORMAT;
    public static int PRIMARY_GENERATOR_TIME_SUFFIX_LENGTH;
    public static String SNOWFLAKE_TWEPOCH;
    public static String GENERATOR_TABLES;
    public static final GeneratorConfig GENERATOR;

    public ConfigTable() {
        ConfigTable.debug();
    }

    public static void setEnvironment(EnvironmentWorker environment) {
        ConfigTable.environment = environment;
    }

    public static EnvironmentWorker environment() {
        if (null == environment) {
            log.error("\u672a\u6ce8\u5165EnvironmentWorker(8.7.2+)(\u57fa\u7840Java\u73af\u5883\u8c03\u7528DefaultEnvironmentWorker.start(),\u5176\u4ed6\u73af\u5883\u6dfb\u52a0\u4f9d\u8d56\u5982spring\u73af\u5883:anyline-environment-spring-data-jdbc)");
        }
        return environment;
    }

    private static synchronized void listener() {
        if (listener_running || listener_files.isEmpty()) {
            return;
        }
        listener_running = true;
        log.info("[\u542f\u52a8\u76d1\u542c][{}]", (Object)BeanUtil.concat(listener_files.keySet()));
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    for (Map.Entry item : listener_files.entrySet()) {
                        File file = new File((String)item.getKey());
                        Long lastLoad = (Long)item.getValue();
                        Long lastModify = file.lastModified();
                        if (lastLoad != 0L && lastModify <= lastLoad) continue;
                        ConfigTable.parse(file);
                    }
                    if (ConfigTable.getInt("RELOAD", 0) != 0) break;
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception) {}
                }
                listener_running = false;
            }
        }).start();
    }

    public static void addConfig(String content) {
        ConfigTable.loadConfig(content);
    }

    public static void addConfig(File ... files) {
        if (null == files) {
            return;
        }
        for (File file : files) {
            ConfigTable.loadConfig(file);
        }
    }

    public static String version() {
        return "8.7.2-20250603-000";
    }

    public static Hashtable<String, Object> getConfigs() {
        return configs;
    }

    public static String getWebRoot() {
        return webRoot;
    }

    public static void setWebRoot(String webRoot) {
        ConfigTable.webRoot = webRoot;
        ConfigTable.init();
    }

    public static String getRoot() {
        return root;
    }

    public static void setRoot(String root) {
        ConfigTable.root = root;
        ConfigTable.init();
    }

    public static String getWebClassPath() {
        String result = webRoot + File.separator + "WEB-INF" + File.separator + "classes" + File.separator;
        return result;
    }

    public static String getClassPath() {
        return classpath;
    }

    public static String getLibPath() {
        return libpath;
    }

    public static void init() {
        ConfigTable.init("anyline");
    }

    public static String getProjectProtocol() {
        URL url = ConfigTable.class.getResource("/");
        if (null != url) {
            return url.getProtocol();
        }
        return null;
    }

    public static String path(String path) {
        if (null == path) {
            return null;
        }
        path = path.replace("nested:", "");
        Properties props = System.getProperties();
        String os = props.getProperty("os.name");
        if (null != os && os.toUpperCase().contains("WINDOWS")) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            path = path.replace("file:/", "");
        }
        if ((path = path.replace("file:", "")).contains("!")) {
            path = path.substring(0, path.indexOf("!"));
        }
        return path;
    }

    public static void prepare() {
        if (isLoading) {
            return;
        }
        lastLoadTime = System.currentTimeMillis();
        isLoading = true;
        String path = null;
        try {
            File tmp;
            URL url = ConfigTable.class.getResource("/");
            if (null != url) {
                path = url.getPath();
            }
            if (null == path && null != (tmp = new File(".").getAbsoluteFile())) {
                path = tmp.getParent();
            }
            if (null == path) {
                path = System.getProperty("user.dir");
            }
        }
        catch (Exception e) {
            log.error("prepare exception:", e);
        }
        log.debug("path={}", (Object)path);
        path = ConfigTable.path(path);
        if (null == root && null != path) {
            root = path;
            if (root.contains(".jar")) {
                root = root.substring(0, root.indexOf(".jar"));
                root = root.substring(0, root.lastIndexOf("/"));
            }
            if (path.indexOf("bin") > 0) {
                root = path.substring(0, path.indexOf("bin") - 1);
            }
            if (path.indexOf("target") > 0) {
                root = path.substring(0, path.indexOf("target") - 1);
            }
        }
        if (null == webRoot && null != path) {
            webRoot = path;
            if (path.indexOf("WEB-INF") > 0) {
                webRoot = path.substring(0, path.indexOf("WEB-INF") - 1);
            }
        }
        if (null == path) {
            path = root;
        }
        if (path.contains("classes")) {
            classpath = path;
        } else if (path.contains("WEB-INF")) {
            classpath = webRoot + File.separator + "WEB-INF" + File.separator + "classes" + File.separator;
        } else {
            classpath = root + File.separator + "bin" + File.separator + "classes" + File.separator;
            if (!new File(classpath).exists()) {
                classpath = root;
            }
        }
        libpath = new File(new File(classpath).getParent(), "lib").getAbsolutePath();
    }

    public static void init(String flag) {
        ConfigTable.loadConfig(flag);
    }

    public static void loadEnvironment() throws Exception {
        String[] items = ENVIRONMENT_CONFIG_FILE_NAMES.split(",");
        if ("jar".equals(ConfigTable.getProjectProtocol())) {
            String txt;
            InputStream in;
            log.debug("[load environment][type:jar]");
            if (FileUtil.getPathType(AnylineConfig.class) == 0) {
                JarFile jar = new JarFile(System.getProperty("java.class.path"));
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!ConfigTable.check(name)) continue;
                    in = jar.getInputStream(entry);
                    txt = FileUtil.read(in, StandardCharsets.UTF_8).toString();
                    ConfigTable.parseEnvironment(txt, name);
                }
            } else {
                for (String item : items) {
                    in = ConfigTable.class.getClassLoader().getResourceAsStream("/" + (String)item);
                    txt = FileUtil.read(in, StandardCharsets.UTF_8).toString();
                    ConfigTable.parseEnvironment(txt, item);
                }
            }
            File dir = new File(FileUtil.merge(root, "config"));
            for (String item : items) {
                txt = FileUtil.read(new File(dir, item), StandardCharsets.UTF_8).toString();
                ConfigTable.parseEnvironment(txt, item);
            }
        } else {
            File dir = new File(classpath);
            for (String item : items) {
                String txt = FileUtil.read(new File(dir, item), StandardCharsets.UTF_8).toString();
                ConfigTable.parseEnvironment(txt, item);
            }
        }
        ConfigTable.map2field();
    }

    public static boolean check(String name) {
        String[] items;
        for (String item : items = ENVIRONMENT_CONFIG_FILE_NAMES.split(",")) {
            if (!name.endsWith(item)) continue;
            return true;
        }
        return false;
    }

    public static void loadEnvironment(String path) {
        try {
            log.debug("[load environment][path:{}]", (Object)path);
            ClassLoader loader = ConfigTable.class.getClassLoader();
            Enumeration<URL> urls = loader.getResources(path);
            while (urls.hasMoreElements()) {
                ConfigTable.parseEnvironment(urls.nextElement());
            }
        }
        catch (Exception e) {
            log.error("load environment \u5f02\u5e38:", e);
        }
    }

    public static void parseEnvironment(URL url) {
        try {
            log.debug("[parse environment][url:{}]", (Object)url);
            LinkedHashMap<Object, Object> map = new LinkedHashMap();
            String path = url.getPath();
            InputStream in = url.openStream();
            String txt = FileUtil.read(in, StandardCharsets.UTF_8).toString();
            if (path.contains(".yml")) {
                map = ConfigTable.parseYml(txt);
            } else if (path.contains("properties")) {
                map = ConfigTable.parseProperty(txt);
            }
            for (String string : map.keySet()) {
                ConfigTable.put(string.trim().toUpperCase(), map.get(string));
            }
        }
        catch (Exception e) {
            log.error("parse environment exception:", e);
        }
    }

    public static void parseEnvironment(String txt, String name) {
        LinkedHashMap<Object, Object> map = new LinkedHashMap();
        if (name.endsWith(".properties")) {
            map = ConfigTable.parseProperty(txt);
        } else if (name.endsWith(".yml")) {
            map = ConfigTable.parseYml(txt);
        }
        for (String string : map.keySet()) {
            ConfigTable.put(string.trim().toUpperCase(), map.get(string));
        }
    }

    public static LinkedHashMap<String, Object> parseYml(String txt) {
        String[] lines;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        HashMap<Integer, String> heads = new HashMap<Integer, String>();
        for (String line : lines = txt.split("\n")) {
            int idx = line.indexOf(":");
            if (idx == -1 || line.trim().startsWith("#")) continue;
            String key = line.substring(0, idx);
            String val = line.substring(idx + 1).trim();
            Integer lvl = ConfigTable.lvl(key);
            key = key.trim();
            if (line.trim().endsWith(":")) {
                heads.put(lvl, key.trim());
                continue;
            }
            String head = ConfigTable.head(heads, lvl);
            head = head.isEmpty() ? key : head + "." + key;
            map.put(head, val);
        }
        return map;
    }

    public static LinkedHashMap<String, Object> parseProperty(String txt) {
        String[] lines;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String line : lines = txt.split("\n")) {
            if ((line = line.trim()).startsWith("#") || !line.contains("=")) continue;
            int idx = line.indexOf("=");
            String key = line.substring(0, idx);
            String val = line.substring(idx + 1);
            map.put(key, val);
        }
        return map;
    }

    private static String head(Map<Integer, String> headers, int lvl) {
        StringBuilder head = new StringBuilder();
        for (int i = 0; i < lvl; ++i) {
            if (i > 0) {
                head.append(".");
            }
            head.append(headers.get(i));
        }
        return head.toString();
    }

    private static Integer lvl(String key) {
        Integer lvl = 0;
        int length = key.length() - key.trim().length();
        lvl = length / 2;
        return lvl;
    }

    protected static synchronized void loadConfig(String flag) {
        try {
            if (null == configs) {
                configs = new Hashtable();
            }
            if (null != root) {
                configs.put("HOME_DIR", root);
            }
            if ("jar".equals(ConfigTable.getProjectProtocol())) {
                InputStream in;
                log.debug("[\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6][type:jar][file:{}]", (Object)(flag + "-config.xml"));
                if (FileUtil.getPathType(AnylineConfig.class) == 0) {
                    JarFile jar = new JarFile(System.getProperty("java.class.path"));
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (name.endsWith(flag + "-config.xml")) {
                            in = jar.getInputStream(entry);
                            ConfigTable.parse(in);
                        }
                        if (!name.contains(flag + "-config") || name.endsWith(flag + "-config.xml")) continue;
                        in = jar.getInputStream(entry);
                        ConfigTable.parse(in);
                    }
                } else {
                    in = ConfigTable.class.getClassLoader().getResourceAsStream("/" + flag + "-config.xml");
                    String txt = FileUtil.read(in, StandardCharsets.UTF_8).toString();
                    ConfigTable.parseXML(txt);
                }
                File dir = new File(FileUtil.merge(root, "config"));
                ConfigTable.loadConfigDir(dir, flag);
                ConfigTable.loadConfig(new File(root, flag + "-config.xml"));
            } else {
                File dir = new File(classpath);
                ConfigTable.loadConfigDir(dir, flag);
            }
        }
        catch (Exception e) {
            log.error("log config exception:", e);
        }
        lastLoadTime = System.currentTimeMillis();
        reload = ConfigTable.getInt("RELOAD");
        String isUpper = ConfigTable.getString("IS_UPPER_KEY");
        if (null != isUpper && ("false".equals(isUpper.toLowerCase()) || "0".equals(isUpper))) {
            IS_UPPER_KEY = false;
        }
    }

    protected static synchronized void loadConfigDir(File dir, String flag) {
        String name;
        log.debug("[\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6][dir:{}]", (Object)dir.getAbsolutePath());
        List<File> files = FileUtil.getAllChildrenFile(dir, "xml");
        for (File f : files) {
            name = f.getName();
            if (!(flag + "-config.xml").equals(name)) continue;
            ConfigTable.loadConfig(f);
        }
        for (File f : files) {
            name = f.getName();
            if (!name.startsWith(flag + "-config") || (flag + "-config.xml").equals(name)) continue;
            ConfigTable.loadConfig(f);
        }
        log.debug("[\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5b8c\u6210]");
    }

    public static LinkedHashMap<String, Object> parse(File file) {
        LinkedHashMap<String, Object> maps = ConfigTable.parseXML(FileUtil.read(file).toString());
        listener_files.put(file.getAbsolutePath(), System.currentTimeMillis());
        return maps;
    }

    public static LinkedHashMap<String, Object> parseXML(String xml) {
        LinkedHashMap<String, Object> maps = new LinkedHashMap<String, Object>();
        try {
            if (BasicUtil.isEmpty((Object)xml)) {
                return maps;
            }
            Document document = DocumentHelper.parseText((String)xml);
            Element root = document.getRootElement();
            Iterator itrProperty = root.elementIterator("property");
            while (itrProperty.hasNext()) {
                Element propertyElement = (Element)itrProperty.next();
                String key = propertyElement.attributeValue("key");
                String value = propertyElement.getTextTrim();
                ConfigTable.put(key.toUpperCase().trim(), value);
                maps.put(key, value);
                if (!IS_DEBUG) continue;
                log.debug("[\u89e3\u6790\u914d\u7f6e\u6587\u4ef6][{}={}]", (Object)key, (Object)value);
            }
            ConfigTable.map2field();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return maps;
    }

    public static void parse(InputStream is) {
        SAXReader reader = new SAXReader();
        try {
            Document document = reader.read(is);
            Element root = document.getRootElement();
            Iterator itrProperty = root.elementIterator("property");
            while (itrProperty.hasNext()) {
                Element propertyElement = (Element)itrProperty.next();
                String key = propertyElement.attributeValue("key");
                String value = propertyElement.getTextTrim();
                configs.put(key.toUpperCase().trim(), value);
                if (!IS_DEBUG) continue;
                log.debug("[\u89e3\u6790\u914d\u7f6e\u6587\u4ef6][{}={}]", (Object)key, (Object)value);
            }
            ConfigTable.map2field();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void map2field() {
        Field[] fields;
        for (Field field : fields = ConfigTable.class.getDeclaredFields()) {
            String name = field.getName();
            if (!configs.containsKey(name)) continue;
            BeanUtil.setFieldValue(null, field, configs.get(name));
        }
    }

    protected static void loadConfig(File file) {
        try {
            if (IS_DEBUG) {
                log.debug("[\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6] [file:{}]", (Object)file);
            }
            if (null != file && !file.exists()) {
                log.debug("[\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728] [file:{}]", (Object)file.getAbsolutePath());
                return;
            }
            if (file.isDirectory()) {
                List<File> files = FileUtil.getAllChildrenDirectory(file);
                for (File f : files) {
                    ConfigTable.loadConfig(f);
                }
            } else {
                ConfigTable.parse(file);
                if (BasicUtil.parseInt(configs.get("RELOAD"), 0) == 0) {
                    ConfigTable.listener();
                }
            }
        }
        catch (Exception e) {
            log.error("\u914d\u7f6e\u6587\u4ef6\u89e3\u6790\u5f02\u5e38:" + e);
        }
    }

    public static Object get(String key) {
        if (null == key) {
            return null;
        }
        Object val = null;
        if (reload > 0 && (System.currentTimeMillis() - lastLoadTime) / 1000L > (long)reload) {
            isLoading = false;
            ConfigTable.init();
        }
        if (null == (val = configs.get(key.toUpperCase().trim())) && null != environment) {
            val = environment.get(key);
        }
        return val;
    }

    public static String getString(String key) {
        Object val = ConfigTable.get(key);
        if (null != val) {
            return val.toString();
        }
        return null;
    }

    public static String getString(String key, String def) {
        String val = ConfigTable.getString(key);
        if (null == val) {
            val = def;
        }
        return val;
    }

    public static Object get(String key, Object def) {
        Object val = ConfigTable.get(key);
        if (null == val) {
            val = def;
        }
        return val;
    }

    public static boolean getBoolean(String key) {
        return ConfigTable.getBoolean(key, false);
    }

    public static boolean getBoolean(String key, boolean def) {
        return BasicUtil.parseBoolean(ConfigTable.get(key), def);
    }

    public static int getInt(String key) {
        return BasicUtil.parseInt(ConfigTable.get(key), 0);
    }

    public static int getInt(String key, int def) {
        return BasicUtil.parseInt(ConfigTable.get(key), def);
    }

    public static void put(String key, String value) {
        configs.put(key, value);
        if (IS_DEBUG) {
            log.debug("[ConfigTable\u52a8\u6001\u66f4\u65b0][{}={}]", (Object)key, (Object)value);
        }
    }

    public static void put(String key, Object value) {
        configs.put(key, value);
        if (value instanceof Collection) {
            Collection cols = (Collection)value;
            int i = 0;
            for (Object col : cols) {
                configs.put(key + "[" + i++ + "]", col);
                configs.put(key + "." + i++, col);
            }
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            for (Object k : map.keySet()) {
                configs.put(key + "[" + k + "]", map.get(k));
                configs.put(key + "." + k, map.get(k));
            }
        }
        if (IS_DEBUG) {
            log.debug("[ConfigTable\u52a8\u6001\u66f4\u65b0][{}={}]", (Object)key, value);
        }
    }

    public static String getVersion() {
        return version;
    }

    public static String getMinVersion() {
        return minVersion;
    }

    public static int getReload() {
        return reload;
    }

    public static boolean isDebug() {
        return IS_DEBUG;
    }

    public static boolean isSQLDebug() {
        return IS_SQL_DEBUG;
    }

    protected static void line(String src, String chr, int append, boolean center) {
        int len = 80 + append;
        String line = "";
        if (center) {
            int fillLeft = (len - src.length() - 2) / 2;
            int fillRight = (len - src.length() - 2) / 2;
            if ((len - src.length()) % 2 != 0) {
                ++fillRight;
            }
            line = "*" + BasicUtil.fillChar("", chr, fillLeft) + src + BasicUtil.fillChar("", chr, fillRight) + "*";
        } else {
            int fill = len - src.length() - 2;
            line = "*" + src + BasicUtil.fillChar("", chr, fill) + "";
        }
        System.out.println(line);
    }

    protected static void debug() {
        if (!IS_DEBUG) {
            return;
        }
        if (IS_LOG) {
            return;
        }
        IS_LOG = true;
        try {
            String time = null;
            String version = version;
            String project = null;
            try {
                String path = ConfigTable.class.getResource("").getPath();
                path = ConfigTable.path(path);
                if (path.contains("/WEB-INF")) {
                    project = path.substring(0, path.indexOf("/WEB-INF"));
                }
                File file = new File(path);
                try {
                    String anylineJarPath = ConfigTable.class.getProtectionDomain().getCodeSource().getLocation().getFile();
                    String anylineJarName = new File(anylineJarPath).getName();
                    if ((anylineJarName.endsWith("jar") || anylineJarName.endsWith("jar!")) && anylineJarName.contains("-")) {
                        version = anylineJarName.replace("anyline-", "").replace(".jar", "").replace("!", "");
                        version = version.substring(version.indexOf("-") + 1);
                    }
                    file = new File(anylineJarPath);
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINESE).format(new Date(file.lastModified()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println();
            ConfigTable.line("", "*", 0, true);
            ConfigTable.line("Anyline Core [" + version + "]", " ", 0, true);
            ConfigTable.line("http://doc.anyline.org ", " ", 0, true);
            ConfigTable.line("", " ", 0, true);
            if (null != time && time.startsWith("2")) {
                ConfigTable.line("Last Modified [" + time + "] ", " ", 0, true);
            } else {
                ConfigTable.line("MinVersion [000]", " ", 0, true);
            }
            ConfigTable.line("", " ", 0, true);
            ConfigTable.line("", "*", 0, true);
            if (null != project) {
                // empty if block
            }
            System.out.println();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setUpperKey(boolean bol) {
        IS_UPPER_KEY = bol;
    }

    public static void setLowerKey(boolean bol) {
        IS_LOWER_KEY = bol;
    }

    public boolean IS_DEBUG() {
        return IS_DEBUG;
    }

    public boolean IS_LOG_SQL() {
        return IS_LOG_SQL;
    }

    public boolean IS_THROW_CONVERT_EXCEPTION() {
        return IS_THROW_CONVERT_EXCEPTION;
    }

    public long SLOW_SQL_MILLIS() {
        return SLOW_SQL_MILLIS;
    }

    public boolean IS_LOG_SQL_PARAM() {
        return IS_LOG_SQL_PARAM;
    }

    public boolean IS_LOG_BATCH_SQL_PARAM() {
        return IS_LOG_BATCH_SQL_PARAM;
    }

    public boolean IS_LOG_SQL_WHEN_ERROR() {
        return IS_LOG_SQL_WHEN_ERROR;
    }

    public boolean IS_LOG_SQL_PARAM_WHEN_ERROR() {
        return IS_LOG_SQL_PARAM_WHEN_ERROR;
    }

    public boolean IS_SQL_DEBUG() {
        return IS_SQL_DEBUG;
    }

    public boolean IS_HTTP_LOG() {
        return IS_HTTP_LOG;
    }

    public boolean IS_HTTP_PARAM_AUTO_TRIM() {
        return IS_HTTP_PARAM_AUTO_TRIM;
    }

    public boolean IS_IGNORE_EMPTY_HTTP_KEY() {
        return IS_IGNORE_EMPTY_HTTP_KEY;
    }

    public int HTTP_PARAM_ENCODE() {
        return HTTP_PARAM_ENCODE;
    }

    public boolean IS_MULTIPLE_SERVICE() {
        return IS_MULTIPLE_SERVICE;
    }

    public boolean IS_ENABLE_COMMON_JDBC_ADAPTER() {
        return IS_ENABLE_COMMON_JDBC_ADAPTER;
    }

    public boolean IS_AUTO_CONVERT_BYTES() {
        return IS_AUTO_CONVERT_BYTES;
    }

    public boolean IS_AUTO_SPLIT_ARRAY() {
        return IS_AUTO_SPLIT_ARRAY;
    }

    public boolean IS_UPPER_KEY() {
        return IS_UPPER_KEY;
    }

    public boolean IS_LOWER_KEY() {
        return IS_LOWER_KEY;
    }

    public boolean IS_KEY_IGNORE_CASE() {
        return IS_KEY_IGNORE_CASE;
    }

    public boolean IS_THROW_SQL_QUERY_EXCEPTION() {
        return IS_THROW_SQL_QUERY_EXCEPTION;
    }

    public boolean IS_THROW_SQL_UPDATE_EXCEPTION() {
        return IS_THROW_SQL_UPDATE_EXCEPTION;
    }

    public boolean IS_UPDATE_NULL_COLUMN() {
        return IS_UPDATE_NULL_COLUMN;
    }

    public boolean IS_UPDATE_EMPTY_COLUMN() {
        return IS_UPDATE_EMPTY_COLUMN;
    }

    public boolean IS_INSERT_NULL_COLUMN() {
        return IS_INSERT_NULL_COLUMN;
    }

    public boolean IS_INSERT_EMPTY_COLUMN() {
        return IS_INSERT_EMPTY_COLUMN;
    }

    public boolean IS_UPDATE_NULL_FIELD() {
        return IS_UPDATE_NULL_FIELD;
    }

    public boolean IS_UPDATE_EMPTY_FIELD() {
        return IS_UPDATE_EMPTY_FIELD;
    }

    public boolean IS_INSERT_NULL_FIELD() {
        return IS_INSERT_NULL_FIELD;
    }

    public boolean IS_INSERT_EMPTY_FIELD() {
        return IS_INSERT_EMPTY_FIELD;
    }

    public String LIST2STRING_FORMAT() {
        return LIST2STRING_FORMAT;
    }

    public boolean IS_REPLACE_EMPTY_NULL() {
        return IS_REPLACE_EMPTY_NULL;
    }

    public boolean IS_SQL_DELIMITER_OPEN() {
        return IS_SQL_DELIMITER_OPEN;
    }

    public boolean IS_AUTO_CHECK_KEYWORD() {
        return IS_AUTO_CHECK_KEYWORD;
    }

    public boolean IS_AUTO_CHECK_EL_VALUE() {
        return IS_AUTO_CHECK_EL_VALUE;
    }

    public boolean IS_SQL_DELIMITER_PLACEHOLDER_OPEN() {
        return IS_SQL_DELIMITER_PLACEHOLDER_OPEN;
    }

    public String SQL_DELIMITER_PLACEHOLDER() {
        return SQL_DELIMITER_PLACEHOLDER;
    }

    public boolean IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL() {
        return IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL;
    }

    public boolean IS_AUTO_CHECK_METADATA() {
        return IS_AUTO_CHECK_METADATA;
    }

    public boolean IS_CHECK_EMPTY_SET_METADATA() {
        return IS_CHECK_EMPTY_SET_METADATA;
    }

    public boolean IS_DISABLED_DEFAULT_ENTITY_ADAPTER() {
        return IS_DISABLED_DEFAULT_ENTITY_ADAPTER;
    }

    public boolean IS_REMOVE_EMPTY_HTTP_KEY() {
        return IS_REMOVE_EMPTY_HTTP_KEY;
    }

    public boolean IS_CACHE_DISABLED() {
        return IS_CACHE_DISABLED;
    }

    public String DEFAULT_PRIMARY_KEY() {
        return DEFAULT_PRIMARY_KEY;
    }

    public boolean IS_OPEN_PRIMARY_TRANSACTION_MANAGER() {
        return IS_OPEN_PRIMARY_TRANSACTION_MANAGER;
    }

    public boolean IS_OPEN_TRANSACTION_MANAGER() {
        return IS_OPEN_TRANSACTION_MANAGER;
    }

    public boolean PRIMARY_GENERATOR_UUID_ACTIVE() {
        return PRIMARY_GENERATOR_UUID_ACTIVE;
    }

    public boolean PRIMARY_GENERATOR_SNOWFLAKE_ACTIVE() {
        return PRIMARY_GENERATOR_SNOWFLAKE_ACTIVE;
    }

    public boolean PRIMARY_GENERATOR_RANDOM_ACTIVE() {
        return PRIMARY_GENERATOR_RANDOM_ACTIVE;
    }

    public boolean PRIMARY_GENERATOR_TIMESTAMP_ACTIVE() {
        return PRIMARY_GENERATOR_TIMESTAMP_ACTIVE;
    }

    public boolean PRIMARY_GENERATOR_TIME_ACTIVE() {
        return PRIMARY_GENERATOR_TIME_ACTIVE;
    }

    public int PRIMARY_GENERATOR_WORKER_ID() {
        return PRIMARY_GENERATOR_WORKER_ID;
    }

    public String PRIMARY_GENERATOR_PREFIX() {
        return PRIMARY_GENERATOR_PREFIX;
    }

    public int PRIMARY_GENERATOR_RANDOM_LENGTH() {
        return PRIMARY_GENERATOR_RANDOM_LENGTH;
    }

    public boolean PRIMARY_GENERATOR_UPPER() {
        return PRIMARY_GENERATOR_UPPER;
    }

    public boolean PRIMARY_GENERATOR_LOWER() {
        return PRIMARY_GENERATOR_LOWER;
    }

    public String PRIMARY_GENERATOR_TIME_FORMAT() {
        return PRIMARY_GENERATOR_TIME_FORMAT;
    }

    public int PRIMARY_GENERATOR_TIME_SUFFIX_LENGTH() {
        return PRIMARY_GENERATOR_TIME_SUFFIX_LENGTH;
    }

    public String SNOWFLAKE_TWEPOCH() {
        return SNOWFLAKE_TWEPOCH;
    }

    public int AFTER_ALTER_COLUMN_EXCEPTION_ACTION() {
        return AFTER_ALTER_COLUMN_EXCEPTION_ACTION;
    }

    public int SQL_QUERY_TIMEOUT() {
        return SQL_QUERY_TIMEOUT;
    }

    public int SQL_UPDATE_TIMEOUT() {
        return SQL_UPDATE_TIMEOUT;
    }

    public boolean IS_DDL_AUTO_DROP_COLUMN() {
        return IS_DDL_AUTO_DROP_COLUMN;
    }

    public String SQL_STORE_DIR() {
        return SQL_STORE_DIR;
    }

    public boolean IS_OPEN_PARSE_MYBATIS() {
        return IS_OPEN_PARSE_MYBATIS;
    }

    public String ENTITY_FIELD_COLUMN_MAP() {
        return ENTITY_FIELD_COLUMN_MAP;
    }

    public String ENTITY_CLASS_TABLE_MAP() {
        return ENTITY_CLASS_TABLE_MAP;
    }

    public String ENTITY_TABLE_ANNOTATION() {
        return ENTITY_TABLE_ANNOTATION;
    }

    public String ENTITY_COLUMN_ANNOTATION() {
        return ENTITY_COLUMN_ANNOTATION;
    }

    public String ENTITY_PRIMARY_KEY_ANNOTATION() {
        return ENTITY_PRIMARY_KEY_ANNOTATION;
    }

    public int ENTITY_FIELD_SELECT_DEPENDENCY() {
        return ENTITY_FIELD_SELECT_DEPENDENCY;
    }

    public int ENTITY_FIELD_INSERT_DEPENDENCY() {
        return ENTITY_FIELD_INSERT_DEPENDENCY;
    }

    public int ENTITY_FIELD_UPDATE_DEPENDENCY() {
        return ENTITY_FIELD_UPDATE_DEPENDENCY;
    }

    public int ENTITY_FIELD_DELETE_DEPENDENCY() {
        return ENTITY_FIELD_DELETE_DEPENDENCY;
    }

    public Compare ENTITY_FIELD_SELECT_DEPENDENCY_COMPARE() {
        return ENTITY_FIELD_SELECT_DEPENDENCY_COMPARE;
    }

    public String HTTP_PARAM_KEY_CASE() {
        return HTTP_PARAM_KEY_CASE;
    }

    public String METADATA_CACHE_KEY() {
        return METADATA_CACHE_KEY;
    }

    public int METADATA_CACHE_SECOND() {
        return METADATA_CACHE_SECOND;
    }

    public String MIX_DEFAULT_SEED() {
        return MIX_DEFAULT_SEED;
    }

    public String EL_ATTRIBUTE_PREFIX() {
        return EL_ATTRIBUTE_PREFIX;
    }

    public String GENERATOR_TABLES() {
        return GENERATOR_TABLES;
    }

    public int IGNORE_GRAPH_QUERY_RESULT_TOP_KEY() {
        return IGNORE_GRAPH_QUERY_RESULT_TOP_KEY;
    }

    public int IGNORE_GRAPH_QUERY_RESULT_TABLE() {
        return IGNORE_GRAPH_QUERY_RESULT_TABLE;
    }

    public int MERGE_GRAPH_QUERY_RESULT_TABLE() {
        return MERGE_GRAPH_QUERY_RESULT_TABLE;
    }

    public static void closeAllSqlLog() {
        ConfigTable.put("IS_LOG_SQL", false);
        ConfigTable.put("IS_LOG_SQL_WHEN_ERROR", false);
        ConfigTable.put("IS_LOG_SQL_TIME", false);
        ConfigTable.put("IS_LOG_SQL_PARAM", false);
        ConfigTable.put("IS_LOG_SQL_PARAM_WHEN_ERROR", false);
        ConfigTable.put("IS_LOG_SLOW_SQL", false);
        IS_LOG_SQL = false;
        IS_LOG_SQL_WHEN_ERROR = false;
        IS_LOG_SQL_TIME = false;
        IS_LOG_SQL_PARAM = false;
        IS_LOG_SQL_PARAM_WHEN_ERROR = false;
        IS_LOG_SLOW_SQL = false;
    }

    public static void openAllSqlLog() {
        ConfigTable.put("IS_LOG_SQL", true);
        ConfigTable.put("IS_LOG_SQL_WHEN_ERROR", true);
        ConfigTable.put("IS_LOG_SQL_TIME", true);
        ConfigTable.put("IS_LOG_SQL_PARAM", true);
        ConfigTable.put("IS_LOG_SQL_PARAM_WHEN_ERROR", true);
        ConfigTable.put("IS_LOG_SLOW_SQL", true);
        IS_LOG_SQL = true;
        IS_LOG_SQL_WHEN_ERROR = true;
        IS_LOG_SQL_TIME = true;
        IS_LOG_SQL_PARAM = true;
        IS_LOG_SQL_PARAM_WHEN_ERROR = true;
        IS_LOG_SLOW_SQL = true;
    }

    static {
        IS_LOG = false;
        listener_files = new Hashtable<String, Long>();
        configs = new Hashtable();
        lastLoadTime = 0L;
        reload = 0;
        isLoading = false;
        listener_running = false;
        CONFIG_NAME = "anyline-config.xml";
        ENVIRONMENT_CONFIG_FILE_NAMES = "application.properties,application.yml";
        DEFAULT_JDBC_ENTITY_CLASS = DataRow.class;
        DEFAULT_MONGO_ENTITY_CLASS = DataRow.class;
        DEFAULT_ELASTIC_SEARCH_ENTITY_CLASS = DataRow.class;
        DEFAULT_NEO4J_ENTITY_CLASS = DataRow.class;
        IS_DEBUG = true;
        KEEP_ADAPTER = 1;
        DEBUG_LVL = 0;
        IS_DISABLED_DEFAULT_LOG = false;
        IS_LOG_SQL = true;
        IS_LOG_SLOW_SQL = true;
        IS_LOG_SQL_TIME = true;
        IS_LOG_QUERY_RESULT = false;
        IS_LOG_QUERY_RESULT_EXCLUDE_METADATA = true;
        LOG_QUERY_RESULT_ALT = "(\u4e2d\u6587\u5bf9\u9f50\u8bf7\u8bbe\u7f6e\u5b57\u4f53)";
        LOG_QUERY_RESULT_ROWS = 10;
        LOG_QUERY_RESULT_TABLE_MAX_WIDTH = 120;
        LOG_QUERY_RESULT_CUT_WIDTH = 30;
        IS_LOG_ADAPTER_MATCH = false;
        IS_LOG_CONVERT_EXCEPTION = false;
        IS_THROW_CONVERT_EXCEPTION = false;
        IS_PRINT_EXCEPTION_STACK_TRACE = false;
        SLOW_SQL_MILLIS = 0L;
        IS_LOG_SQL_PARAM = true;
        IS_LOG_BATCH_SQL_PARAM = false;
        IS_LOG_SQL_WHEN_ERROR = true;
        IS_LOG_SQL_WARN = true;
        IS_LOG_SQL_PARAM_WHEN_ERROR = true;
        IS_SQL_LOG_PLACEHOLDER = true;
        IS_ENABLE_PLACEHOLDER_REGEX_EXT = true;
        IS_ENABLE_SQL_DATATYPE_CONVERT = false;
        IS_SQL_DEBUG = false;
        IS_HTTP_LOG = true;
        IS_HTTP_PARAM_AUTO_TRIM = true;
        IS_IGNORE_EMPTY_HTTP_KEY = true;
        HTTP_PARAM_ENCODE = 0;
        IS_MULTIPLE_SERVICE = true;
        IS_ENABLE_COMMON_JDBC_ADAPTER = false;
        IS_ENABLE_ADAPTER_FAST_MATCH = false;
        IS_ENABLE_COLUMN_POSITION = false;
        IS_AUTO_CONVERT_BYTES = true;
        IS_AUTO_SPLIT_ARRAY = true;
        IS_METADATA_IGNORE_CASE = true;
        IS_UPPER_KEY = true;
        IS_LOWER_KEY = false;
        IS_KEY_IGNORE_CASE = true;
        IS_THROW_SQL_QUERY_EXCEPTION = true;
        IS_THROW_SQL_UPDATE_EXCEPTION = true;
        IS_UPDATE_NULL_COLUMN = false;
        IS_UPDATE_EMPTY_COLUMN = false;
        IS_INSERT_NULL_COLUMN = false;
        IS_INSERT_EMPTY_COLUMN = false;
        IS_UPDATE_NULL_FIELD = false;
        IS_UPDATE_EMPTY_FIELD = false;
        IS_INSERT_NULL_FIELD = false;
        IS_INSERT_EMPTY_FIELD = false;
        IS_CHECK_ALL_INSERT_COLUMN = false;
        IS_CHECK_ALL_UPDATE_COLUMN = false;
        LIST2STRING_FORMAT = "concat";
        IS_REPLACE_EMPTY_NULL = true;
        IS_SQL_DELIMITER_OPEN = false;
        IS_AUTO_CHECK_KEYWORD = false;
        IS_AUTO_CHECK_EL_VALUE = true;
        IS_SQL_DELIMITER_PLACEHOLDER_OPEN = false;
        SQL_DELIMITER_PLACEHOLDER = "`";
        IS_RETURN_EMPTY_STRING_REPLACE_NULL = false;
        IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL = false;
        IS_AUTO_CHECK_METADATA = false;
        IS_AUTO_CHECK_PARAMETER_METADATA = false;
        METADATA_CACHE_SCOPE = 9;
        METADATA_CACHE_KEY = "";
        METADATA_CACHE_SECOND = 86400;
        CHECK_METADATA_SAMPLE = 1000;
        IS_CHECK_EMPTY_SET_METADATA = false;
        IS_DISABLED_DEFAULT_ENTITY_ADAPTER = false;
        IS_REMOVE_EMPTY_HTTP_KEY = true;
        IS_CACHE_DISABLED = false;
        DEFAULT_PRIMARY_KEY = "ID";
        IS_OPEN_TRANSACTION_MANAGER = true;
        IS_OPEN_PRIMARY_TRANSACTION_MANAGER = false;
        ALTER_COLUMN_TYPE_SUFFIX = "___";
        AFTER_ALTER_COLUMN_EXCEPTION_ACTION = 1000;
        SQL_QUERY_TIMEOUT = -1;
        SQL_UPDATE_TIMEOUT = -1;
        IS_DDL_AUTO_DROP_COLUMN = false;
        IS_METADATA_AUTO_CHECK_COLUMN_PRIMARY = false;
        SQL_STORE_DIR = null;
        IS_OPEN_PARSE_MYBATIS = true;
        ENTITY_FIELD_COLUMN_MAP = "camel_";
        ENTITY_CLASS_TABLE_MAP = "Camel_";
        ENTITY_TABLE_ANNOTATION = null;
        ENTITY_COLUMN_ANNOTATION = null;
        ENTITY_PRIMARY_KEY_ANNOTATION = null;
        ENTITY_FIELD_SELECT_DEPENDENCY = 0;
        ENTITY_FIELD_INSERT_DEPENDENCY = 0;
        ENTITY_FIELD_UPDATE_DEPENDENCY = 0;
        ENTITY_FIELD_DELETE_DEPENDENCY = 0;
        ENTITY_FIELD_SELECT_DEPENDENCY_COMPARE = Compare.EQUAL;
        IGNORE_GRAPH_QUERY_RESULT_TOP_KEY = 0;
        IGNORE_GRAPH_QUERY_RESULT_TABLE = 0;
        MERGE_GRAPH_QUERY_RESULT_TABLE = 0;
        HTTP_PARAM_KEY_CASE = "camel";
        MIX_DEFAULT_SEED = "al";
        EL_ATTRIBUTE_PREFIX = "al";
        PRIMARY_GENERATOR_UUID_ACTIVE = false;
        PRIMARY_GENERATOR_SNOWFLAKE_ACTIVE = false;
        PRIMARY_GENERATOR_RANDOM_ACTIVE = false;
        PRIMARY_GENERATOR_TIMESTAMP_ACTIVE = false;
        PRIMARY_GENERATOR_TIME_ACTIVE = false;
        PRIMARY_GENERATOR_WORKER_ID = 1;
        PRIMARY_GENERATOR_PREFIX = "";
        PRIMARY_GENERATOR_RANDOM_LENGTH = 32;
        PRIMARY_GENERATOR_UPPER = true;
        PRIMARY_GENERATOR_LOWER = false;
        PRIMARY_GENERATOR_TIME_FORMAT = null;
        PRIMARY_GENERATOR_TIME_SUFFIX_LENGTH = 3;
        SNOWFLAKE_TWEPOCH = "2000-01-01";
        GENERATOR_TABLES = "*";
        GENERATOR = new GeneratorConfig();
        ConfigTable.prepare();
        try {
            ConfigTable.loadEnvironment();
        }
        catch (Exception e) {
            log.error("load environment exception:", e);
        }
        ConfigTable.init();
    }
}

