/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.pool;

import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.fory.Fory;
import org.apache.fory.logging.Logger;
import org.apache.fory.logging.LoggerFactory;

public class ClassLoaderForyPooled {
    private static final Logger LOG = LoggerFactory.getLogger(ClassLoaderForyPooled.class);
    private final Function<ClassLoader, Fory> foryFactory;
    private Consumer<Fory> factoryCallback = f -> {};
    private final ClassLoader classLoader;
    private final BlockingQueue<Fory> idleCacheQueue;
    final WeakHashMap<Fory, Object> allFory = new WeakHashMap();
    private final AtomicInteger activeCacheNumber = new AtomicInteger(0);
    private final int maxPoolSize;
    private final Lock lock = new ReentrantLock();

    public ClassLoaderForyPooled(ClassLoader classLoader, Function<ClassLoader, Fory> foryFactory, int minPoolSize, int maxPoolSize) {
        Objects.requireNonNull(foryFactory);
        this.maxPoolSize = maxPoolSize;
        this.foryFactory = foryFactory;
        this.classLoader = classLoader;
        this.idleCacheQueue = new LinkedBlockingQueue<Fory>(maxPoolSize);
        while (this.idleCacheQueue.size() < minPoolSize) {
            this.addFory(true);
        }
    }

    public Fory getFory() {
        if (this.activeCacheNumber.get() < this.maxPoolSize) {
            Fory fory = (Fory)this.idleCacheQueue.poll();
            if (fory != null) {
                return fory;
            }
            fory = this.addFory(false);
            if (fory != null) {
                return fory;
            }
        }
        try {
            return this.idleCacheQueue.take();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void returnFory(Fory fory) {
        Objects.requireNonNull(fory);
        this.idleCacheQueue.offer(fory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Fory addFory(boolean addQueue) {
        int after = this.activeCacheNumber.incrementAndGet();
        if (after > this.maxPoolSize) {
            this.activeCacheNumber.decrementAndGet();
            return null;
        }
        try {
            this.lock.lock();
            Fory fory = this.foryFactory.apply(this.classLoader);
            this.factoryCallback.accept(fory);
            this.allFory.put(fory, null);
            if (addQueue) {
                this.idleCacheQueue.add(fory);
            }
            Fory fory2 = fory;
            return fory2;
        }
        finally {
            this.lock.unlock();
        }
    }

    void setFactoryCallback(Consumer<Fory> factoryCallback) {
        try {
            this.lock.lock();
            this.factoryCallback = this.factoryCallback.andThen(factoryCallback);
            this.allFory.keySet().forEach(factoryCallback);
        }
        finally {
            this.lock.unlock();
        }
    }
}

