/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.resolver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.fory.collection.IdentityObjectIntMap;
import org.apache.fory.collection.IntArray;
import org.apache.fory.collection.MapStatistics;
import org.apache.fory.collection.ObjectArray;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.resolver.RefResolver;
import org.apache.fory.util.Preconditions;

public final class MapRefResolver
implements RefResolver {
    private static final boolean ENABLE_FORY_REF_PROFILING = "true".equalsIgnoreCase(System.getProperty("fory.enable_ref_profiling"));
    private static final int DEFAULT_MAP_CAPACITY = 4;
    private static final int DEFAULT_ARRAY_CAPACITY = 4;
    private long writeCounter;
    private long writeTotalObjectSize = 0L;
    private long readCounter;
    private long readTotalObjectSize = 0L;
    private final IdentityObjectIntMap<Object> writtenObjects = new IdentityObjectIntMap(4, 0.51f);
    private final ObjectArray readObjects = new ObjectArray(4);
    private final IntArray readRefIds = new IntArray(4);
    private Object readObject;

    @Override
    public boolean writeRefOrNull(MemoryBuffer buffer, Object obj) {
        buffer.grow(10);
        if (obj == null) {
            buffer._unsafeWriteByte((byte)-3);
            return true;
        }
        int newWriteRefId = this.writtenObjects.size;
        int writtenRefId = ENABLE_FORY_REF_PROFILING ? this.writtenObjects.profilingPutOrGet(obj, newWriteRefId) : this.writtenObjects.putOrGet(obj, newWriteRefId);
        if (writtenRefId >= 0) {
            buffer._unsafeWriteByte((byte)-2);
            buffer._unsafeWriteVarUint32(writtenRefId);
            return true;
        }
        buffer._unsafeWriteByte((byte)0);
        return false;
    }

    @Override
    public boolean writeRefValueFlag(MemoryBuffer buffer, Object obj) {
        assert (obj != null);
        buffer.grow(10);
        int newWriteRefId = this.writtenObjects.size;
        int writtenRefId = ENABLE_FORY_REF_PROFILING ? this.writtenObjects.profilingPutOrGet(obj, newWriteRefId) : this.writtenObjects.putOrGet(obj, newWriteRefId);
        if (writtenRefId >= 0) {
            buffer._unsafeWriteByte((byte)-2);
            buffer._unsafeWriteVarUint32(writtenRefId);
            return false;
        }
        buffer._unsafeWriteByte((byte)0);
        return true;
    }

    @Override
    public boolean writeNullFlag(MemoryBuffer buffer, Object obj) {
        if (obj == null) {
            buffer._unsafeWriteByte((byte)-3);
            return true;
        }
        return false;
    }

    @Override
    public void replaceRef(Object original, Object newObject) {
        int newObjectId = this.writtenObjects.get(newObject, -1);
        Preconditions.checkArgument(newObjectId != -1);
        this.writtenObjects.put(original, newObjectId);
    }

    @Override
    public byte readRefOrNull(MemoryBuffer buffer) {
        byte headFlag = buffer.readByte();
        if (headFlag == -2) {
            int referenceId = buffer.readVarUint32Small14();
            this.readObject = this.getReadObject(referenceId);
        } else {
            this.readObject = null;
        }
        return headFlag;
    }

    @Override
    public int preserveRefId() {
        int nextReadRefId = this.readObjects.size();
        this.readObjects.add(null);
        this.readRefIds.add(nextReadRefId);
        return nextReadRefId;
    }

    @Override
    public int preserveRefId(int refId) {
        this.readRefIds.add(refId);
        return refId;
    }

    @Override
    public int tryPreserveRefId(MemoryBuffer buffer) {
        byte headFlag = buffer.readByte();
        if (headFlag == -2) {
            this.readObject = this.getReadObject(buffer.readVarUint32Small14());
        } else {
            this.readObject = null;
            if (headFlag == 0) {
                return this.preserveRefId();
            }
        }
        return headFlag;
    }

    @Override
    public int lastPreservedRefId() {
        return this.readRefIds.get(this.readRefIds.size - 1);
    }

    @Override
    public void reference(Object object) {
        int refId = this.readRefIds.pop();
        this.setReadObject(refId, object);
    }

    @Override
    public Object getReadObject(int id) {
        return this.readObjects.get(id);
    }

    @Override
    public Object getReadObject() {
        return this.readObject;
    }

    @Override
    public void setReadObject(int id, Object object) {
        if (id >= 0) {
            this.readObjects.set(id, object);
        }
    }

    public ObjectArray getReadObjects() {
        return this.readObjects;
    }

    @Override
    public void reset() {
        this.resetWrite();
        this.resetRead();
    }

    @Override
    public void resetWrite() {
        IdentityObjectIntMap<Object> writtenObjects = this.writtenObjects;
        long writeTotalObjectSize = this.writeTotalObjectSize + (long)writtenObjects.size;
        long writeCounter = this.writeCounter + 1L;
        if (writeCounter < 0L || writeTotalObjectSize < 0L) {
            writeCounter = 1L;
            writeTotalObjectSize = writtenObjects.size;
        }
        this.writeCounter = writeCounter;
        this.writeTotalObjectSize = writeTotalObjectSize;
        int avg = (int)(writeTotalObjectSize / writeCounter);
        if (avg <= 4) {
            avg = 4;
        }
        writtenObjects.clearApproximate(avg);
    }

    @Override
    public void resetRead() {
        ObjectArray readObjects = this.readObjects;
        long readTotalObjectSize = this.readTotalObjectSize + (long)readObjects.size();
        long readCounter = this.readCounter + 1L;
        if (readCounter < 0L || readTotalObjectSize < 0L) {
            readCounter = 1L;
            readTotalObjectSize = readObjects.size();
        }
        this.readCounter = readCounter;
        this.readTotalObjectSize = readTotalObjectSize;
        int avg = (int)(readTotalObjectSize / readCounter);
        if (avg <= 4) {
            avg = 4;
        }
        readObjects.clearApproximate(avg);
        this.readRefIds.clear();
        this.readObject = null;
    }

    public RefStatistics referenceStatistics() {
        return new RefStatistics(this.referenceTypeSummary(), this.writtenObjects.getAndResetStatistics());
    }

    public LinkedHashMap<Class<?>, Integer> referenceTypeSummary() {
        HashMap typeCounter = new HashMap();
        this.writtenObjects.forEach((k, v) -> typeCounter.compute(k.getClass(), (key, value) -> value == null ? 1 : value + 1));
        ArrayList entries = new ArrayList(typeCounter.entrySet());
        entries.sort((o1, o2) -> {
            if (((Integer)o1.getValue()).equals(o2.getValue())) {
                return ((Class)o1.getKey()).getName().compareTo(((Class)o2.getKey()).getName());
            }
            return (Integer)o2.getValue() - (Integer)o1.getValue();
        });
        LinkedHashMap result = new LinkedHashMap(entries.size());
        entries.forEach(e -> {
            Integer cfr_ignored_0 = (Integer)result.put((Class<?>)e.getKey(), (Integer)e.getValue());
        });
        return result;
    }

    public static class RefStatistics {
        LinkedHashMap<Class<?>, Integer> refTypeSummary;
        int refCount;
        MapStatistics mapStatistics;

        public RefStatistics(LinkedHashMap<Class<?>, Integer> refTypeSummary, MapStatistics mapStatistics) {
            this.refTypeSummary = refTypeSummary;
            this.mapStatistics = mapStatistics;
            this.refCount = refTypeSummary.values().stream().reduce(0, Integer::sum, Integer::sum);
        }

        public String toString() {
            return "RefStatistics{referenceTypeSummary=" + this.refTypeSummary + ", referenceCount=" + this.refCount + ", mapProbeStatistics=" + this.mapStatistics + '}';
        }
    }
}

