/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.IdentityHashMap;
import org.apache.fory.Fory;
import org.apache.fory.config.CompatibleMode;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.memory.Platform;
import org.apache.fory.resolver.ClassInfo;
import org.apache.fory.resolver.ClassInfoHolder;
import org.apache.fory.resolver.ClassResolver;
import org.apache.fory.resolver.RefResolver;
import org.apache.fory.serializer.BufferObject;
import org.apache.fory.serializer.CompatibleSerializer;
import org.apache.fory.serializer.NonexistentClass;
import org.apache.fory.serializer.NonexistentClassSerializers;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.serializer.Serializers;
import org.apache.fory.serializer.StringSerializer;
import org.apache.fory.serializer.collection.CollectionFlags;
import org.apache.fory.serializer.collection.ForyArrayAsListSerializer;
import org.apache.fory.type.GenericType;
import org.apache.fory.type.TypeUtils;
import org.apache.fory.util.Preconditions;

public class ArraySerializers {
    static final IdentityHashMap<Class<?>, int[]> primitiveInfo = new IdentityHashMap();

    public static void registerDefaultSerializers(Fory fory) {
        ClassResolver resolver = fory.getClassResolver();
        resolver.registerSerializer(Object[].class, new ObjectArraySerializer(fory, (Class<T[]>)Object[].class));
        resolver.registerSerializer(Class[].class, new ObjectArraySerializer(fory, (Class<T[]>)Class[].class));
        resolver.registerSerializer(byte[].class, new ByteArraySerializer(fory));
        resolver.registerSerializer(Byte[].class, new ObjectArraySerializer(fory, (Class<T[]>)Byte[].class));
        resolver.registerSerializer(char[].class, new CharArraySerializer(fory));
        resolver.registerSerializer(Character[].class, new ObjectArraySerializer(fory, (Class<T[]>)Character[].class));
        resolver.registerSerializer(short[].class, new ShortArraySerializer(fory));
        resolver.registerSerializer(Short[].class, new ObjectArraySerializer(fory, (Class<T[]>)Short[].class));
        resolver.registerSerializer(int[].class, new IntArraySerializer(fory));
        resolver.registerSerializer(Integer[].class, new ObjectArraySerializer(fory, (Class<T[]>)Integer[].class));
        resolver.registerSerializer(long[].class, new LongArraySerializer(fory));
        resolver.registerSerializer(Long[].class, new ObjectArraySerializer(fory, (Class<T[]>)Long[].class));
        resolver.registerSerializer(float[].class, new FloatArraySerializer(fory));
        resolver.registerSerializer(Float[].class, new ObjectArraySerializer(fory, (Class<T[]>)Float[].class));
        resolver.registerSerializer(double[].class, new DoubleArraySerializer(fory));
        resolver.registerSerializer(Double[].class, new ObjectArraySerializer(fory, (Class<T[]>)Double[].class));
        resolver.registerSerializer(boolean[].class, new BooleanArraySerializer(fory));
        resolver.registerSerializer(Boolean[].class, new ObjectArraySerializer(fory, (Class<T[]>)Boolean[].class));
        resolver.registerSerializer(String[].class, new StringArraySerializer(fory));
    }

    static void writePrimitiveArray(MemoryBuffer buffer, Object arr, int offset, int numElements, int elemSize) {
        int size = Math.multiplyExact(numElements, elemSize);
        buffer.writeVarUint32Small7(size);
        int writerIndex = buffer.writerIndex();
        int end = writerIndex + size;
        buffer.ensure(end);
        buffer.copyFromUnsafe(writerIndex, arr, offset, size);
        buffer.writerIndex(end);
    }

    public static PrimitiveArrayBufferObject byteArrayBufferObject(byte[] array) {
        return new PrimitiveArrayBufferObject(array, Platform.BYTE_ARRAY_OFFSET, 1, array.length);
    }

    static {
        primitiveInfo.put(Boolean.TYPE, new int[]{Platform.BOOLEAN_ARRAY_OFFSET, 1, 30});
        primitiveInfo.put(Byte.TYPE, new int[]{Platform.BYTE_ARRAY_OFFSET, 1, 28});
        primitiveInfo.put(Character.TYPE, new int[]{Platform.CHAR_ARRAY_OFFSET, 2, 0});
        primitiveInfo.put(Short.TYPE, new int[]{Platform.SHORT_ARRAY_OFFSET, 2, 32});
        primitiveInfo.put(Integer.TYPE, new int[]{Platform.INT_ARRAY_OFFSET, 4, 33});
        primitiveInfo.put(Long.TYPE, new int[]{Platform.LONG_ARRAY_OFFSET, 8, 34});
        primitiveInfo.put(Float.TYPE, new int[]{Platform.FLOAT_ARRAY_OFFSET, 4, 36});
        primitiveInfo.put(Double.TYPE, new int[]{Platform.DOUBLE_ARRAY_OFFSET, 8, 37});
    }

    public static final class NonexistentArrayClassSerializer
    extends AbstractedNonexistentArrayClassSerializer {
        private final Serializer componentSerializer;

        public NonexistentArrayClassSerializer(Fory fory, Class<?> cls) {
            this(fory, "Unknown", cls);
        }

        public NonexistentArrayClassSerializer(Fory fory, String className, Class<?> cls) {
            super(fory, className, cls);
            this.componentSerializer = TypeUtils.getArrayComponent(cls).isEnum() ? new NonexistentClassSerializers.NonexistentEnumClassSerializer(fory) : (fory.getConfig().getCompatibleMode() == CompatibleMode.COMPATIBLE ? new CompatibleSerializer<NonexistentClass.NonexistentSkip>(fory, NonexistentClass.NonexistentSkip.class) : null);
        }

        @Override
        protected Object readInnerElement(MemoryBuffer buffer) {
            if (this.componentSerializer == null) {
                throw new IllegalStateException(String.format("Class %s should serialize elements as non-morphic", this.className));
            }
            return this.componentSerializer.read(buffer);
        }
    }

    public static abstract class AbstractedNonexistentArrayClassSerializer
    extends Serializer {
        protected final String className;
        private final int dims;

        public AbstractedNonexistentArrayClassSerializer(Fory fory, String className, Class<?> stubClass) {
            super(fory, stubClass);
            this.className = className;
            this.dims = TypeUtils.getArrayDimensions(stubClass);
        }

        public Object[] read(MemoryBuffer buffer) {
            switch (this.dims) {
                case 1: {
                    return this.read1DArray(buffer);
                }
                case 2: {
                    return this.read2DArray(buffer);
                }
                case 3: {
                    return this.read3DArray(buffer);
                }
            }
            throw new UnsupportedOperationException(String.format("Unsupported array dimension %s for class %s", this.dims, this.className));
        }

        protected abstract Object readInnerElement(MemoryBuffer var1);

        private Object[] read1DArray(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            boolean isFinal = (numElements & 1) != 0;
            RefResolver refResolver = this.fory.getRefResolver();
            Object[] value = new Object[numElements >>>= 1];
            refResolver.reference(value);
            if (isFinal) {
                for (int i = 0; i < numElements; ++i) {
                    Object elem;
                    int nextReadRefId = refResolver.tryPreserveRefId(buffer);
                    if (nextReadRefId >= -1) {
                        elem = this.readInnerElement(buffer);
                        refResolver.setReadObject(nextReadRefId, elem);
                    } else {
                        elem = refResolver.getReadObject();
                    }
                    value[i] = elem;
                }
            } else {
                for (int i = 0; i < numElements; ++i) {
                    value[i] = this.fory.readRef(buffer);
                }
            }
            return value;
        }

        private Object[][] read2DArray(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            boolean isFinal = (numElements & 1) != 0;
            RefResolver refResolver = this.fory.getRefResolver();
            Object[][] value = new Object[numElements >>>= 1][];
            refResolver.reference(value);
            if (isFinal) {
                for (int i = 0; i < numElements; ++i) {
                    Object[] elem;
                    int nextReadRefId = refResolver.tryPreserveRefId(buffer);
                    if (nextReadRefId >= -1) {
                        elem = this.read1DArray(buffer);
                        refResolver.setReadObject(nextReadRefId, elem);
                    } else {
                        elem = (Object[])refResolver.getReadObject();
                    }
                    value[i] = elem;
                }
            } else {
                for (int i = 0; i < numElements; ++i) {
                    value[i] = (Object[])this.fory.readRef(buffer);
                }
            }
            return value;
        }

        private Object[] read3DArray(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            boolean isFinal = (numElements & 1) != 0;
            RefResolver refResolver = this.fory.getRefResolver();
            Object[][][] value = new Object[numElements >>>= 1][][];
            refResolver.reference(value);
            if (isFinal) {
                for (int i = 0; i < numElements; ++i) {
                    Object[][] elem;
                    int nextReadRefId = refResolver.tryPreserveRefId(buffer);
                    if (nextReadRefId >= -1) {
                        elem = this.read2DArray(buffer);
                        refResolver.setReadObject(nextReadRefId, elem);
                    } else {
                        elem = (Object[][])refResolver.getReadObject();
                    }
                    value[i] = elem;
                }
            } else {
                for (int i = 0; i < numElements; ++i) {
                    value[i] = (Object[][])this.fory.readRef(buffer);
                }
            }
            return value;
        }
    }

    public static final class StringArraySerializer
    extends Serializer<String[]> {
        private final StringSerializer stringSerializer;
        private final ForyArrayAsListSerializer collectionSerializer;
        private final ForyArrayAsListSerializer.ArrayAsList list;

        public StringArraySerializer(Fory fory) {
            super(fory, String[].class);
            this.stringSerializer = new StringSerializer(fory);
            this.collectionSerializer = new ForyArrayAsListSerializer(fory);
            this.collectionSerializer.setElementSerializer(this.stringSerializer);
            this.list = new ForyArrayAsListSerializer.ArrayAsList(0);
        }

        @Override
        public void write(MemoryBuffer buffer, String[] value) {
            int len = value.length;
            buffer.writeVarUint32Small7(len);
            if (len == 0) {
                return;
            }
            this.list.setArray(value);
            int flags = this.collectionSerializer.writeNullabilityHeader(buffer, this.list);
            this.list.clearArray();
            StringSerializer stringSerializer = this.stringSerializer;
            if ((flags & CollectionFlags.HAS_NULL) != CollectionFlags.HAS_NULL) {
                for (String elem : value) {
                    stringSerializer.write(buffer, elem);
                }
            } else {
                for (String elem : value) {
                    if (elem == null) {
                        buffer.writeByte((byte)-3);
                        continue;
                    }
                    buffer.writeByte((byte)-1);
                    stringSerializer.write(buffer, elem);
                }
            }
        }

        @Override
        public String[] copy(String[] originArray) {
            String[] newArray = new String[originArray.length];
            System.arraycopy(originArray, 0, newArray, 0, originArray.length);
            return newArray;
        }

        @Override
        public String[] read(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            String[] value = new String[numElements];
            if (numElements == 0) {
                return value;
            }
            byte flags = buffer.readByte();
            StringSerializer serializer = this.stringSerializer;
            if ((flags & CollectionFlags.HAS_NULL) != CollectionFlags.HAS_NULL) {
                for (int i = 0; i < numElements; ++i) {
                    value[i] = serializer.readJavaString(buffer);
                }
            } else {
                for (int i = 0; i < numElements; ++i) {
                    if (buffer.readByte() == -3) continue;
                    value[i] = serializer.readJavaString(buffer);
                }
            }
            return value;
        }

        @Override
        public void xwrite(MemoryBuffer buffer, String[] value) {
            int len = value.length;
            buffer.writeVarUint32Small7(len);
            for (String elem : value) {
                if (elem != null) {
                    buffer.writeByte((byte)-1);
                    this.stringSerializer.writeString(buffer, elem);
                    continue;
                }
                buffer.writeByte((byte)-3);
            }
        }

        @Override
        public String[] xread(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            String[] value = new String[numElements];
            for (int i = 0; i < numElements; ++i) {
                value[i] = buffer.readByte() >= -1 ? this.stringSerializer.readString(buffer) : null;
            }
            return value;
        }
    }

    public static final class DoubleArraySerializer
    extends PrimitiveArraySerializer<double[]> {
        public DoubleArraySerializer(Fory fory) {
            super(fory, double[].class);
        }

        @Override
        public void write(MemoryBuffer buffer, double[] value) {
            if (this.fory.getBufferCallback() == null) {
                int size = Math.multiplyExact(value.length, this.elemSize);
                buffer.writePrimitiveArrayWithSize(value, this.offset, size);
            } else {
                this.fory.writeBufferObject(buffer, new PrimitiveArrayBufferObject(value, this.offset, this.elemSize, value.length));
            }
        }

        @Override
        public double[] copy(double[] originArray) {
            return Arrays.copyOf(originArray, originArray.length);
        }

        @Override
        public double[] read(MemoryBuffer buffer) {
            if (this.fory.isPeerOutOfBandEnabled()) {
                MemoryBuffer buf = this.fory.readBufferObject(buffer);
                int size = buf.remaining();
                int numElements = size / this.elemSize;
                double[] values = new double[numElements];
                buf.copyToUnsafe(0L, values, this.offset, size);
                return values;
            }
            int size = buffer.readVarUint32Small7();
            int numElements = size / this.elemSize;
            double[] values = new double[numElements];
            buffer.readToUnsafe(values, this.offset, size);
            return values;
        }
    }

    public static final class FloatArraySerializer
    extends PrimitiveArraySerializer<float[]> {
        public FloatArraySerializer(Fory fory) {
            super(fory, float[].class);
        }

        @Override
        public void write(MemoryBuffer buffer, float[] value) {
            if (this.fory.getBufferCallback() == null) {
                int size = Math.multiplyExact(value.length, this.elemSize);
                buffer.writePrimitiveArrayWithSize(value, this.offset, size);
            } else {
                this.fory.writeBufferObject(buffer, new PrimitiveArrayBufferObject(value, this.offset, this.elemSize, value.length));
            }
        }

        @Override
        public float[] copy(float[] originArray) {
            return Arrays.copyOf(originArray, originArray.length);
        }

        @Override
        public float[] read(MemoryBuffer buffer) {
            if (this.fory.isPeerOutOfBandEnabled()) {
                MemoryBuffer buf = this.fory.readBufferObject(buffer);
                int size = buf.remaining();
                int numElements = size / this.elemSize;
                float[] values = new float[numElements];
                buf.copyToUnsafe(0L, values, this.offset, size);
                return values;
            }
            int size = buffer.readVarUint32Small7();
            int numElements = size / this.elemSize;
            float[] values = new float[numElements];
            buffer.readToUnsafe(values, this.offset, size);
            return values;
        }
    }

    public static final class LongArraySerializer
    extends PrimitiveArraySerializer<long[]> {
        public LongArraySerializer(Fory fory) {
            super(fory, long[].class);
        }

        @Override
        public void write(MemoryBuffer buffer, long[] value) {
            if (this.fory.getBufferCallback() == null) {
                int size = Math.multiplyExact(value.length, this.elemSize);
                buffer.writePrimitiveArrayWithSize(value, this.offset, size);
            } else {
                this.fory.writeBufferObject(buffer, new PrimitiveArrayBufferObject(value, this.offset, this.elemSize, value.length));
            }
        }

        @Override
        public long[] copy(long[] originArray) {
            return Arrays.copyOf(originArray, originArray.length);
        }

        @Override
        public long[] read(MemoryBuffer buffer) {
            if (this.fory.isPeerOutOfBandEnabled()) {
                MemoryBuffer buf = this.fory.readBufferObject(buffer);
                int size = buf.remaining();
                int numElements = size / this.elemSize;
                long[] values = new long[numElements];
                buf.copyToUnsafe(0L, values, this.offset, size);
                return values;
            }
            int size = buffer.readVarUint32Small7();
            int numElements = size / this.elemSize;
            long[] values = new long[numElements];
            buffer.readToUnsafe(values, this.offset, size);
            return values;
        }
    }

    public static final class IntArraySerializer
    extends PrimitiveArraySerializer<int[]> {
        public IntArraySerializer(Fory fory) {
            super(fory, int[].class);
        }

        @Override
        public void write(MemoryBuffer buffer, int[] value) {
            if (this.fory.getBufferCallback() == null) {
                int size = Math.multiplyExact(value.length, this.elemSize);
                buffer.writePrimitiveArrayWithSize(value, this.offset, size);
            } else {
                this.fory.writeBufferObject(buffer, new PrimitiveArrayBufferObject(value, this.offset, this.elemSize, value.length));
            }
        }

        @Override
        public int[] copy(int[] originArray) {
            return Arrays.copyOf(originArray, originArray.length);
        }

        @Override
        public int[] read(MemoryBuffer buffer) {
            if (this.fory.isPeerOutOfBandEnabled()) {
                MemoryBuffer buf = this.fory.readBufferObject(buffer);
                int size = buf.remaining();
                int numElements = size / this.elemSize;
                int[] values = new int[numElements];
                buf.copyToUnsafe(0L, values, this.offset, size);
                return values;
            }
            int size = buffer.readVarUint32Small7();
            int numElements = size / this.elemSize;
            int[] values = new int[numElements];
            buffer.readToUnsafe(values, this.offset, size);
            return values;
        }
    }

    public static final class ShortArraySerializer
    extends PrimitiveArraySerializer<short[]> {
        public ShortArraySerializer(Fory fory) {
            super(fory, short[].class);
        }

        @Override
        public void write(MemoryBuffer buffer, short[] value) {
            if (this.fory.getBufferCallback() == null) {
                int size = Math.multiplyExact(value.length, this.elemSize);
                buffer.writePrimitiveArrayWithSize(value, this.offset, size);
            } else {
                this.fory.writeBufferObject(buffer, new PrimitiveArrayBufferObject(value, this.offset, this.elemSize, value.length));
            }
        }

        @Override
        public short[] copy(short[] originArray) {
            return Arrays.copyOf(originArray, originArray.length);
        }

        @Override
        public short[] read(MemoryBuffer buffer) {
            if (this.fory.isPeerOutOfBandEnabled()) {
                MemoryBuffer buf = this.fory.readBufferObject(buffer);
                int size = buf.remaining();
                int numElements = size / this.elemSize;
                short[] values = new short[numElements];
                buf.copyToUnsafe(0L, values, this.offset, size);
                return values;
            }
            int size = buffer.readVarUint32Small7();
            int numElements = size / this.elemSize;
            short[] values = new short[numElements];
            buffer.readToUnsafe(values, this.offset, size);
            return values;
        }
    }

    public static final class CharArraySerializer
    extends PrimitiveArraySerializer<char[]> {
        public CharArraySerializer(Fory fory) {
            super(fory, char[].class);
        }

        @Override
        public void write(MemoryBuffer buffer, char[] value) {
            if (this.fory.getBufferCallback() == null) {
                int size = Math.multiplyExact(value.length, this.elemSize);
                buffer.writePrimitiveArrayWithSize(value, this.offset, size);
            } else {
                this.fory.writeBufferObject(buffer, new PrimitiveArrayBufferObject(value, this.offset, this.elemSize, value.length));
            }
        }

        @Override
        public char[] copy(char[] originArray) {
            return Arrays.copyOf(originArray, originArray.length);
        }

        @Override
        public char[] read(MemoryBuffer buffer) {
            if (this.fory.isPeerOutOfBandEnabled()) {
                MemoryBuffer buf = this.fory.readBufferObject(buffer);
                int size = buf.remaining();
                int numElements = size / this.elemSize;
                char[] values = new char[numElements];
                buf.copyToUnsafe(0L, values, this.offset, size);
                return values;
            }
            int size = buffer.readVarUint32Small7();
            int numElements = size / this.elemSize;
            char[] values = new char[numElements];
            buffer.readToUnsafe(values, this.offset, size);
            return values;
        }

        @Override
        public void xwrite(MemoryBuffer buffer, char[] value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public char[] xread(MemoryBuffer buffer) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class ByteArraySerializer
    extends PrimitiveArraySerializer<byte[]> {
        public ByteArraySerializer(Fory fory) {
            super(fory, byte[].class);
        }

        @Override
        public void write(MemoryBuffer buffer, byte[] value) {
            if (this.fory.getBufferCallback() == null) {
                int size = Math.multiplyExact(value.length, 1);
                buffer.writePrimitiveArrayWithSize(value, this.offset, size);
            } else {
                this.fory.writeBufferObject(buffer, new PrimitiveArrayBufferObject(value, this.offset, 1, value.length));
            }
        }

        @Override
        public byte[] copy(byte[] originArray) {
            return Arrays.copyOf(originArray, originArray.length);
        }

        @Override
        public byte[] read(MemoryBuffer buffer) {
            if (this.fory.isPeerOutOfBandEnabled()) {
                MemoryBuffer buf = this.fory.readBufferObject(buffer);
                int size = buf.remaining();
                byte[] values = new byte[size];
                buf.copyToUnsafe(0L, values, this.offset, size);
                return values;
            }
            int size = buffer.readVarUint32Small7();
            byte[] values = new byte[size];
            buffer.readToUnsafe(values, this.offset, size);
            return values;
        }
    }

    public static final class BooleanArraySerializer
    extends PrimitiveArraySerializer<boolean[]> {
        public BooleanArraySerializer(Fory fory) {
            super(fory, boolean[].class);
        }

        @Override
        public void write(MemoryBuffer buffer, boolean[] value) {
            if (this.fory.getBufferCallback() == null) {
                int size = Math.multiplyExact(value.length, this.elemSize);
                buffer.writePrimitiveArrayWithSize(value, this.offset, size);
            } else {
                this.fory.writeBufferObject(buffer, new PrimitiveArrayBufferObject(value, this.offset, this.elemSize, value.length));
            }
        }

        @Override
        public boolean[] copy(boolean[] originArray) {
            return Arrays.copyOf(originArray, originArray.length);
        }

        @Override
        public boolean[] read(MemoryBuffer buffer) {
            if (this.fory.isPeerOutOfBandEnabled()) {
                MemoryBuffer buf = this.fory.readBufferObject(buffer);
                int size = buf.remaining();
                int numElements = size / this.elemSize;
                boolean[] values = new boolean[numElements];
                buf.copyToUnsafe(0L, values, this.offset, size);
                return values;
            }
            int size = buffer.readVarUint32Small7();
            int numElements = size / this.elemSize;
            boolean[] values = new boolean[numElements];
            buffer.readToUnsafe(values, this.offset, size);
            return values;
        }
    }

    public static abstract class PrimitiveArraySerializer<T>
    extends Serializers.CrossLanguageCompatibleSerializer<T> {
        protected final int offset;
        protected final int elemSize;

        public PrimitiveArraySerializer(Fory fory, Class<T> cls) {
            super(fory, cls);
            Class innerType = (Class)TypeUtils.getArrayComponentInfo(cls).f0;
            this.offset = primitiveInfo.get(innerType)[0];
            this.elemSize = primitiveInfo.get(innerType)[1];
        }

        @Override
        public void xwrite(MemoryBuffer buffer, T value) {
            this.write(buffer, value);
        }

        @Override
        public T xread(MemoryBuffer buffer) {
            return this.read(buffer);
        }
    }

    public static final class PrimitiveArrayBufferObject
    implements BufferObject {
        private final Object array;
        private final int offset;
        private final int elemSize;
        private final int length;

        public PrimitiveArrayBufferObject(Object array, int offset, int elemSize, int length) {
            this.array = array;
            this.offset = offset;
            this.elemSize = elemSize;
            this.length = length;
        }

        @Override
        public int totalBytes() {
            return this.length * this.elemSize;
        }

        @Override
        public void writeTo(MemoryBuffer buffer) {
            int size = Math.multiplyExact(this.length, this.elemSize);
            int writerIndex = buffer.writerIndex();
            int end = writerIndex + size;
            buffer.ensure(end);
            buffer.copyFromUnsafe(writerIndex, this.array, this.offset, size);
            buffer.writerIndex(end);
        }

        @Override
        public MemoryBuffer toBuffer() {
            MemoryBuffer buffer = MemoryBuffer.newHeapBuffer(this.totalBytes());
            this.writeTo(buffer);
            return buffer.slice(0, buffer.writerIndex());
        }
    }

    public static final class ObjectArraySerializer<T>
    extends Serializer<T[]> {
        private final Class<T> innerType;
        private final Serializer componentTypeSerializer;
        private final ClassInfoHolder classInfoHolder;
        private final int[] stubDims;
        private final GenericType componentGenericType;

        public ObjectArraySerializer(Fory fory, Class<T[]> cls) {
            super(fory, cls);
            fory.getClassResolver().setSerializer(cls, this);
            Preconditions.checkArgument(cls.isArray());
            Class<Object> t = cls;
            Class<T[]> innerType = cls;
            int dimension = 0;
            while (t != null && t.isArray()) {
                ++dimension;
                if ((t = t.getComponentType()) == null) continue;
                innerType = t;
            }
            this.innerType = innerType;
            Class<?> componentType = cls.getComponentType();
            this.componentGenericType = fory.getClassResolver().buildGenericType(componentType);
            this.componentTypeSerializer = fory.getClassResolver().isMonomorphic(componentType) ? (fory.isCrossLanguage() ? null : fory.getClassResolver().getSerializer(componentType)) : null;
            this.stubDims = new int[dimension];
            this.classInfoHolder = fory.getClassResolver().nilClassInfoHolder();
        }

        @Override
        public void write(MemoryBuffer buffer, T[] arr) {
            int len = arr.length;
            RefResolver refResolver = this.fory.getRefResolver();
            Serializer componentSerializer = this.componentTypeSerializer;
            int header = componentSerializer != null ? 1 : 0;
            buffer.writeVarUint32Small7(len << 1 | header);
            if (componentSerializer != null) {
                for (T t : arr) {
                    if (refResolver.writeRefOrNull(buffer, t)) continue;
                    componentSerializer.write(buffer, t);
                }
            } else {
                Fory fory = this.fory;
                ClassResolver classResolver = fory.getClassResolver();
                ClassInfo classInfo = null;
                Class<?> elemClass = null;
                for (T t : arr) {
                    if (refResolver.writeRefOrNull(buffer, t)) continue;
                    Class<?> clz = t.getClass();
                    if (clz != elemClass) {
                        elemClass = clz;
                        classInfo = classResolver.getClassInfo(clz);
                    }
                    fory.writeNonRef(buffer, t, classInfo);
                }
            }
        }

        @Override
        public T[] copy(T[] originArray) {
            Serializer componentSerializer;
            int length = originArray.length;
            Object[] newArray = this.newArray(length);
            if (this.needToCopyRef) {
                this.fory.reference(originArray, newArray);
            }
            if ((componentSerializer = this.componentTypeSerializer) != null) {
                if (componentSerializer.isImmutable()) {
                    System.arraycopy(originArray, 0, newArray, 0, length);
                } else {
                    for (int i = 0; i < length; ++i) {
                        newArray[i] = componentSerializer.copy(originArray[i]);
                    }
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    newArray[i] = this.fory.copyObject(originArray[i]);
                }
            }
            return newArray;
        }

        @Override
        public void xwrite(MemoryBuffer buffer, T[] arr) {
            int len = arr.length;
            buffer.writeVarUint32Small7(len);
            for (T t : arr) {
                this.fory.xwriteRef(buffer, t);
            }
        }

        @Override
        public T[] read(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            boolean isFinal = (numElements & 1) != 0;
            Object[] value = this.newArray(numElements >>>= 1);
            RefResolver refResolver = this.fory.getRefResolver();
            refResolver.reference(value);
            if (isFinal) {
                Serializer componentTypeSerializer = this.componentTypeSerializer;
                for (int i = 0; i < numElements; ++i) {
                    Object elem;
                    int nextReadRefId = refResolver.tryPreserveRefId(buffer);
                    if (nextReadRefId >= -1) {
                        elem = componentTypeSerializer.read(buffer);
                        refResolver.setReadObject(nextReadRefId, elem);
                    } else {
                        elem = refResolver.getReadObject();
                    }
                    value[i] = elem;
                }
            } else {
                Fory fory = this.fory;
                ClassInfoHolder classInfoHolder = this.classInfoHolder;
                for (int i = 0; i < numElements; ++i) {
                    Object o;
                    int nextReadRefId = refResolver.tryPreserveRefId(buffer);
                    if (nextReadRefId >= -1) {
                        o = fory.readNonRef(buffer, classInfoHolder);
                        refResolver.setReadObject(nextReadRefId, o);
                    } else {
                        o = refResolver.getReadObject();
                    }
                    value[i] = o;
                }
            }
            return value;
        }

        @Override
        public T[] xread(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            Object[] value = this.newArray(numElements);
            this.fory.getGenerics().pushGenericType(this.componentGenericType);
            for (int i = 0; i < numElements; ++i) {
                Object x;
                value[i] = x = this.fory.xreadRef(buffer);
            }
            this.fory.getGenerics().popGenericType();
            return value;
        }

        private Object[] newArray(int numElements) {
            Object[] value;
            if (this.type == Object[].class) {
                value = new Object[numElements];
            } else {
                this.stubDims[0] = numElements;
                value = (Object[])Array.newInstance(this.innerType, this.stubDims);
            }
            return value;
        }
    }
}

