/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer;

import org.apache.fory.collection.LazyMap;
import org.apache.fory.meta.ClassDef;
import org.apache.fory.type.TypeUtils;

public interface NonexistentClass {
    public static final Class<?> NonexistentEnum1DArray = NonexistentEnum[].class;
    public static final Class<?> NonexistentEnum2DArray = NonexistentEnum[][].class;
    public static final Class<?> NonexistentEnum3DArray = NonexistentEnum[][][].class;
    public static final Class<?> NonexistentSkip1DArray = NonexistentSkip[].class;
    public static final Class<?> NonexistentSkip2DArray = NonexistentSkip[][].class;
    public static final Class<?> NonexistentSkip3DArray = NonexistentSkip[][][].class;
    public static final Class<?> Nonexistent1DArray = NonexistentMetaShared[].class;
    public static final Class<?> Nonexistent2DArray = NonexistentMetaShared[][].class;
    public static final Class<?> Nonexistent3DArray = NonexistentMetaShared[][][].class;

    public static boolean isNonexistent(Class<?> cls) {
        if (cls.isArray()) {
            Class<?> component = TypeUtils.getArrayComponent(cls);
            return NonexistentClass.class.isAssignableFrom(component);
        }
        return NonexistentClass.class.isAssignableFrom(cls);
    }

    public static Class<?> getNonexistentClass(boolean isEnum, int arrayDims, boolean shareMeta) {
        return NonexistentClass.getNonexistentClass("Unknown", isEnum, arrayDims, shareMeta);
    }

    public static Class<?> getNonexistentClass(String className, boolean isEnum, int arrayDims, boolean shareMeta) {
        if (arrayDims != 0) {
            if (isEnum) {
                switch (arrayDims) {
                    case 1: {
                        return NonexistentEnum1DArray;
                    }
                    case 2: {
                        return NonexistentEnum2DArray;
                    }
                    case 3: {
                        return NonexistentEnum3DArray;
                    }
                }
                throw new UnsupportedOperationException(String.format("Unsupported array dimensions %s for nonexistent class %s", arrayDims, className));
            }
            switch (arrayDims) {
                case 1: {
                    return shareMeta ? Nonexistent1DArray : NonexistentSkip1DArray;
                }
                case 2: {
                    return shareMeta ? Nonexistent2DArray : NonexistentSkip2DArray;
                }
                case 3: {
                    return shareMeta ? Nonexistent3DArray : NonexistentSkip3DArray;
                }
            }
            throw new UnsupportedOperationException(String.format("Unsupported array dimensions %s for nonexistent class %s", arrayDims, className));
        }
        if (isEnum) {
            return NonexistentEnum.class;
        }
        return shareMeta ? NonexistentMetaShared.class : NonexistentSkip.class;
    }

    public static class NonexistentMetaShared
    extends LazyMap
    implements NonexistentClass {
        final ClassDef classDef;

        public NonexistentMetaShared(ClassDef classDef) {
            this.classDef = classDef;
        }
    }

    public static class NonexistentSkip
    implements NonexistentClass {
    }

    public static enum NonexistentEnum implements NonexistentClass
    {
        V0,
        V1,
        V2,
        V3,
        V4,
        V5,
        V6,
        V7,
        V8,
        V9,
        V10,
        V11,
        V12,
        V13,
        V14,
        V15,
        V16,
        V17,
        V18,
        V19,
        V20,
        V21,
        V22,
        V23,
        V24,
        V25,
        V26,
        V27,
        V28,
        V29,
        V30,
        V31,
        V32,
        V33,
        V34,
        V35,
        V36,
        V37,
        V38,
        V39,
        V40,
        V41,
        V42,
        V43,
        V44,
        V45,
        V46,
        V47,
        V48,
        V49,
        V50,
        V51,
        V52,
        V53,
        V54,
        V55,
        V56,
        V57,
        V58,
        V59,
        V60,
        V61,
        V62,
        V63,
        UNKNOWN;

    }
}

