/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer.collection;

import com.google.common.collect.ImmutableMap;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;
import org.apache.fory.Fory;
import org.apache.fory.collection.IdentityMap;
import org.apache.fory.collection.Tuple2;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.reflect.ReflectionUtils;
import org.apache.fory.reflect.TypeRef;
import org.apache.fory.resolver.ClassInfo;
import org.apache.fory.resolver.ClassInfoHolder;
import org.apache.fory.resolver.RefResolver;
import org.apache.fory.resolver.TypeResolver;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.serializer.collection.MapFlags;
import org.apache.fory.serializer.collection.SerializationBinding;
import org.apache.fory.type.GenericType;
import org.apache.fory.type.Generics;
import org.apache.fory.type.TypeUtils;

public abstract class AbstractMapSerializer<T>
extends Serializer<T> {
    public static final int MAX_CHUNK_SIZE = 255;
    protected MethodHandle constructor;
    protected final boolean supportCodegenHook;
    private Serializer keySerializer;
    private Serializer valueSerializer;
    protected final ClassInfoHolder keyClassInfoWriteCache;
    protected final ClassInfoHolder keyClassInfoReadCache;
    protected final ClassInfoHolder valueClassInfoWriteCache;
    protected final ClassInfoHolder valueClassInfoReadCache;
    private final IdentityMap<GenericType, GenericType> partialGenericKVTypeMap;
    private final GenericType objType;
    private int numElements;
    private final TypeResolver typeResolver;
    protected final SerializationBinding binding;

    public AbstractMapSerializer(Fory fory, Class<T> cls) {
        this(fory, cls, !ReflectionUtils.isDynamicGeneratedCLass(cls));
    }

    public AbstractMapSerializer(Fory fory, Class<T> cls, boolean supportCodegenHook) {
        this(fory, cls, supportCodegenHook, false);
    }

    public AbstractMapSerializer(Fory fory, Class<T> cls, boolean supportCodegenHook, boolean immutable) {
        super(fory, cls, immutable);
        this.typeResolver = fory.isCrossLanguage() ? fory.getXtypeResolver() : fory.getClassResolver();
        this.supportCodegenHook = supportCodegenHook;
        this.keyClassInfoWriteCache = this.typeResolver.nilClassInfoHolder();
        this.keyClassInfoReadCache = this.typeResolver.nilClassInfoHolder();
        this.valueClassInfoWriteCache = this.typeResolver.nilClassInfoHolder();
        this.valueClassInfoReadCache = this.typeResolver.nilClassInfoHolder();
        this.partialGenericKVTypeMap = new IdentityMap();
        this.objType = this.typeResolver.buildGenericType((Type)((Object)Object.class));
        this.binding = SerializationBinding.createBinding(fory);
    }

    public void setKeySerializer(Serializer keySerializer) {
        this.keySerializer = keySerializer;
    }

    public void setValueSerializer(Serializer valueSerializer) {
        this.valueSerializer = valueSerializer;
    }

    @Override
    public void write(MemoryBuffer buffer, T value) {
        Map map = this.onMapWrite(buffer, value);
        Serializer keySerializer = this.keySerializer;
        Serializer valueSerializer = this.valueSerializer;
        this.keySerializer = null;
        this.valueSerializer = null;
        if (map.isEmpty()) {
            return;
        }
        TypeResolver classResolver = this.typeResolver;
        Iterator<Map.Entry<Object, Object>> iterator = map.entrySet().iterator();
        Map.Entry entry = iterator.next();
        while (entry != null) {
            GenericType valueGenericType;
            GenericType keyGenericType;
            if (keySerializer != null || valueSerializer != null) {
                if ((entry = this.writeJavaNullChunk(buffer, entry, iterator, keySerializer, valueSerializer)) == null) continue;
                entry = this.writeJavaChunk(classResolver, buffer, entry, iterator, keySerializer, valueSerializer);
                continue;
            }
            Generics generics = this.fory.getGenerics();
            GenericType genericType = generics.nextGenericType();
            if (genericType == null) {
                if ((entry = this.writeJavaNullChunk(buffer, entry, iterator, null, null)) == null) continue;
                entry = this.writeJavaChunk(classResolver, buffer, entry, iterator, null, null);
                continue;
            }
            if (genericType.getTypeParametersCount() < 2) {
                genericType = this.getKVGenericType(genericType);
            }
            if ((entry = this.writeJavaNullChunkGeneric(buffer, entry, iterator, keyGenericType = genericType.getTypeParameter0(), valueGenericType = genericType.getTypeParameter1())) == null) continue;
            entry = this.writeJavaChunkGeneric(classResolver, generics, genericType, buffer, entry, iterator);
        }
    }

    @Override
    public void xwrite(MemoryBuffer buffer, T value) {
        this.write(buffer, value);
    }

    public final Map.Entry writeJavaNullChunk(MemoryBuffer buffer, Map.Entry entry, Iterator<Map.Entry<Object, Object>> iterator, Serializer keySerializer, Serializer valueSerializer) {
        while (true) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key != null) {
                if (value != null) {
                    return entry;
                }
                this.writeNullValueChunk(buffer, keySerializer, key);
            } else {
                this.writeNullKeyChunk(buffer, valueSerializer, value);
            }
            if (!iterator.hasNext()) break;
            entry = iterator.next();
        }
        return null;
    }

    private void writeNullValueChunk(MemoryBuffer buffer, Serializer keySerializer, Object key) {
        if (keySerializer != null) {
            if (keySerializer.needToWriteRef()) {
                buffer.writeByte(MapFlags.NULL_VALUE_KEY_DECL_TYPE_TRACKING_REF);
                this.binding.writeRef(buffer, key, keySerializer);
            } else {
                buffer.writeByte(MapFlags.NULL_VALUE_KEY_DECL_TYPE);
                this.binding.write(buffer, keySerializer, key);
            }
        } else {
            buffer.writeByte(MapFlags.VALUE_HAS_NULL | MapFlags.TRACKING_KEY_REF);
            this.binding.writeRef(buffer, key, this.keyClassInfoWriteCache);
        }
    }

    private void writeNullKeyChunk(MemoryBuffer buffer, Serializer valueSerializer, Object value) {
        if (value != null) {
            if (valueSerializer != null) {
                if (valueSerializer.needToWriteRef()) {
                    buffer.writeByte(MapFlags.NULL_KEY_VALUE_DECL_TYPE_TRACKING_REF);
                    this.binding.writeRef(buffer, value, valueSerializer);
                } else {
                    buffer.writeByte(MapFlags.NULL_KEY_VALUE_DECL_TYPE);
                    this.binding.write(buffer, valueSerializer, value);
                }
            } else {
                buffer.writeByte(MapFlags.KEY_HAS_NULL | MapFlags.TRACKING_VALUE_REF);
                this.binding.writeRef(buffer, value, this.valueClassInfoWriteCache);
            }
        } else {
            buffer.writeByte(MapFlags.KV_NULL);
        }
    }

    public final Map.Entry writeNullChunkKVFinalNoRef(MemoryBuffer buffer, Map.Entry entry, Iterator<Map.Entry<Object, Object>> iterator, Serializer keySerializer, Serializer valueSerializer) {
        while (true) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key != null) {
                if (value != null) {
                    return entry;
                }
                buffer.writeByte(MapFlags.NULL_VALUE_KEY_DECL_TYPE);
                this.binding.write(buffer, keySerializer, key);
            } else {
                this.writeNullKeyChunk(buffer, valueSerializer, value);
            }
            if (!iterator.hasNext()) break;
            entry = iterator.next();
        }
        return null;
    }

    public final Map.Entry writeJavaNullChunkGeneric(MemoryBuffer buffer, Map.Entry entry, Iterator<Map.Entry<Object, Object>> iterator, GenericType keyType, GenericType valueType) {
        while (true) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key != null) {
                if (value != null) {
                    return entry;
                }
                this.writeKeyForNullValueChunkGeneric(buffer, key, keyType);
            } else {
                this.writeValueForNullKeyChunkGeneric(buffer, value, valueType);
            }
            if (!iterator.hasNext()) break;
            entry = iterator.next();
        }
        return null;
    }

    private void writeKeyForNullValueChunkGeneric(MemoryBuffer buffer, Object key, GenericType keyType) {
        if (!keyType.isMonomorphic()) {
            buffer.writeByte(MapFlags.VALUE_HAS_NULL | MapFlags.TRACKING_KEY_REF);
            this.binding.writeRef(buffer, key, this.keyClassInfoWriteCache);
            return;
        }
        Serializer<?> serializer = keyType.getSerializer(this.typeResolver);
        if (keyType.hasGenericParameters()) {
            this.fory.getGenerics().pushGenericType(keyType);
            this.fory.incDepth(1);
        }
        if (serializer.needToWriteRef()) {
            buffer.writeByte(MapFlags.NULL_VALUE_KEY_DECL_TYPE_TRACKING_REF);
            this.binding.writeRef(buffer, key, serializer);
        } else {
            buffer.writeByte(MapFlags.NULL_VALUE_KEY_DECL_TYPE);
            this.binding.write(buffer, serializer, key);
        }
        if (keyType.hasGenericParameters()) {
            this.fory.incDepth(-1);
            this.fory.getGenerics().popGenericType();
        }
    }

    private void writeValueForNullKeyChunkGeneric(MemoryBuffer buffer, Object value, GenericType valueType) {
        if (!valueType.isMonomorphic()) {
            buffer.writeByte(MapFlags.KEY_HAS_NULL | MapFlags.TRACKING_VALUE_REF);
            this.binding.writeRef(buffer, value, this.valueClassInfoWriteCache);
            return;
        }
        Serializer<?> serializer = valueType.getSerializer(this.typeResolver);
        if (valueType.hasGenericParameters()) {
            this.fory.getGenerics().pushGenericType(valueType);
            this.fory.incDepth(1);
        }
        if (serializer.needToWriteRef()) {
            buffer.writeByte(MapFlags.NULL_KEY_VALUE_DECL_TYPE_TRACKING_REF);
            this.binding.writeRef(buffer, value, serializer);
        } else {
            buffer.writeByte(MapFlags.NULL_KEY_VALUE_DECL_TYPE);
            this.binding.write(buffer, serializer, value);
        }
        if (valueType.hasGenericParameters()) {
            this.fory.incDepth(-1);
            this.fory.getGenerics().popGenericType();
        }
    }

    private Map.Entry writeJavaChunk(TypeResolver classResolver, MemoryBuffer buffer, Map.Entry<Object, Object> entry, Iterator<Map.Entry<Object, Object>> iterator, Serializer keySerializer, Serializer valueSerializer) {
        Object key = entry.getKey();
        Object value = entry.getValue();
        Class<?> keyType = key.getClass();
        Class<?> valueType = value.getClass();
        buffer.writeInt16((short)-1);
        int chunkSizeOffset = buffer.writerIndex() - 1;
        int chunkHeader = 0;
        if (keySerializer != null) {
            chunkHeader |= MapFlags.KEY_DECL_TYPE;
        } else {
            keySerializer = this.writeKeyClassInfo(classResolver, keyType, buffer);
        }
        if (valueSerializer != null) {
            chunkHeader |= MapFlags.VALUE_DECL_TYPE;
        } else {
            valueSerializer = this.writeValueClassInfo(classResolver, valueType, buffer);
        }
        boolean keyWriteRef = keySerializer.needToWriteRef();
        boolean valueWriteRef = valueSerializer.needToWriteRef();
        if (keyWriteRef) {
            chunkHeader |= MapFlags.TRACKING_KEY_REF;
        }
        if (valueWriteRef) {
            chunkHeader |= MapFlags.TRACKING_VALUE_REF;
        }
        buffer.putByte(chunkSizeOffset - 1, (byte)chunkHeader);
        RefResolver refResolver = this.fory.getRefResolver();
        int chunkSize = 0;
        while (key != null && value != null && key.getClass() == keyType && value.getClass() == valueType) {
            if (!keyWriteRef || !refResolver.writeRefOrNull(buffer, key)) {
                this.binding.write(buffer, keySerializer, key);
            }
            if (!valueWriteRef || !refResolver.writeRefOrNull(buffer, value)) {
                this.binding.write(buffer, valueSerializer, value);
            }
            ++chunkSize;
            if (!iterator.hasNext()) {
                entry = null;
                break;
            }
            entry = iterator.next();
            key = entry.getKey();
            value = entry.getValue();
            if (chunkSize != 255) continue;
        }
        buffer.putByte(chunkSizeOffset, (byte)chunkSize);
        return entry;
    }

    private Serializer writeKeyClassInfo(TypeResolver classResolver, Class keyType, MemoryBuffer buffer) {
        ClassInfo classInfo = classResolver.getClassInfo(keyType, this.keyClassInfoWriteCache);
        classResolver.writeClassInfo(buffer, classInfo);
        return classInfo.getSerializer();
    }

    private Serializer writeValueClassInfo(TypeResolver classResolver, Class valueType, MemoryBuffer buffer) {
        ClassInfo classInfo = classResolver.getClassInfo(valueType, this.valueClassInfoWriteCache);
        classResolver.writeClassInfo(buffer, classInfo);
        return classInfo.getSerializer();
    }

    public Map.Entry writeJavaChunkGeneric(TypeResolver classResolver, Generics generics, GenericType genericType, MemoryBuffer buffer, Map.Entry<Object, Object> entry, Iterator<Map.Entry<Object, Object>> iterator) {
        boolean valueWriteRef;
        Serializer<?> valueSerializer;
        Serializer<?> keySerializer;
        if (genericType.getTypeParametersCount() < 2) {
            genericType = this.getKVGenericType(genericType);
        }
        GenericType keyGenericType = genericType.getTypeParameter0();
        GenericType valueGenericType = genericType.getTypeParameter1();
        if (keyGenericType == this.objType && valueGenericType == this.objType) {
            return this.writeJavaChunk(classResolver, buffer, entry, iterator, null, null);
        }
        boolean keyGenericTypeFinal = keyGenericType.isMonomorphic();
        boolean valueGenericTypeFinal = valueGenericType.isMonomorphic();
        Object key = entry.getKey();
        Object value = entry.getValue();
        Class<?> keyType = key.getClass();
        Class<?> valueType = value.getClass();
        buffer.writeInt16((short)-1);
        int chunkSizeOffset = buffer.writerIndex() - 1;
        int chunkHeader = 0;
        if (keyGenericTypeFinal) {
            chunkHeader |= MapFlags.KEY_DECL_TYPE;
            keySerializer = keyGenericType.getSerializer(classResolver);
        } else {
            keySerializer = this.writeKeyClassInfo(classResolver, keyType, buffer);
        }
        if (valueGenericTypeFinal) {
            chunkHeader |= MapFlags.VALUE_DECL_TYPE;
            valueSerializer = valueGenericType.getSerializer(classResolver);
        } else {
            valueSerializer = this.writeValueClassInfo(classResolver, valueType, buffer);
        }
        boolean keyWriteRef = keySerializer.needToWriteRef();
        if (keyWriteRef) {
            chunkHeader |= MapFlags.TRACKING_KEY_REF;
        }
        if (valueWriteRef = valueSerializer.needToWriteRef()) {
            chunkHeader |= MapFlags.TRACKING_VALUE_REF;
        }
        buffer.putByte(chunkSizeOffset - 1, (byte)chunkHeader);
        RefResolver refResolver = this.fory.getRefResolver();
        int chunkSize = 0;
        while (key != null && value != null && key.getClass() == keyType && value.getClass() == valueType) {
            generics.pushGenericType(keyGenericType);
            if (!keyWriteRef || !refResolver.writeRefOrNull(buffer, key)) {
                this.fory.incDepth(1);
                this.binding.write(buffer, keySerializer, key);
                this.fory.incDepth(-1);
            }
            generics.popGenericType();
            generics.pushGenericType(valueGenericType);
            if (!valueWriteRef || !refResolver.writeRefOrNull(buffer, value)) {
                this.fory.incDepth(1);
                this.binding.write(buffer, valueSerializer, value);
                this.fory.incDepth(-1);
            }
            generics.popGenericType();
            ++chunkSize;
            if (!iterator.hasNext()) {
                entry = null;
                break;
            }
            entry = iterator.next();
            key = entry.getKey();
            value = entry.getValue();
            if (chunkSize != 255) continue;
        }
        buffer.putByte(chunkSizeOffset, (byte)chunkSize);
        return entry;
    }

    private GenericType getKVGenericType(GenericType genericType) {
        GenericType mapGenericType = this.partialGenericKVTypeMap.get(genericType);
        if (mapGenericType == null) {
            TypeRef<?> typeRef = genericType.getTypeRef();
            if (!TypeUtils.MAP_TYPE.isSupertypeOf(typeRef)) {
                mapGenericType = GenericType.build(TypeUtils.mapOf(Object.class, Object.class));
                this.partialGenericKVTypeMap.put(genericType, mapGenericType);
                return mapGenericType;
            }
            Tuple2<TypeRef<?>, TypeRef<?>> mapKeyValueType = TypeUtils.getMapKeyValueType(typeRef);
            mapGenericType = GenericType.build(TypeUtils.mapOf((TypeRef)mapKeyValueType.f0, (TypeRef)mapKeyValueType.f1));
            this.partialGenericKVTypeMap.put(genericType, mapGenericType);
        }
        return mapGenericType;
    }

    @Override
    public T xread(MemoryBuffer buffer) {
        return this.read(buffer);
    }

    protected <K, V> void copyEntry(Map<K, V> originMap, Map<K, V> newMap) {
        TypeResolver classResolver = this.typeResolver;
        for (Map.Entry<K, V> entry : originMap.entrySet()) {
            ClassInfo classInfo;
            V value;
            ClassInfo classInfo2;
            K key = entry.getKey();
            if (key != null && !(classInfo2 = classResolver.getClassInfo(key.getClass(), this.keyClassInfoWriteCache)).getSerializer().isImmutable()) {
                key = this.fory.copyObject(key, classInfo2.getClassId());
            }
            if ((value = entry.getValue()) != null && !(classInfo = classResolver.getClassInfo(value.getClass(), this.valueClassInfoWriteCache)).getSerializer().isImmutable()) {
                value = this.fory.copyObject(value, classInfo.getClassId());
            }
            newMap.put(key, value);
        }
    }

    protected <K, V> void copyEntry(Map<K, V> originMap, ImmutableMap.Builder<K, V> builder) {
        TypeResolver classResolver = this.typeResolver;
        for (Map.Entry<K, V> entry : originMap.entrySet()) {
            ClassInfo classInfo;
            V value;
            ClassInfo classInfo2;
            K key = entry.getKey();
            if (key != null && !(classInfo2 = classResolver.getClassInfo(key.getClass(), this.keyClassInfoWriteCache)).getSerializer().isImmutable()) {
                key = this.fory.copyObject(key, classInfo2.getClassId());
            }
            if ((value = entry.getValue()) != null && !(classInfo = classResolver.getClassInfo(value.getClass(), this.valueClassInfoWriteCache)).getSerializer().isImmutable()) {
                value = this.fory.copyObject(value, classInfo.getClassId());
            }
            builder.put(key, value);
        }
    }

    protected <K, V> void copyEntry(Map<K, V> originMap, Object[] elements) {
        TypeResolver classResolver = this.typeResolver;
        int index = 0;
        for (Map.Entry<K, V> entry : originMap.entrySet()) {
            ClassInfo classInfo;
            V value;
            ClassInfo classInfo2;
            K key = entry.getKey();
            if (key != null && !(classInfo2 = classResolver.getClassInfo(key.getClass(), this.keyClassInfoWriteCache)).getSerializer().isImmutable()) {
                key = this.fory.copyObject(key, classInfo2.getClassId());
            }
            if ((value = entry.getValue()) != null && !(classInfo = classResolver.getClassInfo(value.getClass(), this.valueClassInfoWriteCache)).getSerializer().isImmutable()) {
                value = this.fory.copyObject(value, classInfo.getClassId());
            }
            elements[index++] = key;
            elements[index++] = value;
        }
    }

    @Override
    public T read(MemoryBuffer buffer) {
        Map map = this.newMap(buffer);
        int size = this.getAndClearNumElements();
        this.readElements(buffer, size, map);
        return this.onMapRead(map);
    }

    public void readElements(MemoryBuffer buffer, int size, Map map) {
        Serializer keySerializer = this.keySerializer;
        Serializer valueSerializer = this.valueSerializer;
        this.keySerializer = null;
        this.valueSerializer = null;
        int chunkHeader = 0;
        if (size != 0) {
            chunkHeader = buffer.readUnsignedByte();
        }
        while (size > 0) {
            Generics generics;
            GenericType genericType;
            long sizeAndHeader = this.readJavaNullChunk(buffer, map, chunkHeader, size, keySerializer, valueSerializer);
            chunkHeader = (int)(sizeAndHeader & 0xFFL);
            size = (int)(sizeAndHeader >>> 8);
            if (size == 0) break;
            sizeAndHeader = keySerializer != null || valueSerializer != null ? this.readJavaChunk(this.fory, buffer, map, size, chunkHeader, keySerializer, valueSerializer) : ((genericType = (generics = this.fory.getGenerics()).nextGenericType()) == null ? this.readJavaChunk(this.fory, buffer, map, size, chunkHeader, null, null) : this.readJavaChunkGeneric(this.fory, generics, genericType, buffer, map, size, chunkHeader));
            chunkHeader = (int)(sizeAndHeader & 0xFFL);
            size = (int)(sizeAndHeader >>> 8);
        }
    }

    public long readJavaNullChunk(MemoryBuffer buffer, Map map, int chunkHeader, long size, Serializer keySerializer, Serializer valueSerializer) {
        while (true) {
            boolean valueHasNull;
            boolean keyHasNull = (chunkHeader & MapFlags.KEY_HAS_NULL) != 0;
            boolean bl = valueHasNull = (chunkHeader & MapFlags.VALUE_HAS_NULL) != 0;
            if (!keyHasNull) {
                boolean trackKeyRef;
                if (!valueHasNull) {
                    return size << 8 | (long)chunkHeader;
                }
                boolean bl2 = trackKeyRef = (chunkHeader & MapFlags.TRACKING_KEY_REF) != 0;
                Object key = (chunkHeader & MapFlags.KEY_DECL_TYPE) != 0 ? (keySerializer == null ? this.readNonEmptyValueFromNullChunk(buffer, trackKeyRef, true) : (trackKeyRef ? this.binding.readRef(buffer, keySerializer) : this.binding.read(buffer, keySerializer))) : this.binding.readRef(buffer, this.keyClassInfoReadCache);
                map.put(key, null);
            } else {
                this.readNullKeyChunk(buffer, map, chunkHeader, valueSerializer, valueHasNull);
            }
            if (--size == 0L) {
                return 0L;
            }
            chunkHeader = buffer.readUnsignedByte();
        }
    }

    private void readNullKeyChunk(MemoryBuffer buffer, Map map, int chunkHeader, Serializer valueSerializer, boolean valueHasNull) {
        if (!valueHasNull) {
            boolean trackValueRef;
            boolean bl = trackValueRef = (chunkHeader & MapFlags.TRACKING_VALUE_REF) != 0;
            Object value = (chunkHeader & MapFlags.VALUE_DECL_TYPE) != 0 ? (valueSerializer == null ? this.readNonEmptyValueFromNullChunk(buffer, trackValueRef, false) : (trackValueRef ? this.binding.readRef(buffer, valueSerializer) : this.binding.read(buffer, valueSerializer))) : this.binding.readRef(buffer, this.valueClassInfoReadCache);
            map.put(null, value);
        } else {
            map.put(null, null);
        }
    }

    private Object readNonEmptyValueFromNullChunk(MemoryBuffer buffer, boolean trackRef, boolean isKey) {
        Generics generics = this.fory.getGenerics();
        GenericType genericType = generics.nextGenericType();
        if (genericType.getTypeParametersCount() < 2) {
            genericType = this.getKVGenericType(genericType);
        }
        GenericType type = isKey ? genericType.getTypeParameter0() : genericType.getTypeParameter1();
        generics.pushGenericType(type);
        this.fory.incDepth(1);
        Serializer<?> serializer = type.getSerializer(this.typeResolver);
        Object v = trackRef ? this.binding.readRef(buffer, serializer) : this.binding.read(buffer, serializer);
        this.fory.incDepth(-1);
        generics.popGenericType();
        return v;
    }

    public long readNullChunkKVFinalNoRef(MemoryBuffer buffer, Map map, int chunkHeader, long size, Serializer keySerializer, Serializer valueSerializer) {
        while (true) {
            boolean valueHasNull;
            boolean keyHasNull = (chunkHeader & MapFlags.KEY_HAS_NULL) != 0;
            boolean bl = valueHasNull = (chunkHeader & MapFlags.VALUE_HAS_NULL) != 0;
            if (!keyHasNull) {
                if (!valueHasNull) {
                    return size << 8 | (long)chunkHeader;
                }
                Object key = this.binding.read(buffer, keySerializer);
                map.put(key, null);
            } else {
                this.readNullKeyChunk(buffer, map, chunkHeader, valueSerializer, valueHasNull);
            }
            if (size-- == 0L) {
                return 0L;
            }
            chunkHeader = buffer.readUnsignedByte();
        }
    }

    private long readJavaChunk(Fory fory, MemoryBuffer buffer, Map map, long size, int chunkHeader, Serializer keySerializer, Serializer valueSerializer) {
        boolean trackKeyRef = (chunkHeader & MapFlags.TRACKING_KEY_REF) != 0;
        boolean trackValueRef = (chunkHeader & MapFlags.TRACKING_VALUE_REF) != 0;
        boolean keyIsDeclaredType = (chunkHeader & MapFlags.KEY_DECL_TYPE) != 0;
        boolean valueIsDeclaredType = (chunkHeader & MapFlags.VALUE_DECL_TYPE) != 0;
        int chunkSize = buffer.readUnsignedByte();
        if (!keyIsDeclaredType) {
            keySerializer = this.typeResolver.readClassInfo(buffer, this.keyClassInfoReadCache).getSerializer();
        }
        if (!valueIsDeclaredType) {
            valueSerializer = this.typeResolver.readClassInfo(buffer, this.valueClassInfoReadCache).getSerializer();
        }
        for (int i = 0; i < chunkSize; ++i) {
            Object key = trackKeyRef ? this.binding.readRef(buffer, keySerializer) : this.binding.read(buffer, keySerializer);
            Object value = trackValueRef ? this.binding.readRef(buffer, valueSerializer) : this.binding.read(buffer, valueSerializer);
            map.put(key, value);
            --size;
        }
        return size > 0L ? size << 8 | (long)buffer.readUnsignedByte() : 0L;
    }

    private long readJavaChunkGeneric(Fory fory, Generics generics, GenericType genericType, MemoryBuffer buffer, Map map, long size, int chunkHeader) {
        if (genericType.getTypeParametersCount() < 2) {
            genericType = this.getKVGenericType(genericType);
        }
        GenericType keyGenericType = genericType.getTypeParameter0();
        GenericType valueGenericType = genericType.getTypeParameter1();
        boolean trackKeyRef = (chunkHeader & MapFlags.TRACKING_KEY_REF) != 0;
        boolean trackValueRef = (chunkHeader & MapFlags.TRACKING_VALUE_REF) != 0;
        boolean keyIsDeclaredType = (chunkHeader & MapFlags.KEY_DECL_TYPE) != 0;
        boolean valueIsDeclaredType = (chunkHeader & MapFlags.VALUE_DECL_TYPE) != 0;
        int chunkSize = buffer.readUnsignedByte();
        Serializer<Object> keySerializer = !keyIsDeclaredType ? this.typeResolver.readClassInfo(buffer, this.keyClassInfoReadCache).getSerializer() : keyGenericType.getSerializer(this.typeResolver);
        Serializer<Object> valueSerializer = !valueIsDeclaredType ? this.typeResolver.readClassInfo(buffer, this.valueClassInfoReadCache).getSerializer() : valueGenericType.getSerializer(this.typeResolver);
        if (keyGenericType.hasGenericParameters() || valueGenericType.hasGenericParameters()) {
            for (int i = 0; i < chunkSize; ++i) {
                generics.pushGenericType(keyGenericType);
                fory.incDepth(1);
                Object key = trackKeyRef ? this.binding.readRef(buffer, keySerializer) : this.binding.read(buffer, keySerializer);
                fory.incDepth(-1);
                generics.popGenericType();
                generics.pushGenericType(valueGenericType);
                fory.incDepth(1);
                Object value = trackValueRef ? this.binding.readRef(buffer, valueSerializer) : this.binding.read(buffer, valueSerializer);
                fory.incDepth(-1);
                generics.popGenericType();
                map.put(key, value);
                --size;
            }
        } else {
            for (int i = 0; i < chunkSize; ++i) {
                fory.incDepth(1);
                Object key = trackKeyRef ? this.binding.readRef(buffer, keySerializer) : this.binding.read(buffer, keySerializer);
                Object value = trackValueRef ? this.binding.readRef(buffer, valueSerializer) : this.binding.read(buffer, valueSerializer);
                fory.incDepth(-1);
                map.put(key, value);
                --size;
            }
        }
        return size > 0L ? size << 8 | (long)buffer.readUnsignedByte() : 0L;
    }

    public final boolean supportCodegenHook() {
        return this.supportCodegenHook;
    }

    public abstract Map onMapWrite(MemoryBuffer var1, T var2);

    public Map newMap(MemoryBuffer buffer) {
        this.numElements = buffer.readVarUint32Small7();
        if (this.constructor == null) {
            this.constructor = ReflectionUtils.getCtrHandle(this.type, true);
        }
        try {
            Map instance = this.constructor.invoke();
            this.fory.getRefResolver().reference(instance);
            return instance;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Please provide public no arguments constructor for class " + this.type, e);
        }
    }

    public Map newMap(Map map) {
        this.numElements = map.size();
        if (this.constructor == null) {
            this.constructor = ReflectionUtils.getCtrHandle(this.type, true);
        }
        try {
            return this.constructor.invoke();
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Please provide public no arguments constructor for class " + this.type, e);
        }
    }

    public int getAndClearNumElements() {
        int size = this.numElements;
        this.numElements = -1;
        return size;
    }

    public void setNumElements(int numElements) {
        this.numElements = numElements;
    }

    public abstract T onMapCopy(Map var1);

    public abstract T onMapRead(Map var1);
}

