/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer.collection;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.fory.Fory;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.memory.Platform;
import org.apache.fory.resolver.ClassResolver;
import org.apache.fory.serializer.collection.CollectionContainer;
import org.apache.fory.serializer.collection.CollectionSerializer;
import org.apache.fory.serializer.collection.JDKImmutableMapContainer;
import org.apache.fory.serializer.collection.MapSerializer;
import org.apache.fory.util.unsafe._JDKAccess;

public class ImmutableCollectionSerializers {
    private static Class<?> List12;
    private static Class<?> ListN;
    private static Class<?> SubList;
    private static Class<?> Set12;
    private static Class<?> SetN;
    private static Class<?> Map1;
    private static Class<?> MapN;
    private static MethodHandle listFactory;
    private static MethodHandle setFactory;
    private static MethodHandle map1Factory;
    private static MethodHandle mapNFactory;

    public static void registerSerializers(Fory fory) {
        ClassResolver resolver = fory.getClassResolver();
        resolver.registerSerializer(List12, new ImmutableListSerializer(fory, (Class)List12));
        resolver.registerSerializer(ListN, new ImmutableListSerializer(fory, (Class)ListN));
        resolver.registerSerializer(SubList, new ImmutableListSerializer(fory, (Class)SubList));
        resolver.registerSerializer(Set12, new ImmutableSetSerializer(fory, (Class)Set12));
        resolver.registerSerializer(SetN, new ImmutableSetSerializer(fory, (Class)SetN));
        resolver.registerSerializer(Map1, new ImmutableMapSerializer(fory, (Class)Map1));
        resolver.registerSerializer(MapN, new ImmutableMapSerializer(fory, (Class)MapN));
    }

    static {
        if (Platform.JAVA_VERSION > 8) {
            try {
                List12 = Class.forName("java.util.ImmutableCollections$List12");
                ListN = Class.forName("java.util.ImmutableCollections$ListN");
                SubList = Class.forName("java.util.ImmutableCollections$SubList");
                Set12 = Class.forName("java.util.ImmutableCollections$Set12");
                SetN = Class.forName("java.util.ImmutableCollections$SetN");
                Map1 = Class.forName("java.util.ImmutableCollections$Map1");
                MapN = Class.forName("java.util.ImmutableCollections$MapN");
                listFactory = _JDKAccess._trustedLookup(List.class).findStatic(List.class, "of", MethodType.methodType(List.class, Object[].class));
                setFactory = _JDKAccess._trustedLookup(Set.class).findStatic(Set.class, "of", MethodType.methodType(Set.class, Object[].class));
                map1Factory = _JDKAccess._trustedLookup(Map1).findConstructor(Map1, MethodType.methodType(Void.TYPE, Object.class, Object.class));
                mapNFactory = _JDKAccess._trustedLookup(MapN).findConstructor(MapN, MethodType.methodType(Void.TYPE, Object[].class));
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
                e.printStackTrace();
                Platform.throwException(e);
            }
        } else {
            class List12Stub {
                List12Stub() {
                }
            }
            List12 = List12Stub.class;
            class ListNStub {
                ListNStub() {
                }
            }
            ListN = ListNStub.class;
            class SubListStub {
                SubListStub() {
                }
            }
            SubList = SubListStub.class;
            class Set12Stub {
                Set12Stub() {
                }
            }
            Set12 = Set12Stub.class;
            class SetNStub {
                SetNStub() {
                }
            }
            SetN = SetNStub.class;
            class Map1Stub {
                Map1Stub() {
                }
            }
            Map1 = Map1Stub.class;
            class MapNStub {
                MapNStub() {
                }
            }
            MapN = MapNStub.class;
        }
    }

    public static class ImmutableMapSerializer
    extends MapSerializer {
        public ImmutableMapSerializer(Fory fory, Class cls) {
            super(fory, cls, true);
        }

        @Override
        public Map newMap(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            this.setNumElements(numElements);
            if (Platform.JAVA_VERSION > 8) {
                return new JDKImmutableMapContainer(numElements);
            }
            return new HashMap(numElements);
        }

        @Override
        public Map copy(Map originMap) {
            if (Platform.JAVA_VERSION <= 8) {
                throw new UnsupportedOperationException(String.format("Only support jdk9+ java.util.ImmutableCollections deep copy. %s", originMap.getClass()));
            }
            int size = originMap.size();
            Object[] elements = new Object[size * 2];
            this.copyEntry(originMap, elements);
            try {
                if (size == 1) {
                    return map1Factory.invoke(elements[0], elements[1]);
                }
                return mapNFactory.invoke(elements);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Map onMapRead(Map map) {
            if (Platform.JAVA_VERSION > 8) {
                JDKImmutableMapContainer container = (JDKImmutableMapContainer)map;
                try {
                    if (container.size() == 1) {
                        map = map1Factory.invoke(container.array[0], container.array[1]);
                    }
                    map = mapNFactory.invoke(container.array);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            } else {
                map = Collections.unmodifiableMap(map);
            }
            return map;
        }
    }

    public static class ImmutableSetSerializer
    extends CollectionSerializer {
        public ImmutableSetSerializer(Fory fory, Class cls) {
            super(fory, cls, true);
        }

        @Override
        public Collection newCollection(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            this.setNumElements(numElements);
            if (Platform.JAVA_VERSION > 8) {
                return new CollectionContainer(numElements);
            }
            return new HashSet(numElements);
        }

        @Override
        public Collection copy(Collection originCollection) {
            if (Platform.JAVA_VERSION <= 8) {
                throw new UnsupportedOperationException(String.format("Only support jdk9+ java.util.ImmutableCollections deep copy. %s", originCollection.getClass()));
            }
            Object[] elements = new Object[originCollection.size()];
            this.copyElements(originCollection, elements);
            try {
                return setFactory.invoke(elements);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Collection onCollectionRead(Collection collection) {
            if (Platform.JAVA_VERSION > 8) {
                CollectionContainer container = (CollectionContainer)collection;
                try {
                    collection = setFactory.invoke(container.elements);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            } else {
                collection = Collections.unmodifiableSet((HashSet)collection);
            }
            return collection;
        }
    }

    public static class ImmutableListSerializer
    extends CollectionSerializer {
        public ImmutableListSerializer(Fory fory, Class cls) {
            super(fory, cls, true);
        }

        @Override
        public Collection newCollection(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            this.setNumElements(numElements);
            if (Platform.JAVA_VERSION > 8) {
                return new CollectionContainer(numElements);
            }
            return new ArrayList(numElements);
        }

        @Override
        public Collection copy(Collection originCollection) {
            if (Platform.JAVA_VERSION <= 8) {
                throw new UnsupportedOperationException(String.format("Only support jdk9+ java.util.ImmutableCollections deep copy. %s", originCollection.getClass()));
            }
            Object[] elements = new Object[originCollection.size()];
            this.copyElements(originCollection, elements);
            try {
                return listFactory.invoke(elements);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Collection onCollectionRead(Collection collection) {
            if (Platform.JAVA_VERSION > 8) {
                CollectionContainer container = (CollectionContainer)collection;
                try {
                    collection = listFactory.invoke(container.elements);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            } else {
                collection = Collections.unmodifiableList((List)collection);
            }
            return collection;
        }
    }
}

