/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer.collection;

import java.util.Map;
import org.apache.fory.Fory;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.serializer.collection.AbstractMapSerializer;

public class MapSerializer<T extends Map>
extends AbstractMapSerializer<T> {
    public MapSerializer(Fory fory, Class<T> cls) {
        super(fory, cls);
    }

    public MapSerializer(Fory fory, Class<T> cls, boolean supportCodegenHook) {
        super(fory, cls, supportCodegenHook);
    }

    public MapSerializer(Fory fory, Class<T> cls, boolean supportCodegenHook, boolean immutable) {
        super(fory, cls, supportCodegenHook, immutable);
    }

    @Override
    public Map onMapWrite(MemoryBuffer buffer, T value) {
        buffer.writeVarUint32Small7(value.size());
        return value;
    }

    @Override
    public T copy(T originMap) {
        if (this.isImmutable()) {
            return originMap;
        }
        Map newMap = this.newMap((Map)originMap);
        if (this.needToCopyRef) {
            this.fory.reference(originMap, newMap);
        }
        this.copyEntry(originMap, newMap);
        return (T)this.onMapCopy(newMap);
    }

    @Override
    public T onMapCopy(Map map) {
        return (T)map;
    }

    @Override
    public T onMapRead(Map map) {
        return (T)map;
    }
}

