/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import org.apache.fory.Fory;
import org.apache.fory.collection.Tuple2;
import org.apache.fory.logging.Logger;
import org.apache.fory.logging.LoggerFactory;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.memory.Platform;
import org.apache.fory.resolver.ClassResolver;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.serializer.collection.CollectionSerializer;
import org.apache.fory.serializer.collection.MapSerializer;
import org.apache.fory.util.ExceptionUtils;

public class SynchronizedSerializers {
    private static final Logger LOG = LoggerFactory.getLogger(SynchronizedSerializers.class);

    static Serializer createSerializer(Fory fory, Class<?> cls) {
        for (Tuple2<Class<?>, Function> factory : SynchronizedSerializers.synchronizedFactories()) {
            if (factory.f0 != cls) continue;
            return SynchronizedSerializers.createSerializer(fory, factory);
        }
        throw new IllegalArgumentException("Unsupported type " + cls);
    }

    private static Serializer<?> createSerializer(Fory fory, Tuple2<Class<?>, Function> factory) {
        if (Collection.class.isAssignableFrom((Class)factory.f0)) {
            return new SynchronizedCollectionSerializer(fory, (Class)factory.f0, (Function)factory.f1, Offset.SOURCE_COLLECTION_FIELD_OFFSET);
        }
        return new SynchronizedMapSerializer(fory, (Class)factory.f0, (Function)factory.f1, Offset.SOURCE_MAP_FIELD_OFFSET);
    }

    static Tuple2<Class<?>, Function>[] synchronizedFactories() {
        Tuple2<Class<?>, Function<Object, Object>> collectionFactory = Tuple2.of(Collections.synchronizedCollection(Arrays.asList("")).getClass(), o -> Collections.synchronizedCollection((Collection)o));
        Tuple2<Class<?>, Function<Object, Object>> randomListFactory = Tuple2.of(Collections.synchronizedList(new ArrayList()).getClass(), o -> Collections.synchronizedList((List)o));
        Tuple2<Class<?>, Function<Object, Object>> listFactory = Tuple2.of(Collections.synchronizedList(new LinkedList()).getClass(), o -> Collections.synchronizedList((List)o));
        Tuple2<Class<?>, Function<Object, Object>> setFactory = Tuple2.of(Collections.synchronizedSet(new HashSet()).getClass(), o -> Collections.synchronizedSet((Set)o));
        Tuple2<Class<?>, Function<Object, Object>> sortedsetFactory = Tuple2.of(Collections.synchronizedSortedSet(new TreeSet()).getClass(), o -> Collections.synchronizedSortedSet((TreeSet)o));
        Tuple2<Class<?>, Function<Object, Object>> mapFactory = Tuple2.of(Collections.synchronizedMap(new HashMap()).getClass(), o -> Collections.synchronizedMap((Map)o));
        Tuple2<Class<?>, Function<Object, Object>> sortedmapFactory = Tuple2.of(Collections.synchronizedSortedMap(new TreeMap()).getClass(), o -> Collections.synchronizedSortedMap((SortedMap)o));
        return new Tuple2[]{collectionFactory, randomListFactory, listFactory, setFactory, sortedsetFactory, mapFactory, sortedmapFactory};
    }

    public static void registerSerializers(Fory fory) {
        try {
            ClassResolver resolver = fory.getClassResolver();
            for (Tuple2<Class<?>, Function> factory : SynchronizedSerializers.synchronizedFactories()) {
                resolver.registerSerializer((Class)factory.f0, SynchronizedSerializers.createSerializer(fory, factory));
            }
        }
        catch (Throwable e) {
            ExceptionUtils.ignore(e);
        }
    }

    public static final class SynchronizedMapSerializer
    extends MapSerializer<Map> {
        private final Function factory;
        private final long offset;

        public SynchronizedMapSerializer(Fory fory, Class cls, Function factory, long offset) {
            super(fory, cls, false);
            this.factory = factory;
            this.offset = offset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(MemoryBuffer buffer, Map object) {
            Object unwrapped = Platform.getObject(object, this.offset);
            Map map = object;
            synchronized (map) {
                this.fory.writeRef(buffer, unwrapped);
            }
        }

        @Override
        public Map copy(Map originMap) {
            Object unwrappedMap = Platform.getObject(originMap, this.offset);
            return (Map)this.factory.apply(this.fory.copyObject(unwrappedMap));
        }

        @Override
        public Map read(MemoryBuffer buffer) {
            Object sourceCollection = this.fory.readRef(buffer);
            return (Map)this.factory.apply(sourceCollection);
        }
    }

    public static final class SynchronizedCollectionSerializer
    extends CollectionSerializer<Collection> {
        private final Function factory;
        private final long offset;

        public SynchronizedCollectionSerializer(Fory fory, Class cls, Function factory, long offset) {
            super(fory, cls, false);
            this.factory = factory;
            this.offset = offset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(MemoryBuffer buffer, Collection object) {
            Object unwrapped = Platform.getObject(object, this.offset);
            Collection collection = object;
            synchronized (collection) {
                this.fory.writeRef(buffer, unwrapped);
            }
        }

        @Override
        public Collection read(MemoryBuffer buffer) {
            Object sourceCollection = this.fory.readRef(buffer);
            return (Collection)this.factory.apply(sourceCollection);
        }

        @Override
        public Collection copy(Collection object) {
            Object collection = Platform.getObject(object, this.offset);
            return (Collection)this.factory.apply(this.fory.copyObject(collection));
        }
    }

    private static class Offset {
        private static final long SOURCE_COLLECTION_FIELD_OFFSET;
        private static final long SOURCE_MAP_FIELD_OFFSET;

        private Offset() {
        }

        static {
            String clsName = "java.util.Collections$SynchronizedCollection";
            try {
                SOURCE_COLLECTION_FIELD_OFFSET = Platform.UNSAFE.objectFieldOffset(Class.forName(clsName).getDeclaredField("c"));
            }
            catch (Exception e) {
                LOG.info("Could not access source collection field in {}", (Object)clsName);
                throw new RuntimeException(e);
            }
            clsName = "java.util.Collections$SynchronizedMap";
            try {
                SOURCE_MAP_FIELD_OFFSET = Platform.UNSAFE.objectFieldOffset(Class.forName(clsName).getDeclaredField("m"));
            }
            catch (Exception e) {
                LOG.info("Could not access source map field in {}", (Object)clsName);
                throw new RuntimeException(e);
            }
        }
    }
}

