/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import org.apache.fory.Fory;
import org.apache.fory.collection.Tuple2;
import org.apache.fory.logging.Logger;
import org.apache.fory.logging.LoggerFactory;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.memory.Platform;
import org.apache.fory.resolver.ClassResolver;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.serializer.collection.CollectionSerializer;
import org.apache.fory.serializer.collection.MapSerializer;
import org.apache.fory.util.ExceptionUtils;
import org.apache.fory.util.Preconditions;

public class UnmodifiableSerializers {
    private static final Logger LOG = LoggerFactory.getLogger(UnmodifiableSerializers.class);

    static Serializer createSerializer(Fory fory, Class<?> cls) {
        for (Tuple2<Class<?>, Function> factory : UnmodifiableSerializers.unmodifiableFactories()) {
            if (factory.f0 != cls) continue;
            return UnmodifiableSerializers.createSerializer(fory, factory);
        }
        throw new IllegalArgumentException("Unsupported type " + cls);
    }

    private static Serializer<?> createSerializer(Fory fory, Tuple2<Class<?>, Function> factory) {
        if (Collection.class.isAssignableFrom((Class)factory.f0)) {
            return new UnmodifiableCollectionSerializer(fory, (Class)factory.f0, (Function)factory.f1, Offset.SOURCE_COLLECTION_FIELD_OFFSET);
        }
        return new UnmodifiableMapSerializer(fory, (Class)factory.f0, (Function)factory.f1, Offset.SOURCE_MAP_FIELD_OFFSET);
    }

    static Tuple2<Class<?>, Function>[] unmodifiableFactories() {
        Tuple2<Class<?>, Function<Object, Object>> collectionFactory = Tuple2.of(Collections.unmodifiableCollection(Collections.singletonList("")).getClass(), o -> Collections.unmodifiableCollection((Collection)o));
        Tuple2<Class<?>, Function<Object, Object>> randomAccessListFactory = Tuple2.of(Collections.unmodifiableList(new ArrayList()).getClass(), o -> Collections.unmodifiableList((List)o));
        Tuple2<Class<?>, Function<Object, Object>> listFactory = Tuple2.of(Collections.unmodifiableList(new LinkedList()).getClass(), o -> Collections.unmodifiableList((List)o));
        Tuple2<Class<?>, Function<Object, Object>> setFactory = Tuple2.of(Collections.unmodifiableSet(new HashSet()).getClass(), o -> Collections.unmodifiableSet((Set)o));
        Tuple2<Class<?>, Function<Object, Object>> sortedsetFactory = Tuple2.of(Collections.unmodifiableSortedSet(new TreeSet()).getClass(), o -> Collections.unmodifiableSortedSet((SortedSet)o));
        Tuple2<Class<?>, Function<Object, Object>> mapFactory = Tuple2.of(Collections.unmodifiableMap(new HashMap()).getClass(), o -> Collections.unmodifiableMap((Map)o));
        Tuple2<Class<?>, Function<Object, Object>> sortedmapFactory = Tuple2.of(Collections.unmodifiableSortedMap(new TreeMap()).getClass(), o -> Collections.unmodifiableSortedMap((SortedMap)o));
        return new Tuple2[]{collectionFactory, randomAccessListFactory, listFactory, setFactory, sortedsetFactory, mapFactory, sortedmapFactory};
    }

    public static void registerSerializers(Fory fory) {
        try {
            ClassResolver resolver = fory.getClassResolver();
            for (Tuple2<Class<?>, Function> factory : UnmodifiableSerializers.unmodifiableFactories()) {
                resolver.registerSerializer((Class)factory.f0, UnmodifiableSerializers.createSerializer(fory, factory));
            }
        }
        catch (Throwable e) {
            ExceptionUtils.ignore(e);
        }
    }

    public static final class UnmodifiableMapSerializer
    extends MapSerializer<Map> {
        private final Function factory;
        private final long offset;

        public UnmodifiableMapSerializer(Fory fory, Class cls, Function factory, long offset) {
            super(fory, cls, false);
            this.factory = factory;
            this.offset = offset;
        }

        @Override
        public void write(MemoryBuffer buffer, Map value) {
            Preconditions.checkArgument(value.getClass() == this.type);
            Object fieldValue = Platform.getObject(value, this.offset);
            this.fory.writeRef(buffer, fieldValue);
        }

        @Override
        public Map copy(Map originMap) {
            Object unwrappedMap = Platform.getObject(originMap, this.offset);
            return (Map)this.factory.apply(this.fory.copyObject(unwrappedMap));
        }

        @Override
        public Map read(MemoryBuffer buffer) {
            Object sourceCollection = this.fory.readRef(buffer);
            return (Map)this.factory.apply(sourceCollection);
        }
    }

    public static final class UnmodifiableCollectionSerializer
    extends CollectionSerializer<Collection> {
        private final Function factory;
        private final long offset;

        public UnmodifiableCollectionSerializer(Fory fory, Class cls, Function factory, long offset) {
            super(fory, cls, false);
            this.factory = factory;
            this.offset = offset;
        }

        @Override
        public void write(MemoryBuffer buffer, Collection value) {
            Preconditions.checkArgument(value.getClass() == this.type);
            Object fieldValue = Platform.getObject(value, this.offset);
            this.fory.writeRef(buffer, fieldValue);
        }

        @Override
        public Collection read(MemoryBuffer buffer) {
            Object sourceCollection = this.fory.readRef(buffer);
            return (Collection)this.factory.apply(sourceCollection);
        }

        @Override
        public Collection copy(Collection object) {
            Object collection = Platform.getObject(object, this.offset);
            return (Collection)this.factory.apply(this.fory.copyObject(collection));
        }
    }

    private static class Offset {
        private static final long SOURCE_COLLECTION_FIELD_OFFSET;
        private static final long SOURCE_MAP_FIELD_OFFSET;

        private Offset() {
        }

        static {
            String clsName = "java.util.Collections$UnmodifiableCollection";
            try {
                SOURCE_COLLECTION_FIELD_OFFSET = Platform.UNSAFE.objectFieldOffset(Class.forName(clsName).getDeclaredField("c"));
            }
            catch (Exception e) {
                LOG.info("Could not access source collection field in {}", (Object)clsName);
                throw new RuntimeException(e);
            }
            clsName = "java.util.Collections$UnmodifiableMap";
            try {
                SOURCE_MAP_FIELD_OFFSET = Platform.UNSAFE.objectFieldOffset(Class.forName(clsName).getDeclaredField("m"));
            }
            catch (Exception e) {
                LOG.info("Could not access source map field in {}", (Object)clsName);
                throw new RuntimeException(e);
            }
        }
    }
}

