/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer.scala;

import java.lang.reflect.Field;
import java.util.Collection;
import org.apache.fory.Fory;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.memory.Platform;
import org.apache.fory.serializer.collection.AbstractCollectionSerializer;
import org.apache.fory.util.GraalvmSupport;
import org.apache.fory.util.Preconditions;

public class SingletonCollectionSerializer
extends AbstractCollectionSerializer {
    private final Field field;
    private Object base = null;
    private long offset = -1L;

    public SingletonCollectionSerializer(Fory fory, Class cls) {
        super(fory, cls, false);
        try {
            this.field = this.type.getDeclaredField("MODULE$");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(this.type + " doesn't have `MODULE$` field", e);
        }
    }

    public Collection onCollectionWrite(MemoryBuffer buffer, Object value) {
        throw new IllegalStateException("unreachable");
    }

    @Override
    public void write(MemoryBuffer buffer, Object value) {
    }

    @Override
    public Object read(MemoryBuffer buffer) {
        long offset = this.offset;
        if (offset == -1L) {
            Preconditions.checkArgument(!GraalvmSupport.isGraalBuildtime());
            offset = this.offset = Platform.UNSAFE.staticFieldOffset(this.field);
            this.base = Platform.UNSAFE.staticFieldBase(this.field);
        }
        return Platform.getObject(this.base, offset);
    }

    public Object onCollectionRead(Collection collection) {
        throw new IllegalStateException("unreachable");
    }
}

