/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.type;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.fory.annotation.Expose;
import org.apache.fory.annotation.ForyField;
import org.apache.fory.annotation.Ignore;
import org.apache.fory.annotation.Internal;
import org.apache.fory.collection.Collections;
import org.apache.fory.collection.Tuple2;
import org.apache.fory.memory.Platform;
import org.apache.fory.reflect.TypeRef;
import org.apache.fory.type.DescriptorBuilder;
import org.apache.fory.type.TypeUtils;
import org.apache.fory.util.Preconditions;
import org.apache.fory.util.StringUtils;
import org.apache.fory.util.record.RecordComponent;
import org.apache.fory.util.record.RecordUtils;

public class Descriptor {
    private static Cache<Class<?>, Tuple2<SortedMap<Member, Descriptor>, SortedMap<Member, Descriptor>>> descCache = CacheBuilder.newBuilder().weakKeys().softValues().concurrencyLevel(64).build();
    private static final Map<Class<?>, AtomicBoolean> flags = Collections.newClassKeyCacheMap();
    private TypeRef<?> typeRef;
    private Class<?> type;
    private final String typeName;
    private final String name;
    private String snakeCaseName;
    private final int modifier;
    private final String declaringClass;
    private final Field field;
    private final Method readMethod;
    private final Method writeMethod;
    private ForyField foryField;
    private boolean nullable;
    private boolean trackingRef;
    private static final ClassValue<Map<String, List<Member>>> sortedDuplicatedMembers = new ClassValue<Map<String, List<Member>>>(){

        @Override
        protected Map<String, List<Member>> computeValue(Class<?> type) {
            SortedMap<Member, Descriptor> allFields = Descriptor.getAllDescriptorsMap(type);
            Map<String, List<Member>> duplicated = Descriptor.getDuplicateNames(allFields);
            HashMap<String, List<Member>> map = new HashMap<String, List<Member>>();
            for (Map.Entry<String, List<Member>> e : duplicated.entrySet()) {
                e.getValue().sort((f1, f2) -> {
                    if (f1.getDeclaringClass() == f2.getDeclaringClass()) {
                        return 0;
                    }
                    return f1.getDeclaringClass().isAssignableFrom(f2.getDeclaringClass()) ? -1 : 1;
                });
                if (map.put(e.getKey(), e.getValue()) == null) continue;
                throw new IllegalStateException("Duplicate key");
            }
            return map;
        }
    };
    private static final Comparator<Member> memberComparator = (m1, m2) -> {
        int compare = m1.getName().compareTo(m2.getName());
        if (compare == 0) {
            return m1.getDeclaringClass().getName().compareTo(m2.getDeclaringClass().getName());
        }
        return compare;
    };

    @Internal
    public static void clearDescriptorCache() {
        descCache.cleanUp();
        descCache = CacheBuilder.newBuilder().weakKeys().softValues().concurrencyLevel(64).build();
    }

    public Descriptor(Field field, TypeRef<?> typeRef, Method readMethod, Method writeMethod) {
        this.field = field;
        this.typeName = field.getType().getName();
        this.name = field.getName();
        this.modifier = field.getModifiers();
        this.declaringClass = field.getDeclaringClass().getName();
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
        this.typeRef = typeRef;
        this.foryField = this.field.getAnnotation(ForyField.class);
        if (!typeRef.isPrimitive()) {
            this.nullable = this.foryField == null || this.foryField.nullable();
        }
    }

    public Descriptor(TypeRef<?> typeRef, String name, int modifier, String declaringClass) {
        this.field = null;
        this.typeName = typeRef.getRawType().getName();
        this.name = name;
        this.modifier = modifier;
        this.declaringClass = declaringClass;
        this.typeRef = typeRef;
        this.readMethod = null;
        this.writeMethod = null;
        this.foryField = null;
        this.nullable = !typeRef.isPrimitive();
    }

    private Descriptor(Field field, Method readMethod) {
        this.field = field;
        this.typeName = field.getType().getName();
        this.name = field.getName();
        this.modifier = field.getModifiers();
        this.declaringClass = field.getDeclaringClass().getName();
        this.readMethod = readMethod;
        this.writeMethod = null;
        this.typeRef = null;
        this.foryField = this.field.getAnnotation(ForyField.class);
        if (!field.getType().isPrimitive()) {
            this.nullable = this.foryField == null || this.foryField.nullable();
        }
    }

    private Descriptor(Method readMethod) {
        this.field = null;
        this.typeName = readMethod.getReturnType().getName();
        this.name = readMethod.getName();
        this.modifier = readMethod.getModifiers();
        this.declaringClass = readMethod.getDeclaringClass().getName();
        this.readMethod = readMethod;
        this.writeMethod = null;
        this.typeRef = TypeRef.of(readMethod.getGenericReturnType());
        this.foryField = readMethod.getAnnotation(ForyField.class);
        if (!readMethod.getReturnType().isPrimitive()) {
            this.nullable = this.foryField == null || this.foryField.nullable();
        }
    }

    private Descriptor(TypeRef<?> typeRef, String typeName, String name, int modifier, String declaringClass, Field field, Method readMethod, Method writeMethod) {
        this.typeRef = typeRef;
        this.typeName = typeName;
        this.name = name;
        this.modifier = modifier;
        this.declaringClass = declaringClass;
        this.field = field;
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
        ForyField foryField = this.foryField = this.field == null ? null : this.field.getAnnotation(ForyField.class);
        if (!typeRef.isPrimitive()) {
            this.nullable = this.foryField == null || this.foryField.nullable();
        }
    }

    public Descriptor(DescriptorBuilder builder) {
        this(builder.typeRef, builder.typeName, builder.name, builder.modifier, builder.declaringClass, builder.field, builder.readMethod, builder.writeMethod);
        this.nullable = builder.nullable;
        this.trackingRef = builder.trackingRef;
        this.type = builder.type;
        this.foryField = builder.foryField;
    }

    public DescriptorBuilder copyBuilder() {
        return new DescriptorBuilder(this);
    }

    public Descriptor copy(Method readMethod, Method writeMethod) {
        return new DescriptorBuilder(this).readMethod(readMethod).writeMethod(writeMethod).build();
    }

    public Descriptor copyWithTypeName(String typeName) {
        return new DescriptorBuilder(this).typeName(typeName).build();
    }

    public Field getField() {
        return this.field;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isTrackingRef() {
        return this.trackingRef;
    }

    public int getModifier() {
        return this.modifier;
    }

    public String getSnakeCaseName() {
        if (this.snakeCaseName == null) {
            this.snakeCaseName = StringUtils.lowerCamelToLowerUnderscore(this.name);
        }
        return this.snakeCaseName;
    }

    public int getModifiers() {
        return this.modifier;
    }

    public boolean isFinalField() {
        return Modifier.isFinal(this.modifier);
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public Method getReadMethod() {
        return this.readMethod;
    }

    public Method getWriteMethod() {
        return this.writeMethod;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public ForyField getForyField() {
        return this.foryField;
    }

    public Class<?> getRawType() {
        Class<?> type = this.type;
        if (type == null) {
            if (this.field != null) {
                this.type = this.field.getType();
                return this.type;
            }
            this.type = TypeUtils.getRawType(this.getTypeRef());
            return this.type;
        }
        return Objects.requireNonNull(type);
    }

    public TypeRef<?> getTypeRef() {
        TypeRef<Object> typeRef = this.typeRef;
        if (typeRef == null && this.field != null) {
            this.typeRef = typeRef = TypeRef.of(this.field.getGenericType());
        }
        return typeRef;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Descriptor{");
        sb.append("typeName=").append(this.typeName);
        sb.append(", name=").append(this.name);
        sb.append(", modifier=").append(this.modifier);
        if (this.field != null) {
            sb.append(", declaringClass=").append(this.field.getDeclaringClass().getSimpleName());
        }
        if (this.readMethod != null) {
            sb.append(", readMethod=").append(this.readMethod);
        }
        if (this.writeMethod != null) {
            sb.append(", writeMethod=").append(this.writeMethod);
        }
        if (this.typeRef != null) {
            sb.append(", typeRef=").append(this.typeRef);
        }
        sb.append(", foryField=").append(this.foryField);
        sb.append('}');
        return sb.toString();
    }

    public static List<Descriptor> getDescriptors(Class<?> clz) {
        SortedMap<Member, Descriptor> allDescriptorsMap = Descriptor.getAllDescriptorsMap(clz);
        Map<String, List<Member>> duplicateNameFields = Descriptor.getDuplicateNames(allDescriptorsMap);
        Preconditions.checkArgument(duplicateNameFields.size() == 0, "%s has duplicate fields %s", clz, duplicateNameFields);
        return new ArrayList<Descriptor>(allDescriptorsMap.values());
    }

    public static SortedMap<String, Descriptor> getDescriptorsMap(Class<?> clz) {
        SortedMap<Member, Descriptor> allDescriptorsMap = Descriptor.getAllDescriptorsMap(clz);
        Map<String, List<Member>> duplicateNameFields = Descriptor.getDuplicateNames(allDescriptorsMap);
        Preconditions.checkArgument(duplicateNameFields.size() == 0, "%s has duplicate fields %s", clz, duplicateNameFields);
        TreeMap<String, Descriptor> map = new TreeMap<String, Descriptor>();
        allDescriptorsMap.forEach((k, v) -> map.put(k.getName(), (Descriptor)v));
        return map;
    }

    public static Map<String, List<Member>> getDuplicateNames(SortedMap<Member, Descriptor> allDescriptorsMap) {
        HashMap<String, List> duplicateNames = new HashMap<String, List>();
        for (Member member : allDescriptorsMap.keySet()) {
            duplicateNames.compute(member.getName(), (memberName, members) -> {
                if (members == null) {
                    members = new ArrayList<Member>();
                }
                members.add(member);
                return members;
            });
        }
        HashMap<String, List<Member>> map = new HashMap<String, List<Member>>();
        for (Map.Entry e : duplicateNames.entrySet()) {
            if (((List)Objects.requireNonNull(e.getValue())).size() <= 1) continue;
            map.put((String)e.getKey(), (List<Member>)e.getValue());
        }
        return map;
    }

    public static Map<String, List<Member>> getSortedDuplicatedMembers(Class<?> cls) {
        return sortedDuplicatedMembers.get(cls);
    }

    public static boolean hasDuplicateNameFields(Class<?> clz) {
        return !Descriptor.getSortedDuplicatedMembers(clz).isEmpty();
    }

    public static Set<Field> getFields(Class<?> clz) {
        TreeSet<Member> fields = new TreeSet<Member>(memberComparator);
        for (Member member : Descriptor.getAllDescriptorsMap(clz).keySet()) {
            if (!(member instanceof Field)) continue;
            fields.add((Field)member);
        }
        return fields;
    }

    public static SortedMap<Member, Descriptor> getAllDescriptorsMap(Class<?> clz) {
        return Descriptor.getAllDescriptorsMap(clz, true);
    }

    public static SortedMap<Member, Descriptor> getAllDescriptorsMap(Class<?> clz, boolean searchParent) {
        try {
            Tuple2 tuple2 = (Tuple2)descCache.get(clz, () -> Descriptor.createAllDescriptorsMap(clz));
            if (searchParent) {
                return (SortedMap)tuple2.f0;
            }
            return (SortedMap)tuple2.f1;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private static Tuple2<SortedMap<Member, Descriptor>, SortedMap<Member, Descriptor>> createAllDescriptorsMap(Class<?> clz) {
        TreeMap<Member, Descriptor> descriptorMap = new TreeMap<Member, Descriptor>(memberComparator);
        TreeMap currentDescriptorMap = new TreeMap(memberComparator);
        Class<?> clazz = clz;
        ForkJoinPool compilationService = ForkJoinPool.commonPool();
        if (RecordUtils.isRecord(clz)) {
            RecordComponent[] components = RecordUtils.getRecordComponents(clazz);
            assert (components != null);
            try {
                for (RecordComponent component : components) {
                    Field field = clz.getDeclaredField(component.getName());
                    descriptorMap.put(field, new Descriptor(field, component.getAccessor()));
                }
            }
            catch (NoSuchFieldException e) {
                Platform.throwException(e);
            }
            currentDescriptorMap = new TreeMap(descriptorMap);
            return Tuple2.of(descriptorMap, currentDescriptorMap);
        }
        if (clazz.isInterface()) {
            for (Method method : clazz.getMethods()) {
                if (method.getParameterCount() != 0 || method.getReturnType() == Void.TYPE || Modifier.isStatic(method.getModifiers())) continue;
                descriptorMap.put(method, new Descriptor(method));
            }
            currentDescriptorMap = new TreeMap(descriptorMap);
            return Tuple2.of(descriptorMap, currentDescriptorMap);
        }
        do {
            Field[] fields = clazz.getDeclaredFields();
            boolean haveExpose = false;
            boolean haveIgnore = false;
            for (Field field : fields) {
                Descriptor.warmField(clz, field, compilationService);
                if (field.isAnnotationPresent(Expose.class)) {
                    haveExpose = true;
                }
                if (field.isAnnotationPresent(Ignore.class)) {
                    haveIgnore = true;
                }
                if (!haveExpose || !haveIgnore) continue;
                throw new RuntimeException("Fields of a Class are not allowed to have both the Ignore and Expose annotations simultaneously.");
            }
            for (Field field : fields) {
                int modifiers = field.getModifiers();
                if (Modifier.isTransient(modifiers) || Modifier.isStatic(modifiers)) continue;
                if (haveExpose) {
                    if (!field.isAnnotationPresent(Expose.class)) continue;
                    descriptorMap.put(field, new Descriptor(field, null));
                    continue;
                }
                if (field.isAnnotationPresent(Ignore.class)) continue;
                descriptorMap.put(field, new Descriptor(field, null));
            }
            if (clazz != clz) continue;
            currentDescriptorMap = new TreeMap(descriptorMap);
        } while ((clazz = clazz.getSuperclass()) != null);
        return Tuple2.of(descriptorMap, currentDescriptorMap);
    }

    static void warmField(Class<?> context, Field field, ExecutorService compilationService) {
        Class<?> componentType;
        Class<?> fieldRawType = field.getType();
        if (fieldRawType.isPrimitive() || fieldRawType == String.class || fieldRawType == Object.class) {
            return;
        }
        if (TypeUtils.isBoxed(fieldRawType)) {
            return;
        }
        if (fieldRawType == context) {
            return;
        }
        if (!fieldRawType.getName().startsWith("java")) {
            compilationService.submit(() -> {
                AtomicBoolean flag = flags.computeIfAbsent(fieldRawType, k -> new AtomicBoolean(false));
                if (flag.compareAndSet(false, true)) {
                    Descriptor.getAllDescriptorsMap(fieldRawType);
                }
            });
        } else if (TypeUtils.isCollection(fieldRawType) || TypeUtils.isMap(fieldRawType)) {
            compilationService.submit(() -> Descriptor.warmGenericTask(TypeRef.of(field.getGenericType())));
        } else if (fieldRawType.isArray() && !(componentType = fieldRawType.getComponentType()).isPrimitive()) {
            compilationService.submit(() -> Descriptor.warmGenericTask(TypeRef.of(field.getGenericType())));
        }
    }

    static void warmGenericTask(TypeRef<?> typeRef) {
        Class<?> rawType = TypeUtils.getRawType(typeRef);
        if (rawType.isPrimitive() || rawType == String.class || rawType == Object.class) {
            return;
        }
        if (TypeUtils.isBoxed(rawType)) {
            return;
        }
        if (!rawType.getName().startsWith("java")) {
            Descriptor.getAllDescriptorsMap(rawType);
        } else if (TypeUtils.isCollection(rawType)) {
            TypeRef<?> elementType = TypeUtils.getElementType(typeRef);
            Descriptor.warmGenericTask(elementType);
        } else if (TypeUtils.isMap(rawType)) {
            Tuple2<TypeRef<?>, TypeRef<?>> mapKeyValueType = TypeUtils.getMapKeyValueType(typeRef);
            Descriptor.warmGenericTask((TypeRef)mapKeyValueType.f0);
            Descriptor.warmGenericTask((TypeRef)mapKeyValueType.f1);
        } else if (rawType.isArray()) {
            Descriptor.warmGenericTask(typeRef.getComponentType());
        }
    }

    static SortedMap<Field, Descriptor> buildBeanedDescriptorsMap(Class<?> clz, boolean searchParent) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        Class<?> clazz = clz;
        HashMap methodMap = new HashMap();
        do {
            AnnotatedElement[] fields = clazz.getDeclaredFields();
            Field[] fieldArray = fields;
            int n = fieldArray.length;
            for (int i = 0; i < n; ++i) {
                Field field = fieldArray[i];
                int modifiers = field.getModifiers();
                if (Modifier.isTransient(modifiers) || Modifier.isStatic(modifiers) || field.isAnnotationPresent(Ignore.class)) continue;
                fieldList.add(field);
            }
            Arrays.stream(clazz.getDeclaredMethods()).filter(m -> !Modifier.isPrivate(m.getModifiers())).forEach(m -> methodMap.put(Tuple2.of(m.getDeclaringClass(), m.getName()), (Method)m));
        } while ((clazz = clazz.getSuperclass()) != null && searchParent);
        for (AnnotatedElement annotatedElement : clz.getInterfaces()) {
            Method[] methods;
            for (Method method : methods = ((Class)annotatedElement).getDeclaredMethods()) {
                if (!method.isDefault()) continue;
                methodMap.put(Tuple2.of(method.getDeclaringClass(), method.getName()), method);
            }
        }
        TreeMap<Member, Descriptor> descriptorMap = new TreeMap<Member, Descriptor>(memberComparator);
        for (Field field : fieldList) {
            Method setter;
            Class<?> clazz2 = field.getDeclaringClass();
            String fieldName = field.getName();
            String cap = StringUtils.capitalize(fieldName);
            Method getter = "boolean".equalsIgnoreCase(field.getType().getSimpleName()) ? (Method)methodMap.get(Tuple2.of(clazz2, "is" + cap)) : (Method)methodMap.get(Tuple2.of(clazz2, "get" + cap));
            if (!(getter == null || getter.getParameterCount() == 0 && getter.getGenericReturnType().getTypeName().equals(field.getGenericType().getTypeName()))) {
                getter = null;
            }
            if (!((setter = (Method)methodMap.get(Tuple2.of(clazz2, "set" + cap))) == null || setter.getParameterCount() == 1 && setter.getGenericParameterTypes()[0].getTypeName().equals(field.getGenericType().getTypeName()))) {
                setter = null;
            }
            TypeRef fieldType = TypeRef.of(field.getGenericType());
            descriptorMap.put(field, new Descriptor(field, fieldType, getter, setter));
        }
        return descriptorMap;
    }
}

