/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.util;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.apache.fory.Fory;
import org.apache.fory.collection.ObjectArray;
import org.apache.fory.exception.DeserializationException;
import org.apache.fory.memory.Platform;
import org.apache.fory.reflect.ReflectionUtils;
import org.apache.fory.resolver.MapRefResolver;

public class ExceptionUtils {
    private static final Field detailMessageField;

    public static StackOverflowError trySetStackOverflowErrorMessage(StackOverflowError e, String message) {
        if (detailMessageField != null) {
            ReflectionUtils.setObjectFieldValue((Object)e, detailMessageField, (Object)message);
            return e;
        }
        return null;
    }

    public static RuntimeException handleReadFailed(Fory fory, Throwable t) {
        if (fory.getRefResolver() instanceof MapRefResolver) {
            ObjectArray readObjects = ((MapRefResolver)fory.getRefResolver()).getReadObjects();
            List<Object> objects = Arrays.asList(readObjects.objects).subList(0, readObjects.size);
            throw new DeserializationException(objects, t);
        }
        Platform.throwException(t);
        throw new IllegalStateException("unreachable");
    }

    public static void ignore(Object ... args) {
    }

    static {
        try {
            detailMessageField = Throwable.class.getDeclaredField("detailMessage");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

