/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import org.apache.fory.Fory;
import org.apache.fory.config.LongEncoding;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.serializer.PrimitiveSerializers;
import org.apache.fory.serializer.StringSerializer;
import org.apache.fory.util.Preconditions;

public class MemoryBufferObjectInput
extends InputStream
implements ObjectInput {
    private final Fory fory;
    private final boolean compressInt;
    private final LongEncoding longEncoding;
    private MemoryBuffer buffer;
    private final StringSerializer stringSerializer;

    public MemoryBufferObjectInput(Fory fory, MemoryBuffer buffer) {
        this.fory = fory;
        this.compressInt = fory.compressInt();
        this.longEncoding = fory.longEncoding();
        this.buffer = buffer;
        this.stringSerializer = new StringSerializer(fory);
    }

    public MemoryBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(MemoryBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public Object readObject() throws ClassNotFoundException, IOException {
        return this.fory.readRef(this.buffer);
    }

    @Override
    public int read() throws IOException {
        return this.buffer.readByte();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int available = this.available();
        if (available == 0) {
            return -1;
        }
        len = Math.min(available, len);
        this.buffer.readBytes(b, off, len);
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        Preconditions.checkArgument(n < Integer.MAX_VALUE);
        int newIndex = Math.addExact(this.buffer.readerIndex(), (int)n);
        Preconditions.checkArgument(newIndex < this.buffer.size());
        this.buffer.readerIndex(newIndex);
        return n;
    }

    @Override
    public int available() throws IOException {
        return this.buffer.size() - this.buffer.readerIndex();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.buffer.readBytes(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.buffer.readerIndex(this.buffer.readerIndex() + n);
        return n;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.buffer.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.buffer.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.buffer.readByte() & 0xFF;
    }

    @Override
    public short readShort() throws IOException {
        return this.buffer.readInt16();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.buffer.readInt16() & 0xFFFF;
    }

    @Override
    public char readChar() throws IOException {
        return this.buffer.readChar();
    }

    @Override
    public int readInt() throws IOException {
        return this.compressInt ? this.buffer.readVarInt32() : this.buffer.readInt32();
    }

    @Override
    public long readLong() throws IOException {
        return PrimitiveSerializers.LongSerializer.readInt64(this.buffer, this.longEncoding);
    }

    @Override
    public float readFloat() throws IOException {
        return this.buffer.readFloat32();
    }

    @Override
    public double readDouble() throws IOException {
        return this.buffer.readFloat64();
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() throws IOException {
        return this.stringSerializer.readJavaString(this.buffer);
    }
}

