/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.resolver;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.fory.Fory;
import org.apache.fory.exception.InsecureException;
import org.apache.fory.logging.Logger;
import org.apache.fory.logging.LoggerFactory;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.resolver.ClassChecker;
import org.apache.fory.resolver.ClassResolver;
import org.apache.fory.serializer.Serializer;

@ThreadSafe
public class AllowListChecker
implements ClassChecker {
    private static final Logger LOG = LoggerFactory.getLogger(AllowListChecker.class);
    private volatile CheckLevel checkLevel;
    private final Set<String> allowList;
    private final Set<String> allowListPrefix;
    private final Set<String> disallowList;
    private final Set<String> disallowListPrefix;
    private final transient WeakHashMap<ClassResolver, Boolean> listeners;
    private final transient ReadWriteLock lock;

    public AllowListChecker() {
        this(CheckLevel.WARN);
    }

    public AllowListChecker(CheckLevel checkLevel) {
        this.checkLevel = checkLevel;
        this.allowList = new HashSet<String>();
        this.allowListPrefix = new HashSet<String>();
        this.disallowList = new HashSet<String>();
        this.disallowListPrefix = new HashSet<String>();
        this.lock = new ReentrantReadWriteLock();
        this.listeners = new WeakHashMap();
    }

    public CheckLevel getCheckLevel() {
        return this.checkLevel;
    }

    public void setCheckLevel(CheckLevel checkLevel) {
        this.checkLevel = checkLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkClass(ClassResolver classResolver, String className) {
        try {
            this.lock.readLock().lock();
            boolean bl = this.check(className);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private boolean check(String className) {
        switch (this.checkLevel.ordinal()) {
            case 0: {
                return true;
            }
            case 1: {
                if (AllowListChecker.containsPrefix(this.disallowList, this.disallowListPrefix, className)) {
                    throw new InsecureException(String.format("Class %s is forbidden for serialization.", className));
                }
                if (!AllowListChecker.containsPrefix(this.allowList, this.allowListPrefix, className)) {
                    LOG.warn("Class {} not in allow list, please check whether objects of this class are allowed for serialization.", (Object)className);
                }
                return true;
            }
            case 2: {
                if (AllowListChecker.containsPrefix(this.disallowList, this.disallowListPrefix, className)) {
                    throw new InsecureException(String.format("Class %s is forbidden for serialization.", className));
                }
                if (!AllowListChecker.containsPrefix(this.allowList, this.allowListPrefix, className)) {
                    throw new InsecureException(String.format("Class %s isn't in allow list for serialization. If this class is allowed for serialization, please add it to allow list by AllowListChecker#addAllowClass", className));
                }
                return true;
            }
        }
        throw new UnsupportedOperationException("Unsupported check level " + (Object)((Object)this.checkLevel));
    }

    static boolean containsPrefix(Set<String> set, Set<String> prefixSet, String className) {
        if (set.contains(className)) {
            return true;
        }
        for (String prefix : prefixSet) {
            if (!className.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public void allowClass(String classNameOrPrefix) {
        try {
            this.lock.writeLock().lock();
            this.allow(classNameOrPrefix);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allowClasses(Collection<String> classNamesOrPrefixes) {
        try {
            this.lock.writeLock().lock();
            for (String namesOrPrefix : classNamesOrPrefixes) {
                this.allow(namesOrPrefix);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void allow(String classNameOrPrefix) {
        if (classNameOrPrefix.endsWith("*")) {
            this.allowListPrefix.add(classNameOrPrefix.substring(0, classNameOrPrefix.length() - 1));
        } else {
            this.allowList.add(classNameOrPrefix);
        }
    }

    public void disallowClass(String classNameOrPrefix) {
        try {
            this.lock.writeLock().lock();
            this.disallow(classNameOrPrefix);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disallowClasses(Collection<String> classNamesOrPrefixes) {
        try {
            this.lock.writeLock().lock();
            for (String prefix : classNamesOrPrefixes) {
                this.disallow(prefix);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disallow(String classNameOrPrefix) {
        if (classNameOrPrefix.endsWith("*")) {
            String prefix = classNameOrPrefix.substring(0, classNameOrPrefix.length() - 1);
            this.disallowListPrefix.add(prefix);
            for (ClassResolver classResolver : this.listeners.keySet()) {
                try {
                    classResolver.getFory().getJITContext().lock();
                    classResolver.setSerializers(prefix, DisallowSerializer.class);
                }
                finally {
                    classResolver.getFory().getJITContext().unlock();
                }
            }
        } else {
            this.disallowList.add(classNameOrPrefix);
            for (ClassResolver classResolver : this.listeners.keySet()) {
                try {
                    classResolver.getFory().getJITContext().lock();
                    classResolver.setSerializer(classNameOrPrefix, DisallowSerializer.class);
                }
                finally {
                    classResolver.getFory().getJITContext().unlock();
                }
            }
        }
    }

    public void addListener(ClassResolver classResolver) {
        try {
            this.lock.writeLock().lock();
            this.listeners.put(classResolver, true);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public static enum CheckLevel {
        DISABLE,
        WARN,
        STRICT;

    }

    private static class DisallowSerializer
    extends Serializer {
        public DisallowSerializer(Fory fory, Class type) {
            super(fory, type);
        }

        public void write(MemoryBuffer buffer, Object value) {
            throw new InsecureException(String.format("Class %s not allowed for serialization.", this.type));
        }

        public Object read(MemoryBuffer buffer) {
            throw new InsecureException(String.format("Class %s not allowed for serialization.", this.type));
        }
    }
}

