/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.fory.Fory;
import org.apache.fory.logging.Logger;
import org.apache.fory.logging.LoggerFactory;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.reflect.ReflectionUtils;
import org.apache.fory.resolver.ClassResolver;
import org.apache.fory.serializer.ObjectSerializer;
import org.apache.fory.serializer.collection.CollectionSerializer;

public class SubListSerializers {
    private static final Logger LOG;
    private static final Class<?> SubListClass;
    private static final Class<?> RandomAccessSubListClass;
    private static final Class<?> ArrayListSubListClass;

    public static void registerSerializers(Fory fory, boolean preserveView) {
        ClassResolver classResolver = fory.getClassResolver();
        for (Class cls : new Class[]{SubListClass, RandomAccessSubListClass, ArrayListSubListClass}) {
            if (fory.trackingRef() && preserveView && !fory.isCrossLanguage()) {
                classResolver.registerSerializer(cls, new SubListViewSerializer(fory, cls));
                continue;
            }
            classResolver.registerSerializer(cls, new SubListSerializer(fory, cls));
        }
    }

    static {
        Class<?> randomAccessSubListClass;
        Class<?> sublistClass;
        LOG = LoggerFactory.getLogger(SubListSerializers.class);
        try {
            sublistClass = Class.forName("java.util.SubList");
        }
        catch (ClassNotFoundException e) {
            sublistClass = ReflectionUtils.loadClass("java.util.AbstractList$SubList");
        }
        SubListClass = sublistClass;
        try {
            randomAccessSubListClass = Class.forName("java.util.RandomAccessSubList");
        }
        catch (ClassNotFoundException e) {
            randomAccessSubListClass = ReflectionUtils.loadClass("java.util.AbstractList$RandomAccessSubList");
        }
        RandomAccessSubListClass = randomAccessSubListClass;
        try {
            ArrayListSubListClass = Class.forName("java.util.ArrayList$SubList");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static final class SubListViewSerializer
    extends CollectionSerializer<List> {
        private ObjectSerializer dataSerializer;
        private boolean serializedBefore;

        public SubListViewSerializer(Fory fory, Class cls) {
            super(fory, Stub.class.isAssignableFrom(cls) ? ArrayListSubListClass : cls);
            assert (!fory.isCrossLanguage());
        }

        @Override
        public Collection onCollectionWrite(MemoryBuffer buffer, List value) {
            throw new IllegalStateException();
        }

        @Override
        public List onCollectionRead(Collection collection) {
            throw new IllegalStateException();
        }

        @Override
        public void write(MemoryBuffer buffer, List value) {
            this.checkSerialization(value);
            this.getObjectSerializer().write(buffer, value);
        }

        @Override
        public List read(MemoryBuffer buffer) {
            List value = (List)this.getObjectSerializer().read(buffer);
            this.checkSerialization(value);
            return value;
        }

        private ObjectSerializer getObjectSerializer() {
            ObjectSerializer dataSerializer = this.dataSerializer;
            if (dataSerializer == null) {
                dataSerializer = this.dataSerializer = new ObjectSerializer(this.fory, this.type);
            }
            return dataSerializer;
        }

        @Override
        public List copy(List value) {
            throw new UnsupportedOperationException("parent list didn't copy modCount, but sublist does copy it");
        }

        private void checkSerialization(Object value) {
            if (!this.serializedBefore) {
                this.serializedBefore = true;
                LOG.warn("List view of type {} is being serialized/deserialized, this is not recommended, please don't serialize such types, it's not allowed for serialization by JDK too. To ensure consistency between view and the raw List, we must serialize raw List together even if the raw List is not referenced other places. This may cause extra data be serialized if the original List is not referenced in the object graph being serialized, but this is necessary. Otherwise, serializing multiple view of same original list will bring data duplication, and if you update the view, the original list won't be updated too. If you want to serialize SubList view as a standard List, you can register a serializer by `fory.registerSerializer(cls, new SubListSerializer(fory, (Class<List>) cls))`, object type of deserialized value will be {}", (Object)value.getClass(), (Object)ArrayList.class);
            }
        }
    }

    public static final class SubListSerializer
    extends CollectionSerializer {
        public SubListSerializer(Fory fory, Class<List> type) {
            super(fory, type, true);
            fory.getClassResolver().setSerializer(type, this);
        }

        @Override
        public Collection newCollection(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            this.setNumElements(numElements);
            return new ArrayList(numElements);
        }

        @Override
        public Collection newCollection(Collection collection) {
            return new ArrayList(collection.size());
        }
    }

    private static interface Stub {
    }
}

