/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.fory.BaseFory;
import org.apache.fory.annotation.Internal;
import org.apache.fory.builder.JITContext;
import org.apache.fory.collection.IdentityMap;
import org.apache.fory.config.CompatibleMode;
import org.apache.fory.config.Config;
import org.apache.fory.config.ForyBuilder;
import org.apache.fory.config.Language;
import org.apache.fory.config.LongEncoding;
import org.apache.fory.exception.CopyException;
import org.apache.fory.exception.DeserializationException;
import org.apache.fory.exception.ForyException;
import org.apache.fory.exception.InsecureException;
import org.apache.fory.exception.SerializationException;
import org.apache.fory.io.ForyInputStream;
import org.apache.fory.io.ForyReadableChannel;
import org.apache.fory.logging.Logger;
import org.apache.fory.logging.LoggerFactory;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.memory.MemoryUtils;
import org.apache.fory.meta.MetaCompressor;
import org.apache.fory.resolver.ClassInfo;
import org.apache.fory.resolver.ClassInfoHolder;
import org.apache.fory.resolver.ClassResolver;
import org.apache.fory.resolver.MapRefResolver;
import org.apache.fory.resolver.MetaContext;
import org.apache.fory.resolver.MetaStringResolver;
import org.apache.fory.resolver.NoRefResolver;
import org.apache.fory.resolver.RefResolver;
import org.apache.fory.resolver.SerializationContext;
import org.apache.fory.resolver.TypeResolver;
import org.apache.fory.resolver.XtypeResolver;
import org.apache.fory.serializer.ArraySerializers;
import org.apache.fory.serializer.BufferCallback;
import org.apache.fory.serializer.BufferObject;
import org.apache.fory.serializer.PrimitiveSerializers;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.serializer.SerializerFactory;
import org.apache.fory.serializer.StringSerializer;
import org.apache.fory.serializer.collection.CollectionSerializers;
import org.apache.fory.serializer.collection.MapSerializers;
import org.apache.fory.type.Generics;
import org.apache.fory.util.ExceptionUtils;
import org.apache.fory.util.Preconditions;
import org.apache.fory.util.StringUtils;

@NotThreadSafe
public final class Fory
implements BaseFory {
    private static final Logger LOG = LoggerFactory.getLogger(Fory.class);
    public static final byte NULL_FLAG = -3;
    public static final byte REF_FLAG = -2;
    public static final byte NOT_NULL_VALUE_FLAG = -1;
    public static final byte REF_VALUE_FLAG = 0;
    public static final byte NOT_SUPPORT_XLANG = 0;
    private static final byte isNilFlag = 1;
    private static final byte isLittleEndianFlag = 2;
    private static final byte isCrossLanguageFlag = 4;
    private static final byte isOutOfBandFlag = 8;
    private static final boolean isLittleEndian = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    private static final byte BITMAP = (byte)(isLittleEndian ? 2 : 0);
    private static final short MAGIC_NUMBER = 25300;
    private final Config config;
    private final boolean refTracking;
    private final boolean shareMeta;
    private final RefResolver refResolver;
    private final ClassResolver classResolver;
    private final XtypeResolver xtypeResolver;
    private final MetaStringResolver metaStringResolver;
    private final SerializationContext serializationContext;
    private final ClassLoader classLoader;
    private final JITContext jitContext;
    private MemoryBuffer buffer;
    private final StringSerializer stringSerializer;
    private final CollectionSerializers.ArrayListSerializer arrayListSerializer;
    private final MapSerializers.HashMapSerializer hashMapSerializer;
    private final boolean crossLanguage;
    private final boolean compressInt;
    private final LongEncoding longEncoding;
    private final Generics generics;
    private Language peerLanguage;
    private BufferCallback bufferCallback;
    private Iterator<MemoryBuffer> outOfBandBuffers;
    private boolean peerOutOfBandEnabled;
    private int depth;
    private final int maxDepth;
    private int copyDepth;
    private final boolean copyRefTracking;
    private final IdentityMap<Object, Object> originToCopyMap;
    private int classDefEndOffset;

    public Fory(ForyBuilder builder, ClassLoader classLoader) {
        this.config = new Config(builder);
        this.crossLanguage = this.config.getLanguage() != Language.JAVA;
        this.refTracking = this.config.trackingRef();
        this.copyRefTracking = this.config.copyRef();
        this.shareMeta = this.config.isMetaShareEnabled();
        this.compressInt = this.config.compressInt();
        this.longEncoding = this.config.longEncoding();
        this.maxDepth = this.config.maxDepth();
        this.refResolver = this.refTracking ? new MapRefResolver() : new NoRefResolver();
        this.jitContext = new JITContext(this);
        this.generics = new Generics(this);
        this.metaStringResolver = new MetaStringResolver();
        this.depth = -1;
        this.classResolver = new ClassResolver(this);
        this.xtypeResolver = this.crossLanguage ? new XtypeResolver(this) : null;
        this.classResolver.initialize();
        if (this.xtypeResolver != null) {
            this.xtypeResolver.initialize();
        }
        this.serializationContext = new SerializationContext(this.config);
        this.classLoader = classLoader;
        this.stringSerializer = new StringSerializer(this);
        this.arrayListSerializer = new CollectionSerializers.ArrayListSerializer(this);
        this.hashMapSerializer = new MapSerializers.HashMapSerializer(this);
        this.originToCopyMap = new IdentityMap();
        this.classDefEndOffset = -1;
        LOG.info("Created new fory {}", (Object)this);
    }

    @Override
    public void register(Class<?> cls) {
        this._getTypeResolver().register(cls);
    }

    @Override
    public void register(Class<?> cls, int id) {
        this._getTypeResolver().register(cls, id);
    }

    @Override
    @Deprecated
    public void register(Class<?> cls, boolean createSerializer) {
        this._getTypeResolver().register(cls);
    }

    @Override
    @Deprecated
    public void register(Class<?> cls, int id, boolean createSerializer) {
        this._getTypeResolver().register(cls, id);
    }

    @Override
    public void register(Class<?> cls, String typeName) {
        int idx = typeName.lastIndexOf(46);
        String namespace = "";
        if (idx > 0) {
            namespace = typeName.substring(0, idx);
            typeName = typeName.substring(idx + 1);
        }
        this.register(cls, namespace, typeName);
    }

    @Override
    public void register(Class<?> cls, String namespace, String typeName) {
        this._getTypeResolver().register(cls, namespace, typeName);
    }

    @Override
    public void register(String className) {
        this._getTypeResolver().register(className);
    }

    @Override
    public void register(String className, int classId) {
        this._getTypeResolver().register(className, classId);
    }

    @Override
    public void register(String className, String namespace, String typeName) {
        this._getTypeResolver().register(className, namespace, typeName);
    }

    @Override
    public <T> void registerSerializer(Class<T> type, Class<? extends Serializer> serializerClass) {
        this._getTypeResolver().registerSerializer(type, serializerClass);
    }

    @Override
    public void registerSerializer(Class<?> type, Serializer<?> serializer) {
        this._getTypeResolver().registerSerializer(type, serializer);
    }

    @Override
    public void registerSerializer(Class<?> type, Function<Fory, Serializer<?>> serializerCreator) {
        this._getTypeResolver().registerSerializer(type, serializerCreator.apply(this));
    }

    @Override
    public void setSerializerFactory(SerializerFactory serializerFactory) {
        this.classResolver.setSerializerFactory(serializerFactory);
    }

    public SerializerFactory getSerializerFactory() {
        return this.classResolver.getSerializerFactory();
    }

    public <T> Serializer<T> getSerializer(Class<T> cls) {
        Preconditions.checkNotNull(cls);
        if (!this.crossLanguage) {
            return this.classResolver.getSerializer(cls);
        }
        return this.xtypeResolver.getClassInfo(cls).getSerializer();
    }

    @Override
    public MemoryBuffer serialize(Object obj, long address, int size) {
        MemoryBuffer buffer = MemoryUtils.buffer(address, size);
        this.serialize(buffer, obj, null);
        return buffer;
    }

    @Override
    public byte[] serialize(Object obj) {
        MemoryBuffer buf = this.getBuffer();
        buf.writerIndex(0);
        this.serialize(buf, obj, null);
        byte[] bytes = buf.getBytes(0, buf.writerIndex());
        this.resetBuffer();
        return bytes;
    }

    @Override
    public byte[] serialize(Object obj, BufferCallback callback) {
        MemoryBuffer buf = this.getBuffer();
        buf.writerIndex(0);
        this.serialize(buf, obj, callback);
        byte[] bytes = buf.getBytes(0, buf.writerIndex());
        this.resetBuffer();
        return bytes;
    }

    @Override
    public MemoryBuffer serialize(MemoryBuffer buffer, Object obj) {
        return this.serialize(buffer, obj, null);
    }

    @Override
    public MemoryBuffer serialize(MemoryBuffer buffer, Object obj, BufferCallback callback) {
        if (this.crossLanguage) {
            buffer.writeInt16((short)25300);
        }
        byte bitmap = BITMAP;
        if (this.crossLanguage) {
            bitmap = (byte)(bitmap | 4);
        }
        if (obj == null) {
            bitmap = (byte)(bitmap | 1);
            buffer.writeByte(bitmap);
            return buffer;
        }
        if (callback != null) {
            bitmap = (byte)(bitmap | 8);
            this.bufferCallback = callback;
        }
        buffer.writeByte(bitmap);
        try {
            this.jitContext.lock();
            if (this.depth > 0) {
                this.throwDepthSerializationException();
            }
            this.depth = 0;
            if (!this.crossLanguage) {
                this.write(buffer, obj);
            } else {
                this.xwrite(buffer, obj);
            }
            MemoryBuffer memoryBuffer = buffer;
            return memoryBuffer;
        }
        catch (Throwable t) {
            throw this.processSerializationError(t);
        }
        finally {
            this.resetWrite();
            this.jitContext.unlock();
        }
    }

    @Override
    public void serialize(OutputStream outputStream, Object obj) {
        this.serializeToStream(outputStream, buf -> this.serialize((MemoryBuffer)buf, obj, null));
    }

    @Override
    public void serialize(OutputStream outputStream, Object obj, BufferCallback callback) {
        this.serializeToStream(outputStream, buf -> this.serialize((MemoryBuffer)buf, obj, callback));
    }

    private ForyException processSerializationError(Throwable e) {
        if (!this.refTracking) {
            String msg = "Object may contain circular references, please enable ref tracking by `ForyBuilder#withRefTracking(true)`";
            String rawMessage = e.getMessage();
            if (StringUtils.isNotBlank(rawMessage)) {
                msg = msg + ": " + rawMessage;
            }
            if (e instanceof StackOverflowError) {
                e = ExceptionUtils.trySetStackOverflowErrorMessage((StackOverflowError)e, msg);
            }
        }
        if (!(e instanceof ForyException)) {
            e = new SerializationException(e);
        }
        throw (ForyException)e;
    }

    private ForyException processCopyError(Throwable e) {
        if (!this.copyRefTracking) {
            String msg = "Object may contain circular references, please enable ref tracking by `ForyBuilder#withRefCopy(true)`";
            e = ExceptionUtils.trySetStackOverflowErrorMessage((StackOverflowError)e, msg);
        }
        if (!(e instanceof ForyException)) {
            throw new CopyException(e);
        }
        throw (ForyException)e;
    }

    public MemoryBuffer getBuffer() {
        MemoryBuffer buf = this.buffer;
        if (buf == null) {
            buf = this.buffer = MemoryBuffer.newHeapBuffer(64);
        }
        return buf;
    }

    public void resetBuffer() {
        MemoryBuffer buf = this.buffer;
        if (buf != null && buf.size() > this.config.bufferSizeLimitBytes()) {
            this.buffer = MemoryBuffer.newHeapBuffer(this.config.bufferSizeLimitBytes());
        }
    }

    private void write(MemoryBuffer buffer, Object obj) {
        int startOffset = buffer.writerIndex();
        boolean shareMeta = this.config.isMetaShareEnabled();
        if (shareMeta) {
            buffer.writeInt32(-1);
        }
        if (!this.refResolver.writeRefOrNull(buffer, obj)) {
            ClassInfo classInfo = this.classResolver.getOrUpdateClassInfo(obj.getClass());
            this.classResolver.writeClassInfo(buffer, classInfo);
            this.writeData(buffer, classInfo, obj);
        }
        MetaContext metaContext = this.serializationContext.getMetaContext();
        if (shareMeta && metaContext != null && !metaContext.writingClassDefs.isEmpty()) {
            buffer.putInt32(startOffset, buffer.writerIndex() - startOffset - 4);
            this.classResolver.writeClassDefs(buffer);
        }
    }

    private void xwrite(MemoryBuffer buffer, Object obj) {
        buffer.writeByte((byte)Language.JAVA.ordinal());
        int startOffset = buffer.writerIndex();
        boolean shareMeta = this.config.isMetaShareEnabled();
        if (shareMeta) {
            buffer.writeInt32(-1);
        }
        this.xwriteRef(buffer, obj);
        MetaContext metaContext = this.serializationContext.getMetaContext();
        if (shareMeta && metaContext != null && !metaContext.writingClassDefs.isEmpty()) {
            buffer.putInt32(startOffset, buffer.writerIndex() - startOffset - 4);
            this.classResolver.writeClassDefs(buffer);
        }
    }

    public void writeRef(MemoryBuffer buffer, Object obj) {
        if (!this.refResolver.writeRefOrNull(buffer, obj)) {
            ClassInfo classInfo = this.classResolver.getOrUpdateClassInfo(obj.getClass());
            this.classResolver.writeClassInfo(buffer, classInfo);
            this.writeData(buffer, classInfo, obj);
        }
    }

    public void writeRef(MemoryBuffer buffer, Object obj, ClassInfoHolder classInfoHolder) {
        if (!this.refResolver.writeRefOrNull(buffer, obj)) {
            ClassInfo classInfo = this.classResolver.getClassInfo(obj.getClass(), classInfoHolder);
            this.classResolver.writeClassInfo(buffer, classInfo);
            this.writeData(buffer, classInfo, obj);
        }
    }

    public void writeRef(MemoryBuffer buffer, Object obj, ClassInfo classInfo) {
        Serializer<Object> serializer = classInfo.getSerializer();
        if (serializer.needToWriteRef()) {
            if (!this.refResolver.writeRefOrNull(buffer, obj)) {
                this.classResolver.writeClassInfo(buffer, classInfo);
                ++this.depth;
                serializer.write(buffer, obj);
                --this.depth;
            }
        } else if (obj == null) {
            buffer.writeByte((byte)-3);
        } else {
            buffer.writeByte((byte)-1);
            this.classResolver.writeClassInfo(buffer, classInfo);
            ++this.depth;
            serializer.write(buffer, obj);
            --this.depth;
        }
    }

    public <T> void writeRef(MemoryBuffer buffer, T obj, Serializer<T> serializer) {
        if (serializer.needToWriteRef()) {
            if (!this.refResolver.writeRefOrNull(buffer, obj)) {
                ++this.depth;
                serializer.write(buffer, obj);
                --this.depth;
            }
        } else if (obj == null) {
            buffer.writeByte((byte)-3);
        } else {
            buffer.writeByte((byte)-1);
            ++this.depth;
            serializer.write(buffer, obj);
            --this.depth;
        }
    }

    public void writeNullable(MemoryBuffer buffer, Object obj) {
        if (obj == null) {
            buffer.writeByte((byte)-3);
        } else {
            buffer.writeByte((byte)-1);
            this.writeNonRef(buffer, obj);
        }
    }

    public void writeNullable(MemoryBuffer buffer, Object obj, Serializer serializer) {
        if (obj == null) {
            buffer.writeByte((byte)-3);
        } else {
            buffer.writeByte((byte)-1);
            serializer.write(buffer, obj);
        }
    }

    public void writeNullable(MemoryBuffer buffer, Object obj, ClassInfoHolder classInfoHolder) {
        if (obj == null) {
            buffer.writeByte((byte)-3);
        } else {
            buffer.writeByte((byte)-1);
            this.writeNonRef(buffer, obj, this.classResolver.getClassInfo(obj.getClass(), classInfoHolder));
        }
    }

    public void writeNullable(MemoryBuffer buffer, Object obj, ClassInfo classInfo) {
        if (obj == null) {
            buffer.writeByte((byte)-3);
        } else {
            buffer.writeByte((byte)-1);
            this.writeNonRef(buffer, obj, classInfo);
        }
    }

    public void writeNonRef(MemoryBuffer buffer, Object obj) {
        ClassInfo classInfo = this.classResolver.getOrUpdateClassInfo(obj.getClass());
        this.classResolver.writeClassInfo(buffer, classInfo);
        this.writeData(buffer, classInfo, obj);
    }

    public void writeNonRef(MemoryBuffer buffer, Object obj, ClassInfo classInfo) {
        this.classResolver.writeClassInfo(buffer, classInfo);
        Serializer<Object> serializer = classInfo.getSerializer();
        ++this.depth;
        serializer.write(buffer, obj);
        --this.depth;
    }

    public void xwriteRef(MemoryBuffer buffer, Object obj) {
        if (!this.refResolver.writeRefOrNull(buffer, obj)) {
            ClassInfo classInfo = this.xtypeResolver.writeClassInfo(buffer, obj);
            this.xwriteData(buffer, classInfo, obj);
        }
    }

    public <T> void xwriteRef(MemoryBuffer buffer, T obj, Serializer<T> serializer) {
        if (serializer.needToWriteRef()) {
            if (!this.refResolver.writeRefOrNull(buffer, obj)) {
                ++this.depth;
                serializer.xwrite(buffer, obj);
                --this.depth;
            }
        } else if (obj == null) {
            buffer.writeByte((byte)-3);
        } else {
            buffer.writeByte((byte)-1);
            ++this.depth;
            serializer.xwrite(buffer, obj);
            --this.depth;
        }
    }

    public void xwriteNonRef(MemoryBuffer buffer, Object obj) {
        ClassInfo classInfo = this.xtypeResolver.writeClassInfo(buffer, obj);
        this.xwriteData(buffer, classInfo, obj);
    }

    public void xwriteNonRef(MemoryBuffer buffer, Object obj, ClassInfo classInfo) {
        this.xtypeResolver.writeClassInfo(buffer, classInfo);
        this.xwriteData(buffer, classInfo, obj);
    }

    public void xwriteData(MemoryBuffer buffer, ClassInfo classInfo, Object obj) {
        switch (classInfo.getXtypeId()) {
            case 1: {
                buffer.writeBoolean((Boolean)obj);
                break;
            }
            case 2: {
                buffer.writeByte((Byte)obj);
                break;
            }
            case 3: {
                buffer.writeInt16((Short)obj);
                break;
            }
            case 4: 
            case 5: {
                buffer.writeVarInt32((Integer)obj);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                buffer.writeVarInt64((Long)obj);
                break;
            }
            case 10: {
                buffer.writeFloat32(((Float)obj).floatValue());
                break;
            }
            case 11: {
                buffer.writeFloat64((Double)obj);
                break;
            }
            default: {
                ++this.depth;
                classInfo.getSerializer().xwrite(buffer, obj);
                --this.depth;
            }
        }
    }

    private void writeData(MemoryBuffer buffer, ClassInfo classInfo, Object obj) {
        switch (classInfo.getClassId()) {
            case 14: {
                buffer.writeBoolean((Boolean)obj);
                break;
            }
            case 15: {
                buffer.writeByte((Byte)obj);
                break;
            }
            case 16: {
                buffer.writeChar(((Character)obj).charValue());
                break;
            }
            case 17: {
                buffer.writeInt16((Short)obj);
                break;
            }
            case 18: {
                if (this.compressInt) {
                    buffer.writeVarInt32((Integer)obj);
                    break;
                }
                buffer.writeInt32((Integer)obj);
                break;
            }
            case 19: {
                buffer.writeFloat32(((Float)obj).floatValue());
                break;
            }
            case 20: {
                PrimitiveSerializers.LongSerializer.writeInt64(buffer, (Long)obj, this.longEncoding);
                break;
            }
            case 21: {
                buffer.writeFloat64((Double)obj);
                break;
            }
            case 22: {
                this.stringSerializer.writeJavaString(buffer, (String)obj);
                break;
            }
            default: {
                ++this.depth;
                classInfo.getSerializer().write(buffer, obj);
                --this.depth;
            }
        }
    }

    public void writeBufferObject(MemoryBuffer buffer, BufferObject bufferObject) {
        if (this.bufferCallback == null || this.bufferCallback.apply(bufferObject)) {
            buffer.writeBoolean(true);
            int totalBytes = bufferObject.totalBytes();
            if (!this.crossLanguage) {
                buffer.writeVarUint32Aligned(totalBytes);
            } else {
                buffer.writeVarUint32(totalBytes);
            }
            int writerIndex = buffer.writerIndex();
            buffer.ensure(writerIndex + bufferObject.totalBytes());
            bufferObject.writeTo(buffer);
            int size = buffer.writerIndex() - writerIndex;
            Preconditions.checkArgument(size == totalBytes);
        } else {
            buffer.writeBoolean(false);
        }
    }

    public void writeBufferObject(MemoryBuffer buffer, ArraySerializers.PrimitiveArrayBufferObject bufferObject) {
        if (this.bufferCallback == null || this.bufferCallback.apply(bufferObject)) {
            buffer.writeBoolean(true);
            int totalBytes = bufferObject.totalBytes();
            if (!this.crossLanguage) {
                buffer.writeVarUint32Aligned(totalBytes);
            } else {
                buffer.writeVarUint32(totalBytes);
            }
            bufferObject.writeTo(buffer);
        } else {
            buffer.writeBoolean(false);
        }
    }

    public MemoryBuffer readBufferObject(MemoryBuffer buffer) {
        boolean inBand = buffer.readBoolean();
        if (inBand) {
            int size = !this.crossLanguage ? buffer.readAlignedVarUint() : buffer.readVarUint32();
            if (buffer.readerIndex() + size > buffer.size() && buffer.getStreamReader() != null) {
                buffer.getStreamReader().fillBuffer(buffer.readerIndex() + size - buffer.size());
            }
            MemoryBuffer slice = buffer.slice(buffer.readerIndex(), size);
            buffer.readerIndex(buffer.readerIndex() + size);
            return slice;
        }
        Preconditions.checkArgument(this.outOfBandBuffers.hasNext());
        return this.outOfBandBuffers.next();
    }

    public void writeString(MemoryBuffer buffer, String str) {
        this.stringSerializer.writeString(buffer, str);
    }

    public String readString(MemoryBuffer buffer) {
        return this.stringSerializer.readString(buffer);
    }

    public void writeJavaStringRef(MemoryBuffer buffer, String str) {
        if (this.stringSerializer.needToWriteRef()) {
            if (!this.refResolver.writeRefOrNull(buffer, str)) {
                this.stringSerializer.writeJavaString(buffer, str);
            }
        } else if (str == null) {
            buffer.writeByte((byte)-3);
        } else {
            buffer.writeByte((byte)-1);
            this.stringSerializer.write(buffer, str);
        }
    }

    public String readJavaStringRef(MemoryBuffer buffer) {
        RefResolver refResolver = this.refResolver;
        if (this.stringSerializer.needToWriteRef()) {
            int nextReadRefId = refResolver.tryPreserveRefId(buffer);
            if (nextReadRefId >= -1) {
                String obj = this.stringSerializer.read(buffer);
                refResolver.setReadObject(nextReadRefId, obj);
                return obj;
            }
            return (String)refResolver.getReadObject();
        }
        byte headFlag = buffer.readByte();
        if (headFlag == -3) {
            return null;
        }
        return this.stringSerializer.read(buffer);
    }

    public void writeJavaString(MemoryBuffer buffer, String str) {
        this.stringSerializer.writeJavaString(buffer, str);
    }

    public String readJavaString(MemoryBuffer buffer) {
        return this.stringSerializer.readJavaString(buffer);
    }

    public void writeInt64(MemoryBuffer buffer, long value) {
        PrimitiveSerializers.LongSerializer.writeInt64(buffer, value, this.longEncoding);
    }

    public long readInt64(MemoryBuffer buffer) {
        return PrimitiveSerializers.LongSerializer.readInt64(buffer, this.longEncoding);
    }

    @Override
    public Object deserialize(byte[] bytes) {
        return this.deserialize(MemoryUtils.wrap(bytes), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T deserialize(byte[] bytes, Class<T> type) {
        MemoryBuffer buffer = MemoryUtils.wrap(bytes);
        if (!this.crossLanguage && this.shareMeta) {
            boolean peerOutOfBandEnabled;
            byte bitmap = buffer.readByte();
            if ((bitmap & 1) == 1) {
                return null;
            }
            boolean bl = peerOutOfBandEnabled = (bitmap & 8) == 8;
            assert (!peerOutOfBandEnabled) : "Out of band buffers not passed in when deserializing";
            return this.deserializeJavaObject(buffer, type);
        }
        this.generics.pushGenericType(this.classResolver.buildGenericType(type));
        try {
            Object object = this.deserialize(buffer, null);
            return (T)object;
        }
        finally {
            this.generics.popGenericType();
        }
    }

    @Override
    public Object deserialize(byte[] bytes, Iterable<MemoryBuffer> outOfBandBuffers) {
        return this.deserialize(MemoryUtils.wrap(bytes), outOfBandBuffers);
    }

    @Override
    public Object deserialize(long address, int size) {
        return this.deserialize(MemoryUtils.buffer(address, size), null);
    }

    @Override
    public Object deserialize(MemoryBuffer buffer) {
        return this.deserialize(buffer, null);
    }

    @Override
    public Object deserialize(MemoryBuffer buffer, Iterable<MemoryBuffer> outOfBandBuffers) {
        try {
            byte bitmap;
            this.jitContext.lock();
            if (this.depth > 0) {
                this.throwDepthDeserializationException();
            }
            this.depth = 0;
            if (this.crossLanguage) {
                short magicNumber = buffer.readInt16();
                assert (magicNumber == 25300) : String.format("The fory xlang serialization must start with magic number 0x%x. Please check whether the serialization is based on the xlang protocol and the data didn't corrupt.", (short)25300);
            }
            if (((bitmap = buffer.readByte()) & 1) == 1) {
                Object var4_5 = null;
                return var4_5;
            }
            Preconditions.checkArgument(isLittleEndian, "Non-Little-Endian format detected. Only Little-Endian is supported.");
            boolean isTargetXLang = (bitmap & 4) == 4;
            this.peerLanguage = isTargetXLang ? Language.values()[buffer.readByte()] : Language.JAVA;
            boolean bl = this.peerOutOfBandEnabled = (bitmap & 8) == 8;
            if (this.peerOutOfBandEnabled) {
                Preconditions.checkNotNull(outOfBandBuffers, "outOfBandBuffers shouldn't be null when the serialized stream is produced with bufferCallback not null.");
                this.outOfBandBuffers = outOfBandBuffers.iterator();
            } else {
                Preconditions.checkArgument(outOfBandBuffers == null, "outOfBandBuffers should be null when the serialized stream is produced with bufferCallback null.");
            }
            if (this.shareMeta) {
                this.readClassDefs(buffer);
            }
            Object obj = isTargetXLang ? this.xreadRef(buffer) : this.readRef(buffer);
            Object object = obj;
            return object;
        }
        catch (Throwable t) {
            throw ExceptionUtils.handleReadFailed(this, t);
        }
        finally {
            if (this.classDefEndOffset != -1) {
                buffer.readerIndex(this.classDefEndOffset);
            }
            this.resetRead();
            this.jitContext.unlock();
        }
    }

    @Override
    public Object deserialize(ForyInputStream inputStream) {
        return this.deserialize(inputStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object deserialize(ForyInputStream inputStream, Iterable<MemoryBuffer> outOfBandBuffers) {
        try {
            MemoryBuffer buf = inputStream.getBuffer();
            Object object = this.deserialize(buf, outOfBandBuffers);
            return object;
        }
        finally {
            inputStream.shrinkBuffer();
        }
    }

    @Override
    public Object deserialize(ForyReadableChannel channel) {
        return this.deserialize(channel, null);
    }

    @Override
    public Object deserialize(ForyReadableChannel channel, Iterable<MemoryBuffer> outOfBandBuffers) {
        MemoryBuffer buf = channel.getBuffer();
        return this.deserialize(buf, outOfBandBuffers);
    }

    public Object readRef(MemoryBuffer buffer) {
        RefResolver refResolver = this.refResolver;
        int nextReadRefId = refResolver.tryPreserveRefId(buffer);
        if (nextReadRefId >= -1) {
            Object o = this.readDataInternal(buffer, this.classResolver.readClassInfo(buffer));
            refResolver.setReadObject(nextReadRefId, o);
            return o;
        }
        return refResolver.getReadObject();
    }

    public Object readRef(MemoryBuffer buffer, ClassInfoHolder classInfoHolder) {
        RefResolver refResolver = this.refResolver;
        int nextReadRefId = refResolver.tryPreserveRefId(buffer);
        if (nextReadRefId >= -1) {
            Object o = this.readDataInternal(buffer, this.classResolver.readClassInfo(buffer, classInfoHolder));
            refResolver.setReadObject(nextReadRefId, o);
            return o;
        }
        return refResolver.getReadObject();
    }

    public <T> T readRef(MemoryBuffer buffer, Serializer<T> serializer) {
        if (serializer.needToWriteRef()) {
            int nextReadRefId = this.refResolver.tryPreserveRefId(buffer);
            if (nextReadRefId >= -1) {
                T obj = serializer.read(buffer);
                this.refResolver.setReadObject(nextReadRefId, obj);
                return obj;
            }
            return (T)this.refResolver.getReadObject();
        }
        byte headFlag = buffer.readByte();
        if (headFlag == -3) {
            return null;
        }
        return serializer.read(buffer);
    }

    public Object readNonRef(MemoryBuffer buffer) {
        return this.readDataInternal(buffer, this.classResolver.readClassInfo(buffer));
    }

    public Object readNonRef(MemoryBuffer buffer, ClassInfoHolder classInfoHolder) {
        return this.readDataInternal(buffer, this.classResolver.readClassInfo(buffer, classInfoHolder));
    }

    public Object readNullable(MemoryBuffer buffer) {
        byte headFlag = buffer.readByte();
        if (headFlag == -3) {
            return null;
        }
        return this.readNonRef(buffer);
    }

    public Object readNullable(MemoryBuffer buffer, Serializer serializer) {
        byte headFlag = buffer.readByte();
        if (headFlag == -3) {
            return null;
        }
        return serializer.read(buffer);
    }

    public Object readNullable(MemoryBuffer buffer, ClassInfoHolder classInfoHolder) {
        byte headFlag = buffer.readByte();
        if (headFlag == -3) {
            return null;
        }
        return this.readNonRef(buffer, classInfoHolder);
    }

    public Object readData(MemoryBuffer buffer, ClassInfo classInfo) {
        this.incReadDepth();
        Serializer serializer = classInfo.getSerializer();
        Object read = serializer.read(buffer);
        --this.depth;
        return read;
    }

    private Object readDataInternal(MemoryBuffer buffer, ClassInfo classInfo) {
        switch (classInfo.getClassId()) {
            case 14: {
                return buffer.readBoolean();
            }
            case 15: {
                return buffer.readByte();
            }
            case 16: {
                return Character.valueOf(buffer.readChar());
            }
            case 17: {
                return buffer.readInt16();
            }
            case 18: {
                if (this.compressInt) {
                    return buffer.readVarInt32();
                }
                return buffer.readInt32();
            }
            case 19: {
                return Float.valueOf(buffer.readFloat32());
            }
            case 20: {
                return PrimitiveSerializers.LongSerializer.readInt64(buffer, this.longEncoding);
            }
            case 21: {
                return buffer.readFloat64();
            }
            case 22: {
                return this.stringSerializer.readJavaString(buffer);
            }
        }
        this.incReadDepth();
        Object read = classInfo.getSerializer().read(buffer);
        --this.depth;
        return read;
    }

    public Object xreadRef(MemoryBuffer buffer) {
        RefResolver refResolver = this.refResolver;
        int nextReadRefId = refResolver.tryPreserveRefId(buffer);
        if (nextReadRefId >= -1) {
            Object o = this.xreadNonRef(buffer, this.xtypeResolver.readClassInfo(buffer));
            refResolver.setReadObject(nextReadRefId, o);
            return o;
        }
        return refResolver.getReadObject();
    }

    public Object xreadRef(MemoryBuffer buffer, Serializer<?> serializer) {
        if (serializer.needToWriteRef()) {
            RefResolver refResolver = this.refResolver;
            int nextReadRefId = refResolver.tryPreserveRefId(buffer);
            if (nextReadRefId >= -1) {
                Object o = this.xreadNonRef(buffer, serializer);
                refResolver.setReadObject(nextReadRefId, o);
                return o;
            }
            return refResolver.getReadObject();
        }
        byte headFlag = buffer.readByte();
        if (headFlag == -3) {
            return null;
        }
        return this.xreadNonRef(buffer, serializer);
    }

    public Object xreadNonRef(MemoryBuffer buffer) {
        return this.xreadNonRef(buffer, this.xtypeResolver.readClassInfo(buffer));
    }

    public Object xreadNonRef(MemoryBuffer buffer, Serializer<?> serializer) {
        this.incReadDepth();
        Object o = serializer.xread(buffer);
        --this.depth;
        return o;
    }

    public Object xreadNonRef(MemoryBuffer buffer, ClassInfo classInfo) {
        assert (classInfo != null);
        switch (classInfo.getXtypeId()) {
            case 1: {
                return buffer.readBoolean();
            }
            case 2: {
                return buffer.readByte();
            }
            case 3: {
                return buffer.readInt16();
            }
            case 4: 
            case 5: {
                return buffer.readVarInt32();
            }
            case 6: 
            case 7: 
            case 8: {
                return buffer.readVarInt64();
            }
            case 10: {
                return Float.valueOf(buffer.readFloat32());
            }
            case 11: {
                return buffer.readFloat64();
            }
        }
        this.incReadDepth();
        Object o = classInfo.getSerializer().xread(buffer);
        --this.depth;
        return o;
    }

    public Object xreadNonRef(MemoryBuffer buffer, ClassInfoHolder classInfoHolder) {
        ClassInfo classInfo = this.xtypeResolver.readClassInfo(buffer, classInfoHolder);
        return this.xreadNonRef(buffer, classInfo);
    }

    public Object xreadNullable(MemoryBuffer buffer, Serializer<Object> serializer) {
        byte headFlag = buffer.readByte();
        if (headFlag == -3) {
            return null;
        }
        return serializer.xread(buffer);
    }

    @Override
    public byte[] serializeJavaObject(Object obj) {
        MemoryBuffer buf = this.getBuffer();
        buf.writerIndex(0);
        this.serializeJavaObject(buf, obj);
        byte[] bytes = buf.getBytes(0, buf.writerIndex());
        this.resetBuffer();
        return bytes;
    }

    @Override
    public void serializeJavaObject(MemoryBuffer buffer, Object obj) {
        try {
            this.jitContext.lock();
            if (this.depth > 0) {
                this.throwDepthSerializationException();
            }
            if (this.config.isMetaShareEnabled()) {
                int startOffset = buffer.writerIndex();
                buffer.writeInt32(-1);
                if (!this.refResolver.writeRefOrNull(buffer, obj)) {
                    ClassInfo classInfo = this.classResolver.getOrUpdateClassInfo(obj.getClass());
                    this.classResolver.writeClassInfo(buffer, classInfo);
                    this.writeData(buffer, classInfo, obj);
                    MetaContext metaContext = this.serializationContext.getMetaContext();
                    if (metaContext != null && !metaContext.writingClassDefs.isEmpty()) {
                        buffer.putInt32(startOffset, buffer.writerIndex() - startOffset - 4);
                        this.classResolver.writeClassDefs(buffer);
                    }
                }
            } else if (!this.refResolver.writeRefOrNull(buffer, obj)) {
                ClassInfo classInfo = this.classResolver.getOrUpdateClassInfo(obj.getClass());
                this.writeData(buffer, classInfo, obj);
            }
        }
        catch (Throwable t) {
            throw this.processSerializationError(t);
        }
        finally {
            this.resetWrite();
            this.jitContext.unlock();
        }
    }

    @Override
    public void serializeJavaObject(OutputStream outputStream, Object obj) {
        this.serializeToStream(outputStream, buf -> this.serializeJavaObject((MemoryBuffer)buf, obj));
    }

    @Override
    public <T> T deserializeJavaObject(byte[] data, Class<T> cls) {
        return this.deserializeJavaObject(MemoryBuffer.fromByteArray(data), cls);
    }

    @Override
    public <T> T deserializeJavaObject(MemoryBuffer buffer, Class<T> cls) {
        try {
            int nextReadRefId;
            this.jitContext.lock();
            if (this.depth > 0) {
                this.throwDepthDeserializationException();
            }
            if (this.shareMeta) {
                this.readClassDefs(buffer);
            }
            if ((nextReadRefId = this.refResolver.tryPreserveRefId(buffer)) >= -1) {
                Object obj;
                ClassInfo classInfo = this.shareMeta ? this.classResolver.readSharedClassMeta(buffer, cls) : this.classResolver.getClassInfo(cls);
                Object object = obj = this.readDataInternal(buffer, classInfo);
                return (T)object;
            }
            T t = null;
            return t;
        }
        catch (Throwable t) {
            throw ExceptionUtils.handleReadFailed(this, t);
        }
        finally {
            if (this.classDefEndOffset != -1) {
                buffer.readerIndex(this.classDefEndOffset);
            }
            this.resetRead();
            this.jitContext.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T deserializeJavaObject(ForyInputStream inputStream, Class<T> cls) {
        try {
            MemoryBuffer buf = inputStream.getBuffer();
            T t = this.deserializeJavaObject(buf, cls);
            return t;
        }
        finally {
            inputStream.shrinkBuffer();
        }
    }

    @Override
    public <T> T deserializeJavaObject(ForyReadableChannel channel, Class<T> cls) {
        MemoryBuffer buf = channel.getBuffer();
        return this.deserializeJavaObject(buf, cls);
    }

    @Override
    public byte[] serializeJavaObjectAndClass(Object obj) {
        MemoryBuffer buf = this.getBuffer();
        buf.writerIndex(0);
        this.serializeJavaObjectAndClass(buf, obj);
        byte[] bytes = buf.getBytes(0, buf.writerIndex());
        this.resetBuffer();
        return bytes;
    }

    @Override
    public void serializeJavaObjectAndClass(MemoryBuffer buffer, Object obj) {
        try {
            this.jitContext.lock();
            if (this.depth > 0) {
                this.throwDepthSerializationException();
            }
            this.write(buffer, obj);
        }
        catch (Throwable t) {
            throw this.processSerializationError(t);
        }
        finally {
            this.resetWrite();
            this.jitContext.unlock();
        }
    }

    @Override
    public void serializeJavaObjectAndClass(OutputStream outputStream, Object obj) {
        this.serializeToStream(outputStream, buf -> this.serializeJavaObjectAndClass((MemoryBuffer)buf, obj));
    }

    @Override
    public Object deserializeJavaObjectAndClass(byte[] data) {
        return this.deserializeJavaObjectAndClass(MemoryBuffer.fromByteArray(data));
    }

    @Override
    public Object deserializeJavaObjectAndClass(MemoryBuffer buffer) {
        try {
            this.jitContext.lock();
            if (this.depth > 0) {
                this.throwDepthDeserializationException();
            }
            if (this.shareMeta) {
                this.readClassDefs(buffer);
            }
            Object object = this.readRef(buffer);
            return object;
        }
        catch (Throwable t) {
            throw ExceptionUtils.handleReadFailed(this, t);
        }
        finally {
            if (this.classDefEndOffset != -1) {
                buffer.readerIndex(this.classDefEndOffset);
            }
            this.resetRead();
            this.jitContext.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object deserializeJavaObjectAndClass(ForyInputStream inputStream) {
        try {
            MemoryBuffer buf = inputStream.getBuffer();
            Object object = this.deserializeJavaObjectAndClass(buf);
            return object;
        }
        finally {
            inputStream.shrinkBuffer();
        }
    }

    @Override
    public Object deserializeJavaObjectAndClass(ForyReadableChannel channel) {
        MemoryBuffer buf = channel.getBuffer();
        return this.deserializeJavaObjectAndClass(buf);
    }

    @Override
    public <T> T copy(T obj) {
        try {
            T t = this.copyObject(obj);
            return t;
        }
        catch (Throwable e) {
            throw this.processCopyError(e);
        }
        finally {
            if (this.copyRefTracking) {
                this.resetCopy();
            }
        }
    }

    public <T> T copyObject(T obj) {
        Cloneable copy;
        if (obj == null) {
            return null;
        }
        ClassInfo classInfo = this.classResolver.getOrUpdateClassInfo(obj.getClass());
        switch (classInfo.getClassId()) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                return obj;
            }
            case 23: {
                boolean[] boolArr = (boolean[])obj;
                return (T)Arrays.copyOf(boolArr, boolArr.length);
            }
            case 24: {
                byte[] byteArr = (byte[])obj;
                return (T)Arrays.copyOf(byteArr, byteArr.length);
            }
            case 25: {
                char[] charArr = (char[])obj;
                return (T)Arrays.copyOf(charArr, charArr.length);
            }
            case 26: {
                short[] shortArr = (short[])obj;
                return (T)Arrays.copyOf(shortArr, shortArr.length);
            }
            case 27: {
                int[] intArr = (int[])obj;
                return (T)Arrays.copyOf(intArr, intArr.length);
            }
            case 28: {
                float[] floatArr = (float[])obj;
                return (T)Arrays.copyOf(floatArr, floatArr.length);
            }
            case 29: {
                long[] longArr = (long[])obj;
                return (T)Arrays.copyOf(longArr, longArr.length);
            }
            case 30: {
                double[] doubleArr = (double[])obj;
                return (T)Arrays.copyOf(doubleArr, doubleArr.length);
            }
            case 31: {
                String[] stringArr = (String[])obj;
                return (T)Arrays.copyOf(stringArr, stringArr.length);
            }
            case 33: {
                copy = this.arrayListSerializer.copy((ArrayList)obj);
                break;
            }
            case 34: {
                copy = this.hashMapSerializer.copy((HashMap)obj);
                break;
            }
            default: {
                copy = this.copyObject(obj, classInfo.getSerializer());
            }
        }
        return (T)copy;
    }

    public <T> T copyObject(T obj, int classId) {
        if (obj == null) {
            return null;
        }
        switch (classId) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                return obj;
            }
        }
        return this.copyObject(obj, this.classResolver.getOrUpdateClassInfo(obj.getClass()).getSerializer());
    }

    public <T> T copyObject(T obj, Serializer<T> serializer) {
        T copyObject;
        ++this.copyDepth;
        if (serializer.needToCopyRef()) {
            copyObject = this.getCopyObject(obj);
            if (copyObject == null) {
                copyObject = serializer.copy(obj);
                this.originToCopyMap.put(obj, copyObject);
            }
        } else {
            copyObject = serializer.copy(obj);
        }
        --this.copyDepth;
        return copyObject;
    }

    public <T> void reference(T o1, T o2) {
        if (o1 != null) {
            this.originToCopyMap.put(o1, o2);
        }
    }

    public <T> T getCopyObject(T originObj) {
        return (T)this.originToCopyMap.get(originObj);
    }

    private void serializeToStream(OutputStream outputStream, Consumer<MemoryBuffer> function) {
        MemoryBuffer buf = this.getBuffer();
        if (outputStream.getClass() == ByteArrayOutputStream.class) {
            byte[] oldBytes = buf.getHeapMemory();
            assert (oldBytes != null);
            MemoryUtils.wrap((ByteArrayOutputStream)outputStream, buf);
            function.accept(buf);
            MemoryUtils.wrap(buf, (ByteArrayOutputStream)outputStream);
            buf.pointTo(oldBytes, 0, oldBytes.length);
        } else {
            buf.writerIndex(0);
            function.accept(buf);
            try {
                byte[] bytes = buf.getHeapMemory();
                if (bytes != null) {
                    outputStream.write(bytes, 0, buf.writerIndex());
                } else {
                    outputStream.write(buf.getBytes(0, buf.writerIndex()));
                }
                outputStream.flush();
            }
            catch (IOException e) {
                throw new SerializationException(e);
            }
            finally {
                this.resetBuffer();
            }
        }
    }

    private void readClassDefs(MemoryBuffer buffer) {
        int relativeClassDefOffset = buffer.readInt32();
        if (relativeClassDefOffset == -1) {
            return;
        }
        int readerIndex = buffer.readerIndex();
        buffer.readerIndex(readerIndex + relativeClassDefOffset);
        this.classResolver.readClassDefs(buffer);
        this.classDefEndOffset = buffer.readerIndex();
        buffer.readerIndex(readerIndex);
    }

    public void reset() {
        this.resetWrite();
        this.resetRead();
        this.resetCopy();
    }

    public void resetWrite() {
        this.refResolver.resetWrite();
        this.classResolver.resetWrite();
        this.metaStringResolver.resetWrite();
        this.serializationContext.resetWrite();
        this.bufferCallback = null;
        this.depth = 0;
    }

    public void resetRead() {
        this.refResolver.resetRead();
        this.classResolver.resetRead();
        this.metaStringResolver.resetRead();
        this.serializationContext.resetRead();
        this.peerOutOfBandEnabled = false;
        this.classDefEndOffset = -1;
        this.depth = 0;
    }

    public void resetCopy() {
        this.originToCopyMap.clear();
        this.copyDepth = 0;
    }

    private void throwDepthSerializationException() {
        String method = "Fory#" + (this.crossLanguage ? "x" : "") + "writeXXX";
        throw new SerializationException(String.format("Nested call Fory.serializeXXX is not allowed when serializing, Please use %s instead", method));
    }

    private void throwDepthDeserializationException() {
        String method = "Fory#" + (this.crossLanguage ? "x" : "") + "readXXX";
        throw new DeserializationException(String.format("Nested call Fory.deserializeXXX is not allowed when deserializing, Please use %s instead", method));
    }

    @Override
    public void ensureSerializersCompiled() {
        this.classResolver.ensureSerializersCompiled();
    }

    public JITContext getJITContext() {
        return this.jitContext;
    }

    public BufferCallback getBufferCallback() {
        return this.bufferCallback;
    }

    public boolean isPeerOutOfBandEnabled() {
        return this.peerOutOfBandEnabled;
    }

    public RefResolver getRefResolver() {
        return this.refResolver;
    }

    public ClassResolver getClassResolver() {
        return this.classResolver;
    }

    public XtypeResolver getXtypeResolver() {
        return this.xtypeResolver;
    }

    @Internal
    public TypeResolver _getTypeResolver() {
        return this.crossLanguage ? this.xtypeResolver : this.classResolver;
    }

    public MetaStringResolver getMetaStringResolver() {
        return this.metaStringResolver;
    }

    public SerializationContext getSerializationContext() {
        return this.serializationContext;
    }

    public Generics getGenerics() {
        return this.generics;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void incDepth(int diff) {
        this.depth += diff;
    }

    public void incDepth() {
        ++this.depth;
    }

    public void decDepth() {
        --this.depth;
    }

    public void incReadDepth() {
        if (++this.depth > this.maxDepth) {
            this.throwReadDepthExceedException();
        }
    }

    private void throwReadDepthExceedException() {
        throw new InsecureException(String.format("Read depth exceed max depth %s, the deserialization data may be malicious. If it's not malicious, please increase max read depth by ForyBuilder#withMaxDepth(largerDepth)", this.maxDepth));
    }

    public void incCopyDepth(int diff) {
        this.copyDepth += diff;
    }

    public StringSerializer getStringSerializer() {
        return this.stringSerializer;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public boolean isCrossLanguage() {
        return this.crossLanguage;
    }

    public boolean isCompatible() {
        return this.config.getCompatibleMode() == CompatibleMode.COMPATIBLE;
    }

    public boolean trackingRef() {
        return this.refTracking;
    }

    public boolean copyTrackingRef() {
        return this.copyRefTracking;
    }

    public boolean isStringRefIgnored() {
        return this.config.isStringRefIgnored();
    }

    public boolean isBasicTypesRefIgnored() {
        return this.config.isBasicTypesRefIgnored();
    }

    public boolean checkClassVersion() {
        return this.config.checkClassVersion();
    }

    public CompatibleMode getCompatibleMode() {
        return this.config.getCompatibleMode();
    }

    public Config getConfig() {
        return this.config;
    }

    public Class<? extends Serializer> getDefaultJDKStreamSerializerType() {
        return this.config.getDefaultJDKStreamSerializerType();
    }

    public boolean compressString() {
        return this.config.compressString();
    }

    public boolean compressInt() {
        return this.compressInt;
    }

    public LongEncoding longEncoding() {
        return this.longEncoding;
    }

    public boolean compressLong() {
        return this.config.compressLong();
    }

    public MetaCompressor getMetaCompressor() {
        return this.config.getMetaCompressor();
    }

    public static ForyBuilder builder() {
        return new ForyBuilder();
    }
}

