/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.collection;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.fory.annotation.Internal;
import org.apache.fory.util.GraalvmSupport;

@Internal
public class ClassValueCache<T> {
    private final Cache<Class<?>, T> cache;

    private ClassValueCache(Cache<Class<?>, T> cache) {
        this.cache = cache;
    }

    public T getIfPresent(Class<?> k) {
        return (T)this.cache.getIfPresent(k);
    }

    public T get(Class<?> k, Callable<? extends T> loader) {
        try {
            return (T)this.cache.get(k, loader);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void put(Class<?> k, T v) {
        this.cache.put(k, v);
    }

    public static <T> ClassValueCache<T> newClassKeyCache(int concurrencyLevel) {
        if (GraalvmSupport.isGraalBuildtime()) {
            return new ClassValueCache<T>(CacheBuilder.newBuilder().concurrencyLevel(concurrencyLevel).build());
        }
        return new ClassValueCache<T>(CacheBuilder.newBuilder().weakKeys().concurrencyLevel(concurrencyLevel).build());
    }

    public static <T> ClassValueCache<T> newClassKeySoftCache(int concurrencyLevel) {
        if (GraalvmSupport.IN_GRAALVM_NATIVE_IMAGE) {
            return new ClassValueCache<T>(CacheBuilder.newBuilder().concurrencyLevel(concurrencyLevel).build());
        }
        return new ClassValueCache<T>(CacheBuilder.newBuilder().weakKeys().softValues().concurrencyLevel(concurrencyLevel).build());
    }
}

