/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.meta;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.fory.Fory;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.meta.ClassDef;
import org.apache.fory.meta.ClassDefEncoder;
import org.apache.fory.meta.Encoders;
import org.apache.fory.meta.MetaString;
import org.apache.fory.reflect.ReflectionUtils;
import org.apache.fory.resolver.ClassInfo;
import org.apache.fory.resolver.TypeResolver;
import org.apache.fory.resolver.XtypeResolver;
import org.apache.fory.type.Descriptor;
import org.apache.fory.type.DescriptorGrouper;
import org.apache.fory.type.Types;
import org.apache.fory.util.Preconditions;

class TypeDefEncoder {
    static final int SMALL_NUM_FIELDS_THRESHOLD = 31;
    static final int REGISTER_BY_NAME_FLAG = 32;
    static final int FIELD_NAME_SIZE_THRESHOLD = 15;

    TypeDefEncoder() {
    }

    static ClassDef buildTypeDef(Fory fory, Class<?> type) {
        DescriptorGrouper descriptorGrouper = fory.getClassResolver().createDescriptorGrouper(fory.getClassResolver().getFieldDescriptors((Class)type, true), false, Function.identity());
        ClassInfo classInfo = fory._getTypeResolver().getClassInfo(type);
        int xtypeId = classInfo.getXtypeId();
        List<Object> fields = Types.isStructType(xtypeId & 0xFF) ? descriptorGrouper.getSortedDescriptors().stream().map(Descriptor::getField).collect(Collectors.toList()) : new ArrayList();
        return TypeDefEncoder.buildClassDefWithFieldInfos(fory.getXtypeResolver(), type, TypeDefEncoder.buildFieldsInfo(fory.getXtypeResolver(), type, fields));
    }

    static List<ClassDef.FieldInfo> buildFieldsInfo(TypeResolver resolver, Class<?> type, List<Field> fields) {
        return fields.stream().map(field -> new ClassDef.FieldInfo(type.getName(), field.getName(), ClassDef.buildFieldType(resolver, field))).collect(Collectors.toList());
    }

    static ClassDef buildClassDefWithFieldInfos(XtypeResolver resolver, Class<?> type, List<ClassDef.FieldInfo> fieldInfos) {
        fieldInfos = new ArrayList<ClassDef.FieldInfo>(TypeDefEncoder.getClassFields(type, fieldInfos).values());
        MemoryBuffer encodeClassDef = TypeDefEncoder.encodeClassDef(resolver, type, fieldInfos);
        byte[] classDefBytes = encodeClassDef.getBytes(0, encodeClassDef.writerIndex());
        return new ClassDef(Encoders.buildClassSpec(type), fieldInfos, true, encodeClassDef.getInt64(0), classDefBytes);
    }

    static MemoryBuffer encodeClassDef(XtypeResolver resolver, Class<?> type, List<ClassDef.FieldInfo> fields) {
        ClassInfo classInfo = resolver.getClassInfo(type);
        MemoryBuffer buffer = MemoryBuffer.newHeapBuffer(128);
        buffer.writeByte(-1);
        int currentClassHeader = fields.size();
        if (fields.size() >= 31) {
            currentClassHeader = 31;
            buffer.writeVarUint32(fields.size() - 31);
        }
        if (resolver.isRegisteredById(type)) {
            buffer.writeVarUint32(classInfo.getXtypeId());
        } else {
            Preconditions.checkArgument(resolver.isRegisteredByName(type));
            currentClassHeader |= 0x20;
            String ns = classInfo.decodeNamespace();
            String typename = classInfo.decodeTypeName();
            ClassDefEncoder.writePkgName(buffer, ns);
            ClassDefEncoder.writeTypeName(buffer, typename);
        }
        buffer.putByte(0, currentClassHeader);
        TypeDefEncoder.writeFieldsInfo(resolver, buffer, fields);
        byte[] compressed = resolver.getFory().getMetaCompressor().compress(buffer.getHeapMemory(), 0, buffer.writerIndex());
        boolean isCompressed = false;
        if (compressed.length < buffer.writerIndex()) {
            isCompressed = true;
            buffer = MemoryBuffer.fromByteArray(compressed);
            buffer.writerIndex(compressed.length);
        }
        return ClassDefEncoder.prependHeader(buffer, isCompressed, !fields.isEmpty());
    }

    static Map<String, ClassDef.FieldInfo> getClassFields(Class<?> type, List<ClassDef.FieldInfo> fieldsInfo) {
        LinkedHashMap<String, ClassDef.FieldInfo> sortedClassFields = new LinkedHashMap<String, ClassDef.FieldInfo>();
        Map<String, List<ClassDef.FieldInfo>> classFields = ClassDefEncoder.groupClassFields(fieldsInfo);
        for (Class<?> clz : ReflectionUtils.getAllClasses(type, true)) {
            List<ClassDef.FieldInfo> fieldInfos = classFields.get(clz.getName());
            if (fieldInfos == null) continue;
            for (ClassDef.FieldInfo fieldInfo : fieldInfos) {
                sortedClassFields.put(fieldInfo.getFieldName(), fieldInfo);
            }
        }
        return sortedClassFields;
    }

    static void writeFieldsInfo(XtypeResolver resolver, MemoryBuffer buffer, List<ClassDef.FieldInfo> fields) {
        for (ClassDef.FieldInfo fieldInfo : fields) {
            boolean bigSize;
            int encodingFlags;
            int size;
            ClassDef.FieldType fieldType = fieldInfo.getFieldType();
            int header = fieldType.trackingRef() ? 1 : 0;
            header |= fieldType.nullable() ? 2 : 0;
            byte[] encoded = null;
            if (fieldInfo.hasTag()) {
                size = fieldInfo.getTag();
                encodingFlags = 3;
            } else {
                MetaString metaString = Encoders.encodeFieldName(fieldInfo.getFieldName());
                encodingFlags = Encoders.fieldNameEncodingsList.indexOf((Object)metaString.getEncoding());
                encoded = metaString.getBytes();
                size = encoded.length - 1;
            }
            header |= (byte)(encodingFlags << 6);
            boolean bl = bigSize = size >= 15;
            if (bigSize) {
                buffer.writeByte(header |= 0x3C);
                buffer.writeVarUint32Small7(size - 15);
            } else {
                buffer.writeByte(header |= size << 2);
            }
            fieldType.xwrite(buffer, false);
            if (fieldInfo.hasTag()) continue;
            buffer.writeBytes(encoded);
        }
    }
}

