/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.resolver;

import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.fory.Fory;
import org.apache.fory.ForyCopyable;
import org.apache.fory.annotation.Internal;
import org.apache.fory.builder.JITContext;
import org.apache.fory.codegen.CodeGenerator;
import org.apache.fory.codegen.Expression;
import org.apache.fory.collection.IdentityObjectIntMap;
import org.apache.fory.collection.ObjectMap;
import org.apache.fory.collection.Tuple2;
import org.apache.fory.config.Language;
import org.apache.fory.exception.InsecureException;
import org.apache.fory.logging.Logger;
import org.apache.fory.logging.LoggerFactory;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.memory.Platform;
import org.apache.fory.meta.ClassDef;
import org.apache.fory.meta.ClassSpec;
import org.apache.fory.meta.Encoders;
import org.apache.fory.meta.MetaString;
import org.apache.fory.reflect.ObjectCreators;
import org.apache.fory.reflect.ReflectionUtils;
import org.apache.fory.reflect.TypeRef;
import org.apache.fory.resolver.ClassChecker;
import org.apache.fory.resolver.ClassInfo;
import org.apache.fory.resolver.ClassInfoHolder;
import org.apache.fory.resolver.DisallowedList;
import org.apache.fory.resolver.FieldResolver;
import org.apache.fory.resolver.MetaContext;
import org.apache.fory.resolver.MetaStringBytes;
import org.apache.fory.resolver.TypeNameBytes;
import org.apache.fory.resolver.TypeResolver;
import org.apache.fory.resolver.XtypeResolver;
import org.apache.fory.serializer.ArraySerializers;
import org.apache.fory.serializer.BufferSerializers;
import org.apache.fory.serializer.CodegenSerializer;
import org.apache.fory.serializer.CompatibleSerializer;
import org.apache.fory.serializer.EnumSerializer;
import org.apache.fory.serializer.ExternalizableSerializer;
import org.apache.fory.serializer.ForyCopyableSerializer;
import org.apache.fory.serializer.JavaSerializer;
import org.apache.fory.serializer.JdkProxySerializer;
import org.apache.fory.serializer.LambdaSerializer;
import org.apache.fory.serializer.LocaleSerializer;
import org.apache.fory.serializer.NoneSerializer;
import org.apache.fory.serializer.NonexistentClass;
import org.apache.fory.serializer.NonexistentClassSerializers;
import org.apache.fory.serializer.ObjectSerializer;
import org.apache.fory.serializer.OptionalSerializers;
import org.apache.fory.serializer.PrimitiveSerializers;
import org.apache.fory.serializer.ReplaceResolveSerializer;
import org.apache.fory.serializer.SerializationUtils;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.serializer.SerializerFactory;
import org.apache.fory.serializer.Serializers;
import org.apache.fory.serializer.StringSerializer;
import org.apache.fory.serializer.TimeSerializers;
import org.apache.fory.serializer.collection.ChildContainerSerializers;
import org.apache.fory.serializer.collection.CollectionSerializer;
import org.apache.fory.serializer.collection.CollectionSerializers;
import org.apache.fory.serializer.collection.GuavaCollectionSerializers;
import org.apache.fory.serializer.collection.ImmutableCollectionSerializers;
import org.apache.fory.serializer.collection.MapSerializer;
import org.apache.fory.serializer.collection.MapSerializers;
import org.apache.fory.serializer.collection.SubListSerializers;
import org.apache.fory.serializer.collection.SynchronizedSerializers;
import org.apache.fory.serializer.collection.UnmodifiableSerializers;
import org.apache.fory.serializer.scala.SingletonCollectionSerializer;
import org.apache.fory.serializer.scala.SingletonMapSerializer;
import org.apache.fory.serializer.scala.SingletonObjectSerializer;
import org.apache.fory.serializer.shim.ProtobufDispatcher;
import org.apache.fory.serializer.shim.ShimDispatcher;
import org.apache.fory.type.Descriptor;
import org.apache.fory.type.DescriptorGrouper;
import org.apache.fory.type.GenericType;
import org.apache.fory.type.TypeUtils;
import org.apache.fory.util.GraalvmSupport;
import org.apache.fory.util.Preconditions;
import org.apache.fory.util.StringUtils;
import org.apache.fory.util.function.Functions;
import org.apache.fory.util.record.RecordUtils;

public class ClassResolver
extends TypeResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ClassResolver.class);
    public static final short NO_CLASS_ID = 0;
    public static final short LAMBDA_STUB_ID = 1;
    public static final short JDK_PROXY_STUB_ID = 2;
    public static final short REPLACE_STUB_ID = 3;
    public static final short PRIMITIVE_VOID_CLASS_ID = 4;
    public static final short PRIMITIVE_BOOLEAN_CLASS_ID = 5;
    public static final short PRIMITIVE_BYTE_CLASS_ID = 6;
    public static final short PRIMITIVE_CHAR_CLASS_ID = 7;
    public static final short PRIMITIVE_SHORT_CLASS_ID = 8;
    public static final short PRIMITIVE_INT_CLASS_ID = 9;
    public static final short PRIMITIVE_FLOAT_CLASS_ID = 10;
    public static final short PRIMITIVE_LONG_CLASS_ID = 11;
    public static final short PRIMITIVE_DOUBLE_CLASS_ID = 12;
    public static final short VOID_CLASS_ID = 13;
    public static final short BOOLEAN_CLASS_ID = 14;
    public static final short BYTE_CLASS_ID = 15;
    public static final short CHAR_CLASS_ID = 16;
    public static final short SHORT_CLASS_ID = 17;
    public static final short INTEGER_CLASS_ID = 18;
    public static final short FLOAT_CLASS_ID = 19;
    public static final short LONG_CLASS_ID = 20;
    public static final short DOUBLE_CLASS_ID = 21;
    public static final short STRING_CLASS_ID = 22;
    public static final short PRIMITIVE_BOOLEAN_ARRAY_CLASS_ID = 23;
    public static final short PRIMITIVE_BYTE_ARRAY_CLASS_ID = 24;
    public static final short PRIMITIVE_CHAR_ARRAY_CLASS_ID = 25;
    public static final short PRIMITIVE_SHORT_ARRAY_CLASS_ID = 26;
    public static final short PRIMITIVE_INT_ARRAY_CLASS_ID = 27;
    public static final short PRIMITIVE_FLOAT_ARRAY_CLASS_ID = 28;
    public static final short PRIMITIVE_LONG_ARRAY_CLASS_ID = 29;
    public static final short PRIMITIVE_DOUBLE_ARRAY_CLASS_ID = 30;
    public static final short STRING_ARRAY_CLASS_ID = 31;
    public static final short OBJECT_ARRAY_CLASS_ID = 32;
    public static final short ARRAYLIST_CLASS_ID = 33;
    public static final short HASHMAP_CLASS_ID = 34;
    public static final short HASHSET_CLASS_ID = 35;
    public static final short CLASS_CLASS_ID = 36;
    public static final short EMPTY_OBJECT_ID = 37;
    private final Fory fory;
    XtypeResolver xtypeResolver;
    private ClassInfo[] registeredId2ClassInfo = new ClassInfo[0];
    private ClassInfo classInfoCache;
    private final ObjectMap<TypeNameBytes, ClassInfo> compositeNameBytes2ClassInfo = new ObjectMap(16, 0.25f);
    private final Map<Class<?>, ClassDef> classDefMap = new HashMap();
    private Class<?> currentReadClass;
    private short innerEndClassId;
    private final ShimDispatcher shimDispatcher;
    private static final GenericType OBJECT_GENERIC_TYPE = GenericType.build(Object.class);

    public ClassResolver(Fory fory) {
        super(fory);
        this.fory = fory;
        this.classInfoCache = NIL_CLASS_INFO;
        this.shimDispatcher = new ShimDispatcher(fory);
        ClassResolver._addGraalvmClassRegistry(fory.getConfig().getConfigHash(), this);
    }

    @Override
    public void initialize() {
        this.extRegistry.objectGenericType = this.buildGenericType(TypeUtils.OBJECT_TYPE);
        this.register(LambdaSerializer.ReplaceStub.class, 1);
        this.register(JdkProxySerializer.ReplaceStub.class, 2);
        this.register(ReplaceResolveSerializer.ReplaceStub.class, 3);
        this.register(Void.TYPE, 4);
        this.register(Boolean.TYPE, 5);
        this.register(Byte.TYPE, 6);
        this.register(Character.TYPE, 7);
        this.register(Short.TYPE, 8);
        this.register(Integer.TYPE, 9);
        this.register(Float.TYPE, 10);
        this.register(Long.TYPE, 11);
        this.register(Double.TYPE, 12);
        this.register(Void.class, 13);
        this.register(Boolean.class, 14);
        this.register(Byte.class, 15);
        this.register(Character.class, 16);
        this.register(Short.class, 17);
        this.register(Integer.class, 18);
        this.register(Float.class, 19);
        this.register(Long.class, 20);
        this.register(Double.class, 21);
        this.register(String.class, 22);
        this.register(boolean[].class, 23);
        this.register(byte[].class, 24);
        this.register(char[].class, 25);
        this.register(short[].class, 26);
        this.register(int[].class, 27);
        this.register(float[].class, 28);
        this.register(long[].class, 29);
        this.register(double[].class, 30);
        this.register(String[].class, 31);
        this.register(Object[].class, 32);
        this.register(ArrayList.class, 33);
        this.register(HashMap.class, 34);
        this.register(HashSet.class, 35);
        this.register(Class.class, 36);
        this.register(Object.class, 37);
        this.registerCommonUsedClasses();
        this.registerDefaultClasses();
        this.addDefaultSerializers();
        this.shimDispatcher.initialize();
        this.innerEndClassId = this.extRegistry.classIdGenerator;
        if (GraalvmSupport.isGraalBuildtime()) {
            this.classInfoMap.forEach((cls, classInfo) -> {
                if (classInfo.serializer != null) {
                    this.extRegistry.registeredClassInfos.add((ClassInfo)classInfo);
                }
            });
        }
    }

    private void addDefaultSerializers() {
        this.addDefaultSerializer(Void.TYPE, NoneSerializer.class);
        this.addDefaultSerializer(String.class, new StringSerializer(this.fory));
        PrimitiveSerializers.registerDefaultSerializers(this.fory);
        Serializers.registerDefaultSerializers(this.fory);
        ArraySerializers.registerDefaultSerializers(this.fory);
        TimeSerializers.registerDefaultSerializers(this.fory);
        OptionalSerializers.registerDefaultSerializers(this.fory);
        CollectionSerializers.registerDefaultSerializers(this.fory);
        MapSerializers.registerDefaultSerializers(this.fory);
        this.addDefaultSerializer(Locale.class, new LocaleSerializer(this.fory));
        this.addDefaultSerializer(LambdaSerializer.ReplaceStub.class, new LambdaSerializer(this.fory, LambdaSerializer.ReplaceStub.class));
        this.addDefaultSerializer(JdkProxySerializer.ReplaceStub.class, new JdkProxySerializer(this.fory, JdkProxySerializer.ReplaceStub.class));
        this.addDefaultSerializer(ReplaceResolveSerializer.ReplaceStub.class, new ReplaceResolveSerializer(this.fory, ReplaceResolveSerializer.ReplaceStub.class));
        SynchronizedSerializers.registerSerializers(this.fory);
        UnmodifiableSerializers.registerSerializers(this.fory);
        ImmutableCollectionSerializers.registerSerializers(this.fory);
        SubListSerializers.registerSerializers(this.fory, true);
        if (this.fory.getConfig().registerGuavaTypes()) {
            GuavaCollectionSerializers.registerDefaultSerializers(this.fory);
        }
        if (this.fory.getConfig().deserializeNonexistentClass()) {
            if (this.metaContextShareEnabled) {
                this.addDefaultSerializer(NonexistentClass.NonexistentMetaShared.class, new NonexistentClassSerializers.NonexistentClassSerializer(this.fory, null));
                short classId = Objects.requireNonNull((ClassInfo)this.classInfoMap.get(NonexistentClass.NonexistentMetaShared.class)).classId;
                Preconditions.checkArgument(classId > 63 && classId < 8192, classId);
            } else {
                this.register((Class<?>)NonexistentClass.NonexistentSkip.class);
            }
        }
    }

    private void addDefaultSerializer(Class<?> type, Class<? extends Serializer> serializerClass) {
        this.addDefaultSerializer(type, Serializers.newSerializer(this.fory, type, serializerClass));
    }

    private void addDefaultSerializer(Class type, Serializer serializer) {
        this.registerSerializer(type, serializer);
        this.register((Class<?>)type);
    }

    private void registerCommonUsedClasses() {
        this.register(LinkedList.class, TreeSet.class);
        this.register(LinkedHashMap.class, TreeMap.class);
        this.register(Date.class, Timestamp.class, LocalDateTime.class, Instant.class);
        this.register(BigInteger.class, BigDecimal.class);
        this.register(Optional.class, OptionalInt.class);
        this.register(Boolean[].class, Byte[].class, Short[].class, Character[].class);
        this.register(Integer[].class, Float[].class, Long[].class, Double[].class);
    }

    private void registerDefaultClasses() {
        this.register(Platform.HEAP_BYTE_BUFFER_CLASS);
        this.register(Platform.DIRECT_BYTE_BUFFER_CLASS);
        this.register(Comparator.naturalOrder().getClass());
        this.register(Comparator.reverseOrder().getClass());
        this.register((Class<?>)ConcurrentHashMap.class);
        this.register((Class<?>)ArrayBlockingQueue.class);
        this.register((Class<?>)LinkedBlockingQueue.class);
        this.register((Class<?>)AtomicBoolean.class);
        this.register((Class<?>)AtomicInteger.class);
        this.register((Class<?>)AtomicLong.class);
        this.register((Class<?>)AtomicReference.class);
        this.register(EnumSet.allOf(Language.class).getClass());
        this.register(EnumSet.of(Language.JAVA).getClass());
        this.register((Class<?>)SerializedLambda.class);
        this.register(Throwable.class, StackTraceElement.class, StackTraceElement[].class, Exception.class, RuntimeException.class);
        this.register((Class<?>)NullPointerException.class);
        this.register((Class<?>)IOException.class);
        this.register((Class<?>)IllegalArgumentException.class);
        this.register((Class<?>)IllegalStateException.class);
        this.register(IndexOutOfBoundsException.class, ArrayIndexOutOfBoundsException.class);
    }

    @Override
    public void register(Class<?> cls) {
        if (!this.extRegistry.registeredClassIdMap.containsKey(cls)) {
            while (this.extRegistry.classIdGenerator < this.registeredId2ClassInfo.length && this.registeredId2ClassInfo[this.extRegistry.classIdGenerator] != null) {
                this.extRegistry.classIdGenerator = (short)(this.extRegistry.classIdGenerator + 1);
            }
            this.register(cls, (int)this.extRegistry.classIdGenerator);
        }
    }

    @Override
    public void register(String className) {
        this.register(this.loadClass(className, false, 0, false));
    }

    public void register(Class<?> ... classes) {
        for (Class<?> cls : classes) {
            this.register(cls);
        }
    }

    @Deprecated
    public void register(Class<?> cls, boolean createSerializer) {
        this.register(cls);
    }

    @Override
    public void register(Class<?> cls, int classId) {
        ClassInfo classInfo;
        this.checkRegisterAllowed();
        Preconditions.checkArgument(classId >= 0 && classId < Short.MAX_VALUE);
        short id = (short)classId;
        this.checkRegistration(cls, id, cls.getName());
        this.extRegistry.registeredClassIdMap.put(cls, id);
        if (this.registeredId2ClassInfo.length <= id) {
            ClassInfo[] tmp = new ClassInfo[(id + 1) * 2];
            System.arraycopy(this.registeredId2ClassInfo, 0, tmp, 0, this.registeredId2ClassInfo.length);
            this.registeredId2ClassInfo = tmp;
        }
        if ((classInfo = (ClassInfo)this.classInfoMap.get(cls)) != null) {
            classInfo.classId = id;
        } else {
            classInfo = new ClassInfo(this, cls, null, id, 0);
            this.classInfoMap.put(cls, classInfo);
        }
        this.registeredId2ClassInfo[id] = classInfo;
        this.extRegistry.registeredClasses.put((Object)cls.getName(), cls);
        this.extRegistry.classIdGenerator = (short)(this.extRegistry.classIdGenerator + 1);
    }

    @Override
    public void register(String className, int classId) {
        this.register(this.loadClass(className, false, 0, false), classId);
    }

    @Deprecated
    public void register(Class<?> cls, int id, boolean createSerializer) {
        this.register(cls, id);
    }

    @Override
    public void register(Class<?> cls, String namespace, String name) {
        this.checkRegisterAllowed();
        Preconditions.checkArgument(!Functions.isLambda(cls));
        Preconditions.checkArgument(!ReflectionUtils.isJdkProxy(cls));
        Preconditions.checkArgument(!cls.isArray());
        String fullname = name;
        if (namespace == null) {
            namespace = "";
        }
        if (!StringUtils.isBlank(namespace)) {
            fullname = namespace + "." + name;
        }
        this.checkRegistration(cls, (short)-1, fullname);
        MetaStringBytes fullNameBytes = this.metaStringResolver.getOrCreateMetaStringBytes(Encoders.GENERIC_ENCODER.encode(fullname, MetaString.Encoding.UTF_8));
        MetaStringBytes nsBytes = this.metaStringResolver.getOrCreateMetaStringBytes(Encoders.encodePackage(namespace));
        MetaStringBytes nameBytes = this.metaStringResolver.getOrCreateMetaStringBytes(Encoders.encodeTypeName(name));
        ClassInfo classInfo = new ClassInfo(cls, fullNameBytes, nsBytes, nameBytes, false, null, 0, -1);
        this.classInfoMap.put(cls, classInfo);
        this.compositeNameBytes2ClassInfo.put(new TypeNameBytes(nsBytes.hashCode, nameBytes.hashCode), classInfo);
        this.extRegistry.registeredClasses.put((Object)fullname, cls);
    }

    private void checkRegistration(Class<?> cls, short classId, String name) {
        if (this.extRegistry.registeredClassIdMap.containsKey(cls)) {
            throw new IllegalArgumentException(String.format("Class %s already registered with id %s.", cls, this.extRegistry.registeredClassIdMap.get(cls)));
        }
        if (classId > 0 && classId < this.registeredId2ClassInfo.length && this.registeredId2ClassInfo[classId] != null) {
            throw new IllegalArgumentException(String.format("Class %s with id %s has been registered, registering class %s with same id are not allowed.", this.registeredId2ClassInfo[classId].getCls(), classId, cls.getName()));
        }
        if (this.extRegistry.registeredClasses.containsKey((Object)name) || this.extRegistry.registeredClasses.inverse().containsKey(cls)) {
            throw new IllegalArgumentException(String.format("Class %s with name %s has been registered, registering class %s with same name are not allowed.", this.extRegistry.registeredClasses.get((Object)name), name, cls));
        }
    }

    @Override
    public boolean isRegistered(Class<?> cls) {
        return this.extRegistry.registeredClassIdMap.containsKey(cls) || this.extRegistry.registeredClasses.inverse().containsKey(cls);
    }

    public boolean isRegisteredByName(String name) {
        return this.extRegistry.registeredClasses.containsKey((Object)name);
    }

    @Override
    public boolean isRegisteredByName(Class<?> cls) {
        return this.extRegistry.registeredClasses.inverse().containsKey(cls);
    }

    public String getRegisteredName(Class<?> cls) {
        return (String)this.extRegistry.registeredClasses.inverse().get(cls);
    }

    public Tuple2<String, String> getRegisteredNameTuple(Class<?> cls) {
        String name = (String)this.extRegistry.registeredClasses.inverse().get(cls);
        int index = name.lastIndexOf(".");
        if (index != -1) {
            return Tuple2.of(name.substring(0, index), name.substring(index + 1));
        }
        return Tuple2.of("", name);
    }

    @Override
    public boolean isRegisteredById(Class<?> cls) {
        return this.extRegistry.registeredClassIdMap.get(cls) != null;
    }

    public Short getRegisteredClassId(Class<?> cls) {
        return this.extRegistry.registeredClassIdMap.get(cls);
    }

    public Class<?> getRegisteredClass(short id) {
        ClassInfo classInfo;
        if (id < this.registeredId2ClassInfo.length && (classInfo = this.registeredId2ClassInfo[id]) != null) {
            return classInfo.cls;
        }
        return null;
    }

    public Class<?> getRegisteredClass(String className) {
        return (Class)this.extRegistry.registeredClasses.get((Object)className);
    }

    public List<Class<?>> getRegisteredClasses() {
        return Arrays.stream(this.registeredId2ClassInfo).filter(Objects::nonNull).map(info -> info.cls).collect(Collectors.toList());
    }

    public String getTypeAlias(Class<?> cls) {
        Short id = this.extRegistry.registeredClassIdMap.get(cls);
        if (id != null) {
            return String.valueOf(id);
        }
        String name = (String)this.extRegistry.registeredClasses.inverse().get(cls);
        if (name != null) {
            return name;
        }
        return cls.getName();
    }

    @Override
    public boolean isMonomorphic(Class<?> clz) {
        if (this.fory.getConfig().isMetaShareEnabled()) {
            if (!ReflectionUtils.isMonomorphic(clz)) {
                return false;
            }
            if (Map.class.isAssignableFrom(clz) || Collection.class.isAssignableFrom(clz)) {
                return true;
            }
            if (clz.isArray()) {
                Class<?> component = TypeUtils.getArrayComponent(clz);
                return this.isMonomorphic(component);
            }
            return this.isInnerClass(clz) || clz.isEnum();
        }
        return ReflectionUtils.isMonomorphic(clz);
    }

    boolean isInnerClass(Class<?> cls) {
        ClassInfo classInfo;
        Short classId = this.extRegistry.registeredClassIdMap.get(cls);
        if (classId == null && (classInfo = this.getClassInfo(cls, false)) != null) {
            classId = classInfo.getClassId();
        }
        return classId != null && classId != 0 && classId < this.innerEndClassId;
    }

    public static boolean useReplaceResolveSerializer(Class<?> clz) {
        return JavaSerializer.getWriteReplaceMethod(clz) != null || JavaSerializer.getReadResolveMethod(clz) != null;
    }

    public static boolean requireJavaSerialization(Class<?> clz) {
        if (clz.isEnum() || clz.isArray()) {
            return false;
        }
        if (ReflectionUtils.isDynamicGeneratedCLass(clz)) {
            return false;
        }
        if (!Serializable.class.isAssignableFrom(clz)) {
            return false;
        }
        if (ClassResolver.useReplaceResolveSerializer(clz)) {
            return false;
        }
        if (Externalizable.class.isAssignableFrom(clz)) {
            return false;
        }
        if ("sun.reflect.annotation.AnnotationInvocationHandler".equals(clz.getName())) {
            return false;
        }
        return JavaSerializer.getReadObjectMethod(clz) != null || JavaSerializer.getWriteObjectMethod(clz) != null;
    }

    @Override
    public <T> void registerSerializer(Class<T> type, Class<? extends Serializer> serializerClass) {
        this.checkRegisterAllowed();
        this.registerSerializer(type, Serializers.newSerializer(this.fory, type, serializerClass));
    }

    @Override
    public void registerSerializer(Class<?> type, Serializer<?> serializer) {
        this.checkRegisterAllowed();
        if (!serializer.getClass().getPackage().getName().startsWith("org.apache.fory")) {
            SerializationUtils.validate(type, serializer.getClass());
        }
        if (!this.extRegistry.registeredClassIdMap.containsKey(type) && !this.fory.isCrossLanguage()) {
            this.register(type);
        }
        this.addSerializer(type, serializer);
        ClassInfo classInfo = (ClassInfo)this.classInfoMap.get(type);
        this.classInfoMap.put(type, classInfo);
        this.extRegistry.registeredClassInfos.add(classInfo);
        if (!type.isPrimitive() && (ReflectionUtils.isAbstract(type) || type.isInterface())) {
            this.extRegistry.absClassInfo.put(type, classInfo);
            this.extRegistry.registeredClassInfos.add(classInfo);
        }
    }

    public void setSerializerFactory(SerializerFactory serializerFactory) {
        this.extRegistry.serializerFactory = serializerFactory;
    }

    public SerializerFactory getSerializerFactory() {
        return this.extRegistry.serializerFactory;
    }

    @Override
    public <T> void setSerializer(Class<T> cls, Serializer<T> serializer) {
        this.addSerializer(cls, serializer);
    }

    public void setSerializer(String className, Class<? extends Serializer> serializer) {
        for (Map.Entry entry : this.classInfoMap.iterable()) {
            if (this.extRegistry.registeredClasses.containsKey((Object)className)) {
                LOG.warn("Skip clear serializer for registered class {}", (Object)className);
                return;
            }
            Class cls = (Class)entry.getKey();
            if (!cls.getName().equals(className)) continue;
            LOG.info("Clear serializer for class {}.", (Object)className);
            ((ClassInfo)entry.getValue()).setSerializer(this, Serializers.newSerializer(this.fory, cls, serializer));
            this.classInfoCache = NIL_CLASS_INFO;
            return;
        }
    }

    public void setSerializers(String classNamePrefix, Class<? extends Serializer> serializer) {
        for (Map.Entry entry : this.classInfoMap.iterable()) {
            Class cls = (Class)entry.getKey();
            String className = cls.getName();
            if (this.extRegistry.registeredClasses.containsKey((Object)className) || !className.startsWith(classNamePrefix)) continue;
            LOG.info("Clear serializer for class {}.", (Object)className);
            ((ClassInfo)entry.getValue()).setSerializer(this, Serializers.newSerializer(this.fory, cls, serializer));
            this.classInfoCache = NIL_CLASS_INFO;
        }
    }

    public <T> void resetSerializer(Class<T> cls, Serializer<T> serializer) {
        if (serializer == null) {
            this.clearSerializer(cls);
        } else {
            this.setSerializer(cls, serializer);
        }
    }

    @Override
    public <T> void setSerializerIfAbsent(Class<T> cls, Serializer<T> serializer) {
        Serializer<T> s = this.getSerializer(cls, false);
        if (s == null) {
            this.setSerializer(cls, serializer);
        }
    }

    public void clearSerializer(Class<?> cls) {
        ClassInfo classInfo = (ClassInfo)this.classInfoMap.get(cls);
        if (classInfo != null) {
            classInfo.setSerializer(this, null);
        }
    }

    private void addSerializer(Class<?> type, Serializer<?> serializer) {
        ClassInfo classInfo;
        boolean registered;
        Preconditions.checkNotNull(serializer);
        Short classId = this.extRegistry.registeredClassIdMap.get(type);
        boolean bl = registered = classId != null;
        if (registered) {
            classInfo = this.registeredId2ClassInfo[classId];
        } else {
            classId = serializer instanceof ReplaceResolveSerializer ? Short.valueOf((short)3) : Short.valueOf((short)0);
            classInfo = (ClassInfo)this.classInfoMap.get(type);
        }
        if (classInfo == null || classId != classInfo.classId) {
            classInfo = new ClassInfo(this, type, null, classId, 0);
            this.classInfoMap.put(type, classInfo);
            if (registered) {
                this.registeredId2ClassInfo[classId.shortValue()] = classInfo;
            }
        }
        classInfo.setSerializer(this, serializer);
    }

    public <T> Serializer<T> getSerializer(Class<T> cls, boolean createIfNotExist) {
        Preconditions.checkNotNull(cls);
        if (createIfNotExist) {
            return this.getSerializer(cls);
        }
        ClassInfo classInfo = (ClassInfo)this.classInfoMap.get(cls);
        return classInfo == null ? null : classInfo.serializer;
    }

    @Override
    public <T> Serializer<T> getSerializer(Class<T> cls) {
        Preconditions.checkNotNull(cls);
        return this.getOrUpdateClassInfo(cls).serializer;
    }

    @Override
    @Internal
    public Serializer<?> getRawSerializer(Class<?> cls) {
        Preconditions.checkNotNull(cls);
        return this.getOrUpdateClassInfo(cls).serializer;
    }

    @Override
    public Class<? extends Serializer> getSerializerClass(Class<?> cls) {
        boolean codegen = CodegenSerializer.supportCodegenForJavaSerialization(cls) && this.fory.getConfig().isCodeGenEnabled();
        return this.getSerializerClass(cls, codegen);
    }

    @Override
    public Class<? extends Serializer> getSerializerClass(Class<?> cls, boolean codegen) {
        Serializer serializer;
        if (!cls.isEnum() && (ReflectionUtils.isAbstract(cls) || cls.isInterface())) {
            throw new UnsupportedOperationException(String.format("Class %s doesn't support serialization.", cls));
        }
        Class<? extends Serializer> serializerClass = this.getSerializerClassFromGraalvmRegistry(cls);
        if (serializerClass != null) {
            return serializerClass;
        }
        ClassInfo classInfo = (ClassInfo)this.classInfoMap.get(cls = TypeUtils.boxedType(cls));
        if (classInfo != null && classInfo.serializer != null) {
            return classInfo.serializer.getClass();
        }
        if (this.getSerializerFactory() != null && (serializer = this.getSerializerFactory().createSerializer(this.fory, cls)) != null) {
            return serializer.getClass();
        }
        if (NonexistentClass.isNonexistent(cls)) {
            return NonexistentClassSerializers.getSerializer(this.fory, "Unknown", cls).getClass();
        }
        if (cls.isArray()) {
            return ArraySerializers.ObjectArraySerializer.class;
        }
        if (cls.isEnum()) {
            return EnumSerializer.class;
        }
        if (Enum.class.isAssignableFrom(cls) && cls != Enum.class) {
            return EnumSerializer.class;
        }
        if (EnumSet.class.isAssignableFrom(cls)) {
            return CollectionSerializers.EnumSetSerializer.class;
        }
        if (Charset.class.isAssignableFrom(cls)) {
            return Serializers.CharsetSerializer.class;
        }
        if (ReflectionUtils.isJdkProxy(cls)) {
            if (JavaSerializer.getWriteReplaceMethod(cls) != null) {
                return ReplaceResolveSerializer.class;
            }
            return JdkProxySerializer.class;
        }
        if (Functions.isLambda(cls)) {
            return LambdaSerializer.class;
        }
        if (Calendar.class.isAssignableFrom(cls)) {
            return TimeSerializers.CalendarSerializer.class;
        }
        if (ZoneId.class.isAssignableFrom(cls)) {
            return TimeSerializers.ZoneIdSerializer.class;
        }
        if (TimeZone.class.isAssignableFrom(cls)) {
            return TimeSerializers.TimeZoneSerializer.class;
        }
        if (ByteBuffer.class.isAssignableFrom(cls)) {
            return BufferSerializers.ByteBufferSerializer.class;
        }
        if (this.shimDispatcher.contains(cls)) {
            return this.shimDispatcher.getSerializer(cls).getClass();
        }
        serializerClass = ProtobufDispatcher.getSerializerClass(cls);
        if (serializerClass != null) {
            return serializerClass;
        }
        if (this.fory.getConfig().checkJdkClassSerializable() && cls.getName().startsWith("java") && !Serializable.class.isAssignableFrom(cls)) {
            throw new UnsupportedOperationException(String.format("Class %s doesn't support serialization.", cls));
        }
        if (this.fory.getConfig().isScalaOptimizationEnabled() && ReflectionUtils.isScalaSingletonObject(cls)) {
            if (this.isCollection(cls)) {
                return SingletonCollectionSerializer.class;
            }
            if (this.isMap(cls)) {
                return SingletonMapSerializer.class;
            }
            return SingletonObjectSerializer.class;
        }
        if (this.isCollection(cls)) {
            serializerClass = ChildContainerSerializers.getCollectionSerializerClass(cls);
            if (serializerClass != null) {
                return serializerClass;
            }
            if (ClassResolver.requireJavaSerialization(cls) || ClassResolver.useReplaceResolveSerializer(cls)) {
                return CollectionSerializers.JDKCompatibleCollectionSerializer.class;
            }
            if (!this.fory.isCrossLanguage()) {
                return CollectionSerializers.DefaultJavaCollectionSerializer.class;
            }
            return CollectionSerializer.class;
        }
        if (this.isMap(cls)) {
            serializerClass = ChildContainerSerializers.getMapSerializerClass(cls);
            if (serializerClass != null) {
                return serializerClass;
            }
            if (ClassResolver.requireJavaSerialization(cls) || ClassResolver.useReplaceResolveSerializer(cls)) {
                return MapSerializers.JDKCompatibleMapSerializer.class;
            }
            if (!this.fory.isCrossLanguage()) {
                return MapSerializers.DefaultJavaMapSerializer.class;
            }
            return MapSerializer.class;
        }
        if (this.fory.isCrossLanguage()) {
            LOG.warn("Class {} isn't supported for cross-language serialization.", (Object)cls);
        }
        if (ClassResolver.useReplaceResolveSerializer(cls)) {
            return ReplaceResolveSerializer.class;
        }
        if (Externalizable.class.isAssignableFrom(cls)) {
            return ExternalizableSerializer.class;
        }
        if (ClassResolver.requireJavaSerialization(cls)) {
            return this.getJavaSerializer(cls);
        }
        final Class<?> clz = cls;
        return this.getObjectSerializerClass(cls, this.metaContextShareEnabled, codegen, new JITContext.SerializerJITCallback<Class<? extends Serializer>>(){

            @Override
            public void onSuccess(Class<? extends Serializer> result) {
                ClassResolver.this.setSerializer(clz, Serializers.newSerializer(ClassResolver.this.fory, clz, result));
                if (((ClassResolver)ClassResolver.this).classInfoCache.cls == clz) {
                    ClassResolver.this.classInfoCache = TypeResolver.NIL_CLASS_INFO;
                }
                Preconditions.checkState(ClassResolver.this.getSerializer(clz).getClass() == result);
            }

            @Override
            public Object id() {
                return clz;
            }
        });
    }

    public Class<? extends Serializer> getObjectSerializerClass(Class<?> cls, JITContext.SerializerJITCallback<Class<? extends Serializer>> callback) {
        boolean codegen = CodegenSerializer.supportCodegenForJavaSerialization(cls) && this.fory.getConfig().isCodeGenEnabled();
        return this.getObjectSerializerClass(cls, false, codegen, callback);
    }

    public Class<? extends Serializer> getObjectSerializerClass(Class<?> cls, boolean shareMeta, boolean codegen, JITContext.SerializerJITCallback<Class<? extends Serializer>> callback) {
        if (codegen) {
            if (this.extRegistry.getClassCtx.contains(cls)) {
                return CodegenSerializer.LazyInitBeanSerializer.class;
            }
            try {
                this.extRegistry.getClassCtx.add(cls);
                switch (this.fory.getCompatibleMode()) {
                    case SCHEMA_CONSISTENT: {
                        Class<? extends Serializer> sc;
                        Class<? extends Serializer> clazz = sc = this.fory.getJITContext().registerSerializerJITCallback(() -> ObjectSerializer.class, () -> CodegenSerializer.loadCodegenSerializer(this.fory, cls), callback);
                        return clazz;
                    }
                    case COMPATIBLE: {
                        Class<? extends Serializer> sc;
                        Class<? extends Serializer> clazz = sc = this.fory.getJITContext().registerSerializerJITCallback(() -> shareMeta ? ObjectSerializer.class : CompatibleSerializer.class, () -> shareMeta ? CodegenSerializer.loadCodegenSerializer(this.fory, cls) : CodegenSerializer.loadCompatibleCodegenSerializer(this.fory, cls), callback);
                        return clazz;
                    }
                }
                throw new UnsupportedOperationException(String.format("Unsupported mode %s", new Object[]{this.fory.getCompatibleMode()}));
            }
            finally {
                this.extRegistry.getClassCtx.remove(cls);
            }
        }
        if (codegen) {
            LOG.info("Object of type {} can't be serialized by jit", (Object)cls);
        }
        switch (this.fory.getCompatibleMode()) {
            case SCHEMA_CONSISTENT: {
                return ObjectSerializer.class;
            }
            case COMPATIBLE: {
                return shareMeta ? ObjectSerializer.class : CompatibleSerializer.class;
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported mode %s", new Object[]{this.fory.getCompatibleMode()}));
    }

    public Class<? extends Serializer> getJavaSerializer(Class<?> clz) {
        if (Collection.class.isAssignableFrom(clz)) {
            return CollectionSerializers.JDKCompatibleCollectionSerializer.class;
        }
        if (Map.class.isAssignableFrom(clz)) {
            return MapSerializers.JDKCompatibleMapSerializer.class;
        }
        if (ClassResolver.useReplaceResolveSerializer(clz)) {
            return ReplaceResolveSerializer.class;
        }
        return this.fory.getDefaultJDKStreamSerializerType();
    }

    @Deprecated
    public void setClassChecker(ClassChecker classChecker) {
        this.extRegistry.typeChecker = (resolver, className) -> {
            if (resolver instanceof ClassResolver) {
                return classChecker.checkClass((ClassResolver)resolver, className);
            }
            return false;
        };
    }

    public FieldResolver getFieldResolver(Class<?> cls) {
        FieldResolver fieldResolver = this.extRegistry.fieldResolverMap.get(cls);
        if (fieldResolver == null) {
            fieldResolver = FieldResolver.of(this.fory, cls);
            this.extRegistry.fieldResolverMap.put(cls, fieldResolver);
        }
        return fieldResolver;
    }

    public List<Descriptor> getFieldDescriptors(Class<?> clz, boolean searchParent) {
        SortedMap<Member, Descriptor> allDescriptors = this.getAllDescriptorsMap(clz, searchParent);
        ArrayList<Descriptor> result = new ArrayList<Descriptor>(allDescriptors.size());
        allDescriptors.forEach((member, descriptor) -> {
            if (member instanceof Field) {
                result.add((Descriptor)descriptor);
            }
        });
        return result;
    }

    public SortedMap<Member, Descriptor> getAllDescriptorsMap(Class<?> clz, boolean searchParent) {
        return this.extRegistry.descriptorsCache.computeIfAbsent(Tuple2.of(clz, searchParent), t -> Descriptor.getAllDescriptorsMap(clz, searchParent));
    }

    public ClassInfo getClassInfo(short classId) {
        ClassInfo classInfo = this.registeredId2ClassInfo[classId];
        assert (classInfo != null) : classId;
        if (classInfo.serializer == null) {
            this.addSerializer(classInfo.cls, this.createSerializer(classInfo.cls));
            classInfo = (ClassInfo)this.classInfoMap.get(classInfo.cls);
        }
        return classInfo;
    }

    @Override
    public ClassInfo getClassInfo(Class<?> cls) {
        ClassInfo classInfo = (ClassInfo)this.classInfoMap.get(cls);
        if (classInfo == null || classInfo.serializer == null) {
            this.addSerializer(cls, this.createSerializer(cls));
            classInfo = (ClassInfo)this.classInfoMap.get(cls);
        }
        return classInfo;
    }

    @Override
    public ClassInfo getClassInfo(Class<?> cls, ClassInfoHolder classInfoHolder) {
        ClassInfo classInfo = classInfoHolder.classInfo;
        if (classInfo.getCls() != cls) {
            classInfo = (ClassInfo)this.classInfoMap.get(cls);
            if (classInfo == null || classInfo.serializer == null) {
                this.addSerializer(cls, this.createSerializer(cls));
                classInfo = Objects.requireNonNull((ClassInfo)this.classInfoMap.get(cls));
            }
            classInfoHolder.classInfo = classInfo;
        }
        assert (classInfo.serializer != null);
        return classInfo;
    }

    @Override
    public ClassInfo getClassInfo(Class<?> cls, boolean createClassInfoIfNotFound) {
        if (createClassInfoIfNotFound) {
            return this.getOrUpdateClassInfo(cls);
        }
        if (this.extRegistry.getClassCtx.contains(cls)) {
            return null;
        }
        return (ClassInfo)this.classInfoMap.get(cls);
    }

    @Internal
    public ClassInfo getOrUpdateClassInfo(Class<?> cls) {
        ClassInfo classInfo = this.classInfoCache;
        if (classInfo.cls != cls) {
            classInfo = (ClassInfo)this.classInfoMap.get(cls);
            if (classInfo == null || classInfo.serializer == null) {
                this.addSerializer(cls, this.createSerializer(cls));
                classInfo = (ClassInfo)this.classInfoMap.get(cls);
            }
            this.classInfoCache = classInfo;
        }
        return classInfo;
    }

    private ClassInfo getOrUpdateClassInfo(short classId) {
        ClassInfo classInfo = this.classInfoCache;
        if (classInfo.classId != classId) {
            classInfo = this.registeredId2ClassInfo[classId];
            if (classInfo.serializer == null) {
                this.addSerializer(classInfo.cls, this.createSerializer(classInfo.cls));
                classInfo = (ClassInfo)this.classInfoMap.get(classInfo.cls);
            }
            this.classInfoCache = classInfo;
        }
        return classInfo;
    }

    public <T> Serializer<T> createSerializerSafe(Class<T> cls, Supplier<Serializer<T>> func) {
        Serializer<T> serializer = this.fory.getClassResolver().getSerializer(cls, false);
        try {
            return func.get();
        }
        catch (Throwable t) {
            this.resetSerializer(cls, serializer);
            Platform.throwException(t);
            throw new IllegalStateException("unreachable");
        }
    }

    private Serializer createSerializer(Class<?> cls) {
        Serializer serializer;
        DisallowedList.checkNotInDisallowedList(cls.getName());
        if (!this.isSecure(cls)) {
            throw new InsecureException(this.generateSecurityMsg(cls));
        }
        if (!(this.fory.getConfig().suppressClassRegistrationWarnings() || Functions.isLambda(cls) || ReflectionUtils.isJdkProxy(cls) || this.extRegistry.registeredClassIdMap.containsKey(cls) || this.shimDispatcher.contains(cls))) {
            LOG.warn(this.generateSecurityMsg(cls));
        }
        if (this.extRegistry.serializerFactory != null && (serializer = this.extRegistry.serializerFactory.createSerializer(this.fory, cls)) != null) {
            return serializer;
        }
        Serializer<?> shimSerializer = this.shimDispatcher.getSerializer(cls);
        if (shimSerializer != null) {
            return shimSerializer;
        }
        if (!this.extRegistry.absClassInfo.isEmpty()) {
            for (Class<?> tmpCls = cls; tmpCls != null && tmpCls != Object.class; tmpCls = tmpCls.getSuperclass()) {
                ClassInfo absClass = this.extRegistry.absClassInfo.get(tmpCls.getSuperclass());
                if (absClass != null) {
                    return absClass.serializer;
                }
                for (Class<?> tmpI : tmpCls.getInterfaces()) {
                    absClass = this.extRegistry.absClassInfo.get(tmpI);
                    if (absClass == null) continue;
                    return absClass.serializer;
                }
            }
        }
        Class<? extends Serializer> serializerClass = this.getSerializerClass(cls);
        Serializer serializer2 = Serializers.newSerializer(this.fory, cls, serializerClass);
        if (ForyCopyable.class.isAssignableFrom(cls)) {
            serializer2 = new ForyCopyableSerializer(this.fory, cls, serializer2);
        }
        return serializer2;
    }

    private void createSerializer0(Class<?> cls) {
        ClassInfo classInfo = this.getClassInfo(cls);
        if (this.metaContextShareEnabled && this.needToWriteClassDef(classInfo.serializer)) {
            ClassInfo deserializationClassInfo;
            ClassDef classDef = classInfo.classDef;
            if (classDef == null) {
                classDef = this.buildClassDef(classInfo);
            }
            if ((deserializationClassInfo = this.buildMetaSharedClassInfo(Tuple2.of(classDef, null), classDef)) != null && GraalvmSupport.isGraalBuildtime()) {
                this.getGraalvmClassRegistry().deserializerClassMap.put(classDef.getId(), this.getGraalvmSerializerClass(deserializationClassInfo.serializer));
                Tuple2<ClassDef, ClassInfo> classDefTuple = this.extRegistry.classIdToDef.get(classDef.getId());
                this.classInfoCache = NIL_CLASS_INFO;
                this.extRegistry.classIdToDef.put(classDef.getId(), Tuple2.of((ClassDef)classDefTuple.f0, null));
            }
        }
        if (GraalvmSupport.isGraalBuildtime()) {
            this.getGraalvmClassRegistry().serializerClassMap.put(cls, this.getGraalvmSerializerClass(classInfo.serializer));
            this.classInfoCache = NIL_CLASS_INFO;
            if (RecordUtils.isRecord(cls)) {
                RecordUtils.getRecordConstructor(cls);
                RecordUtils.getRecordComponents(cls);
            }
            ObjectCreators.getObjectCreator(cls);
        }
    }

    private String generateSecurityMsg(Class<?> cls) {
        String tpl = "%s is not registered, please check whether it's the type you want to serialize or a **vulnerability**. If safe, you should invoke `Fory#register` to register class,  which will have better performance by skipping classname serialization. If your env is 100%% secure, you can also avoid this exception by disabling class registration check using `ForyBuilder#requireClassRegistration(false)`";
        return String.format(tpl, cls);
    }

    private boolean isSecure(Class<?> cls) {
        if (this.extRegistry.registeredClasses.inverse().containsKey(cls) || this.shimDispatcher.contains(cls)) {
            return true;
        }
        if (cls.isArray()) {
            return this.isSecure(TypeUtils.getArrayComponent(cls));
        }
        if (this.fory.getConfig().requireClassRegistration()) {
            return Functions.isLambda(cls) || ReflectionUtils.isJdkProxy(cls) || this.extRegistry.registeredClassIdMap.containsKey(cls) || this.shimDispatcher.contains(cls);
        }
        return this.extRegistry.typeChecker.checkType(this, cls.getName());
    }

    public void writeClassAndUpdateCache(MemoryBuffer buffer, Class<?> cls) {
        if (cls == Integer.class) {
            buffer.writeVarUint32Small7(36);
        } else if (cls == Long.class) {
            buffer.writeVarUint32Small7(40);
        } else {
            this.writeClassInfo(buffer, this.getOrUpdateClassInfo(cls));
        }
    }

    @Override
    public void writeClassInfo(MemoryBuffer buffer, ClassInfo classInfo) {
        if (this.metaContextShareEnabled) {
            this.writeClassInfoWithMetaShare(buffer, classInfo);
        } else if (classInfo.classId == 0) {
            assert (classInfo.namespaceBytes != null);
            this.metaStringResolver.writeMetaStringBytesWithFlag(buffer, classInfo.namespaceBytes);
            assert (classInfo.typeNameBytes != null);
            this.metaStringResolver.writeMetaStringBytes(buffer, classInfo.typeNameBytes);
        } else {
            buffer.writeVarUint32(classInfo.classId << 1);
        }
    }

    public void writeClassInfoWithMetaShare(MemoryBuffer buffer, ClassInfo classInfo) {
        if (classInfo.classId != 0 && !classInfo.needToWriteClassDef) {
            buffer.writeVarUint32(classInfo.classId << 1);
            return;
        }
        MetaContext metaContext = this.fory.getSerializationContext().getMetaContext();
        assert (metaContext != null) : "Meta context must be set before serialization, please set meta context by SerializationContext.setMetaContext";
        IdentityObjectIntMap<Class<?>> classMap = metaContext.classMap;
        int newId = classMap.size;
        int id = classMap.putOrGet(classInfo.cls, newId);
        if (id >= 0) {
            buffer.writeVarUint32(id << 1 | 1);
        } else {
            buffer.writeVarUint32(newId << 1 | 1);
            ClassDef classDef = classInfo.classDef;
            if (classDef == null) {
                classDef = this.buildClassDef(classInfo);
            }
            metaContext.writingClassDefs.add(classDef);
        }
    }

    private ClassDef buildClassDef(ClassInfo classInfo) {
        Serializer<?> serializer = classInfo.serializer;
        Preconditions.checkArgument(serializer.getClass() != NonexistentClassSerializers.NonexistentClassSerializer.class);
        ClassDef classDef = this.needToWriteClassDef(serializer) ? this.classDefMap.computeIfAbsent(classInfo.cls, cls -> ClassDef.buildClassDef(this.fory, cls)) : this.classDefMap.computeIfAbsent(classInfo.cls, cls -> ClassDef.buildClassDef(this, cls, new ArrayList<Field>(), false));
        classInfo.classDef = classDef;
        return classDef;
    }

    @Override
    public ClassInfo readSharedClassMeta(MemoryBuffer buffer, MetaContext metaContext) {
        assert (metaContext != null) : "Meta context must be set before serialization, please set meta context by SerializationContext.setMetaContext";
        int header = buffer.readVarUint32Small14();
        int id = header >>> 1;
        if ((header & 1) == 0) {
            return this.getOrUpdateClassInfo((short)id);
        }
        ClassInfo classInfo = metaContext.readClassInfos.get(id);
        if (classInfo == null) {
            classInfo = this.readSharedClassMeta(metaContext, id);
        }
        return classInfo;
    }

    @Override
    public ClassDef getTypeDef(Class<?> cls, boolean resolveParent) {
        if (resolveParent) {
            return this.classDefMap.computeIfAbsent(cls, k -> ClassDef.buildClassDef(this.fory, cls));
        }
        ClassDef classDef = this.extRegistry.currentLayerClassDef.get(cls);
        if (classDef == null) {
            classDef = ClassDef.buildClassDef(this.fory, cls, false);
            this.extRegistry.currentLayerClassDef.put(cls, classDef);
        }
        return classDef;
    }

    public Expression writeClassExpr(Expression buffer, short classId) {
        Preconditions.checkArgument(classId != 0);
        return this.writeClassExpr(buffer, Expression.Literal.ofShort(classId));
    }

    private Expression writeClassExpr(Expression buffer, Expression classId) {
        return new Expression.Invoke(buffer, "writeVarUint32", new Expression.BitShift("<<", classId, 1));
    }

    public Expression skipRegisteredClassExpr(Expression buffer) {
        return new Expression.Invoke(buffer, "readVarUint32Small14", new Expression[0]);
    }

    public void writeClassInternal(MemoryBuffer buffer, Class<?> cls) {
        ClassInfo classInfo = (ClassInfo)this.classInfoMap.get(cls);
        if (classInfo == null) {
            Short classId = this.extRegistry.registeredClassIdMap.get(cls);
            classInfo = new ClassInfo(this, cls, null, classId == null ? (short)0 : classId, 0);
            this.classInfoMap.put(cls, classInfo);
        }
        this.writeClassInternal(buffer, classInfo);
    }

    public void writeClassInternal(MemoryBuffer buffer, ClassInfo classInfo) {
        short classId = classInfo.classId;
        if (classId == 3) {
            classInfo.classId = 0;
        }
        if (classInfo.classId != 0) {
            buffer.writeVarUint32(classInfo.classId << 1);
        } else {
            this.metaStringResolver.writeMetaStringBytesWithFlag(buffer, classInfo.namespaceBytes);
            this.metaStringResolver.writeMetaStringBytes(buffer, classInfo.typeNameBytes);
        }
        classInfo.classId = classId;
    }

    public Class<?> readClassInternal(MemoryBuffer buffer) {
        ClassInfo classInfo;
        int header = buffer.readVarUint32Small14();
        if ((header & 1) != 0) {
            MetaStringBytes packageBytes = this.metaStringResolver.readMetaStringBytesWithFlag(buffer, header);
            MetaStringBytes simpleClassNameBytes = this.metaStringResolver.readMetaStringBytes(buffer);
            classInfo = this.loadBytesToClassInfo(packageBytes, simpleClassNameBytes);
        } else {
            classInfo = this.registeredId2ClassInfo[(short)(header >> 1)];
        }
        Class<?> cls = classInfo.cls;
        this.currentReadClass = cls;
        return cls;
    }

    public ClassInfo readClassInfo(MemoryBuffer buffer) {
        ClassInfo classInfo;
        if (this.metaContextShareEnabled) {
            return this.readSharedClassMeta(buffer, this.fory.getSerializationContext().getMetaContext());
        }
        int header = buffer.readVarUint32Small14();
        if ((header & 1) != 0) {
            this.classInfoCache = classInfo = this.readClassInfoFromBytes(buffer, this.classInfoCache, header);
        } else {
            classInfo = this.getOrUpdateClassInfo((short)(header >> 1));
        }
        this.currentReadClass = classInfo.cls;
        return classInfo;
    }

    @Override
    public ClassInfo readClassInfo(MemoryBuffer buffer, ClassInfo classInfoCache) {
        if (this.metaContextShareEnabled) {
            return this.readSharedClassMeta(buffer, this.fory.getSerializationContext().getMetaContext());
        }
        int header = buffer.readVarUint32Small14();
        if ((header & 1) != 0) {
            return this.readClassInfoByCache(buffer, classInfoCache, header);
        }
        return this.getClassInfo((short)(header >> 1));
    }

    @Override
    public ClassInfo readClassInfo(MemoryBuffer buffer, ClassInfoHolder classInfoHolder) {
        if (this.metaContextShareEnabled) {
            return this.readSharedClassMeta(buffer, this.fory.getSerializationContext().getMetaContext());
        }
        int header = buffer.readVarUint32Small14();
        if ((header & 1) != 0) {
            return this.readClassInfoFromBytes(buffer, classInfoHolder, header);
        }
        return this.getClassInfo((short)(header >> 1));
    }

    private ClassInfo readClassInfoByCache(MemoryBuffer buffer, ClassInfo classInfoCache, int header) {
        if (this.metaContextShareEnabled) {
            return this.readSharedClassMeta(buffer, this.fory.getSerializationContext().getMetaContext());
        }
        return this.readClassInfoFromBytes(buffer, classInfoCache, header);
    }

    private ClassInfo readClassInfoFromBytes(MemoryBuffer buffer, ClassInfoHolder classInfoHolder, int header) {
        ClassInfo classInfo;
        if (this.metaContextShareEnabled) {
            return this.readSharedClassMeta(buffer, this.fory.getSerializationContext().getMetaContext());
        }
        classInfoHolder.classInfo = classInfo = this.readClassInfoFromBytes(buffer, classInfoHolder.classInfo, header);
        return classInfo;
    }

    private ClassInfo readClassInfoFromBytes(MemoryBuffer buffer, ClassInfo classInfoCache, int header) {
        MetaStringBytes simpleClassNameBytes;
        MetaStringBytes namespaceBytes;
        MetaStringBytes typeNameBytesCache = classInfoCache.typeNameBytes;
        if (typeNameBytesCache != null) {
            MetaStringBytes packageNameBytesCache = classInfoCache.namespaceBytes;
            namespaceBytes = this.metaStringResolver.readMetaStringBytesWithFlag(buffer, packageNameBytesCache, header);
            assert (packageNameBytesCache != null);
            simpleClassNameBytes = this.metaStringResolver.readMetaStringBytes(buffer, typeNameBytesCache);
            if (typeNameBytesCache.hashCode == simpleClassNameBytes.hashCode && packageNameBytesCache.hashCode == namespaceBytes.hashCode) {
                return classInfoCache;
            }
        } else {
            namespaceBytes = this.metaStringResolver.readMetaStringBytesWithFlag(buffer, header);
            simpleClassNameBytes = this.metaStringResolver.readMetaStringBytes(buffer);
        }
        ClassInfo classInfo = this.loadBytesToClassInfo(namespaceBytes, simpleClassNameBytes);
        if (classInfo.serializer == null) {
            return this.getClassInfo(classInfo.cls);
        }
        return classInfo;
    }

    ClassInfo loadBytesToClassInfo(MetaStringBytes packageBytes, MetaStringBytes simpleClassNameBytes) {
        TypeNameBytes typeNameBytes = new TypeNameBytes(packageBytes.hashCode, simpleClassNameBytes.hashCode);
        ClassInfo classInfo = (ClassInfo)this.compositeNameBytes2ClassInfo.get(typeNameBytes);
        if (classInfo == null) {
            classInfo = this.populateBytesToClassInfo(typeNameBytes, packageBytes, simpleClassNameBytes);
        }
        return classInfo;
    }

    private ClassInfo populateBytesToClassInfo(TypeNameBytes typeNameBytes, MetaStringBytes packageBytes, MetaStringBytes simpleClassNameBytes) {
        String packageName = packageBytes.decode(Encoders.PACKAGE_DECODER);
        String className = simpleClassNameBytes.decode(Encoders.TYPE_NAME_DECODER);
        ClassSpec classSpec = Encoders.decodePkgAndClass(packageName, className);
        MetaStringBytes fullClassNameBytes = this.metaStringResolver.getOrCreateMetaStringBytes(Encoders.PACKAGE_ENCODER.encode(classSpec.entireClassName, MetaString.Encoding.UTF_8));
        Class<?> cls = this.loadClass(classSpec.entireClassName, classSpec.isEnum, classSpec.dimension);
        ClassInfo classInfo = new ClassInfo(cls, fullClassNameBytes, packageBytes, simpleClassNameBytes, false, null, 0, 0);
        if (NonexistentClass.class.isAssignableFrom(TypeUtils.getComponentIfArray(cls))) {
            classInfo.serializer = NonexistentClassSerializers.getSerializer(this.fory, classSpec.entireClassName, cls);
        } else if (!this.classInfoMap.containsKey(cls)) {
            this.classInfoMap.put(cls, classInfo);
        }
        this.compositeNameBytes2ClassInfo.put(typeNameBytes, classInfo);
        return classInfo;
    }

    public Class<?> getCurrentReadClass() {
        return this.currentReadClass;
    }

    public void reset() {
        this.resetRead();
        this.resetWrite();
    }

    public void resetRead() {
    }

    public void resetWrite() {
    }

    public GenericType getGenericTypeInStruct(Class<?> cls, String genericTypeStr) {
        Map map = this.extRegistry.classGenericTypes.computeIfAbsent(cls, this::buildGenericMap);
        return map.getOrDefault(genericTypeStr, OBJECT_GENERIC_TYPE);
    }

    @Override
    public GenericType buildGenericType(TypeRef<?> typeRef) {
        return GenericType.build(typeRef, t -> {
            if (t.getClass() == Class.class) {
                return this.isMonomorphic((Class)t);
            }
            return this.isMonomorphic(TypeUtils.getRawType(t));
        });
    }

    @Override
    public GenericType buildGenericType(Type type) {
        GenericType genericType = this.extRegistry.genericTypes.get(type);
        if (genericType != null) {
            return genericType;
        }
        return this.populateGenericType(type);
    }

    private GenericType populateGenericType(Type type) {
        GenericType genericType = GenericType.build(type, t -> {
            if (t.getClass() == Class.class) {
                return this.isMonomorphic((Class)t);
            }
            return this.isMonomorphic(TypeUtils.getRawType(t));
        });
        this.extRegistry.genericTypes.put(type, genericType);
        return genericType;
    }

    public GenericType getObjectGenericType() {
        return this.extRegistry.objectGenericType;
    }

    public ClassInfo newClassInfo(Class<?> cls, Serializer<?> serializer, short classId) {
        return new ClassInfo(this, cls, serializer, classId, 0);
    }

    @Override
    public ClassInfo nilClassInfo() {
        return new ClassInfo(this, null, null, 0, 0);
    }

    @Override
    public ClassInfoHolder nilClassInfoHolder() {
        return new ClassInfoHolder(this.nilClassInfo());
    }

    public boolean isPrimitive(short classId) {
        return classId >= 4 && classId <= 12;
    }

    public CodeGenerator getCodeGenerator(ClassLoader ... loaders) {
        ArrayList loaderList = new ArrayList(loaders.length);
        Collections.addAll(loaderList, loaders);
        return this.extRegistry.codeGeneratorMap.get(loaderList);
    }

    public void setCodeGenerator(ClassLoader loader, CodeGenerator codeGenerator) {
        this.setCodeGenerator(new ClassLoader[]{loader}, codeGenerator);
    }

    public void setCodeGenerator(ClassLoader[] loaders, CodeGenerator codeGenerator) {
        this.extRegistry.codeGeneratorMap.put(Arrays.asList(loaders), codeGenerator);
    }

    @Override
    public DescriptorGrouper createDescriptorGrouper(Collection<Descriptor> descriptors, boolean descriptorsGroupedOrdered, Function<Descriptor, Descriptor> descriptorUpdator) {
        return DescriptorGrouper.createDescriptorGrouper(this.fory.getClassResolver()::isMonomorphic, descriptors, descriptorsGroupedOrdered, descriptorUpdator, this.fory.compressInt(), this.fory.compressLong(), DescriptorGrouper.COMPARATOR_BY_TYPE_AND_NAME).sort();
    }

    public void ensureSerializersCompiled() {
        if (this.extRegistry.ensureSerializersCompiled) {
            return;
        }
        this.extRegistry.ensureSerializersCompiled = true;
        try {
            this.fory.getJITContext().lock();
            Serializers.newSerializer(this.fory, LambdaSerializer.STUB_LAMBDA_CLASS, LambdaSerializer.class);
            Serializers.newSerializer(this.fory, JdkProxySerializer.SUBT_PROXY.getClass(), JdkProxySerializer.class);
            this.classInfoMap.forEach((cls, classInfo) -> {
                if (classInfo.serializer == null) {
                    if (this.isSerializable(classInfo.cls)) {
                        this.createSerializer0((Class<?>)cls);
                    }
                    if (cls.isArray()) {
                        this.createSerializer0(TypeUtils.getArrayComponent(cls));
                    }
                }
            });
            if (GraalvmSupport.isGraalBuildtime()) {
                this.classInfoCache = NIL_CLASS_INFO;
                this.classInfoMap.forEach((cls, classInfo) -> {
                    if (classInfo.serializer != null && !this.extRegistry.registeredClassInfos.contains(classInfo)) {
                        classInfo.serializer = null;
                    }
                });
            }
        }
        finally {
            this.fory.getJITContext().unlock();
        }
    }
}

