/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.resolver;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.fory.Fory;
import org.apache.fory.annotation.Internal;
import org.apache.fory.builder.Generated;
import org.apache.fory.collection.IdentityObjectIntMap;
import org.apache.fory.collection.LongMap;
import org.apache.fory.collection.ObjectMap;
import org.apache.fory.collection.Tuple2;
import org.apache.fory.config.Config;
import org.apache.fory.exception.ClassUnregisteredException;
import org.apache.fory.exception.SerializerUnregisteredException;
import org.apache.fory.logging.Logger;
import org.apache.fory.logging.LoggerFactory;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.memory.Platform;
import org.apache.fory.meta.ClassDef;
import org.apache.fory.meta.Encoders;
import org.apache.fory.meta.MetaString;
import org.apache.fory.reflect.ReflectionUtils;
import org.apache.fory.reflect.TypeRef;
import org.apache.fory.resolver.ClassInfo;
import org.apache.fory.resolver.ClassInfoHolder;
import org.apache.fory.resolver.ClassResolver;
import org.apache.fory.resolver.MetaContext;
import org.apache.fory.resolver.MetaStringBytes;
import org.apache.fory.resolver.MetaStringResolver;
import org.apache.fory.resolver.TypeNameBytes;
import org.apache.fory.resolver.TypeResolver;
import org.apache.fory.serializer.ArraySerializers;
import org.apache.fory.serializer.DeferedLazySerializer;
import org.apache.fory.serializer.EnumSerializer;
import org.apache.fory.serializer.NonexistentClass;
import org.apache.fory.serializer.NonexistentClassSerializers;
import org.apache.fory.serializer.ObjectSerializer;
import org.apache.fory.serializer.SerializationUtils;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.serializer.Serializers;
import org.apache.fory.serializer.TimeSerializers;
import org.apache.fory.serializer.collection.CollectionLikeSerializer;
import org.apache.fory.serializer.collection.CollectionSerializer;
import org.apache.fory.serializer.collection.CollectionSerializers;
import org.apache.fory.serializer.collection.MapLikeSerializer;
import org.apache.fory.serializer.collection.MapSerializer;
import org.apache.fory.serializer.collection.MapSerializers;
import org.apache.fory.type.Descriptor;
import org.apache.fory.type.DescriptorGrouper;
import org.apache.fory.type.GenericType;
import org.apache.fory.type.Generics;
import org.apache.fory.type.TypeUtils;
import org.apache.fory.type.Types;
import org.apache.fory.util.Preconditions;

public class XtypeResolver
extends TypeResolver {
    private static final Logger LOG = LoggerFactory.getLogger(XtypeResolver.class);
    private static final float loadFactor = 0.5f;
    private static final int MAX_TYPE_ID = 4096;
    private final Config config;
    private final Fory fory;
    private final ClassResolver classResolver;
    private final ClassInfoHolder classInfoCache = new ClassInfoHolder(NIL_CLASS_INFO);
    private final MetaStringResolver metaStringResolver;
    private final ObjectMap<TypeNameBytes, ClassInfo> compositeClassNameBytes2ClassInfo = new ObjectMap(16, 0.5f);
    private final ObjectMap<String, ClassInfo> qualifiedType2ClassInfo = new ObjectMap(16, 0.5f);
    private final Map<Class<?>, ClassDef> classDefMap = new HashMap();
    private final boolean shareMeta;
    private int xtypeIdGenerator = 64;
    private final LongMap<ClassInfo> xtypeIdToClassMap = new LongMap(8, 0.5f);
    private final Set<Integer> registeredTypeIds = new HashSet<Integer>();
    private final Generics generics;
    private static final int UNKNOWN_TYPE_ID = 63;

    public XtypeResolver(Fory fory) {
        super(fory);
        this.config = fory.getConfig();
        this.fory = fory;
        this.classResolver = fory.getClassResolver();
        this.classResolver.xtypeResolver = this;
        this.shareMeta = fory.getConfig().isMetaShareEnabled();
        this.generics = fory.getGenerics();
        this.metaStringResolver = fory.getMetaStringResolver();
    }

    @Override
    public void initialize() {
        this.registerDefaultTypes();
        if (this.shareMeta) {
            NonexistentClassSerializers.NonexistentClassSerializer serializer = new NonexistentClassSerializers.NonexistentClassSerializer(this.fory, null);
            this.register(NonexistentClass.NonexistentMetaShared.class, serializer, "", "unknown_struct", 16);
        }
    }

    @Override
    public void register(Class<?> type) {
        while (this.registeredTypeIds.contains(this.xtypeIdGenerator)) {
            ++this.xtypeIdGenerator;
        }
        this.register(type, this.xtypeIdGenerator++);
    }

    @Override
    public void register(Class<?> type, int userTypeId) {
        this.checkRegisterAllowed();
        Preconditions.checkArgument(userTypeId < 4096, "Too big type id %s", userTypeId, new Object[0]);
        ClassInfo classInfo = (ClassInfo)this.classInfoMap.get(type);
        if (type.isArray()) {
            this.buildClassInfo(type);
            return;
        }
        Serializer<?> serializer = null;
        if (classInfo != null) {
            serializer = classInfo.serializer;
            if (classInfo.xtypeId != 0) {
                throw new IllegalArgumentException(String.format("Type %s has been registered with id %s", type, classInfo.xtypeId));
            }
            String prevNamespace = classInfo.decodeNamespace();
            String prevTypeName = classInfo.decodeTypeName();
            if (!type.getSimpleName().equals(prevTypeName)) {
                throw new IllegalArgumentException(String.format("Type %s has been registered with namespace %s type %s", type, prevNamespace, prevTypeName));
            }
        }
        int xtypeId = userTypeId;
        if (type.isEnum()) {
            xtypeId = (xtypeId << 8) + 13;
        } else {
            int id = (xtypeId << 8) + (this.shareMeta ? 16 : 15);
            xtypeId = serializer != null ? (this.isStructType(serializer) ? id : (xtypeId << 8) + 19) : id;
        }
        this.register(type, serializer, ReflectionUtils.getPackage(type), ReflectionUtils.getClassNameWithoutPackage(type), xtypeId);
    }

    @Override
    public void register(Class<?> type, String namespace, String typeName) {
        this.checkRegisterAllowed();
        Preconditions.checkArgument(!typeName.contains("."), "Typename %s should not contains `.`, please put it into namespace", typeName, new Object[0]);
        ClassInfo classInfo = (ClassInfo)this.classInfoMap.get(type);
        Serializer<?> serializer = null;
        if (classInfo != null) {
            serializer = classInfo.serializer;
            if (classInfo.typeNameBytes != null) {
                String prevNamespace = classInfo.decodeNamespace();
                String prevTypeName = classInfo.decodeTypeName();
                if (!namespace.equals(prevNamespace) || typeName.equals(prevTypeName)) {
                    throw new IllegalArgumentException(String.format("Type %s has been registered with namespace %s type %s", type, prevNamespace, prevTypeName));
                }
            }
        }
        int xtypeId = serializer != null ? (this.isStructType(serializer) ? (int)((short)(this.fory.isCompatible() ? 18 : 17)) : (serializer instanceof EnumSerializer ? 14 : 20)) : (type.isEnum() ? 14 : (int)((short)(this.fory.isCompatible() ? 18 : 17)));
        this.register(type, serializer, namespace, typeName, xtypeId);
    }

    private void register(Class<?> type, Serializer<?> serializer, String namespace, String typeName, int xtypeId) {
        ClassInfo classInfo = this.newClassInfo(type, serializer, namespace, typeName, xtypeId);
        String qualifiedName = TypeUtils.qualifiedName(namespace, typeName);
        this.qualifiedType2ClassInfo.put(qualifiedName, classInfo);
        this.extRegistry.registeredClasses.put((Object)qualifiedName, type);
        if (serializer == null) {
            if (type.isEnum()) {
                classInfo.serializer = new EnumSerializer(this.fory, type);
            } else {
                AtomicBoolean updated = new AtomicBoolean(false);
                AtomicReference<Object> ref = new AtomicReference<Object>(null);
                classInfo.serializer = new DeferedLazySerializer.DeferedLazyObjectSerializer(this.fory, type, () -> {
                    if (ref.get() == null) {
                        Class<? extends Serializer> c = this.classResolver.getObjectSerializerClass(type, this.shareMeta, this.fory.getConfig().isCodeGenEnabled(), sc -> ref.set(Serializers.newSerializer(this.fory, type, sc)));
                        ref.set(Serializers.newSerializer(this.fory, type, c));
                        if (!this.fory.getConfig().isAsyncCompilationEnabled()) {
                            updated.set(true);
                        }
                    }
                    return Tuple2.of(updated.get(), (Serializer)ref.get());
                });
            }
        }
        this.classInfoMap.put(type, classInfo);
        this.registeredTypeIds.add(xtypeId);
        this.xtypeIdToClassMap.put(xtypeId, classInfo);
    }

    @Internal
    public void registerForyType(Class<?> type, Serializer serializer, int typeId) {
        Preconditions.checkArgument(typeId < 4096, "Too big type id %s", typeId, new Object[0]);
        this.register(type, serializer, ReflectionUtils.getPackage(type), ReflectionUtils.getClassNameWithoutPackage(type), typeId);
    }

    private boolean isStructType(Serializer serializer) {
        if (serializer instanceof ObjectSerializer || serializer instanceof Generated.GeneratedSerializer) {
            return true;
        }
        return serializer instanceof DeferedLazySerializer.DeferedLazyObjectSerializer;
    }

    private ClassInfo newClassInfo(Class<?> type, Serializer<?> serializer, int xtypeId) {
        return this.newClassInfo(type, serializer, ReflectionUtils.getPackage(type), ReflectionUtils.getClassNameWithoutPackage(type), xtypeId);
    }

    private ClassInfo newClassInfo(Class<?> type, Serializer<?> serializer, String namespace, String typeName, int xtypeId) {
        MetaStringBytes fullClassNameBytes = this.metaStringResolver.getOrCreateMetaStringBytes(Encoders.GENERIC_ENCODER.encode(type.getName(), MetaString.Encoding.UTF_8));
        MetaStringBytes nsBytes = this.metaStringResolver.getOrCreateMetaStringBytes(Encoders.encodePackage(namespace));
        MetaStringBytes classNameBytes = this.metaStringResolver.getOrCreateMetaStringBytes(Encoders.encodeTypeName(typeName));
        return new ClassInfo(type, fullClassNameBytes, nsBytes, classNameBytes, false, serializer, 0, xtypeId);
    }

    @Override
    public <T> void registerSerializer(Class<T> type, Class<? extends Serializer> serializerClass) {
        this.checkRegisterAllowed();
        this.registerSerializer(type, Serializers.newSerializer(this.fory, type, serializerClass));
    }

    @Override
    public void registerSerializer(Class<?> type, Serializer<?> serializer) {
        this.checkRegisterAllowed();
        ClassInfo classInfo = this.checkClassRegistration(type);
        if (!serializer.getClass().getPackage().getName().startsWith("org.apache.fory")) {
            SerializationUtils.validate(type, serializer.getClass());
        }
        int oldXtypeId = classInfo.xtypeId;
        int foryId = oldXtypeId & 0xFF;
        if (oldXtypeId != 0 && this.xtypeIdToClassMap.get(oldXtypeId) == classInfo) {
            this.xtypeIdToClassMap.remove(oldXtypeId);
            this.registeredTypeIds.remove(oldXtypeId);
        }
        if (foryId != 19 && foryId != 20) {
            if (foryId == 15 || foryId == 16) {
                classInfo.xtypeId = oldXtypeId & 0xFFFFFF00 | 0x13;
            } else if (foryId == 17 || foryId == 18) {
                classInfo.xtypeId = oldXtypeId & 0xFFFFFF00 | 0x14;
            } else {
                throw new IllegalArgumentException(String.format("Can't register serializer for type %s with id %s", type, oldXtypeId));
            }
        }
        classInfo.serializer = serializer;
        int newXtypeId = classInfo.xtypeId;
        if (newXtypeId != 0) {
            this.xtypeIdToClassMap.put(newXtypeId, classInfo);
            this.registeredTypeIds.add(newXtypeId);
        }
    }

    private ClassInfo checkClassRegistration(Class<?> type) {
        ClassInfo classInfo = (ClassInfo)this.classInfoMap.get(type);
        Preconditions.checkArgument(classInfo != null && (classInfo.xtypeId != 0 || !type.getSimpleName().equals(classInfo.decodeTypeName())), "Type %s should be registered with id or namespace+typename before register serializer", type, new Object[0]);
        return classInfo;
    }

    @Override
    public boolean isRegistered(Class<?> cls) {
        return this.classInfoMap.get(cls) != null;
    }

    @Override
    public boolean isRegisteredById(Class<?> cls) {
        ClassInfo classInfo = (ClassInfo)this.classInfoMap.get(cls);
        if (classInfo == null) {
            return false;
        }
        int xtypeId = classInfo.xtypeId & 0xFF;
        switch (xtypeId) {
            case 14: 
            case 17: 
            case 18: 
            case 20: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isRegisteredByName(Class<?> cls) {
        ClassInfo classInfo = (ClassInfo)this.classInfoMap.get(cls);
        if (classInfo == null) {
            return false;
        }
        int xtypeId = classInfo.xtypeId & 0xFF;
        switch (xtypeId) {
            case 14: 
            case 17: 
            case 18: 
            case 20: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isMonomorphic(Class<?> clz) {
        if (TypeUtils.unwrap(clz).isPrimitive() || clz.isEnum() || clz == String.class) {
            return true;
        }
        if (clz.isArray()) {
            return true;
        }
        ClassInfo classInfo = this.getClassInfo(clz, false);
        if (classInfo != null) {
            Serializer<?> s = classInfo.serializer;
            if (s instanceof TimeSerializers.TimeSerializer || s instanceof MapLikeSerializer || s instanceof CollectionLikeSerializer) {
                return true;
            }
            return s instanceof TimeSerializers.ImmutableTimeSerializer;
        }
        return this.isMap(clz) || this.isCollection(clz);
    }

    @Override
    public ClassInfo getClassInfo(Class<?> cls) {
        ClassInfo classInfo = (ClassInfo)this.classInfoMap.get(cls);
        if (classInfo == null) {
            classInfo = this.buildClassInfo(cls);
        }
        return classInfo;
    }

    @Override
    public ClassInfo getClassInfo(Class<?> cls, boolean createIfAbsent) {
        if (createIfAbsent) {
            return this.getClassInfo(cls);
        }
        return (ClassInfo)this.classInfoMap.get(cls);
    }

    @Override
    public ClassInfo getClassInfo(Class<?> cls, ClassInfoHolder classInfoHolder) {
        ClassInfo classInfo = classInfoHolder.classInfo;
        if (classInfo.getCls() != cls) {
            classInfo = (ClassInfo)this.classInfoMap.get(cls);
            if (classInfo == null) {
                classInfo = this.buildClassInfo(cls);
            }
            classInfoHolder.classInfo = classInfo;
        }
        assert (classInfo.serializer != null);
        return classInfo;
    }

    public ClassInfo getXtypeInfo(int typeId) {
        return this.xtypeIdToClassMap.get(typeId);
    }

    public ClassInfo getUserTypeInfo(String namespace, String typeName) {
        String name = TypeUtils.qualifiedName(namespace, typeName);
        return (ClassInfo)this.qualifiedType2ClassInfo.get(name);
    }

    public ClassInfo getUserTypeInfo(int userTypeId) {
        Preconditions.checkArgument((userTypeId & 0xFF) < 63);
        return this.xtypeIdToClassMap.get(userTypeId);
    }

    @Override
    public GenericType buildGenericType(TypeRef<?> typeRef) {
        return this.classResolver.buildGenericType(typeRef);
    }

    @Override
    public GenericType buildGenericType(Type type) {
        return this.classResolver.buildGenericType(type);
    }

    private ClassInfo buildClassInfo(Class<?> cls) {
        int xtypeId;
        Serializer serializer;
        if (this.classResolver.isSet(cls)) {
            if (cls.isAssignableFrom(HashSet.class)) {
                cls = HashSet.class;
                serializer = new CollectionSerializers.HashSetSerializer(this.fory);
            } else {
                serializer = this.getCollectionSerializer(cls);
            }
            xtypeId = 22;
        } else if (this.classResolver.isCollection(cls)) {
            if (cls.isAssignableFrom(ArrayList.class)) {
                cls = ArrayList.class;
                serializer = new CollectionSerializers.ArrayListSerializer(this.fory);
            } else {
                serializer = this.getCollectionSerializer(cls);
            }
            xtypeId = 21;
        } else if (cls.isArray() && !cls.getComponentType().isPrimitive()) {
            serializer = new ArraySerializers.ObjectArraySerializer(this.fory, (Class<T[]>)cls);
            xtypeId = 21;
        } else if (this.classResolver.isMap(cls)) {
            if (cls.isAssignableFrom(HashMap.class)) {
                cls = HashMap.class;
                serializer = new MapSerializers.HashMapSerializer(this.fory);
            } else {
                ClassInfo classInfo = this.classResolver.getClassInfo(cls, false);
                serializer = classInfo != null && classInfo.serializer != null ? (classInfo.serializer instanceof MapLikeSerializer && ((MapLikeSerializer)classInfo.serializer).supportCodegenHook() ? classInfo.serializer : new MapSerializer<Object>(this.fory, cls)) : new MapSerializer<Object>(this.fory, cls);
            }
            xtypeId = 23;
        } else if (NonexistentClass.class.isAssignableFrom(cls)) {
            serializer = NonexistentClassSerializers.getSerializer(this.fory, "Unknown", cls);
            xtypeId = cls.isEnum() ? 13 : (this.shareMeta ? 16 : 15);
        } else {
            if (cls == Object.class) {
                return this.classResolver.getClassInfo(cls);
            }
            Class<?> enclosingClass = cls.getEnclosingClass();
            if (enclosingClass != null && enclosingClass.isEnum()) {
                serializer = new EnumSerializer(this.fory, (Class<Enum>)cls);
                xtypeId = this.getClassInfo(enclosingClass).xtypeId;
            } else {
                throw new ClassUnregisteredException(cls);
            }
        }
        ClassInfo info = this.newClassInfo(cls, serializer, (short)xtypeId);
        this.classInfoMap.put(cls, info);
        return info;
    }

    private Serializer<?> getCollectionSerializer(Class<?> cls) {
        ClassInfo classInfo = this.classResolver.getClassInfo(cls, false);
        if (classInfo != null && classInfo.serializer != null && classInfo.serializer instanceof CollectionLikeSerializer && ((CollectionLikeSerializer)classInfo.serializer).supportCodegenHook()) {
            return classInfo.serializer;
        }
        return new CollectionSerializer(this.fory, cls);
    }

    private void registerDefaultTypes() {
        this.registerDefaultTypes(1, Boolean.class, Boolean.TYPE, AtomicBoolean.class);
        this.registerDefaultTypes(2, Byte.class, Byte.TYPE);
        this.registerDefaultTypes(3, Short.class, Short.TYPE);
        this.registerDefaultTypes(4, Integer.class, Integer.TYPE, AtomicInteger.class);
        this.registerDefaultTypes(6, Long.class, Long.TYPE, AtomicLong.class);
        this.registerDefaultTypes(10, Float.class, Float.TYPE);
        this.registerDefaultTypes(11, Double.class, Double.TYPE);
        this.registerDefaultTypes(12, String.class, StringBuilder.class, StringBuffer.class);
        this.registerDefaultTypes(24, Duration.class, new Class[0]);
        this.registerDefaultTypes(25, Instant.class, Date.class, java.sql.Date.class, Timestamp.class, LocalDateTime.class);
        this.registerDefaultTypes(27, BigDecimal.class, BigInteger.class);
        this.registerDefaultTypes(28, byte[].class, Platform.HEAP_BYTE_BUFFER_CLASS, Platform.DIRECT_BYTE_BUFFER_CLASS);
        this.registerDefaultTypes(30, boolean[].class, new Class[0]);
        this.registerDefaultTypes(32, short[].class, new Class[0]);
        this.registerDefaultTypes(33, int[].class, new Class[0]);
        this.registerDefaultTypes(34, long[].class, new Class[0]);
        this.registerDefaultTypes(36, float[].class, new Class[0]);
        this.registerDefaultTypes(37, double[].class, new Class[0]);
        this.registerDefaultTypes(21, ArrayList.class, Object[].class, List.class, Collection.class);
        this.registerDefaultTypes(22, HashSet.class, LinkedHashSet.class, Set.class);
        this.registerDefaultTypes(23, HashMap.class, LinkedHashMap.class, Map.class);
        this.registerDefaultTypes(26, LocalDate.class, new Class[0]);
    }

    private void registerDefaultTypes(int xtypeId, Class<?> defaultType, Class<?> ... otherTypes) {
        ClassInfo classInfo = this.newClassInfo(defaultType, this.classResolver.getSerializer(defaultType), (short)xtypeId);
        this.classInfoMap.put(defaultType, classInfo);
        this.xtypeIdToClassMap.put(xtypeId, classInfo);
        for (Class<?> otherType : otherTypes) {
            Serializer serializer = ReflectionUtils.isAbstract(otherType) ? (this.isMap(otherType) ? new MapSerializers.XlangMapSerializer(this.fory, (Class)otherType) : (this.isSet(otherType) ? new CollectionSerializers.XlangSetDefaultSerializer(this.fory, (Class)otherType) : (this.isCollection(otherType) ? new CollectionSerializers.XlangListDefaultSerializer(this.fory, (Class)otherType) : classInfo.serializer))) : this.classResolver.getSerializer(otherType);
            ClassInfo info = this.newClassInfo(otherType, serializer, (short)xtypeId);
            this.classInfoMap.put(otherType, info);
        }
    }

    public ClassInfo writeClassInfo(MemoryBuffer buffer, Object obj) {
        ClassInfo classInfo = this.getClassInfo(obj.getClass(), this.classInfoCache);
        this.writeClassInfo(buffer, classInfo);
        return classInfo;
    }

    @Override
    public void writeClassInfo(MemoryBuffer buffer, ClassInfo classInfo) {
        int xtypeId = classInfo.getXtypeId();
        int internalTypeId = xtypeId & 0xFF;
        buffer.writeVarUint32Small7(xtypeId);
        switch (internalTypeId) {
            case 14: 
            case 17: 
            case 20: {
                if (this.shareMeta) {
                    this.writeSharedClassMeta(buffer, classInfo);
                    return;
                }
                assert (classInfo.namespaceBytes != null);
                this.metaStringResolver.writeMetaStringBytes(buffer, classInfo.namespaceBytes);
                assert (classInfo.typeNameBytes != null);
                this.metaStringResolver.writeMetaStringBytes(buffer, classInfo.typeNameBytes);
                break;
            }
            case 16: 
            case 18: {
                assert (this.shareMeta) : "Meta share must be enabled for compatible mode";
                this.writeSharedClassMeta(buffer, classInfo);
                break;
            }
        }
    }

    public void writeSharedClassMeta(MemoryBuffer buffer, ClassInfo classInfo) {
        MetaContext metaContext = this.fory.getSerializationContext().getMetaContext();
        assert (metaContext != null) : "Meta context must be set before serialization, please set meta context by SerializationContext.setMetaContext";
        IdentityObjectIntMap<Class<?>> classMap = metaContext.classMap;
        int newId = classMap.size;
        int id = classMap.putOrGet(classInfo.cls, newId);
        if (id >= 0) {
            buffer.writeVarUint32(id);
        } else {
            buffer.writeVarUint32(newId);
            ClassDef classDef = classInfo.classDef;
            if (classDef == null) {
                classDef = this.buildClassDef(classInfo);
            }
            metaContext.writingClassDefs.add(classDef);
        }
    }

    private ClassDef buildClassDef(ClassInfo classInfo) {
        ClassDef classDef;
        classInfo.classDef = classDef = this.classDefMap.computeIfAbsent(classInfo.cls, cls -> ClassDef.buildClassDef(this.fory, cls));
        return classDef;
    }

    @Override
    public <T> Serializer<T> getSerializer(Class<T> cls) {
        return this.getClassInfo(cls).serializer;
    }

    @Override
    public Serializer<?> getRawSerializer(Class<?> cls) {
        return this.getClassInfo(cls).serializer;
    }

    @Override
    public <T> void setSerializer(Class<T> cls, Serializer<T> serializer) {
        this.getClassInfo(cls).serializer = serializer;
    }

    @Override
    public <T> void setSerializerIfAbsent(Class<T> cls, Serializer<T> serializer) {
        ClassInfo classInfo = (ClassInfo)this.classInfoMap.get(cls);
        Preconditions.checkNotNull(classInfo);
        Preconditions.checkNotNull(classInfo.serializer);
    }

    @Override
    public ClassInfo nilClassInfo() {
        return this.classResolver.nilClassInfo();
    }

    @Override
    public ClassInfoHolder nilClassInfoHolder() {
        return this.classResolver.nilClassInfoHolder();
    }

    @Override
    public ClassInfo readClassInfo(MemoryBuffer buffer, ClassInfoHolder classInfoHolder) {
        return this.readClassInfo(buffer);
    }

    @Override
    public ClassInfo readClassInfo(MemoryBuffer buffer, ClassInfo classInfoCache) {
        return this.readClassInfo(buffer);
    }

    public ClassInfo readClassInfo(MemoryBuffer buffer) {
        int xtypeId = buffer.readVarUint32Small14();
        int internalTypeId = xtypeId & 0xFF;
        switch (internalTypeId) {
            case 14: 
            case 17: 
            case 20: {
                if (this.shareMeta) {
                    return this.readSharedClassMeta(buffer);
                }
                MetaStringBytes packageBytes = this.metaStringResolver.readMetaStringBytes(buffer);
                MetaStringBytes simpleClassNameBytes = this.metaStringResolver.readMetaStringBytes(buffer);
                return this.loadBytesToClassInfo(internalTypeId, packageBytes, simpleClassNameBytes);
            }
            case 16: 
            case 18: {
                assert (this.shareMeta) : "Meta share must be enabled for compatible mode";
                return this.readSharedClassMeta(buffer);
            }
            case 21: {
                return this.getListClassInfo();
            }
            case 25: {
                return this.getGenericClassInfo();
            }
        }
        ClassInfo classInfo = this.xtypeIdToClassMap.get(xtypeId);
        if (classInfo == null) {
            this.throwUnexpectTypeIdException(xtypeId);
        }
        return classInfo;
    }

    @Override
    public ClassInfo readSharedClassMeta(MemoryBuffer buffer, MetaContext metaContext) {
        return this.readClassInfo(buffer);
    }

    private ClassInfo readSharedClassMeta(MemoryBuffer buffer) {
        MetaContext metaContext = this.fory.getSerializationContext().getMetaContext();
        assert (metaContext != null) : "Meta context must be set before serialization, please set meta context by SerializationContext.setMetaContext";
        int id = buffer.readVarUint32Small14();
        ClassInfo classInfo = metaContext.readClassInfos.get(id);
        if (classInfo == null) {
            classInfo = this.readSharedClassMeta(metaContext, id);
        }
        return classInfo;
    }

    private void throwUnexpectTypeIdException(long xtypeId) {
        throw new IllegalStateException(String.format("Type id %s not registered", xtypeId));
    }

    private ClassInfo getListClassInfo() {
        this.fory.incReadDepth();
        GenericType genericType = this.generics.nextGenericType();
        this.fory.decDepth();
        if (genericType != null) {
            return this.getOrBuildClassInfo(genericType.getCls());
        }
        return this.xtypeIdToClassMap.get(21L);
    }

    private ClassInfo getGenericClassInfo() {
        this.fory.incReadDepth();
        GenericType genericType = this.generics.nextGenericType();
        this.fory.decDepth();
        if (genericType != null) {
            return this.getOrBuildClassInfo(genericType.getCls());
        }
        return this.xtypeIdToClassMap.get(25L);
    }

    private ClassInfo getOrBuildClassInfo(Class<?> cls) {
        ClassInfo classInfo = (ClassInfo)this.classInfoMap.get(cls);
        if (classInfo == null) {
            classInfo = this.buildClassInfo(cls);
            this.classInfoMap.put(cls, classInfo);
        }
        return classInfo;
    }

    private ClassInfo loadBytesToClassInfo(int internalTypeId, MetaStringBytes packageBytes, MetaStringBytes simpleClassNameBytes) {
        TypeNameBytes typeNameBytes = new TypeNameBytes(packageBytes.hashCode, simpleClassNameBytes.hashCode);
        ClassInfo classInfo = (ClassInfo)this.compositeClassNameBytes2ClassInfo.get(typeNameBytes);
        if (classInfo == null) {
            classInfo = this.populateBytesToClassInfo(internalTypeId, typeNameBytes, packageBytes, simpleClassNameBytes);
        }
        return classInfo;
    }

    private ClassInfo populateBytesToClassInfo(int typeId, TypeNameBytes typeNameBytes, MetaStringBytes packageBytes, MetaStringBytes simpleClassNameBytes) {
        String typeName;
        String namespace = packageBytes.decode(Encoders.PACKAGE_DECODER);
        String qualifiedName = TypeUtils.qualifiedName(namespace, typeName = simpleClassNameBytes.decode(Encoders.TYPE_NAME_DECODER));
        ClassInfo classInfo = (ClassInfo)this.qualifiedType2ClassInfo.get(qualifiedName);
        if (classInfo == null) {
            String msg = String.format("Class %s not registered", qualifiedName);
            Class<?> type = null;
            if (this.config.deserializeNonexistentClass()) {
                LOG.warn(msg);
                switch (typeId) {
                    case 14: 
                    case 17: 
                    case 18: {
                        type = NonexistentClass.getNonexistentClass(qualifiedName, this.isEnum(typeId), 0, this.config.isMetaShareEnabled());
                        break;
                    }
                    case 20: {
                        throw new SerializerUnregisteredException(qualifiedName);
                    }
                }
            } else {
                throw new ClassUnregisteredException(qualifiedName);
            }
            MetaStringBytes fullClassNameBytes = this.metaStringResolver.getOrCreateMetaStringBytes(Encoders.PACKAGE_ENCODER.encode(qualifiedName, MetaString.Encoding.UTF_8));
            classInfo = new ClassInfo(type, fullClassNameBytes, packageBytes, simpleClassNameBytes, false, null, 0, 0);
            if (NonexistentClass.class.isAssignableFrom(TypeUtils.getComponentIfArray(type))) {
                classInfo.serializer = NonexistentClassSerializers.getSerializer(this.fory, qualifiedName, type);
            }
        }
        this.compositeClassNameBytes2ClassInfo.put(typeNameBytes, classInfo);
        return classInfo;
    }

    @Override
    public DescriptorGrouper createDescriptorGrouper(Collection<Descriptor> descriptors, boolean descriptorsGroupedOrdered, Function<Descriptor, Descriptor> descriptorUpdator) {
        return DescriptorGrouper.createDescriptorGrouper(clz -> {
            ClassInfo classInfo = this.getClassInfo((Class<?>)clz, false);
            if (classInfo == null || clz.isEnum()) {
                return false;
            }
            byte foryTypeId = (byte)(classInfo.xtypeId & 0xFF);
            if (foryTypeId == 0 || foryTypeId == 63 || Types.isUserDefinedType(foryTypeId)) {
                return false;
            }
            return foryTypeId != 21 && foryTypeId != 22 && foryTypeId != 23;
        }, descriptors, descriptorsGroupedOrdered, descriptorUpdator, this.fory.compressInt(), this.fory.compressLong(), (o1, o2) -> {
            int xtypeId2;
            int xtypeId = this.getXtypeId(o1.getRawType());
            if (xtypeId == (xtypeId2 = this.getXtypeId(o2.getRawType()))) {
                return o1.getSnakeCaseName().compareTo(o2.getSnakeCaseName());
            }
            return xtypeId - xtypeId2;
        }).setOtherDescriptorComparator(Comparator.comparing(Descriptor::getSnakeCaseName)).sort();
    }

    private int getXtypeId(Class<?> cls) {
        if (this.isSet(cls)) {
            return 22;
        }
        if (this.isCollection(cls)) {
            return 21;
        }
        if (cls.isArray() && !cls.getComponentType().isPrimitive()) {
            return 21;
        }
        if (this.isMap(cls)) {
            return 23;
        }
        if (this.fory.getXtypeResolver().isRegistered(cls)) {
            return this.fory.getXtypeResolver().getClassInfo(cls).getXtypeId();
        }
        if (cls.isEnum()) {
            return 13;
        }
        if (cls.isArray()) {
            return 21;
        }
        if (ReflectionUtils.isMonomorphic(cls)) {
            throw new UnsupportedOperationException(cls + " is not supported for xlang serialization");
        }
        return 63;
    }

    public List<Descriptor> getFieldDescriptors(Class<?> clz, boolean searchParent) {
        return this.classResolver.getFieldDescriptors((Class)clz, searchParent);
    }

    @Override
    public ClassDef getTypeDef(Class<?> cls, boolean resolveParent) {
        return this.classResolver.getTypeDef(cls, resolveParent);
    }

    @Override
    public Class<? extends Serializer> getSerializerClass(Class<?> cls) {
        return this.getSerializer(cls).getClass();
    }

    @Override
    public Class<? extends Serializer> getSerializerClass(Class<?> cls, boolean codegen) {
        return this.getSerializer(cls).getClass();
    }

    private boolean isEnum(int internalTypeId) {
        return internalTypeId == 13 || internalTypeId == 14;
    }
}

