/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer;

import java.util.function.Supplier;
import org.apache.fory.Fory;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.serializer.Serializer;

public class LazySerializer
extends Serializer {
    private final Supplier<Serializer> serializerSupplier;
    private Serializer serializer;

    public LazySerializer(Fory fory, Class type, Supplier<Serializer> serializerSupplier) {
        super(fory, type);
        this.serializerSupplier = serializerSupplier;
    }

    public void write(MemoryBuffer buffer, Object value) {
        if (this.serializer == null) {
            this.serializer = this.serializerSupplier.get();
            this.fory.getClassResolver().setSerializer(value.getClass(), this.serializer);
        }
        this.serializer.write(buffer, value);
    }

    public Object read(MemoryBuffer buffer) {
        boolean unInit;
        boolean bl = unInit = this.serializer == null;
        if (unInit) {
            this.serializer = this.serializerSupplier.get();
        }
        Object value = this.serializer.read(buffer);
        if (unInit) {
            this.fory.getClassResolver().setSerializer(value.getClass(), this.serializer);
        }
        return value;
    }

    public void xwrite(MemoryBuffer buffer, Object value) {
        if (this.serializer == null) {
            this.serializer = this.serializerSupplier.get();
            this.fory.getClassResolver().setSerializer(value.getClass(), this.serializer);
            this.fory.getXtypeResolver().getClassInfo(value.getClass()).setSerializer(this.serializer);
        }
        this.serializer.xwrite(buffer, value);
    }

    public Object xread(MemoryBuffer buffer) {
        boolean unInit;
        boolean bl = unInit = this.serializer == null;
        if (unInit) {
            this.serializer = this.serializerSupplier.get();
        }
        Object value = this.serializer.xread(buffer);
        if (unInit) {
            this.fory.getClassResolver().setSerializer(value.getClass(), this.serializer);
            this.fory.getXtypeResolver().getClassInfo(value.getClass()).setSerializer(this.serializer);
        }
        return value;
    }

    public Object copy(Object value) {
        if (this.serializer == null) {
            this.serializer = this.serializerSupplier.get();
            this.fory.getClassResolver().setSerializer(value.getClass(), this.serializer);
        }
        return this.serializer.copy(value);
    }

    public static class LazyObjectSerializer
    extends LazySerializer {
        public LazyObjectSerializer(Fory fory, Class type, Supplier<Serializer> serializerSupplier) {
            super(fory, type, serializerSupplier);
        }
    }
}

