/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer.collection;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.fory.Fory;
import org.apache.fory.collection.CollectionSnapshot;
import org.apache.fory.exception.ForyException;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.memory.Platform;
import org.apache.fory.reflect.ReflectionUtils;
import org.apache.fory.resolver.ClassInfo;
import org.apache.fory.resolver.ClassInfoHolder;
import org.apache.fory.resolver.ClassResolver;
import org.apache.fory.resolver.RefResolver;
import org.apache.fory.serializer.ReplaceResolveSerializer;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.serializer.Serializers;
import org.apache.fory.serializer.collection.CollectionContainer;
import org.apache.fory.serializer.collection.CollectionLikeSerializer;
import org.apache.fory.serializer.collection.CollectionSerializer;
import org.apache.fory.serializer.collection.ConcurrentCollectionSerializer;
import org.apache.fory.serializer.collection.MapLikeSerializer;
import org.apache.fory.util.Preconditions;
import org.apache.fory.util.unsafe._JDKAccess;

public class CollectionSerializers {
    public static void registerDefaultSerializers(Fory fory) {
        ClassResolver resolver = fory.getClassResolver();
        resolver.registerSerializer(ArrayList.class, new ArrayListSerializer(fory));
        Class<List<?>> arrayAsListClass = Arrays.asList(1, 2).getClass();
        resolver.registerSerializer(arrayAsListClass, new ArraysAsListSerializer(fory, arrayAsListClass));
        resolver.registerSerializer(LinkedList.class, new CollectionSerializer<LinkedList>(fory, LinkedList.class, true));
        resolver.registerSerializer(HashSet.class, new HashSetSerializer(fory));
        resolver.registerSerializer(LinkedHashSet.class, new LinkedHashSetSerializer(fory));
        resolver.registerSerializer(TreeSet.class, new SortedSetSerializer<TreeSet>(fory, TreeSet.class));
        resolver.registerSerializer(Collections.EMPTY_LIST.getClass(), new EmptyListSerializer(fory, Collections.EMPTY_LIST.getClass()));
        resolver.registerSerializer(Collections.emptySortedSet().getClass(), new EmptySortedSetSerializer(fory, Collections.emptySortedSet().getClass()));
        resolver.registerSerializer(Collections.EMPTY_SET.getClass(), new EmptySetSerializer(fory, Collections.EMPTY_SET.getClass()));
        resolver.registerSerializer(Collections.singletonList(null).getClass(), new CollectionsSingletonListSerializer(fory, Collections.singletonList(null).getClass()));
        resolver.registerSerializer(Collections.singleton(null).getClass(), new CollectionsSingletonSetSerializer(fory, Collections.singleton(null).getClass()));
        resolver.registerSerializer(ConcurrentSkipListSet.class, new ConcurrentSkipListSetSerializer(fory, ConcurrentSkipListSet.class));
        resolver.registerSerializer(Vector.class, new VectorSerializer(fory, Vector.class));
        resolver.registerSerializer(ArrayDeque.class, new ArrayDequeSerializer(fory, ArrayDeque.class));
        resolver.registerSerializer(BitSet.class, new BitSetSerializer(fory, BitSet.class));
        resolver.registerSerializer(PriorityQueue.class, new PriorityQueueSerializer(fory, PriorityQueue.class));
        resolver.registerSerializer(CopyOnWriteArrayList.class, new CopyOnWriteArrayListSerializer(fory, CopyOnWriteArrayList.class));
        Class<Set<?>> setFromMapClass = Collections.newSetFromMap(new HashMap()).getClass();
        resolver.registerSerializer(setFromMapClass, new SetFromMapSerializer(fory, setFromMapClass));
        resolver.registerSerializer(ConcurrentHashMap.KeySetView.class, new ConcurrentHashMapKeySetViewSerializer(fory, ConcurrentHashMap.KeySetView.class));
    }

    public static final class ArrayListSerializer
    extends CollectionSerializer<ArrayList> {
        public ArrayListSerializer(Fory fory) {
            super(fory, ArrayList.class, true);
        }

        @Override
        public ArrayList newCollection(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            this.setNumElements(numElements);
            ArrayList arrayList = new ArrayList(numElements);
            this.fory.getRefResolver().reference(arrayList);
            return arrayList;
        }
    }

    public static final class ArraysAsListSerializer
    extends CollectionSerializer<List<?>> {
        private static final long arrayFieldOffset;

        public ArraysAsListSerializer(Fory fory, Class<List<?>> cls) {
            super(fory, cls, fory.isCrossLanguage());
        }

        @Override
        public List<?> copy(List<?> originCollection) {
            Object[] elements = new Object[originCollection.size()];
            List<Object> newCollection = Arrays.asList(elements);
            if (this.needToCopyRef) {
                this.fory.reference(originCollection, newCollection);
            }
            this.copyElements(originCollection, elements);
            return newCollection;
        }

        @Override
        public void write(MemoryBuffer buffer, List<?> value) {
            try {
                Object[] array = (Object[])Platform.getObject(value, arrayFieldOffset);
                this.fory.writeRef(buffer, array);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public List<?> read(MemoryBuffer buffer) {
            Object[] array = (Object[])this.fory.readRef(buffer);
            Preconditions.checkNotNull(array);
            return Arrays.asList(array);
        }

        @Override
        public void xwrite(MemoryBuffer buffer, List<?> value) {
            super.write(buffer, value);
        }

        @Override
        public List<?> xread(MemoryBuffer buffer) {
            return (List)super.read(buffer);
        }

        @Override
        public ArrayList newCollection(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            this.setNumElements(numElements);
            ArrayList arrayList = new ArrayList(numElements);
            this.fory.getRefResolver().reference(arrayList);
            return arrayList;
        }

        static {
            try {
                Field arrayField = Class.forName("java.util.Arrays$ArrayList").getDeclaredField("a");
                arrayFieldOffset = Platform.objectFieldOffset(arrayField);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static final class HashSetSerializer
    extends CollectionSerializer<HashSet> {
        public HashSetSerializer(Fory fory) {
            super(fory, HashSet.class, true);
        }

        @Override
        public HashSet newCollection(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            this.setNumElements(numElements);
            HashSet hashSet = new HashSet(numElements);
            this.fory.getRefResolver().reference(hashSet);
            return hashSet;
        }
    }

    public static final class LinkedHashSetSerializer
    extends CollectionSerializer<LinkedHashSet> {
        public LinkedHashSetSerializer(Fory fory) {
            super(fory, LinkedHashSet.class, true);
        }

        @Override
        public LinkedHashSet newCollection(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            this.setNumElements(numElements);
            LinkedHashSet hashSet = new LinkedHashSet(numElements);
            this.fory.getRefResolver().reference(hashSet);
            return hashSet;
        }
    }

    public static class SortedSetSerializer<T extends SortedSet>
    extends CollectionSerializer<T> {
        private MethodHandle constructor;

        public SortedSetSerializer(Fory fory, Class<T> cls) {
            super(fory, cls, true);
            if (cls != TreeSet.class) {
                try {
                    this.constructor = ReflectionUtils.getCtrHandle(cls, Comparator.class);
                }
                catch (Exception e) {
                    throw new UnsupportedOperationException(e);
                }
            }
        }

        @Override
        public Collection onCollectionWrite(MemoryBuffer buffer, T value) {
            buffer.writeVarUint32Small7(value.size());
            if (!this.fory.isCrossLanguage()) {
                this.fory.writeRef(buffer, value.comparator());
            }
            return value;
        }

        public T newCollection(MemoryBuffer buffer) {
            SortedSet collection;
            assert (!this.fory.isCrossLanguage());
            int numElements = buffer.readVarUint32Small7();
            this.setNumElements(numElements);
            Comparator comparator = (Comparator)this.fory.readRef(buffer);
            if (this.type == TreeSet.class) {
                collection = new TreeSet(comparator);
            } else {
                try {
                    collection = this.constructor.invoke(comparator);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            this.fory.getRefResolver().reference(collection);
            return (T)collection;
        }

        @Override
        public Collection newCollection(Collection originCollection) {
            SortedSet collection;
            Comparator comparator = this.fory.copyObject(((SortedSet)originCollection).comparator());
            if (Objects.equals(this.type, TreeSet.class)) {
                collection = new TreeSet(comparator);
            } else {
                try {
                    collection = this.constructor.invoke(comparator);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            return collection;
        }
    }

    public static final class EmptyListSerializer
    extends CollectionSerializer<List<?>> {
        public EmptyListSerializer(Fory fory, Class<List<?>> cls) {
            super(fory, cls, false, true);
        }

        @Override
        public void write(MemoryBuffer buffer, List<?> value) {
        }

        @Override
        public void xwrite(MemoryBuffer buffer, List<?> value) {
            buffer.writeVarUint32Small7(0);
        }

        @Override
        public List<?> read(MemoryBuffer buffer) {
            return Collections.EMPTY_LIST;
        }

        @Override
        public List<?> xread(MemoryBuffer buffer) {
            buffer.readVarUint32Small7();
            return Collections.EMPTY_LIST;
        }
    }

    public static final class EmptySortedSetSerializer
    extends CollectionSerializer<SortedSet<?>> {
        public EmptySortedSetSerializer(Fory fory, Class<SortedSet<?>> cls) {
            super(fory, cls, fory.isCrossLanguage(), true);
        }

        @Override
        public void write(MemoryBuffer buffer, SortedSet<?> value) {
        }

        @Override
        public SortedSet<?> read(MemoryBuffer buffer) {
            return Collections.emptySortedSet();
        }

        @Override
        public void xwrite(MemoryBuffer buffer, SortedSet<?> value) {
            super.write(buffer, value);
        }

        @Override
        public SortedSet<?> xread(MemoryBuffer buffer) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class EmptySetSerializer
    extends CollectionSerializer<Set<?>> {
        public EmptySetSerializer(Fory fory, Class<Set<?>> cls) {
            super(fory, cls, fory.isCrossLanguage(), true);
        }

        @Override
        public void write(MemoryBuffer buffer, Set<?> value) {
        }

        @Override
        public void xwrite(MemoryBuffer buffer, Set<?> value) {
            super.write(buffer, value);
        }

        @Override
        public Set<?> read(MemoryBuffer buffer) {
            return Collections.EMPTY_SET;
        }

        @Override
        public Set<?> xread(MemoryBuffer buffer) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class CollectionsSingletonListSerializer
    extends CollectionSerializer<List<?>> {
        public CollectionsSingletonListSerializer(Fory fory, Class<List<?>> cls) {
            super(fory, cls, fory.isCrossLanguage());
        }

        @Override
        public List<?> copy(List<?> originCollection) {
            return Collections.singletonList(this.fory.copyObject(originCollection.get(0)));
        }

        @Override
        public void write(MemoryBuffer buffer, List<?> value) {
            this.fory.writeRef(buffer, value.get(0));
        }

        @Override
        public void xwrite(MemoryBuffer buffer, List<?> value) {
            super.write(buffer, value);
        }

        @Override
        public List<?> read(MemoryBuffer buffer) {
            return Collections.singletonList(this.fory.readRef(buffer));
        }

        @Override
        public List<?> xread(MemoryBuffer buffer) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class CollectionsSingletonSetSerializer
    extends CollectionSerializer<Set<?>> {
        public CollectionsSingletonSetSerializer(Fory fory, Class<Set<?>> cls) {
            super(fory, cls, fory.isCrossLanguage());
        }

        @Override
        public Set<?> copy(Set<?> originCollection) {
            return Collections.singleton(this.fory.copyObject(originCollection.iterator().next()));
        }

        @Override
        public void write(MemoryBuffer buffer, Set<?> value) {
            this.fory.writeRef(buffer, value.iterator().next());
        }

        @Override
        public void xwrite(MemoryBuffer buffer, Set<?> value) {
            super.write(buffer, value);
        }

        @Override
        public Set<?> read(MemoryBuffer buffer) {
            return Collections.singleton(this.fory.readRef(buffer));
        }

        @Override
        public Set<?> xread(MemoryBuffer buffer) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class ConcurrentSkipListSetSerializer
    extends ConcurrentCollectionSerializer<ConcurrentSkipListSet> {
        public ConcurrentSkipListSetSerializer(Fory fory, Class<ConcurrentSkipListSet> cls) {
            super(fory, cls, true);
        }

        @Override
        public CollectionSnapshot onCollectionWrite(MemoryBuffer buffer, ConcurrentSkipListSet value) {
            Collection snapshot = super.onCollectionWrite(buffer, value);
            if (!this.fory.isCrossLanguage()) {
                this.fory.writeRef(buffer, value.comparator());
            }
            return snapshot;
        }

        @Override
        public ConcurrentSkipListSet newCollection(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            this.setNumElements(numElements);
            assert (!this.fory.isCrossLanguage());
            RefResolver refResolver = this.fory.getRefResolver();
            int refId = refResolver.lastPreservedRefId();
            Comparator comparator = (Comparator)this.fory.readRef(buffer);
            ConcurrentSkipListSet skipListSet = new ConcurrentSkipListSet(comparator);
            refResolver.setReadObject(refId, skipListSet);
            return skipListSet;
        }
    }

    public static final class VectorSerializer
    extends CollectionSerializer<Vector> {
        public VectorSerializer(Fory fory, Class<Vector> cls) {
            super(fory, cls, true);
        }

        @Override
        public Vector newCollection(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            this.setNumElements(numElements);
            Vector vector = new Vector(numElements);
            this.fory.getRefResolver().reference(vector);
            return vector;
        }
    }

    public static final class ArrayDequeSerializer
    extends CollectionSerializer<ArrayDeque> {
        public ArrayDequeSerializer(Fory fory, Class<ArrayDeque> cls) {
            super(fory, cls, true);
        }

        @Override
        public ArrayDeque newCollection(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            this.setNumElements(numElements);
            ArrayDeque deque = new ArrayDeque(numElements);
            this.fory.getRefResolver().reference(deque);
            return deque;
        }
    }

    public static class BitSetSerializer
    extends Serializer<BitSet> {
        public BitSetSerializer(Fory fory, Class<BitSet> type) {
            super(fory, type);
        }

        @Override
        public void write(MemoryBuffer buffer, BitSet set) {
            long[] values = set.toLongArray();
            buffer.writePrimitiveArrayWithSize(values, Platform.LONG_ARRAY_OFFSET, Math.multiplyExact(values.length, 8));
        }

        @Override
        public BitSet copy(BitSet originCollection) {
            return BitSet.valueOf(originCollection.toLongArray());
        }

        @Override
        public BitSet read(MemoryBuffer buffer) {
            long[] values = buffer.readLongs(buffer.readVarUint32Small7());
            return BitSet.valueOf(values);
        }
    }

    public static class PriorityQueueSerializer
    extends CollectionSerializer<PriorityQueue> {
        public PriorityQueueSerializer(Fory fory, Class<PriorityQueue> cls) {
            super(fory, cls, true);
        }

        @Override
        public Collection onCollectionWrite(MemoryBuffer buffer, PriorityQueue value) {
            buffer.writeVarUint32Small7(value.size());
            if (!this.fory.isCrossLanguage()) {
                this.fory.writeRef(buffer, value.comparator());
            }
            return value;
        }

        @Override
        public Collection newCollection(Collection collection) {
            return new PriorityQueue(collection.size(), this.fory.copyObject(((PriorityQueue)collection).comparator()));
        }

        @Override
        public PriorityQueue newCollection(MemoryBuffer buffer) {
            assert (!this.fory.isCrossLanguage());
            int numElements = buffer.readVarUint32Small7();
            this.setNumElements(numElements);
            Comparator comparator = (Comparator)this.fory.readRef(buffer);
            PriorityQueue queue = new PriorityQueue(comparator);
            this.fory.getRefResolver().reference(queue);
            return queue;
        }
    }

    public static class CopyOnWriteArrayListSerializer
    extends ConcurrentCollectionSerializer<CopyOnWriteArrayList> {
        public CopyOnWriteArrayListSerializer(Fory fory, Class<CopyOnWriteArrayList> type) {
            super(fory, type, true);
        }

        @Override
        public Collection newCollection(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            this.setNumElements(numElements);
            return new CollectionContainer(numElements);
        }

        @Override
        public CopyOnWriteArrayList onCollectionRead(Collection collection) {
            Object[] elements = ((CollectionContainer)collection).elements;
            return new CopyOnWriteArrayList<Object>(elements);
        }
    }

    public static final class SetFromMapSerializer
    extends CollectionSerializer<Set<?>> {
        private static final long MAP_FIELD_OFFSET;
        private static final List EMPTY_COLLECTION_STUB;
        private static final MethodHandle m;
        private static final MethodHandle s;

        public SetFromMapSerializer(Fory fory, Class<Set<?>> type) {
            super(fory, type, true);
        }

        @Override
        public Collection newCollection(MemoryBuffer buffer) {
            Set set;
            ClassInfo mapClassInfo = this.fory.getClassResolver().readClassInfo(buffer);
            MapLikeSerializer mapSerializer = (MapLikeSerializer)mapClassInfo.getSerializer();
            RefResolver refResolver = this.fory.getRefResolver();
            int refId = refResolver.lastPreservedRefId();
            if (buffer.readBoolean()) {
                refResolver.preserveRefId();
                set = Collections.newSetFromMap(mapSerializer.newMap(buffer));
                this.setNumElements(mapSerializer.getAndClearNumElements());
            } else {
                Map map = (Map)mapSerializer.read(buffer);
                try {
                    set = (Set)Platform.newInstance(this.type);
                    m.invoke(set, map);
                    s.invoke(set, map.keySet());
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                this.setNumElements(0);
            }
            refResolver.setReadObject(refId, set);
            return set;
        }

        @Override
        public Collection newCollection(Collection originCollection) {
            assert (!this.fory.isCrossLanguage());
            Map map = (Map)Platform.getObject(originCollection, MAP_FIELD_OFFSET);
            MapLikeSerializer mapSerializer = (MapLikeSerializer)this.fory.getClassResolver().getSerializer(map.getClass());
            Map newMap = mapSerializer.newMap(map);
            return Collections.newSetFromMap(newMap);
        }

        @Override
        public Collection onCollectionWrite(MemoryBuffer buffer, Set<?> value) {
            Map map = (Map)Platform.getObject(value, MAP_FIELD_OFFSET);
            ClassInfo classInfo = this.fory.getClassResolver().getClassInfo(map.getClass());
            MapLikeSerializer mapSerializer = (MapLikeSerializer)classInfo.getSerializer();
            this.fory.getClassResolver().writeClassInfo(buffer, classInfo);
            if (mapSerializer.supportCodegenHook) {
                buffer.writeBoolean(true);
                mapSerializer.onMapWrite(buffer, map);
                return value;
            }
            buffer.writeBoolean(false);
            mapSerializer.write(buffer, map);
            return EMPTY_COLLECTION_STUB;
        }

        static {
            EMPTY_COLLECTION_STUB = new ArrayList();
            try {
                Class<?> type = Class.forName("java.util.Collections$SetFromMap");
                Field mapField = type.getDeclaredField("m");
                MAP_FIELD_OFFSET = Platform.objectFieldOffset(mapField);
                MethodHandles.Lookup lookup = _JDKAccess._trustedLookup(type);
                m = lookup.findSetter(type, "m", Map.class);
                s = lookup.findSetter(type, "s", Set.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static final class ConcurrentHashMapKeySetViewSerializer
    extends CollectionSerializer<ConcurrentHashMap.KeySetView> {
        private final ClassInfoHolder mapClassInfoHolder;
        private final ClassInfoHolder valueClassInfoHolder;

        public ConcurrentHashMapKeySetViewSerializer(Fory fory, Class<ConcurrentHashMap.KeySetView> type) {
            super(fory, type, false);
            this.mapClassInfoHolder = fory.getClassResolver().nilClassInfoHolder();
            this.valueClassInfoHolder = fory.getClassResolver().nilClassInfoHolder();
        }

        @Override
        public void write(MemoryBuffer buffer, ConcurrentHashMap.KeySetView value) {
            this.fory.writeRef(buffer, (Object)value.getMap(), this.mapClassInfoHolder);
            this.fory.writeRef(buffer, value.getMappedValue(), this.valueClassInfoHolder);
        }

        @Override
        public ConcurrentHashMap.KeySetView read(MemoryBuffer buffer) {
            ConcurrentHashMap map = (ConcurrentHashMap)this.fory.readRef(buffer, this.mapClassInfoHolder);
            Object value = this.fory.readRef(buffer, this.valueClassInfoHolder);
            return map.keySet(value);
        }

        @Override
        public ConcurrentHashMap.KeySetView copy(ConcurrentHashMap.KeySetView value) {
            ConcurrentHashMap newMap = this.fory.copyObject(value.getMap());
            return newMap.keySet(this.fory.copyObject(value.getMappedValue()));
        }

        @Override
        public Collection newCollection(MemoryBuffer buffer) {
            throw new IllegalStateException("Should not be invoked since we set supportCodegenHook to false");
        }
    }

    public static class XlangSetDefaultSerializer
    extends XlangCollectionDefaultSerializer {
        public XlangSetDefaultSerializer(Fory fory, Class cls) {
            super(fory, cls);
        }

        @Override
        public Set newCollection(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            this.setNumElements(numElements);
            HashSet set = new HashSet(numElements);
            this.fory.getRefResolver().reference(set);
            return set;
        }
    }

    public static class XlangListDefaultSerializer
    extends XlangCollectionDefaultSerializer {
        public XlangListDefaultSerializer(Fory fory, Class cls) {
            super(fory, cls);
        }

        @Override
        public List newCollection(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            this.setNumElements(numElements);
            ArrayList list = new ArrayList(numElements);
            this.fory.getRefResolver().reference(list);
            return list;
        }
    }

    public static abstract class XlangCollectionDefaultSerializer
    extends CollectionLikeSerializer {
        public XlangCollectionDefaultSerializer(Fory fory, Class cls) {
            super(fory, cls);
        }

        public Collection onCollectionWrite(MemoryBuffer buffer, Object value) {
            Collection v = (Collection)value;
            buffer.writeVarUint32Small7(v.size());
            return v;
        }

        public Object onCollectionRead(Collection collection) {
            return collection;
        }
    }

    public static final class JDKCompatibleCollectionSerializer<T>
    extends CollectionLikeSerializer<T> {
        private final Serializer serializer;

        public JDKCompatibleCollectionSerializer(Fory fory, Class<T> cls) {
            super(fory, cls, false);
            Class serializerType = ClassResolver.useReplaceResolveSerializer(cls) ? ReplaceResolveSerializer.class : fory.getDefaultJDKStreamSerializerType();
            this.serializer = Serializers.newSerializer(fory, cls, serializerType);
        }

        @Override
        public Collection onCollectionWrite(MemoryBuffer buffer, T value) {
            throw new IllegalStateException();
        }

        @Override
        public T read(MemoryBuffer buffer) {
            return this.serializer.read(buffer);
        }

        @Override
        public T onCollectionRead(Collection collection) {
            throw new IllegalStateException();
        }

        @Override
        public void write(MemoryBuffer buffer, T value) {
            this.serializer.write(buffer, value);
        }

        @Override
        public T copy(T value) {
            return this.fory.copyObject(value, this.serializer);
        }
    }

    public static final class DefaultJavaCollectionSerializer<T>
    extends CollectionLikeSerializer<T> {
        private Serializer<T> dataSerializer;

        public DefaultJavaCollectionSerializer(Fory fory, Class<T> cls) {
            super(fory, cls, false);
            Preconditions.checkArgument(!fory.isCrossLanguage(), "Fory cross-language default collection serializer should use " + CollectionSerializer.class);
            fory.getClassResolver().setSerializer(cls, this);
            Class<? extends Serializer> serializerClass = fory.getClassResolver().getObjectSerializerClass(cls, sc -> {
                this.dataSerializer = Serializers.newSerializer(fory, cls, sc);
            });
            this.dataSerializer = Serializers.newSerializer(fory, cls, serializerClass);
        }

        @Override
        public Collection onCollectionWrite(MemoryBuffer buffer, T value) {
            throw new IllegalStateException();
        }

        @Override
        public T onCollectionRead(Collection collection) {
            throw new IllegalStateException();
        }

        @Override
        public void write(MemoryBuffer buffer, T value) {
            this.dataSerializer.write(buffer, value);
        }

        @Override
        public T copy(T originCollection) {
            return this.fory.copyObject(originCollection, this.dataSerializer);
        }

        @Override
        public T read(MemoryBuffer buffer) {
            return this.dataSerializer.read(buffer);
        }
    }

    public static class EnumSetSerializer
    extends CollectionSerializer<EnumSet> {
        public EnumSetSerializer(Fory fory, Class<EnumSet> type) {
            super(fory, type, false);
        }

        @Override
        public void write(MemoryBuffer buffer, EnumSet object) {
            Class<?> elemClass;
            if (object.isEmpty()) {
                EnumSet tmp = EnumSet.complementOf(object);
                if (tmp.isEmpty()) {
                    throw new ForyException("An EnumSet must have a defined Enum to be serialized.");
                }
                elemClass = tmp.iterator().next().getClass();
            } else {
                elemClass = object.iterator().next().getClass();
            }
            this.fory.getClassResolver().writeClassAndUpdateCache(buffer, elemClass);
            Serializer<?> serializer = this.fory.getClassResolver().getSerializer(elemClass);
            buffer.writeVarUint32Small7(object.size());
            for (Object element : object) {
                serializer.write(buffer, element);
            }
        }

        @Override
        public EnumSet read(MemoryBuffer buffer) {
            Class<?> elemClass = this.fory.getClassResolver().readClassInfo(buffer).getCls();
            EnumSet<?> object = EnumSet.noneOf(elemClass);
            Serializer<?> elemSerializer = this.fory.getClassResolver().getSerializer(elemClass);
            int length = buffer.readVarUint32Small7();
            for (int i = 0; i < length; ++i) {
                object.add(elemSerializer.read(buffer));
            }
            return object;
        }

        @Override
        public EnumSet copy(EnumSet originCollection) {
            return EnumSet.copyOf(originCollection);
        }
    }
}

