/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.type;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.fory.type.Descriptor;
import org.apache.fory.type.TypeUtils;
import org.apache.fory.type.Types;
import org.apache.fory.util.Preconditions;
import org.apache.fory.util.record.RecordUtils;

public class DescriptorGrouper {
    static final Comparator<Descriptor> COMPARATOR_BY_PRIMITIVE_TYPE_ID = (d1, d2) -> {
        int c = Types.getPrimitiveTypeId(TypeUtils.unwrap(d2.getRawType())) - Types.getPrimitiveTypeId(TypeUtils.unwrap(d1.getRawType()));
        if (c == 0 && (c = d1.getSnakeCaseName().compareTo(d2.getSnakeCaseName())) == 0) {
            c = d1.getDeclaringClass().compareTo(d2.getDeclaringClass());
        }
        return c;
    };
    private final Collection<Descriptor> descriptors;
    private final Predicate<Class<?>> isMonomorphic;
    private final Function<Descriptor, Descriptor> descriptorUpdater;
    private final boolean descriptorsGroupedOrdered;
    private boolean sorted = false;
    public static final Comparator<Descriptor> COMPARATOR_BY_TYPE_AND_NAME = (d1, d2) -> {
        int c = d1.getTypeName().compareTo(d2.getTypeName());
        if (c == 0 && (c = d1.getName().compareTo(d2.getName())) == 0) {
            c = d1.getDeclaringClass().compareTo(d2.getDeclaringClass());
        }
        return c;
    };
    private final Collection<Descriptor> primitiveDescriptors;
    private final Collection<Descriptor> boxedDescriptors;
    private final Collection<Descriptor> collectionDescriptors;
    private final Collection<Descriptor> mapDescriptors;
    private final Collection<Descriptor> finalDescriptors;
    private Collection<Descriptor> otherDescriptors;

    public static Comparator<Descriptor> getPrimitiveComparator(boolean compressInt, boolean compressLong) {
        if (!compressInt && !compressLong) {
            return (d1, d2) -> {
                int c = TypeUtils.getSizeOfPrimitiveType(TypeUtils.unwrap(d2.getRawType())) - TypeUtils.getSizeOfPrimitiveType(TypeUtils.unwrap(d1.getRawType()));
                if (c == 0) {
                    c = COMPARATOR_BY_PRIMITIVE_TYPE_ID.compare((Descriptor)d1, (Descriptor)d2);
                }
                return c;
            };
        }
        return (d1, d2) -> {
            Class<?> t1 = TypeUtils.unwrap(d1.getRawType());
            Class<?> t2 = TypeUtils.unwrap(d2.getRawType());
            boolean t1Compress = DescriptorGrouper.isCompressedType(t1, compressInt, compressLong);
            boolean t2Compress = DescriptorGrouper.isCompressedType(t2, compressInt, compressLong);
            if (t1Compress && t2Compress || !t1Compress && !t2Compress) {
                int c = TypeUtils.getSizeOfPrimitiveType(t2) - TypeUtils.getSizeOfPrimitiveType(t1);
                if (c == 0) {
                    c = COMPARATOR_BY_PRIMITIVE_TYPE_ID.compare((Descriptor)d1, (Descriptor)d2);
                }
                return c;
            }
            if (t1Compress) {
                return 1;
            }
            return -1;
        };
    }

    private static boolean isCompressedType(Class<?> cls, boolean compressInt, boolean compressLong) {
        if ((cls = TypeUtils.unwrap(cls)) == Integer.TYPE) {
            return compressInt;
        }
        if (cls == Long.TYPE) {
            return compressLong;
        }
        return false;
    }

    private DescriptorGrouper(Predicate<Class<?>> isMonomorphic, Collection<Descriptor> descriptors, boolean descriptorsGroupedOrdered, Function<Descriptor, Descriptor> descriptorUpdater, Comparator<Descriptor> primitiveComparator, Comparator<Descriptor> comparator) {
        this.descriptors = descriptors;
        this.isMonomorphic = isMonomorphic;
        this.descriptorUpdater = descriptorUpdater;
        this.descriptorsGroupedOrdered = descriptorsGroupedOrdered;
        this.primitiveDescriptors = descriptorsGroupedOrdered ? new ArrayList() : new TreeSet<Descriptor>(primitiveComparator);
        this.boxedDescriptors = descriptorsGroupedOrdered ? new ArrayList() : new TreeSet<Descriptor>(primitiveComparator);
        this.collectionDescriptors = descriptorsGroupedOrdered ? new ArrayList() : new TreeSet<Descriptor>(comparator);
        this.mapDescriptors = descriptorsGroupedOrdered ? new ArrayList() : new TreeSet<Descriptor>(comparator);
        this.finalDescriptors = descriptorsGroupedOrdered ? new ArrayList() : new TreeSet<Descriptor>(comparator);
        this.otherDescriptors = descriptorsGroupedOrdered ? new ArrayList() : new TreeSet<Descriptor>(comparator);
    }

    public DescriptorGrouper setOtherDescriptorComparator(Comparator<Descriptor> comparator) {
        Preconditions.checkArgument(!this.sorted);
        this.otherDescriptors = this.descriptorsGroupedOrdered ? new ArrayList() : new TreeSet<Descriptor>(comparator);
        return this;
    }

    public DescriptorGrouper sort() {
        if (this.sorted) {
            return this;
        }
        for (Descriptor descriptor : this.descriptors) {
            if (TypeUtils.isPrimitive(descriptor.getRawType())) {
                this.primitiveDescriptors.add(this.descriptorUpdater.apply(descriptor));
                continue;
            }
            if (TypeUtils.isBoxed(descriptor.getRawType())) {
                this.boxedDescriptors.add(this.descriptorUpdater.apply(descriptor));
                continue;
            }
            if (TypeUtils.isCollection(descriptor.getRawType())) {
                this.collectionDescriptors.add(this.descriptorUpdater.apply(descriptor));
                continue;
            }
            if (TypeUtils.isMap(descriptor.getRawType())) {
                this.mapDescriptors.add(this.descriptorUpdater.apply(descriptor));
                continue;
            }
            if (this.isMonomorphic.test(descriptor.getRawType())) {
                this.finalDescriptors.add(this.descriptorUpdater.apply(descriptor));
                continue;
            }
            this.otherDescriptors.add(this.descriptorUpdater.apply(descriptor));
        }
        this.sorted = true;
        return this;
    }

    public List<Descriptor> getSortedDescriptors() {
        Preconditions.checkArgument(this.sorted);
        ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>(this.getNumDescriptors());
        descriptors.addAll(this.getPrimitiveDescriptors());
        descriptors.addAll(this.getBoxedDescriptors());
        descriptors.addAll(this.getFinalDescriptors());
        descriptors.addAll(this.getCollectionDescriptors());
        descriptors.addAll(this.getMapDescriptors());
        descriptors.addAll(this.getOtherDescriptors());
        return descriptors;
    }

    public Collection<Descriptor> getPrimitiveDescriptors() {
        Preconditions.checkArgument(this.sorted);
        return this.primitiveDescriptors;
    }

    public Collection<Descriptor> getBoxedDescriptors() {
        Preconditions.checkArgument(this.sorted);
        return this.boxedDescriptors;
    }

    public Collection<Descriptor> getCollectionDescriptors() {
        Preconditions.checkArgument(this.sorted);
        return this.collectionDescriptors;
    }

    public Collection<Descriptor> getMapDescriptors() {
        Preconditions.checkArgument(this.sorted);
        return this.mapDescriptors;
    }

    public Collection<Descriptor> getFinalDescriptors() {
        Preconditions.checkArgument(this.sorted);
        return this.finalDescriptors;
    }

    public Collection<Descriptor> getOtherDescriptors() {
        Preconditions.checkArgument(this.sorted);
        return this.otherDescriptors;
    }

    private static Descriptor createDescriptor(Descriptor d) {
        Method readMethod = d.getReadMethod();
        if (readMethod != null && !RecordUtils.isRecord(readMethod.getDeclaringClass())) {
            readMethod = null;
        }
        if (readMethod == null && d.getWriteMethod() == null) {
            return d;
        }
        return d.copy(readMethod, null);
    }

    public static DescriptorGrouper createDescriptorGrouper(Predicate<Class<?>> isMonomorphic, Collection<Descriptor> descriptors, boolean descriptorsGroupedOrdered, Function<Descriptor, Descriptor> descriptorUpdator, boolean compressInt, boolean compressLong, Comparator<Descriptor> comparator) {
        return new DescriptorGrouper(isMonomorphic, descriptors, descriptorsGroupedOrdered, descriptorUpdator == null ? DescriptorGrouper::createDescriptor : descriptorUpdator, DescriptorGrouper.getPrimitiveComparator(compressInt, compressLong), comparator);
    }

    public int getNumDescriptors() {
        Preconditions.checkArgument(this.sorted);
        return this.primitiveDescriptors.size() + this.boxedDescriptors.size() + this.collectionDescriptors.size() + this.mapDescriptors.size() + this.finalDescriptors.size() + this.otherDescriptors.size();
    }
}

