/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.type;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.apache.fory.annotation.Internal;
import org.apache.fory.reflect.TypeRef;
import org.apache.fory.type.CustomTypeRegistry;

@Internal
public class TypeResolutionContext {
    private final CustomTypeRegistry customTypeRegistry;
    private final LinkedHashSet<TypeRef<?>> walkedTypePath;
    private final boolean synthesizeInterfaces;

    public TypeResolutionContext(CustomTypeRegistry customTypeRegistry) {
        this(customTypeRegistry, false);
    }

    public TypeResolutionContext(CustomTypeRegistry customTypeRegistry, boolean synthesizeInterfaces) {
        this.customTypeRegistry = customTypeRegistry;
        this.synthesizeInterfaces = synthesizeInterfaces;
        this.walkedTypePath = new LinkedHashSet();
    }

    public TypeResolutionContext(CustomTypeRegistry customTypeRegistry, LinkedHashSet<TypeRef<?>> walkedTypePath, boolean synthesizeInterfaces) {
        this.customTypeRegistry = customTypeRegistry;
        this.walkedTypePath = walkedTypePath;
        this.synthesizeInterfaces = synthesizeInterfaces;
    }

    public CustomTypeRegistry getCustomTypeRegistry() {
        return this.customTypeRegistry;
    }

    public LinkedHashSet<TypeRef<?>> getWalkedTypePath() {
        return this.walkedTypePath;
    }

    public boolean isSynthesizeInterfaces() {
        return this.synthesizeInterfaces;
    }

    public TypeRef<?> getEnclosingType() {
        TypeRef result = TypeRef.of(Object.class);
        Iterator iterator = this.walkedTypePath.iterator();
        while (iterator.hasNext()) {
            TypeRef type;
            result = type = (TypeRef)iterator.next();
        }
        return result;
    }

    public TypeResolutionContext appendTypePath(TypeRef<?> ... typeRef) {
        LinkedHashSet newWalkedTypePath = new LinkedHashSet(this.walkedTypePath);
        newWalkedTypePath.addAll(Arrays.asList(typeRef));
        return new TypeResolutionContext(this.customTypeRegistry, newWalkedTypePath, this.synthesizeInterfaces);
    }

    public TypeResolutionContext appendTypePath(Class<?> clz) {
        return this.appendTypePath(TypeRef.of(clz));
    }

    public void checkNoCycle(Class<?> clz) {
        this.checkNoCycle(TypeRef.of(clz));
    }

    public void checkNoCycle(TypeRef<?> typeRef) {
        if (this.walkedTypePath.contains(typeRef) || this.walkedTypePath.contains(TypeRef.of(typeRef.getRawType()))) {
            throw new UnsupportedOperationException("cyclic type is not supported. walkedTypePath: " + this.walkedTypePath + " seen type: " + typeRef);
        }
    }
}

