/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.util;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.apache.fory.Fory;
import org.apache.fory.collection.ObjectArray;
import org.apache.fory.exception.DeserializationException;
import org.apache.fory.exception.ForyException;
import org.apache.fory.reflect.ReflectionUtils;
import org.apache.fory.resolver.MapRefResolver;

public class ExceptionUtils {
    private static final Field detailMessageField;

    public static StackOverflowError trySetStackOverflowErrorMessage(StackOverflowError e, String message) {
        if (detailMessageField != null) {
            ReflectionUtils.setObjectFieldValue((Object)e, detailMessageField, (Object)message);
            return e;
        }
        return e;
    }

    public static RuntimeException handleReadFailed(Fory fory, Throwable t) {
        if (fory.getRefResolver() instanceof MapRefResolver) {
            ObjectArray readObjects = ((MapRefResolver)fory.getRefResolver()).getReadObjects();
            List<Object> objects = Arrays.asList(readObjects.objects).subList(0, readObjects.size);
            throw new DeserializationException(objects, t);
        }
        if (!(t instanceof ForyException)) {
            throw new DeserializationException("Failed to deserialize input", t);
        }
        throw (ForyException)t;
    }

    public static void ignore(Object ... args) {
    }

    public static RuntimeException throwAnyway(Throwable t) {
        throw (RuntimeException)ExceptionUtils.throwEvadingChecks(t);
    }

    private static <E extends Throwable> E throwEvadingChecks(Throwable throwable) throws E {
        throw throwable;
    }

    static {
        try {
            detailMessageField = Throwable.class.getDeclaredField("detailMessage");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

