/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.util;

import com.google.common.collect.MapMaker;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.fory.Fory;
import org.apache.fory.annotation.Internal;
import org.apache.fory.util.GraalvmSupport;
import org.apache.fory.util.Preconditions;

@Internal
public final class LoaderBinding {
    private final Function<ClassLoader, Fory> foryFactory;
    private final HashMap<ClassLoader, Fory> foryMap = new HashMap();
    private final Map<ClassLoader, SoftReference<Fory>> forySoftMap = GraalvmSupport.IN_GRAALVM_NATIVE_IMAGE ? new ConcurrentHashMap<ClassLoader, SoftReference<Fory>>() : new MapMaker().weakKeys().makeMap();
    private Consumer<Fory> bindingCallback = f -> {};
    private ClassLoader loader;
    private Fory fory;

    public LoaderBinding(Function<ClassLoader, Fory> foryFactory) {
        this.foryFactory = foryFactory;
    }

    public Fory get() {
        return this.fory;
    }

    public void visitAllFory(Consumer<Fory> consumer) {
        if (this.forySoftMap.isEmpty()) {
            for (Fory f : this.foryMap.values()) {
                consumer.accept(f);
            }
        } else if (this.foryMap.isEmpty()) {
            for (SoftReference<Fory> ref : this.forySoftMap.values()) {
                Fory f = ref.get();
                if (f == null) continue;
                consumer.accept(f);
            }
        } else {
            HashSet<Fory> forySet = new HashSet<Fory>(this.foryMap.size());
            forySet.addAll(this.foryMap.values());
            for (SoftReference<Fory> ref : this.forySoftMap.values()) {
                Fory f = ref.get();
                if (f == null) continue;
                forySet.add(f);
            }
            for (Fory f : forySet) {
                consumer.accept(f);
            }
        }
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.setClassLoader(classLoader, StagingType.STRONG_STAGING);
    }

    public void setClassLoader(ClassLoader classLoader, StagingType stagingType) {
        if (this.loader != classLoader) {
            if (classLoader == null) {
                classLoader = Fory.class.getClassLoader();
            }
            this.loader = classLoader;
            switch (stagingType) {
                case NO_STAGING: {
                    this.fory = this.foryFactory.apply(classLoader);
                    this.bindingCallback.accept(this.fory);
                    break;
                }
                case SOFT_STAGING: {
                    Fory fory;
                    SoftReference<Fory> forySoftReference = this.forySoftMap.get(classLoader);
                    Fory fory2 = fory = forySoftReference == null ? null : forySoftReference.get();
                    if (fory == null) {
                        fory = this.foryFactory.apply(classLoader);
                        this.bindingCallback.accept(fory);
                        this.forySoftMap.put(classLoader, new SoftReference<Fory>(fory));
                    }
                    this.fory = fory;
                    break;
                }
                case STRONG_STAGING: {
                    Fory fory = this.foryMap.get(classLoader);
                    if (fory == null) {
                        fory = this.foryFactory.apply(classLoader);
                        this.bindingCallback.accept(fory);
                        this.foryMap.put(classLoader, fory);
                    }
                    this.fory = fory;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
    }

    public void clearClassLoader(ClassLoader classLoader) {
        this.foryMap.remove(classLoader);
        SoftReference<Fory> softReference = this.forySoftMap.remove(classLoader);
        if (softReference != null) {
            softReference.clear();
        }
        if (this.loader == classLoader) {
            this.loader = null;
            this.fory = null;
        }
    }

    public void register(Class<?> clz) {
        this.foryMap.values().forEach(fory -> fory.register(clz));
        this.bindingCallback = this.bindingCallback.andThen(fory -> fory.register(clz));
    }

    public void register(Class<?> clz, int id) {
        Preconditions.checkArgument(id < Short.MAX_VALUE);
        this.foryMap.values().forEach(fory -> fory.register(clz, (int)((short)id)));
        this.bindingCallback = this.bindingCallback.andThen(fory -> fory.register(clz, (int)((short)id)));
    }

    public void setBindingCallback(Consumer<Fory> bindingCallback) {
        this.bindingCallback = bindingCallback;
    }

    public static enum StagingType {
        NO_STAGING,
        SOFT_STAGING,
        STRONG_STAGING;

    }
}

