/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.builder;

import java.util.Collections;
import org.apache.fury.Fury;
import org.apache.fury.builder.BaseObjectCodecBuilder;
import org.apache.fury.builder.CompatibleCodecBuilder;
import org.apache.fury.builder.Generated;
import org.apache.fury.builder.MetaSharedCodecBuilder;
import org.apache.fury.builder.ObjectCodecBuilder;
import org.apache.fury.codegen.CodeGenerator;
import org.apache.fury.codegen.CompileUnit;
import org.apache.fury.meta.ClassDef;
import org.apache.fury.reflect.TypeRef;
import org.apache.fury.resolver.ClassResolver;
import org.apache.fury.resolver.FieldResolver;
import org.apache.fury.serializer.Serializer;
import org.apache.fury.util.ClassLoaderUtils;
import org.apache.fury.util.Preconditions;

public class CodecUtils {
    public static <T> Class<? extends Serializer<T>> loadOrGenObjectCodecClass(Class<T> cls, Fury fury) {
        Preconditions.checkNotNull(fury);
        ObjectCodecBuilder codecBuilder = new ObjectCodecBuilder(cls, fury);
        return CodecUtils.loadOrGenCodecClass(cls, fury, codecBuilder);
    }

    public static <T> Class<? extends Serializer<T>> loadOrGenMetaSharedCodecClass(Fury fury, Class<T> cls, ClassDef classDef) {
        Preconditions.checkNotNull(fury);
        MetaSharedCodecBuilder codecBuilder = new MetaSharedCodecBuilder(TypeRef.of(cls), fury, classDef);
        return CodecUtils.loadOrGenCodecClass(cls, fury, codecBuilder);
    }

    public static <T> Class<? extends Serializer<T>> loadOrGenCompatibleCodecClass(Class<T> cls, Fury fury) {
        FieldResolver resolver = FieldResolver.of(fury, cls, true, false);
        return CodecUtils.loadOrGenCompatibleCodecClass(cls, fury, resolver, Generated.GeneratedSerializer.class);
    }

    public static <T> Class<? extends Serializer<T>> loadOrGenCompatibleCodecClass(Class<T> cls, Fury fury, FieldResolver fieldResolver, Class<?> parentSerializerClass) {
        Preconditions.checkNotNull(fury);
        CompatibleCodecBuilder codecBuilder = new CompatibleCodecBuilder(TypeRef.of(cls), fury, fieldResolver, parentSerializerClass);
        return CodecUtils.loadOrGenCodecClass(cls, fury, codecBuilder);
    }

    static <T> Class<? extends Serializer<T>> loadOrGenCodecClass(Class<T> beanClass, Fury fury, BaseObjectCodecBuilder codecBuilder) {
        ClassLoader beanClassClassLoader;
        CompileUnit compileUnit = new CompileUnit(CodeGenerator.getPackage(beanClass), codecBuilder.codecClassName(beanClass), codecBuilder::genCode);
        ClassLoader classLoader = beanClassClassLoader = beanClass.getClassLoader() == null ? Thread.currentThread().getContextClassLoader() : beanClass.getClassLoader();
        if (beanClassClassLoader == null) {
            beanClassClassLoader = fury.getClass().getClassLoader();
        }
        ClassResolver classResolver = fury.getClassResolver();
        CodeGenerator codeGenerator = CodecUtils.getCodeGenerator(fury, beanClassClassLoader, classResolver);
        ClassLoader classLoader2 = codeGenerator.compile(Collections.singletonList(compileUnit), compileState -> compileState.lock.lock());
        String className = codecBuilder.codecQualifiedClassName(beanClass);
        try {
            return classLoader2.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Impossible because we just compiled class", e);
        }
    }

    private static CodeGenerator getCodeGenerator(Fury fury, ClassLoader beanClassClassLoader, ClassResolver classResolver) {
        CodeGenerator codeGenerator;
        block4: {
            try {
                if (beanClassClassLoader.loadClass(Fury.class.getName()) != Fury.class) {
                    throw new ClassNotFoundException();
                }
                codeGenerator = classResolver.getCodeGenerator(beanClassClassLoader);
                if (codeGenerator == null) {
                    codeGenerator = CodeGenerator.getSharedCodeGenerator(beanClassClassLoader);
                    classResolver.setCodeGenerator(beanClassClassLoader, codeGenerator);
                }
            }
            catch (ClassNotFoundException e) {
                codeGenerator = classResolver.getCodeGenerator(beanClassClassLoader, fury.getClass().getClassLoader());
                ClassLoader[] loaders = new ClassLoader[]{beanClassClassLoader, fury.getClass().getClassLoader()};
                if (codeGenerator != null) break block4;
                codeGenerator = CodeGenerator.getSharedCodeGenerator(ClassLoaderUtils.FuryJarClassLoader.getInstance(), beanClassClassLoader);
                classResolver.setCodeGenerator(loaders, codeGenerator);
            }
        }
        return codeGenerator;
    }
}

