/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.codegen;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.fury.codegen.CodeFormatter;
import org.apache.fury.codegen.CodeGenerator;
import org.apache.fury.codegen.CodegenException;
import org.apache.fury.codegen.CompileUnit;
import org.apache.fury.collection.Tuple2;
import org.apache.fury.logging.Logger;
import org.apache.fury.logging.LoggerFactory;
import org.apache.fury.reflect.ReflectionUtils;
import org.apache.fury.shaded.org.codehaus.commons.compiler.util.reflect.ByteArrayClassLoader;
import org.apache.fury.shaded.org.codehaus.commons.compiler.util.resource.MapResourceCreator;
import org.apache.fury.shaded.org.codehaus.commons.compiler.util.resource.MapResourceFinder;
import org.apache.fury.shaded.org.codehaus.commons.compiler.util.resource.Resource;
import org.apache.fury.shaded.org.codehaus.janino.ClassLoaderIClassLoader;
import org.apache.fury.shaded.org.codehaus.janino.Compiler;
import org.apache.fury.shaded.org.codehaus.janino.util.ClassFile;
import org.apache.fury.util.StringUtils;

public class JaninoUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JaninoUtils.class);

    public static Class<?> compileClass(ClassLoader loader, String pkg, String className, String code) {
        ByteArrayClassLoader classLoader = JaninoUtils.compile(loader, new CompileUnit(pkg, className, code));
        try {
            return classLoader.loadClass(StringUtils.isBlank(pkg) ? className : pkg + "." + className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static ByteArrayClassLoader compile(ClassLoader parentClassLoader, CompileUnit ... compileUnits) {
        Map<String, byte[]> classes = JaninoUtils.toBytecode(parentClassLoader, compileUnits);
        return new ByteArrayClassLoader(classes, parentClassLoader);
    }

    public static Map<String, byte[]> toBytecode(ClassLoader parentClassLoader, CompileUnit ... compileUnits) {
        return JaninoUtils.toBytecode(parentClassLoader, CodeGenerator.getCodeDir(), compileUnits);
    }

    public static Map<String, byte[]> toBytecode(ClassLoader parentClassLoader, String codeDir, CompileUnit ... compileUnits) {
        MapResourceFinder sourceFinder = new MapResourceFinder();
        for (CompileUnit unit2 : compileUnits) {
            String stubFileName = unit2.pkg.replace(".", "/") + "/" + unit2.mainClassName + ".java";
            sourceFinder.addResource(stubFileName, unit2.getCode());
            if (!StringUtils.isNotBlank(codeDir)) continue;
            Path path = Paths.get(codeDir, stubFileName).toAbsolutePath();
            try {
                path.getParent().toFile().mkdirs();
                if (CodeGenerator.deleteCodeOnExit()) {
                    path.toFile().deleteOnExit();
                } else {
                    LOG.info("Write generate class {} to file {}", (Object)stubFileName, (Object)path);
                }
                Files.write(path, unit2.getCode().getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Write code file %s failed", path), e);
            }
        }
        long startTime = System.nanoTime();
        HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
        ClassLoaderIClassLoader classLoader = new ClassLoaderIClassLoader(parentClassLoader);
        Compiler compiler = new Compiler(sourceFinder, classLoader);
        compiler.setClassFileCreator(new MapResourceCreator(classes));
        compiler.setClassFileFinder(new MapResourceFinder(classes));
        compiler.setDebugSource(true);
        compiler.setDebugLines(true);
        try {
            compiler.compile(sourceFinder.resources().toArray(new Resource[0]));
            long durationMs = (System.nanoTime() - startTime) / 1000000L;
            String classNames = Arrays.stream(compileUnits).map(unit -> unit.mainClassName).collect(Collectors.joining(", ", "[", "]"));
            LOG.info("Compile {} take {} ms", (Object)classNames, (Object)durationMs);
        }
        catch (Exception e) {
            StringBuilder msgBuilder = new StringBuilder("Compile error: \n");
            for (int i = 0; i < compileUnits.length; ++i) {
                CompileUnit unit3 = compileUnits[i];
                if (i != 0) {
                    msgBuilder.append('\n');
                }
                String qualifiedName = unit3.pkg + "." + unit3.mainClassName;
                msgBuilder.append(qualifiedName).append(":\n");
                msgBuilder.append(CodeFormatter.format(unit3.getCode()));
            }
            throw new CodegenException(msgBuilder.toString(), e);
        }
        ReflectionUtils.setObjectFieldValue((Object)classLoader, "classLoader", null);
        ReflectionUtils.setObjectFieldValue((Object)classLoader, "loadedIClasses", new HashMap());
        return classes;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static CodeStats getClassStats(Class<?> cls) {
        try (InputStream stream = cls.getResourceAsStream(ReflectionUtils.getClassNameWithoutPackage(cls) + ".class");){
            CodeStats codeStats;
            try (BufferedInputStream bis = new BufferedInputStream(Objects.requireNonNull(stream));){
                byte[] bytecodes = new byte[stream.available()];
                bis.read(bytecodes);
                codeStats = JaninoUtils.getClassStats(bytecodes);
            }
            return codeStats;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static CodeStats getClassStats(byte[] classBytes) {
        try {
            ClassFile classFile = new ClassFile(new ByteArrayInputStream(classBytes));
            int constPoolSize = classFile.getConstantPoolSize();
            Class<?> codeAttrClass = Compiler.class.getClassLoader().loadClass("org.apache.fury.shaded.org.codehaus.janino.util.ClassFile$CodeAttribute");
            Field codeAttrField = codeAttrClass.getDeclaredField("code");
            codeAttrField.setAccessible(true);
            LinkedHashMap<String, Integer> methodSizes = new LinkedHashMap<String, Integer>();
            classFile.methodInfos.stream().flatMap(m -> Arrays.stream(m.getAttributes()).filter(attr -> attr.getClass() == codeAttrClass).map(attr -> {
                try {
                    Object codeAttr = codeAttrField.get(attr);
                    int length = ((byte[])codeAttr).length;
                    if (length > 8000) {
                        LOG.info("Generated method too long to be JIT compiled: class {} method {} size {}", classFile.getThisClassName(), m.getName(), length);
                    }
                    return Tuple2.of(m.getName(), length);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            })).sorted(Comparator.comparingInt(a -> -((Integer)a.f1).intValue())).forEach(e -> methodSizes.put((String)e.f0, (Integer)e.f1));
            return new CodeStats(methodSizes, constPoolSize);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static class CodeStats {
        public final Map<String, Integer> methodsSize;
        public final int constPoolSize;

        public CodeStats(Map<String, Integer> methodsSize, int constPoolSize) {
            this.methodsSize = methodsSize;
            this.constPoolSize = constPoolSize;
        }

        public String toString() {
            return "CodeStats{methodsSize=" + this.methodsSize + ", constPoolSize=" + this.constPoolSize + '}';
        }
    }
}

