/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.config;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.fury.Fury;
import org.apache.fury.ThreadLocalFury;
import org.apache.fury.ThreadSafeFury;
import org.apache.fury.config.CompatibleMode;
import org.apache.fury.config.Language;
import org.apache.fury.config.LongEncoding;
import org.apache.fury.logging.Logger;
import org.apache.fury.logging.LoggerFactory;
import org.apache.fury.memory.Platform;
import org.apache.fury.meta.DeflaterMetaCompressor;
import org.apache.fury.meta.MetaCompressor;
import org.apache.fury.pool.ThreadPoolFury;
import org.apache.fury.reflect.ReflectionUtils;
import org.apache.fury.serializer.JavaSerializer;
import org.apache.fury.serializer.ObjectStreamSerializer;
import org.apache.fury.serializer.Serializer;
import org.apache.fury.util.GraalvmSupport;

public final class FuryBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(FuryBuilder.class);
    private static final boolean ENABLE_CLASS_REGISTRATION_FORCIBLY;
    String name;
    boolean checkClassVersion = false;
    Language language = Language.JAVA;
    boolean trackingRef = false;
    boolean copyRef = false;
    boolean basicTypesRefIgnored = true;
    boolean stringRefIgnored = true;
    boolean timeRefIgnored = true;
    ClassLoader classLoader;
    boolean compressInt = true;
    public LongEncoding longEncoding = LongEncoding.SLI;
    boolean compressString = false;
    Boolean writeNumUtf16BytesForUtf8Encoding;
    CompatibleMode compatibleMode = CompatibleMode.SCHEMA_CONSISTENT;
    boolean checkJdkClassSerializable = true;
    Class<? extends Serializer> defaultJDKStreamSerializerType = ObjectStreamSerializer.class;
    boolean requireClassRegistration = true;
    Boolean metaShareEnabled;
    Boolean scopedMetaShareEnabled;
    boolean codeGenEnabled = true;
    Boolean deserializeNonexistentClass;
    boolean asyncCompilationEnabled = false;
    boolean registerGuavaTypes = true;
    boolean scalaOptimizationEnabled = false;
    boolean suppressClassRegistrationWarnings = true;
    boolean deserializeNonexistentEnumValueAsNull = false;
    boolean serializeEnumByName = false;
    int bufferSizeLimitBytes = 131072;
    MetaCompressor metaCompressor = new DeflaterMetaCompressor();

    public FuryBuilder withLanguage(Language language) {
        this.language = language;
        return this;
    }

    public FuryBuilder withRefTracking(boolean trackingRef) {
        this.trackingRef = trackingRef;
        return this;
    }

    public FuryBuilder withRefCopy(boolean copyRef) {
        this.copyRef = copyRef;
        return this;
    }

    public FuryBuilder ignoreBasicTypesRef(boolean ignoreBasicTypesRef) {
        this.basicTypesRefIgnored = ignoreBasicTypesRef;
        return this;
    }

    public FuryBuilder ignoreStringRef(boolean ignoreStringRef) {
        this.stringRefIgnored = ignoreStringRef;
        return this;
    }

    public FuryBuilder deserializeNonexistentEnumValueAsNull(boolean deserializeNonexistentEnumValueAsNull) {
        this.deserializeNonexistentEnumValueAsNull = deserializeNonexistentEnumValueAsNull;
        return this;
    }

    public FuryBuilder serializeEnumByName(boolean serializeEnumByName) {
        this.serializeEnumByName = serializeEnumByName;
        return this;
    }

    public FuryBuilder ignoreTimeRef(boolean ignoreTimeRef) {
        this.timeRefIgnored = ignoreTimeRef;
        return this;
    }

    public FuryBuilder withNumberCompressed(boolean numberCompressed) {
        this.compressInt = numberCompressed;
        this.withLongCompressed(numberCompressed);
        return this;
    }

    public FuryBuilder withIntCompressed(boolean intCompressed) {
        this.compressInt = intCompressed;
        return this;
    }

    public FuryBuilder withLongCompressed(boolean longCompressed) {
        return this.withLongCompressed(longCompressed ? LongEncoding.SLI : LongEncoding.LE_RAW_BYTES);
    }

    public FuryBuilder withLongCompressed(LongEncoding longEncoding) {
        this.longEncoding = Objects.requireNonNull(longEncoding);
        return this;
    }

    public FuryBuilder withStringCompressed(boolean stringCompressed) {
        this.compressString = stringCompressed;
        return this;
    }

    public FuryBuilder withWriteNumUtf16BytesForUtf8Encoding(boolean writeNumUtf16BytesForUtf8Encoding) {
        this.writeNumUtf16BytesForUtf8Encoding = writeNumUtf16BytesForUtf8Encoding;
        return this;
    }

    public FuryBuilder withBufferSizeLimitBytes(int bufferSizeLimitBytes) {
        this.bufferSizeLimitBytes = bufferSizeLimitBytes;
        return this;
    }

    public FuryBuilder withClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public FuryBuilder withCompatibleMode(CompatibleMode compatibleMode) {
        this.compatibleMode = compatibleMode;
        return this;
    }

    public FuryBuilder withClassVersionCheck(boolean checkClassVersion) {
        this.checkClassVersion = checkClassVersion;
        return this;
    }

    public FuryBuilder withJdkClassSerializableCheck(boolean checkJdkClassSerializable) {
        this.checkJdkClassSerializable = checkJdkClassSerializable;
        return this;
    }

    public FuryBuilder registerGuavaTypes(boolean register) {
        this.registerGuavaTypes = register;
        return this;
    }

    public FuryBuilder requireClassRegistration(boolean requireClassRegistration) {
        this.requireClassRegistration = requireClassRegistration;
        return this;
    }

    public FuryBuilder suppressClassRegistrationWarnings(boolean suppress) {
        this.suppressClassRegistrationWarnings = suppress;
        return this;
    }

    public FuryBuilder withMetaShare(boolean shareMeta) {
        this.metaShareEnabled = shareMeta;
        if (!shareMeta) {
            this.scopedMetaShareEnabled = false;
        }
        return this;
    }

    public FuryBuilder withScopedMetaShare(boolean scoped) {
        this.scopedMetaShareEnabled = scoped;
        return this;
    }

    public FuryBuilder withMetaCompressor(MetaCompressor metaCompressor) {
        this.metaCompressor = MetaCompressor.checkMetaCompressor(metaCompressor);
        return this;
    }

    public FuryBuilder withDeserializeNonexistentClass(boolean deserializeNonexistentClass) {
        this.deserializeNonexistentClass = deserializeNonexistentClass;
        return this;
    }

    public FuryBuilder withCodegen(boolean codeGen) {
        this.codeGenEnabled = codeGen;
        return this;
    }

    public FuryBuilder withAsyncCompilation(boolean asyncCompilation) {
        this.asyncCompilationEnabled = asyncCompilation;
        return this;
    }

    public FuryBuilder withScalaOptimizationEnabled(boolean enableScalaOptimization) {
        this.scalaOptimizationEnabled = enableScalaOptimization;
        if (enableScalaOptimization) {
            try {
                Class.forName(ReflectionUtils.getPackage(Fury.class) + ".serializer.scala.ScalaSerializers");
            }
            catch (ClassNotFoundException e) {
                LOG.warn("`fury-scala` library is not in the classpath, please add it to class path and invoke `org.apache.fury.serializer.scala.ScalaSerializers.registerSerializers` for peek performance");
            }
        }
        return this;
    }

    public FuryBuilder withName(String name) {
        this.name = name;
        return this;
    }

    private void finish() {
        if (this.classLoader == null) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
            if (this.classLoader == null) {
                this.classLoader = Fury.class.getClassLoader();
            }
        }
        if (this.language != Language.JAVA) {
            this.stringRefIgnored = false;
        }
        if (ENABLE_CLASS_REGISTRATION_FORCIBLY && !this.requireClassRegistration) {
            LOG.warn("Class registration is enabled forcibly.");
            this.requireClassRegistration = true;
        }
        if (this.defaultJDKStreamSerializerType == JavaSerializer.class) {
            LOG.warn("JDK serialization is used for types which customized java serialization by implementing methods such as writeObject/readObject. This is not secure, try to use {} instead, or implement a custom {}.", (Object)ObjectStreamSerializer.class, (Object)Serializer.class);
        }
        if (this.writeNumUtf16BytesForUtf8Encoding == null) {
            this.writeNumUtf16BytesForUtf8Encoding = this.language == Language.JAVA;
        }
        if (this.compatibleMode == CompatibleMode.COMPATIBLE) {
            this.checkClassVersion = false;
            if (this.deserializeNonexistentClass == null) {
                this.deserializeNonexistentClass = true;
            }
            if (this.scopedMetaShareEnabled == null) {
                if (this.metaShareEnabled == null) {
                    this.metaShareEnabled = true;
                    this.scopedMetaShareEnabled = true;
                } else {
                    this.scopedMetaShareEnabled = false;
                }
            } else if (this.metaShareEnabled == null) {
                this.metaShareEnabled = this.scopedMetaShareEnabled;
            }
        } else {
            if (this.deserializeNonexistentClass == null) {
                this.deserializeNonexistentClass = false;
            }
            if (this.scopedMetaShareEnabled != null && this.scopedMetaShareEnabled.booleanValue()) {
                LOG.warn("Scoped meta share is for CompatibleMode only, disable it for {}", (Object)this.compatibleMode);
            }
            this.scopedMetaShareEnabled = false;
            if (this.metaShareEnabled == null) {
                this.metaShareEnabled = false;
            }
        }
        if (!this.requireClassRegistration) {
            LOG.warn("Class registration isn't forced, unknown classes can be deserialized. If the environment isn't secure, please enable class registration by `FuryBuilder#requireClassRegistration(true)` or configure ClassChecker by `ClassResolver#setClassChecker`");
        }
        if (GraalvmSupport.IN_GRAALVM_NATIVE_IMAGE && this.asyncCompilationEnabled) {
            LOG.info("Use sync compilation for graalvm native image since it doesn't support JIT.");
            this.asyncCompilationEnabled = false;
        }
    }

    private static Fury newFury(FuryBuilder builder, ClassLoader classLoader) {
        try {
            return new Fury(builder, classLoader);
        }
        catch (Throwable t) {
            t.printStackTrace();
            LOG.error("Fury creation failed with classloader {}", (Object)classLoader);
            Platform.throwException(t);
            throw new RuntimeException(t);
        }
    }

    public Fury build() {
        this.finish();
        ClassLoader loader = this.classLoader;
        this.classLoader = null;
        return FuryBuilder.newFury(this, loader);
    }

    public ThreadSafeFury buildThreadSafeFury() {
        return this.buildThreadLocalFury();
    }

    public ThreadLocalFury buildThreadLocalFury() {
        this.finish();
        ClassLoader loader = this.classLoader;
        this.classLoader = null;
        ThreadLocalFury threadSafeFury = new ThreadLocalFury(classLoader -> FuryBuilder.newFury(this, classLoader));
        threadSafeFury.setClassLoader(loader);
        return threadSafeFury;
    }

    public ThreadSafeFury buildThreadSafeFuryPool(int minPoolSize, int maxPoolSize) {
        return this.buildThreadSafeFuryPool(minPoolSize, maxPoolSize, 30L, TimeUnit.SECONDS);
    }

    public ThreadSafeFury buildThreadSafeFuryPool(int minPoolSize, int maxPoolSize, long expireTime, TimeUnit timeUnit) {
        if (minPoolSize < 0 || maxPoolSize < 0 || minPoolSize > maxPoolSize) {
            throw new IllegalArgumentException(String.format("thread safe fury pool's init pool size error, please check it, min:[%s], max:[%s]", minPoolSize, maxPoolSize));
        }
        this.finish();
        ClassLoader loader = this.classLoader;
        this.classLoader = null;
        ThreadPoolFury threadSafeFury = new ThreadPoolFury(classLoader -> FuryBuilder.newFury(this, classLoader), minPoolSize, maxPoolSize, expireTime, timeUnit);
        threadSafeFury.setClassLoader(loader);
        return threadSafeFury;
    }

    static {
        String flagValue = System.getProperty("fury.enable_fury_security_mode_forcibly", System.getenv("ENABLE_CLASS_REGISTRATION_FORCIBLY"));
        ENABLE_CLASS_REGISTRATION_FORCIBLY = "true".equals(flagValue) || "1".equals(flagValue);
    }
}

