/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.io;

import java.io.IOException;
import java.io.ObjectOutput;
import java.io.OutputStream;
import org.apache.fury.Fury;
import org.apache.fury.config.LongEncoding;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.serializer.PrimitiveSerializers;
import org.apache.fury.serializer.StringSerializer;
import org.apache.fury.util.Preconditions;

public class MemoryBufferObjectOutput
extends OutputStream
implements ObjectOutput {
    private final Fury fury;
    private final boolean compressInt;
    private final LongEncoding longEncoding;
    private final StringSerializer stringSerializer;
    private MemoryBuffer buffer;

    public MemoryBufferObjectOutput(Fury fury, MemoryBuffer buffer) {
        this.fury = fury;
        this.compressInt = fury.compressInt();
        this.longEncoding = fury.longEncoding();
        this.buffer = buffer;
        this.stringSerializer = new StringSerializer(fury);
    }

    public MemoryBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(MemoryBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        this.fury.writeRef(this.buffer, obj);
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer.writeByte((byte)b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.buffer.writeBytes(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.buffer.writeBytes(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.buffer.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.buffer.writeByte((byte)v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.buffer.writeInt16((short)v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.buffer.writeChar((char)v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        if (this.compressInt) {
            this.buffer.writeVarInt32(v);
        } else {
            this.buffer.writeInt32(v);
        }
    }

    @Override
    public void writeLong(long v) throws IOException {
        PrimitiveSerializers.LongSerializer.writeInt64(this.buffer, v, this.longEncoding);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.buffer.writeFloat32(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.buffer.writeFloat64(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        Preconditions.checkNotNull(s);
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.buffer.writeByte((byte)s.charAt(i));
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        Preconditions.checkNotNull(s);
        this.stringSerializer.writeJavaString(this.buffer, s);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        Preconditions.checkNotNull(s);
        this.stringSerializer.writeJavaString(this.buffer, s);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }
}

