/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.meta;

import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import org.apache.fury.collection.Collections;
import org.apache.fury.meta.MetaString;
import org.apache.fury.util.Preconditions;
import org.apache.fury.util.StringUtils;

public class MetaStringEncoder {
    private final char specialChar1;
    private final char specialChar2;

    public MetaStringEncoder(char specialChar1, char specialChar2) {
        this.specialChar1 = specialChar1;
        this.specialChar2 = specialChar2;
    }

    public MetaString encode(String input) {
        return this.encode(input, MetaString.Encoding.values());
    }

    public MetaString encode(String input, MetaString.Encoding[] encodings) {
        if (input.isEmpty()) {
            return new MetaString(input, MetaString.Encoding.UTF_8, this.specialChar1, this.specialChar2, new byte[0]);
        }
        if (!StringUtils.isLatin(input.toCharArray())) {
            return new MetaString(input, MetaString.Encoding.UTF_8, this.specialChar1, this.specialChar2, input.getBytes(StandardCharsets.UTF_8));
        }
        MetaString.Encoding encoding = this.computeEncoding(input, encodings);
        return this.encode(input, encoding);
    }

    public MetaString encode(String input, MetaString.Encoding encoding) {
        Preconditions.checkArgument(input.length() < Short.MAX_VALUE, "Long meta string than 32767 is not allowed");
        if (encoding != MetaString.Encoding.UTF_8 && !StringUtils.isLatin(input.toCharArray())) {
            throw new IllegalArgumentException("Non-ASCII characters in meta string are not allowed");
        }
        if (input.isEmpty()) {
            return new MetaString(input, MetaString.Encoding.UTF_8, this.specialChar1, this.specialChar2, new byte[0]);
        }
        switch (encoding) {
            case LOWER_SPECIAL: {
                byte[] bytes = this.encodeLowerSpecial(input);
                return new MetaString(input, encoding, this.specialChar1, this.specialChar2, bytes);
            }
            case LOWER_UPPER_DIGIT_SPECIAL: {
                byte[] bytes = this.encodeLowerUpperDigitSpecial(input);
                return new MetaString(input, encoding, this.specialChar1, this.specialChar2, bytes);
            }
            case FIRST_TO_LOWER_SPECIAL: {
                byte[] bytes = this.encodeFirstToLowerSpecial(input);
                return new MetaString(input, encoding, this.specialChar1, this.specialChar2, bytes);
            }
            case ALL_TO_LOWER_SPECIAL: {
                char[] chars = input.toCharArray();
                int upperCount = this.countUppers(chars);
                byte[] bytes = this.encodeAllToLowerSpecial(chars, upperCount);
                return new MetaString(input, encoding, this.specialChar1, this.specialChar2, bytes);
            }
        }
        byte[] bytes = input.getBytes(StandardCharsets.UTF_8);
        return new MetaString(input, MetaString.Encoding.UTF_8, this.specialChar1, this.specialChar2, bytes);
    }

    public MetaString.Encoding computeEncoding(String input) {
        return this.computeEncoding(input, MetaString.Encoding.values());
    }

    public MetaString.Encoding computeEncoding(String input, MetaString.Encoding[] encodings) {
        HashSet<MetaString.Encoding> encodingSet = Collections.ofHashSet(encodings);
        if (input.isEmpty() && encodingSet.contains((Object)MetaString.Encoding.LOWER_SPECIAL)) {
            return MetaString.Encoding.LOWER_SPECIAL;
        }
        char[] chars = input.toCharArray();
        StringStatistics statistics = this.computeStatistics(chars);
        if (statistics.canLowerSpecialEncoded && encodingSet.contains((Object)MetaString.Encoding.LOWER_SPECIAL)) {
            return MetaString.Encoding.LOWER_SPECIAL;
        }
        if (statistics.canLowerUpperDigitSpecialEncoded) {
            if (statistics.digitCount != 0 && encodingSet.contains((Object)MetaString.Encoding.LOWER_UPPER_DIGIT_SPECIAL)) {
                return MetaString.Encoding.LOWER_UPPER_DIGIT_SPECIAL;
            }
            int upperCount = statistics.upperCount;
            if (upperCount == 1 && Character.isUpperCase(chars[0]) && encodingSet.contains((Object)MetaString.Encoding.FIRST_TO_LOWER_SPECIAL)) {
                return MetaString.Encoding.FIRST_TO_LOWER_SPECIAL;
            }
            if ((chars.length + upperCount) * 5 < chars.length * 6 && encodingSet.contains((Object)MetaString.Encoding.ALL_TO_LOWER_SPECIAL)) {
                return MetaString.Encoding.ALL_TO_LOWER_SPECIAL;
            }
            if (encodingSet.contains((Object)MetaString.Encoding.LOWER_UPPER_DIGIT_SPECIAL)) {
                return MetaString.Encoding.LOWER_UPPER_DIGIT_SPECIAL;
            }
        }
        return MetaString.Encoding.UTF_8;
    }

    private StringStatistics computeStatistics(char[] chars) {
        boolean canLowerUpperDigitSpecialEncoded = true;
        boolean canLowerSpecialEncoded = true;
        int digitCount = 0;
        int upperCount = 0;
        for (char c : chars) {
            if (!(!canLowerUpperDigitSpecialEncoded || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == this.specialChar1 || c == this.specialChar2)) {
                canLowerUpperDigitSpecialEncoded = false;
            }
            if (canLowerSpecialEncoded && (c < 'a' || c > 'z') && c != '.' && c != '_' && c != '$' && c != '|') {
                canLowerSpecialEncoded = false;
            }
            if (Character.isDigit(c)) {
                ++digitCount;
            }
            if (!Character.isUpperCase(c)) continue;
            ++upperCount;
        }
        return new StringStatistics(digitCount, upperCount, canLowerSpecialEncoded, canLowerUpperDigitSpecialEncoded);
    }

    private int countUppers(char[] chars) {
        int upperCount = 0;
        for (char c : chars) {
            if (!Character.isUpperCase(c)) continue;
            ++upperCount;
        }
        return upperCount;
    }

    public byte[] encodeLowerSpecial(String input) {
        return this.encodeGeneric(input, 5);
    }

    public byte[] encodeLowerUpperDigitSpecial(String input) {
        return this.encodeGeneric(input, 6);
    }

    public byte[] encodeFirstToLowerSpecial(String input) {
        return this.encodeFirstToLowerSpecial(input.toCharArray());
    }

    public byte[] encodeFirstToLowerSpecial(char[] chars) {
        chars[0] = Character.toLowerCase(chars[0]);
        return this.encodeGeneric(chars, 5);
    }

    public byte[] encodeAllToLowerSpecial(char[] chars, int upperCount) {
        char[] newChars = new char[chars.length + upperCount];
        int newIdx = 0;
        for (char c : chars) {
            if (Character.isUpperCase(c)) {
                newChars[newIdx++] = 124;
                newChars[newIdx++] = Character.toLowerCase(c);
                continue;
            }
            newChars[newIdx++] = c;
        }
        return this.encodeGeneric(newChars, 5);
    }

    private byte[] encodeGeneric(String input, int bitsPerChar) {
        return this.encodeGeneric(input.toCharArray(), bitsPerChar);
    }

    private byte[] encodeGeneric(char[] chars, int bitsPerChar) {
        boolean stripLastChar;
        int totalBits = chars.length * bitsPerChar + 1;
        int byteLength = (totalBits + 7) / 8;
        byte[] bytes = new byte[byteLength];
        int byteInd = 0;
        int bitInd = 1;
        int charInd = 0;
        int charBitRemain = bitsPerChar;
        while (charInd < chars.length) {
            int mask;
            int charVal = bitsPerChar == 5 ? this.charToValueLowerSpecial(chars[charInd]) : this.charToValueLowerUpperDigitSpecial(chars[charInd]);
            int nowByteRemain = 8 - bitInd;
            if (nowByteRemain >= charBitRemain) {
                mask = (1 << charBitRemain) - 1;
                int n = byteInd++;
                bytes[n] = (byte)(bytes[n] | (byte)((charVal & mask) << nowByteRemain - charBitRemain));
                if ((bitInd += charBitRemain) == 8) {
                    bitInd = 0;
                }
                ++charInd;
                charBitRemain = bitsPerChar;
                continue;
            }
            mask = (1 << nowByteRemain) - 1;
            int n = byteInd++;
            bytes[n] = (byte)(bytes[n] | (byte)(charVal >> charBitRemain - nowByteRemain & mask));
            bitInd = 0;
            charBitRemain -= nowByteRemain;
        }
        boolean bl = stripLastChar = bytes.length * 8 >= totalBits + bitsPerChar;
        if (stripLastChar) {
            bytes[0] = (byte)(bytes[0] | 0x80);
        }
        return bytes;
    }

    private int charToValueLowerSpecial(char c) {
        if (c >= 'a' && c <= 'z') {
            return c - 97;
        }
        if (c == '.') {
            return 26;
        }
        if (c == '_') {
            return 27;
        }
        if (c == '$') {
            return 28;
        }
        if (c == '|') {
            return 29;
        }
        throw new IllegalArgumentException("Unsupported character for LOWER_SPECIAL encoding: " + c);
    }

    private int charToValueLowerUpperDigitSpecial(char c) {
        if (c >= 'a' && c <= 'z') {
            return c - 97;
        }
        if (c >= 'A' && c <= 'Z') {
            return 26 + (c - 65);
        }
        if (c >= '0' && c <= '9') {
            return 52 + (c - 48);
        }
        if (c == this.specialChar1) {
            return 62;
        }
        if (c == this.specialChar2) {
            return 63;
        }
        throw new IllegalArgumentException("Unsupported character for LOWER_UPPER_DIGIT_SPECIAL encoding: " + c);
    }

    private static class StringStatistics {
        final int digitCount;
        final int upperCount;
        final boolean canLowerUpperDigitSpecialEncoded;
        final boolean canLowerSpecialEncoded;

        public StringStatistics(int digitCount, int upperCount, boolean canLowerSpecialEncoded, boolean canLowerUpperDigitSpecialEncoded) {
            this.digitCount = digitCount;
            this.upperCount = upperCount;
            this.canLowerSpecialEncoded = canLowerSpecialEncoded;
            this.canLowerUpperDigitSpecialEncoded = canLowerUpperDigitSpecialEncoded;
        }
    }
}

