/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.serializer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.fury.Fury;
import org.apache.fury.memory.ByteBufferUtil;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.serializer.BufferObject;
import org.apache.fury.serializer.Serializers;
import org.apache.fury.type.Type;

public class BufferSerializers {

    public static final class ByteBufferSerializer
    extends Serializers.CrossLanguageCompatibleSerializer<ByteBuffer> {
        public ByteBufferSerializer(Fury fury, Class<ByteBuffer> cls) {
            super(fury, cls, Type.FURY_BUFFER.getId());
        }

        @Override
        public void write(MemoryBuffer buffer, ByteBuffer value) {
            this.fury.writeBufferObject(buffer, new BufferObject.ByteBufferBufferObject(value));
        }

        @Override
        public ByteBuffer copy(ByteBuffer value) {
            ByteBuffer dst = ByteBuffer.allocate(value.remaining());
            dst.put(value.duplicate());
            ByteBufferUtil.rewind(dst);
            return dst;
        }

        @Override
        public ByteBuffer read(MemoryBuffer buffer) {
            MemoryBuffer newBuffer = this.fury.readBufferObject(buffer);
            int readerIndex = newBuffer.readerIndex();
            int size = newBuffer.remaining();
            ByteBuffer originalBuffer = newBuffer.sliceAsByteBuffer(readerIndex, size - 1);
            byte isBigEndian = newBuffer.getByte(readerIndex + size - 1);
            originalBuffer.order(isBigEndian == 1 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
            return originalBuffer;
        }
    }
}

