/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.serializer;

import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.apache.fury.Fury;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.serializer.ImmutableSerializer;
import org.apache.fury.serializer.Serializer;

public final class OptionalSerializers {
    public static void registerDefaultSerializers(Fury fury) {
        fury.registerSerializer(Optional.class, new OptionalSerializer(fury));
        fury.registerSerializer(OptionalInt.class, new OptionalIntSerializer(fury));
        fury.registerSerializer(OptionalLong.class, new OptionalLongSerializer(fury));
        fury.registerSerializer(OptionalDouble.class, new OptionalDoubleSerializer(fury));
    }

    public static final class OptionalSerializer
    extends Serializer<Optional> {
        public OptionalSerializer(Fury fury) {
            super(fury, Optional.class);
        }

        @Override
        public void write(MemoryBuffer buffer, Optional value) {
            Object nullable = value.isPresent() ? value.get() : null;
            this.fury.writeRef(buffer, nullable);
        }

        @Override
        public Optional copy(Optional originOptional) {
            if (originOptional.isPresent()) {
                return Optional.ofNullable(this.fury.copyObject(originOptional.get()));
            }
            return originOptional;
        }

        @Override
        public Optional read(MemoryBuffer buffer) {
            return Optional.ofNullable(this.fury.readRef(buffer));
        }
    }

    public static final class OptionalIntSerializer
    extends ImmutableSerializer<OptionalInt> {
        public OptionalIntSerializer(Fury fury) {
            super(fury, OptionalInt.class);
        }

        @Override
        public void write(MemoryBuffer buffer, OptionalInt value) {
            boolean present = value.isPresent();
            buffer.writeBoolean(present);
            if (present) {
                buffer.writeInt32(value.getAsInt());
            }
        }

        @Override
        public OptionalInt read(MemoryBuffer buffer) {
            if (buffer.readBoolean()) {
                return OptionalInt.of(buffer.readInt32());
            }
            return OptionalInt.empty();
        }
    }

    public static final class OptionalLongSerializer
    extends ImmutableSerializer<OptionalLong> {
        public OptionalLongSerializer(Fury fury) {
            super(fury, OptionalLong.class);
        }

        @Override
        public void write(MemoryBuffer buffer, OptionalLong value) {
            boolean present = value.isPresent();
            buffer.writeBoolean(present);
            if (present) {
                buffer.writeInt64(value.getAsLong());
            }
        }

        @Override
        public OptionalLong read(MemoryBuffer buffer) {
            if (buffer.readBoolean()) {
                return OptionalLong.of(buffer.readInt64());
            }
            return OptionalLong.empty();
        }
    }

    public static final class OptionalDoubleSerializer
    extends ImmutableSerializer<OptionalDouble> {
        public OptionalDoubleSerializer(Fury fury) {
            super(fury, OptionalDouble.class);
        }

        @Override
        public void write(MemoryBuffer buffer, OptionalDouble value) {
            boolean present = value.isPresent();
            buffer.writeBoolean(present);
            if (present) {
                buffer.writeFloat64(value.getAsDouble());
            }
        }

        @Override
        public OptionalDouble read(MemoryBuffer buffer) {
            if (buffer.readBoolean()) {
                return OptionalDouble.of(buffer.readFloat64());
            }
            return OptionalDouble.empty();
        }
    }
}

