/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.serializer;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.fury.Fury;
import org.apache.fury.codegen.Expression;
import org.apache.fury.memory.LittleEndian;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.memory.Platform;
import org.apache.fury.reflect.ReflectionUtils;
import org.apache.fury.serializer.ImmutableSerializer;
import org.apache.fury.serializer.StringUTF16;
import org.apache.fury.type.Type;
import org.apache.fury.type.TypeUtils;
import org.apache.fury.util.MathUtils;
import org.apache.fury.util.Preconditions;
import org.apache.fury.util.StringEncodingUtils;
import org.apache.fury.util.StringUtils;
import org.apache.fury.util.unsafe._JDKAccess;

public final class StringSerializer
extends ImmutableSerializer<String> {
    private static final boolean STRING_VALUE_FIELD_IS_CHARS;
    private static final boolean STRING_VALUE_FIELD_IS_BYTES;
    private static final byte LATIN1 = 0;
    private static final Byte LATIN1_BOXED;
    private static final byte UTF16 = 1;
    private static final Byte UTF16_BOXED;
    private static final byte UTF8 = 2;
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final long STRING_VALUE_FIELD_OFFSET;
    private final boolean compressString;
    private final boolean writeNumUtf16BytesForUtf8Encoding;
    private byte[] byteArray = new byte[1024];
    private int smoothByteArrayLength = 1024;
    private char[] charArray = new char[16];
    private int smoothCharArrayLength = 1024;
    private byte[] byteArray2 = new byte[16];
    private static final MethodHandles.Lookup STRING_LOOK_UP;
    private static final BiFunction<char[], Boolean, String> CHARS_STRING_ZERO_COPY_CTR;
    private static final BiFunction<byte[], Byte, String> BYTES_STRING_ZERO_COPY_CTR;
    private static final Function<byte[], String> LATIN_BYTES_STRING_ZERO_COPY_CTR;

    public StringSerializer(Fury fury) {
        super(fury, String.class, fury.trackingRef() && !fury.isStringRefIgnored());
        this.compressString = fury.compressString();
        this.writeNumUtf16BytesForUtf8Encoding = fury.getConfig().writeNumUtf16BytesForUtf8Encoding();
    }

    @Override
    public short getXtypeId() {
        return Type.STRING.getId();
    }

    @Override
    public void write(MemoryBuffer buffer, String value) {
        this.writeJavaString(buffer, value);
    }

    @Override
    public void xwrite(MemoryBuffer buffer, String value) {
        this.writeUTF8String(buffer, value);
    }

    @Override
    public String read(MemoryBuffer buffer) {
        return this.readJavaString(buffer);
    }

    @Override
    public String xread(MemoryBuffer buffer) {
        return this.readUTF8String(buffer);
    }

    public void writeString(MemoryBuffer buffer, String value) {
        if (this.isJava) {
            this.writeJavaString(buffer, value);
        } else {
            this.writeUTF8String(buffer, value);
        }
    }

    public Expression writeStringExpr(Expression strSerializer, Expression buffer, Expression str) {
        if (this.isJava) {
            if (STRING_VALUE_FIELD_IS_BYTES) {
                if (this.compressString) {
                    return new Expression.Invoke(strSerializer, "writeCompressedBytesString", buffer, str);
                }
                return new Expression.StaticInvoke(StringSerializer.class, "writeBytesString", buffer, str);
            }
            if (!STRING_VALUE_FIELD_IS_CHARS) {
                throw new UnsupportedOperationException();
            }
            if (this.compressString) {
                return new Expression.Invoke(strSerializer, "writeCompressedCharsString", buffer, str);
            }
            return new Expression.Invoke(strSerializer, "writeCharsString", buffer, str);
        }
        return new Expression.Invoke(strSerializer, "writeUTF8String", buffer, str);
    }

    public String readString(MemoryBuffer buffer) {
        if (this.isJava) {
            return this.readJavaString(buffer);
        }
        return this.readUTF8String(buffer);
    }

    public Expression readStringExpr(Expression strSerializer, Expression buffer) {
        if (this.isJava) {
            if (STRING_VALUE_FIELD_IS_BYTES) {
                if (this.compressString) {
                    return new Expression.Invoke(strSerializer, "readCompressedBytesString", TypeUtils.STRING_TYPE, buffer);
                }
                return new Expression.Invoke(strSerializer, "readBytesString", TypeUtils.STRING_TYPE, buffer);
            }
            if (!STRING_VALUE_FIELD_IS_CHARS) {
                throw new UnsupportedOperationException();
            }
            if (this.compressString) {
                return new Expression.Invoke(strSerializer, "readCompressedCharsString", TypeUtils.STRING_TYPE, buffer);
            }
            return new Expression.Invoke(strSerializer, "readCharsString", TypeUtils.STRING_TYPE, buffer);
        }
        return new Expression.Invoke(strSerializer, "readUTF8String", TypeUtils.STRING_TYPE, buffer);
    }

    public String readBytesString(MemoryBuffer buffer) {
        long header = buffer.readVarUint36Small();
        byte coder = (byte)(header & 3L);
        int numBytes = (int)(header >>> 2);
        byte[] bytes = this.readBytesUnCompressedUTF16(buffer, numBytes);
        if (coder != 2) {
            return StringSerializer.newBytesStringZeroCopy(coder, bytes);
        }
        return new String(bytes, 0, numBytes, StandardCharsets.UTF_8);
    }

    public String readCharsString(MemoryBuffer buffer) {
        char[] chars;
        long header = buffer.readVarUint36Small();
        byte coder = (byte)(header & 3L);
        int numBytes = (int)(header >>> 2);
        if (coder == 0) {
            chars = this.readCharsLatin1(buffer, numBytes);
        } else if (coder == 1) {
            chars = this.readCharsUTF16(buffer, numBytes);
        } else {
            throw new RuntimeException("Unknown coder type " + coder);
        }
        return StringSerializer.newCharsStringZeroCopy(chars);
    }

    public String readCompressedBytesString(MemoryBuffer buffer) {
        long header = buffer.readVarUint36Small();
        byte coder = (byte)(header & 3L);
        int numBytes = (int)(header >>> 2);
        if (coder == 2) {
            byte[] data = this.writeNumUtf16BytesForUtf8Encoding ? this.readBytesUTF8PerfOptimized(buffer, numBytes) : this.readBytesUTF8(buffer, numBytes);
            return StringSerializer.newBytesStringZeroCopy((byte)1, data);
        }
        if (coder == 0 || coder == 1) {
            return StringSerializer.newBytesStringZeroCopy(coder, this.readBytesUnCompressedUTF16(buffer, numBytes));
        }
        throw new RuntimeException("Unknown coder type " + coder);
    }

    public String readCompressedCharsString(MemoryBuffer buffer) {
        char[] chars;
        long header = buffer.readVarUint36Small();
        byte coder = (byte)(header & 3L);
        int numBytes = (int)(header >>> 2);
        if (coder == 0) {
            chars = this.readCharsLatin1(buffer, numBytes);
        } else {
            if (coder == 2) {
                return this.writeNumUtf16BytesForUtf8Encoding ? this.readCharsUTF8PerfOptimized(buffer, numBytes) : this.readCharsUTF8(buffer, numBytes);
            }
            if (coder == 1) {
                chars = this.readCharsUTF16(buffer, numBytes);
            } else {
                throw new RuntimeException("Unknown coder type " + coder);
            }
        }
        return StringSerializer.newCharsStringZeroCopy(chars);
    }

    public void writeJavaString(MemoryBuffer buffer, String value) {
        if (STRING_VALUE_FIELD_IS_BYTES) {
            if (this.compressString) {
                this.writeCompressedBytesString(buffer, value);
            } else {
                StringSerializer.writeBytesString(buffer, value);
            }
        } else {
            assert (STRING_VALUE_FIELD_IS_CHARS);
            if (this.compressString) {
                this.writeCompressedCharsString(buffer, value);
            } else {
                this.writeCharsString(buffer, value);
            }
        }
    }

    public void writeUTF8String(MemoryBuffer buffer, String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        buffer.writeVarUint32(bytes.length);
        buffer.writeBytes(bytes);
    }

    public String readJavaString(MemoryBuffer buffer) {
        if (STRING_VALUE_FIELD_IS_BYTES) {
            if (this.compressString) {
                return this.readCompressedBytesString(buffer);
            }
            return this.readBytesString(buffer);
        }
        assert (STRING_VALUE_FIELD_IS_CHARS);
        if (this.compressString) {
            return this.readCompressedCharsString(buffer);
        }
        return this.readCharsString(buffer);
    }

    public void writeCompressedBytesString(MemoryBuffer buffer, String value) {
        byte[] bytes = (byte[])Platform.getObject(value, STRING_VALUE_FIELD_OFFSET);
        byte coder = Platform.getByte(value, Offset.STRING_CODER_FIELD_OFFSET);
        if (coder == 0 || StringSerializer.bestCoder(bytes) == 1) {
            StringSerializer.writeBytesString(buffer, coder, bytes);
        } else if (this.writeNumUtf16BytesForUtf8Encoding) {
            this.writeBytesUTF8PerfOptimized(buffer, bytes);
        } else {
            this.writeBytesUTF8(buffer, bytes);
        }
    }

    public void writeCompressedCharsString(MemoryBuffer buffer, String value) {
        char[] chars = (char[])Platform.getObject(value, STRING_VALUE_FIELD_OFFSET);
        byte coder = StringSerializer.bestCoder(chars);
        if (coder == 0) {
            this.writeCharsLatin1(buffer, chars, chars.length);
        } else if (coder == 2) {
            if (this.writeNumUtf16BytesForUtf8Encoding) {
                this.writeCharsUTF8PerfOptimized(buffer, chars);
            } else {
                this.writeCharsUTF8(buffer, chars);
            }
        } else {
            this.writeCharsUTF16(buffer, chars, chars.length);
        }
    }

    public static void writeBytesString(MemoryBuffer buffer, String value) {
        byte[] bytes = (byte[])Platform.getObject(value, STRING_VALUE_FIELD_OFFSET);
        byte coder = Platform.getByte(value, Offset.STRING_CODER_FIELD_OFFSET);
        StringSerializer.writeBytesString(buffer, coder, bytes);
    }

    public static void writeBytesString(MemoryBuffer buffer, byte coder, byte[] bytes) {
        int bytesLen = bytes.length;
        long header = (long)bytesLen << 2 | (long)coder;
        int writerIndex = buffer.writerIndex();
        buffer.ensure(writerIndex + 9 + bytesLen);
        byte[] targetArray = buffer.getHeapMemory();
        if (targetArray != null) {
            int targetIndex;
            int arrIndex = targetIndex = buffer._unsafeHeapWriterIndex();
            arrIndex += LittleEndian.putVarUint36Small(targetArray, arrIndex, header);
            writerIndex += arrIndex - targetIndex;
            System.arraycopy(bytes, 0, targetArray, arrIndex, bytesLen);
        } else {
            writerIndex += buffer._unsafePutVarUint36Small(writerIndex, header);
            long offHeapAddress = buffer.getUnsafeAddress();
            Platform.copyMemory(bytes, Platform.BYTE_ARRAY_OFFSET, null, offHeapAddress + (long)writerIndex, bytesLen);
        }
        buffer._unsafeWriterIndex(writerIndex += bytesLen);
    }

    public void writeCharsString(MemoryBuffer buffer, String value) {
        char[] chars = (char[])Platform.getObject(value, STRING_VALUE_FIELD_OFFSET);
        if (StringUtils.isLatin(chars)) {
            this.writeCharsLatin1(buffer, chars, chars.length);
        } else {
            this.writeCharsUTF16(buffer, chars, chars.length);
        }
    }

    public String readUTF8String(MemoryBuffer buffer) {
        int numBytes = buffer.readVarUint32Small14();
        buffer.checkReadableBytes(numBytes);
        byte[] targetArray = buffer.getHeapMemory();
        if (targetArray != null) {
            String str = new String(targetArray, buffer._unsafeHeapReaderIndex(), numBytes, StandardCharsets.UTF_8);
            buffer.increaseReaderIndex(numBytes);
            return str;
        }
        byte[] tmpArray = this.getByteArray(numBytes);
        buffer.readBytes(tmpArray, 0, numBytes);
        return new String(tmpArray, 0, numBytes, StandardCharsets.UTF_8);
    }

    public char[] readCharsLatin1(MemoryBuffer buffer, int numBytes) {
        buffer.checkReadableBytes(numBytes);
        byte[] srcArray = buffer.getHeapMemory();
        char[] chars = new char[numBytes];
        if (srcArray != null) {
            int srcIndex = buffer._unsafeHeapReaderIndex();
            for (int i = 0; i < numBytes; ++i) {
                chars[i] = (char)(srcArray[srcIndex++] & 0xFF);
            }
            buffer._increaseReaderIndexUnsafe(numBytes);
        } else {
            byte[] tmpArray = this.getByteArray(numBytes);
            buffer.readBytes(tmpArray, 0, numBytes);
            for (int i = 0; i < numBytes; ++i) {
                chars[i] = (char)(tmpArray[i] & 0xFF);
            }
        }
        return chars;
    }

    public byte[] readBytesUTF8(MemoryBuffer buffer, int numBytes) {
        int utf16NumBytes;
        byte[] tmpArray = this.getByteArray(numBytes << 1);
        buffer.checkReadableBytes(numBytes);
        byte[] srcArray = buffer.getHeapMemory();
        if (srcArray != null) {
            int srcIndex = buffer._unsafeHeapReaderIndex();
            utf16NumBytes = StringEncodingUtils.convertUTF8ToUTF16(srcArray, srcIndex, numBytes, tmpArray);
            buffer._increaseReaderIndexUnsafe(numBytes);
        } else {
            byte[] byteArray2 = this.getByteArray2(numBytes);
            buffer.readBytes(byteArray2, 0, numBytes);
            utf16NumBytes = StringEncodingUtils.convertUTF8ToUTF16(byteArray2, 0, numBytes, tmpArray);
        }
        return Arrays.copyOf(tmpArray, utf16NumBytes);
    }

    private byte[] readBytesUTF8PerfOptimized(MemoryBuffer buffer, int numBytes) {
        int udf8Bytes = buffer.readInt32();
        byte[] bytes = new byte[numBytes];
        buffer.checkReadableBytes(udf8Bytes);
        byte[] srcArray = buffer.getHeapMemory();
        if (srcArray != null) {
            int srcIndex = buffer._unsafeHeapReaderIndex();
            int readLen = StringEncodingUtils.convertUTF8ToUTF16(srcArray, srcIndex, udf8Bytes, bytes);
            assert (readLen == numBytes) : "Decode UTF8 to UTF16 failed";
            buffer._increaseReaderIndexUnsafe(udf8Bytes);
        } else {
            byte[] tmpArray = this.getByteArray(udf8Bytes);
            buffer.readBytes(tmpArray, 0, udf8Bytes);
            int readLen = StringEncodingUtils.convertUTF8ToUTF16(tmpArray, 0, udf8Bytes, bytes);
            assert (readLen == numBytes) : "Decode UTF8 to UTF16 failed";
        }
        return bytes;
    }

    public byte[] readBytesUnCompressedUTF16(MemoryBuffer buffer, int numBytes) {
        byte[] bytes;
        buffer.checkReadableBytes(numBytes);
        byte[] heapMemory = buffer.getHeapMemory();
        if (heapMemory != null) {
            int arrIndex = buffer._unsafeHeapReaderIndex();
            buffer.increaseReaderIndex(numBytes);
            bytes = new byte[numBytes];
            System.arraycopy(heapMemory, arrIndex, bytes, 0, numBytes);
        } else {
            bytes = buffer.readBytes(numBytes);
        }
        return bytes;
    }

    public char[] readCharsUTF16(MemoryBuffer buffer, int numBytes) {
        char[] chars = new char[numBytes >> 1];
        if (Platform.IS_LITTLE_ENDIAN) {
            buffer.readChars(chars, Platform.CHAR_ARRAY_OFFSET, numBytes);
        } else {
            buffer.checkReadableBytes(numBytes);
            byte[] targetArray = buffer.getHeapMemory();
            if (targetArray != null) {
                int i;
                int charIndex = 0;
                int end = i + numBytes;
                for (i = buffer._unsafeHeapReaderIndex(); i < end; i += 2) {
                    char c = (char)(targetArray[i] & 255 << StringUTF16.HI_BYTE_SHIFT | (targetArray[i + 1] & 0xFF) << StringUTF16.LO_BYTE_SHIFT);
                    chars[charIndex++] = c;
                }
                buffer._increaseReaderIndexUnsafe(numBytes);
            } else {
                byte[] tmpArray = this.getByteArray(numBytes);
                buffer.readBytes(tmpArray, 0, numBytes);
                int charIndex = 0;
                for (int i = 0; i < numBytes; i += 2) {
                    char c = (char)(tmpArray[i] & 255 << StringUTF16.HI_BYTE_SHIFT | (tmpArray[i + 1] & 0xFF) << StringUTF16.LO_BYTE_SHIFT);
                    chars[charIndex++] = c;
                }
            }
        }
        return chars;
    }

    public String readCharsUTF8(MemoryBuffer buffer, int numBytes) {
        int charsLen;
        char[] chars = this.getCharArray(numBytes);
        buffer.checkReadableBytes(numBytes);
        byte[] srcArray = buffer.getHeapMemory();
        if (srcArray != null) {
            int srcIndex = buffer._unsafeHeapReaderIndex();
            charsLen = StringEncodingUtils.convertUTF8ToUTF16(srcArray, srcIndex, numBytes, chars);
            buffer._increaseReaderIndexUnsafe(numBytes);
        } else {
            byte[] tmpArray = this.getByteArray(numBytes);
            buffer.readBytes(tmpArray, 0, numBytes);
            charsLen = StringEncodingUtils.convertUTF8ToUTF16(tmpArray, 0, numBytes, chars);
        }
        return new String(chars, 0, charsLen);
    }

    public String readCharsUTF8PerfOptimized(MemoryBuffer buffer, int numBytes) {
        int udf16Chars = numBytes >> 1;
        int udf8Bytes = buffer.readInt32();
        char[] chars = new char[udf16Chars];
        buffer.checkReadableBytes(udf8Bytes);
        byte[] srcArray = buffer.getHeapMemory();
        if (srcArray != null) {
            int srcIndex = buffer._unsafeHeapReaderIndex();
            int readLen = StringEncodingUtils.convertUTF8ToUTF16(srcArray, srcIndex, udf8Bytes, chars);
            assert (readLen == udf16Chars) : "Decode UTF8 to UTF16 failed";
            buffer._increaseReaderIndexUnsafe(udf8Bytes);
        } else {
            byte[] tmpArray = this.getByteArray(udf8Bytes);
            buffer.readBytes(tmpArray, 0, udf8Bytes);
            int readLen = StringEncodingUtils.convertUTF8ToUTF16(tmpArray, 0, udf8Bytes, chars);
            assert (readLen == udf16Chars) : "Decode UTF8 to UTF16 failed";
        }
        return StringSerializer.newCharsStringZeroCopy(chars);
    }

    public void writeCharsLatin1(MemoryBuffer buffer, char[] chars, int numBytes) {
        int writerIndex = buffer.writerIndex();
        long header = (long)numBytes << 2 | 0L;
        buffer.ensure(writerIndex + 5 + numBytes);
        byte[] targetArray = buffer.getHeapMemory();
        if (targetArray != null) {
            int targetIndex;
            int arrIndex = targetIndex = buffer._unsafeHeapWriterIndex();
            arrIndex += LittleEndian.putVarUint36Small(targetArray, arrIndex, header);
            writerIndex += arrIndex - targetIndex;
            for (int i = 0; i < numBytes; ++i) {
                targetArray[arrIndex + i] = (byte)chars[i];
            }
        } else {
            writerIndex += buffer._unsafePutVarUint36Small(writerIndex, header);
            byte[] tmpArray = this.getByteArray(numBytes);
            for (int i = 0; i < numBytes; ++i) {
                tmpArray[i] = (byte)chars[i];
            }
            buffer.put(writerIndex, tmpArray, 0, numBytes);
        }
        buffer._unsafeWriterIndex(writerIndex += numBytes);
    }

    public void writeCharsUTF16(MemoryBuffer buffer, char[] chars, int numChars) {
        int numBytes = MathUtils.doubleExact(numChars);
        int writerIndex = buffer.writerIndex();
        long header = (long)numBytes << 2 | 1L;
        buffer.ensure(writerIndex + 5 + numBytes);
        byte[] targetArray = buffer.getHeapMemory();
        if (targetArray != null) {
            int targetIndex;
            int arrIndex = targetIndex = buffer._unsafeHeapWriterIndex();
            arrIndex += LittleEndian.putVarUint36Small(targetArray, arrIndex, header);
            writerIndex += arrIndex - targetIndex + numBytes;
            if (Platform.IS_LITTLE_ENDIAN) {
                Platform.UNSAFE.copyMemory(chars, Platform.CHAR_ARRAY_OFFSET, targetArray, Platform.BYTE_ARRAY_OFFSET + arrIndex, numBytes);
            } else {
                StringSerializer.heapWriteCharsUTF16BE(chars, arrIndex, numBytes, targetArray);
            }
        } else {
            writerIndex += buffer._unsafePutVarUint36Small(writerIndex, header);
            writerIndex = this.offHeapWriteCharsUTF16(buffer, chars, writerIndex, numBytes);
        }
        buffer._unsafeWriterIndex(writerIndex);
    }

    public void writeCharsUTF8(MemoryBuffer buffer, char[] chars) {
        int estimateMaxBytes = chars.length * 3;
        int approxNumBytes = (int)((double)chars.length * 1.5) + 1;
        int writerIndex = buffer.writerIndex();
        buffer.ensure(writerIndex + 9 + estimateMaxBytes);
        byte[] targetArray = buffer.getHeapMemory();
        if (targetArray != null) {
            int targetIndex;
            int headerPos = targetIndex = buffer._unsafeHeapWriterIndex();
            int arrIndex = targetIndex;
            long header = (long)approxNumBytes << 2 | 2L;
            int headerBytesWritten = LittleEndian.putVarUint36Small(targetArray, arrIndex, header);
            writerIndex += headerBytesWritten;
            targetIndex = StringEncodingUtils.convertUTF16ToUTF8(chars, targetArray, arrIndex += headerBytesWritten);
            byte stashedByte = targetArray[arrIndex];
            int written = targetIndex - arrIndex;
            header = (long)written << 2 | 2L;
            int diff = LittleEndian.putVarUint36Small(targetArray, headerPos, header) - headerBytesWritten;
            if (diff != 0) {
                this.handleWriteCharsUTF8UnalignedHeaderBytes(targetArray, arrIndex, diff, written, stashedByte);
            }
            buffer._unsafeWriterIndex(writerIndex + written + diff);
        } else {
            byte[] tmpArray = this.getByteArray(estimateMaxBytes);
            int written = StringEncodingUtils.convertUTF16ToUTF8(chars, tmpArray, 0);
            long header = (long)written << 2 | 2L;
            writerIndex += buffer._unsafePutVarUint36Small(writerIndex, header);
            buffer.put(writerIndex, tmpArray, 0, written);
            buffer._unsafeWriterIndex(writerIndex + written);
        }
    }

    public void writeCharsUTF8PerfOptimized(MemoryBuffer buffer, char[] chars) {
        int estimateMaxBytes = chars.length * 3;
        int numBytes = MathUtils.doubleExact(chars.length);
        int writerIndex = buffer.writerIndex();
        long header = (long)numBytes << 2 | 2L;
        buffer.ensure(writerIndex + 9 + estimateMaxBytes);
        byte[] targetArray = buffer.getHeapMemory();
        if (targetArray != null) {
            int targetIndex;
            int arrIndex = targetIndex = buffer._unsafeHeapWriterIndex();
            arrIndex += LittleEndian.putVarUint36Small(targetArray, arrIndex, header);
            writerIndex += arrIndex - targetIndex;
            targetIndex = StringEncodingUtils.convertUTF16ToUTF8(chars, targetArray, arrIndex + 4);
            int written = targetIndex - arrIndex - 4;
            buffer._unsafePutInt32(writerIndex, written);
            buffer._unsafeWriterIndex(writerIndex + 4 + written);
        } else {
            byte[] tmpArray = this.getByteArray(estimateMaxBytes);
            int written = StringEncodingUtils.convertUTF16ToUTF8(chars, tmpArray, 0);
            writerIndex += buffer._unsafePutVarUint36Small(writerIndex, header);
            buffer._unsafePutInt32(writerIndex, written);
            buffer.put(writerIndex += 4, tmpArray, 0, written);
            buffer._unsafeWriterIndex(writerIndex + written);
        }
    }

    private void handleWriteCharsUTF8UnalignedHeaderBytes(byte[] targetArray, int arrIndex, int diff, int written, byte stashed) {
        if (diff == 1) {
            System.arraycopy(targetArray, arrIndex + 1, targetArray, arrIndex + 2, written - 1);
            targetArray[arrIndex + 1] = stashed;
        } else {
            System.arraycopy(targetArray, arrIndex, targetArray, arrIndex - 1, written);
        }
    }

    private void writeBytesUTF8(MemoryBuffer buffer, byte[] bytes) {
        int numBytes = bytes.length;
        int estimateMaxBytes = bytes.length / 2 * 3;
        int writerIndex = buffer.writerIndex();
        buffer.ensure(writerIndex + 9 + estimateMaxBytes);
        byte[] targetArray = buffer.getHeapMemory();
        if (targetArray != null) {
            int targetIndex;
            int headerPos = targetIndex = buffer._unsafeHeapWriterIndex();
            int arrIndex = targetIndex;
            long header = (long)numBytes << 2 | 2L;
            int headerBytesWritten = LittleEndian.putVarUint36Small(targetArray, arrIndex, header);
            writerIndex += (arrIndex += headerBytesWritten) - targetIndex;
            targetIndex = StringEncodingUtils.convertUTF16ToUTF8(bytes, targetArray, arrIndex);
            byte stashedByte = targetArray[arrIndex];
            int written = targetIndex - arrIndex;
            header = (long)written << 2 | 2L;
            int diff = LittleEndian.putVarUint36Small(targetArray, headerPos, header) - headerBytesWritten;
            if (diff != 0) {
                this.handleWriteCharsUTF8UnalignedHeaderBytes(targetArray, arrIndex, diff, written, stashedByte);
            }
            buffer._unsafeWriterIndex(writerIndex + written + diff);
        } else {
            byte[] tmpArray = this.getByteArray(estimateMaxBytes);
            int written = StringEncodingUtils.convertUTF16ToUTF8(bytes, tmpArray, 0);
            long header = (long)written << 2 | 2L;
            writerIndex += buffer._unsafePutVarUint36Small(writerIndex, header);
            buffer.put(writerIndex, tmpArray, 0, written);
            buffer._unsafeWriterIndex(writerIndex + written);
        }
    }

    private void writeBytesUTF8PerfOptimized(MemoryBuffer buffer, byte[] bytes) {
        int numBytes = bytes.length;
        int estimateMaxBytes = bytes.length / 2 * 3;
        int writerIndex = buffer.writerIndex();
        long header = (long)numBytes << 2 | 2L;
        buffer.ensure(writerIndex + 9 + estimateMaxBytes);
        byte[] targetArray = buffer.getHeapMemory();
        if (targetArray != null) {
            int targetIndex;
            int arrIndex = targetIndex = buffer._unsafeHeapWriterIndex();
            arrIndex += LittleEndian.putVarUint36Small(targetArray, arrIndex, header);
            writerIndex += arrIndex - targetIndex;
            targetIndex = StringEncodingUtils.convertUTF16ToUTF8(bytes, targetArray, arrIndex + 4);
            int written = targetIndex - arrIndex - 4;
            buffer._unsafePutInt32(writerIndex, written);
            buffer._unsafeWriterIndex(writerIndex + 4 + written);
        } else {
            byte[] tmpArray = this.getByteArray(estimateMaxBytes);
            int written = StringEncodingUtils.convertUTF16ToUTF8(bytes, tmpArray, 0);
            writerIndex += buffer._unsafePutVarUint36Small(writerIndex, header);
            buffer._unsafePutInt32(writerIndex, written);
            buffer.put(writerIndex += 4, tmpArray, 0, written);
            buffer._unsafeWriterIndex(writerIndex + written);
        }
    }

    public static String newCharsStringZeroCopy(char[] data) {
        if (!STRING_VALUE_FIELD_IS_CHARS) {
            throw new IllegalStateException("String value isn't char[], current java isn't supported");
        }
        return CHARS_STRING_ZERO_COPY_CTR.apply(data, Boolean.TRUE);
    }

    public static String newBytesStringZeroCopy(byte coder, byte[] data) {
        if (coder == 0) {
            if (LATIN_BYTES_STRING_ZERO_COPY_CTR != null) {
                return LATIN_BYTES_STRING_ZERO_COPY_CTR.apply(data);
            }
            return BYTES_STRING_ZERO_COPY_CTR.apply(data, LATIN1_BOXED);
        }
        if (coder == 1) {
            return BYTES_STRING_ZERO_COPY_CTR.apply(data, UTF16_BOXED);
        }
        return BYTES_STRING_ZERO_COPY_CTR.apply(data, coder);
    }

    private static BiFunction<char[], Boolean, String> getCharsStringZeroCopyCtr() {
        if (!STRING_VALUE_FIELD_IS_CHARS) {
            return null;
        }
        MethodHandle handle = StringSerializer.getJavaStringZeroCopyCtrHandle();
        if (handle == null) {
            return null;
        }
        try {
            CallSite callSite = LambdaMetafactory.metafactory(STRING_LOOK_UP, "apply", MethodType.methodType(BiFunction.class), handle.type().generic(), handle, handle.type());
            return callSite.getTarget().invokeExact();
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static BiFunction<byte[], Byte, String> getBytesStringZeroCopyCtr() {
        if (!STRING_VALUE_FIELD_IS_BYTES) {
            return null;
        }
        MethodHandle handle = StringSerializer.getJavaStringZeroCopyCtrHandle();
        if (handle == null) {
            return null;
        }
        try {
            MethodType instantiatedMethodType = MethodType.methodType(handle.type().returnType(), new Class[]{byte[].class, Byte.class});
            CallSite callSite = LambdaMetafactory.metafactory(STRING_LOOK_UP, "apply", MethodType.methodType(BiFunction.class), handle.type().generic(), handle, instantiatedMethodType);
            return callSite.getTarget().invokeExact();
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static Function<byte[], String> getLatinBytesStringZeroCopyCtr() {
        if (!STRING_VALUE_FIELD_IS_BYTES) {
            return null;
        }
        if (STRING_LOOK_UP == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName("java.lang.StringCoding");
            MethodHandles.Lookup caller = STRING_LOOK_UP.in(clazz);
            MethodHandle handle = caller.findStatic(clazz, "newStringLatin1", MethodType.methodType(String.class, byte[].class));
            return _JDKAccess.makeFunction(caller, handle, Function.class);
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static MethodHandle getJavaStringZeroCopyCtrHandle() {
        Preconditions.checkArgument(Platform.JAVA_VERSION >= 8);
        if (STRING_LOOK_UP == null) {
            return null;
        }
        try {
            if (STRING_VALUE_FIELD_IS_CHARS) {
                return STRING_LOOK_UP.findConstructor(String.class, MethodType.methodType(Void.TYPE, char[].class, Boolean.TYPE));
            }
            return STRING_LOOK_UP.findConstructor(String.class, MethodType.methodType(Void.TYPE, byte[].class, Byte.TYPE));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void heapWriteCharsUTF16BE(char[] chars, int arrIndex, int numBytes, byte[] targetArray) {
        int i;
        int charIndex = 0;
        int end = i + numBytes;
        for (i = arrIndex; i < end; i += 2) {
            char c = chars[charIndex++];
            targetArray[i] = (byte)(c >> StringUTF16.HI_BYTE_SHIFT);
            targetArray[i + 1] = (byte)(c >> StringUTF16.LO_BYTE_SHIFT);
        }
    }

    private int offHeapWriteCharsUTF16(MemoryBuffer buffer, char[] chars, int writerIndex, int numBytes) {
        byte[] tmpArray = this.getByteArray(numBytes);
        int charIndex = 0;
        for (int i = 0; i < numBytes; i += 2) {
            char c = chars[charIndex++];
            tmpArray[i] = (byte)(c >> StringUTF16.HI_BYTE_SHIFT);
            tmpArray[i + 1] = (byte)(c >> StringUTF16.LO_BYTE_SHIFT);
        }
        buffer.put(writerIndex, tmpArray, 0, numBytes);
        return writerIndex += numBytes;
    }

    private static byte bestCoder(char[] chars) {
        int numChars = chars.length;
        int sampleNum = Math.min(64, numChars);
        int vectorizedLen = sampleNum >> 2;
        int vectorizedChars = vectorizedLen << 2;
        int endOffset = Platform.CHAR_ARRAY_OFFSET + (vectorizedChars << 1);
        int asciiCount = 0;
        int latin1Count = 0;
        int offset = Platform.CHAR_ARRAY_OFFSET;
        int charOffset = 0;
        while (offset < endOffset) {
            int i;
            long multiChars = Platform.getLong(chars, offset);
            if ((multiChars & StringUtils.MULTI_CHARS_NON_ASCII_MASK) == 0L) {
                latin1Count += 4;
                asciiCount += 4;
            } else if ((multiChars & StringUtils.MULTI_CHARS_NON_LATIN_MASK) == 0L) {
                latin1Count += 4;
                for (i = 0; i < 4; ++i) {
                    if (chars[charOffset + i] >= '\u0080') continue;
                    ++asciiCount;
                }
            } else {
                for (i = 0; i < 4; ++i) {
                    if (chars[charOffset + i] < '\u0080') {
                        ++latin1Count;
                        ++asciiCount;
                        continue;
                    }
                    if (chars[charOffset + i] > '\u00ff') continue;
                    ++latin1Count;
                }
            }
            offset += 8;
            charOffset += 4;
        }
        for (int i = vectorizedChars; i < sampleNum; ++i) {
            if (chars[i] < '\u0080') {
                ++latin1Count;
                ++asciiCount;
                continue;
            }
            if (chars[i] > '\u00ff') continue;
            ++latin1Count;
        }
        if (latin1Count == numChars || latin1Count == sampleNum && StringUtils.isLatin(chars, sampleNum)) {
            return 0;
        }
        if ((double)asciiCount >= (double)sampleNum * 0.5) {
            return 2;
        }
        return 1;
    }

    private static byte bestCoder(byte[] bytes) {
        int numBytes = bytes.length;
        int sampleNum = Math.min(128, numBytes);
        int vectorizedLen = sampleNum >> 3;
        int vectorizedBytes = vectorizedLen << 3;
        int endOffset = Platform.BYTE_ARRAY_OFFSET + vectorizedBytes;
        int asciiCount = 0;
        int offset = Platform.BYTE_ARRAY_OFFSET;
        int bytesOffset = 0;
        while (offset < endOffset) {
            long multiChars = Platform.getLong(bytes, offset);
            if ((multiChars & StringUtils.MULTI_CHARS_NON_ASCII_MASK) == 0L) {
                asciiCount += 4;
            } else {
                for (int i = 0; i < 8; i += 2) {
                    if (Platform.getChar(bytes, offset + i) >= '\u0080') continue;
                    ++asciiCount;
                }
            }
            offset += 8;
            bytesOffset += 8;
        }
        int i = vectorizedBytes;
        while (vectorizedBytes < sampleNum) {
            if (Platform.getChar(bytes, Platform.BYTE_ARRAY_OFFSET + i) < '\u0080') {
                ++asciiCount;
            }
            vectorizedBytes += 2;
        }
        if ((double)asciiCount >= (double)sampleNum * 0.5) {
            return 2;
        }
        return 1;
    }

    private char[] getCharArray(int numElements) {
        char[] charArray = this.charArray;
        if (charArray.length < numElements) {
            this.charArray = charArray = new char[numElements];
        }
        if (charArray.length > 1024) {
            this.smoothCharArrayLength = Math.max((int)((double)this.smoothCharArrayLength * 0.9 + (double)numElements * 0.1), 1024);
            if (this.smoothByteArrayLength <= 1024) {
                this.charArray = new char[1024];
            }
        }
        return charArray;
    }

    private byte[] getByteArray(int numElements) {
        byte[] byteArray = this.byteArray;
        if (byteArray.length < numElements) {
            this.byteArray = byteArray = new byte[numElements];
        }
        if (byteArray.length > 1024) {
            this.smoothByteArrayLength = Math.max((int)((double)this.smoothByteArrayLength * 0.9 + (double)numElements * 0.1), 1024);
            if (this.smoothByteArrayLength <= 1024) {
                this.byteArray = new byte[1024];
            }
        }
        return byteArray;
    }

    private byte[] getByteArray2(int numElements) {
        byte[] byteArray2 = this.byteArray2;
        if (byteArray2.length < numElements) {
            byteArray2 = new byte[numElements];
            this.byteArray = byteArray2;
        }
        if (byteArray2.length > 1024) {
            this.smoothByteArrayLength = Math.max((int)((double)this.smoothByteArrayLength * 0.9 + (double)numElements * 0.1), 1024);
            if (this.smoothByteArrayLength <= 1024) {
                this.byteArray2 = new byte[1024];
            }
        }
        return byteArray2;
    }

    static {
        LATIN1_BOXED = 0;
        UTF16_BOXED = 1;
        Field valueField = ReflectionUtils.getFieldNullable(String.class, "value");
        STRING_VALUE_FIELD_IS_CHARS = valueField != null && valueField.getType() == char[].class;
        STRING_VALUE_FIELD_IS_BYTES = valueField != null && valueField.getType() == byte[].class;
        try {
            STRING_VALUE_FIELD_OFFSET = Platform.objectFieldOffset(String.class.getDeclaredField("value"));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        Preconditions.checkArgument(ReflectionUtils.getFieldNullable(String.class, "count") == null, "Current jdk not supported");
        Preconditions.checkArgument(ReflectionUtils.getFieldNullable(String.class, "offset") == null, "Current jdk not supported");
        STRING_LOOK_UP = _JDKAccess._trustedLookup(String.class);
        CHARS_STRING_ZERO_COPY_CTR = StringSerializer.getCharsStringZeroCopyCtr();
        BYTES_STRING_ZERO_COPY_CTR = StringSerializer.getBytesStringZeroCopyCtr();
        LATIN_BYTES_STRING_ZERO_COPY_CTR = StringSerializer.getLatinBytesStringZeroCopyCtr();
    }

    private static class Offset {
        private static final long STRING_CODER_FIELD_OFFSET;

        private Offset() {
        }

        static {
            try {
                STRING_CODER_FIELD_OFFSET = Platform.objectFieldOffset(String.class.getDeclaredField("coder"));
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

