/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.serializer.collection;

import java.lang.invoke.MethodHandle;
import java.util.Collection;
import org.apache.fury.Fury;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.reflect.ReflectionUtils;
import org.apache.fury.resolver.ClassInfo;
import org.apache.fury.resolver.ClassInfoHolder;
import org.apache.fury.resolver.ClassResolver;
import org.apache.fury.resolver.RefResolver;
import org.apache.fury.serializer.Serializer;
import org.apache.fury.serializer.collection.CollectionFlags;
import org.apache.fury.type.GenericType;
import org.apache.fury.util.Preconditions;

public abstract class AbstractCollectionSerializer<T>
extends Serializer<T> {
    private MethodHandle constructor;
    private int numElements;
    protected final boolean supportCodegenHook;
    private Serializer<?> elemSerializer;
    protected final ClassInfoHolder elementClassInfoHolder;

    public AbstractCollectionSerializer(Fury fury, Class<T> cls) {
        this(fury, cls, !ReflectionUtils.isDynamicGeneratedCLass(cls));
    }

    public AbstractCollectionSerializer(Fury fury, Class<T> cls, boolean supportCodegenHook) {
        super(fury, cls);
        this.supportCodegenHook = supportCodegenHook;
        this.elementClassInfoHolder = fury.getClassResolver().nilClassInfoHolder();
    }

    public AbstractCollectionSerializer(Fury fury, Class<T> cls, boolean supportCodegenHook, boolean immutable) {
        super(fury, cls, immutable);
        this.supportCodegenHook = supportCodegenHook;
        this.elementClassInfoHolder = fury.getClassResolver().nilClassInfoHolder();
    }

    private GenericType getElementGenericType(Fury fury) {
        GenericType genericType = fury.getGenerics().nextGenericType();
        GenericType elemGenericType = null;
        if (genericType != null) {
            elemGenericType = genericType.getTypeParameter0();
        }
        return elemGenericType;
    }

    public void setElementSerializer(Serializer serializer) {
        this.elemSerializer = serializer;
    }

    public final boolean supportCodegenHook() {
        return this.supportCodegenHook;
    }

    public abstract Collection onCollectionWrite(MemoryBuffer var1, T var2);

    protected final int writeElementsHeader(MemoryBuffer buffer, Collection value) {
        GenericType elemGenericType = this.getElementGenericType(this.fury);
        if (elemGenericType != null) {
            boolean trackingRef = elemGenericType.trackingRef(this.fury.getClassResolver());
            if (elemGenericType.isMonomorphic()) {
                if (trackingRef) {
                    buffer.writeByte(CollectionFlags.TRACKING_REF);
                    return CollectionFlags.TRACKING_REF;
                }
                return this.writeNullabilityHeader(buffer, value);
            }
            if (trackingRef) {
                return this.writeTypeHeader(buffer, value, elemGenericType.getCls(), this.elementClassInfoHolder);
            }
            return this.writeTypeNullabilityHeader(buffer, value, elemGenericType.getCls(), this.elementClassInfoHolder);
        }
        if (this.elemSerializer != null) {
            if (this.elemSerializer.needToWriteRef()) {
                buffer.writeByte(CollectionFlags.TRACKING_REF);
                return CollectionFlags.TRACKING_REF;
            }
            return this.writeNullabilityHeader(buffer, value);
        }
        if (this.fury.trackingRef()) {
            return this.writeTypeHeader(buffer, value, this.elementClassInfoHolder);
        }
        return this.writeTypeNullabilityHeader(buffer, value, null, this.elementClassInfoHolder);
    }

    public int writeNullabilityHeader(MemoryBuffer buffer, Collection value) {
        for (Object elem : value) {
            if (elem != null) continue;
            buffer.writeByte(CollectionFlags.HAS_NULL);
            return CollectionFlags.HAS_NULL;
        }
        buffer.writeByte(0);
        return 0;
    }

    public int writeTypeHeader(MemoryBuffer buffer, Collection value, Class<?> declareElementType, ClassInfoHolder cache) {
        int bitmap = CollectionFlags.TRACKING_REF;
        boolean hasDifferentClass = false;
        Class<Void> elemClass = null;
        for (Object elem : value) {
            if (elem == null) continue;
            if (elemClass == null) {
                elemClass = elem.getClass();
                continue;
            }
            if (elemClass == elem.getClass()) continue;
            hasDifferentClass = true;
            break;
        }
        if (hasDifferentClass) {
            buffer.writeByte(bitmap |= CollectionFlags.NOT_SAME_TYPE | CollectionFlags.NOT_DECL_ELEMENT_TYPE);
        } else {
            if (elemClass == null) {
                elemClass = Void.TYPE;
            }
            if (!this.fury.getConfig().isMetaShareEnabled() && elemClass == declareElementType) {
                buffer.writeByte(bitmap);
            } else {
                buffer.writeByte(bitmap |= CollectionFlags.NOT_DECL_ELEMENT_TYPE);
                ClassResolver classResolver = this.fury.getClassResolver();
                ClassInfo classInfo = classResolver.getClassInfo(elemClass, cache);
                classResolver.writeClass(buffer, classInfo);
            }
        }
        return bitmap;
    }

    public int writeTypeHeader(MemoryBuffer buffer, Collection value, ClassInfoHolder cache) {
        int bitmap = CollectionFlags.NOT_DECL_ELEMENT_TYPE;
        boolean hasDifferentClass = false;
        Class<Object> elemClass = null;
        boolean containsNull = false;
        for (Object elem : value) {
            if (elem == null) {
                containsNull = true;
                continue;
            }
            if (elemClass == null) {
                elemClass = elem.getClass();
                continue;
            }
            if (hasDifferentClass || elem.getClass() == elemClass) continue;
            hasDifferentClass = true;
        }
        if (containsNull) {
            bitmap |= CollectionFlags.HAS_NULL;
        }
        if (hasDifferentClass) {
            buffer.writeByte(bitmap |= CollectionFlags.NOT_SAME_TYPE | CollectionFlags.TRACKING_REF);
        } else {
            ClassInfo classInfo;
            ClassResolver classResolver = this.fury.getClassResolver();
            if (elemClass == null) {
                elemClass = Object.class;
            }
            if ((classInfo = classResolver.getClassInfo(elemClass, cache)).getSerializer().needToWriteRef()) {
                bitmap |= CollectionFlags.TRACKING_REF;
            }
            buffer.writeByte(bitmap);
            classResolver.writeClass(buffer, classInfo);
        }
        return bitmap;
    }

    public int writeTypeNullabilityHeader(MemoryBuffer buffer, Collection value, Class<?> declareElementType, ClassInfoHolder cache) {
        int bitmap = 0;
        boolean containsNull = false;
        boolean hasDifferentClass = false;
        Class elemClass = null;
        for (Object elem : value) {
            if (elem == null) {
                containsNull = true;
                continue;
            }
            if (elemClass == null) {
                elemClass = elem.getClass();
                continue;
            }
            if (hasDifferentClass || elem.getClass() == elemClass) continue;
            hasDifferentClass = true;
        }
        if (containsNull) {
            bitmap |= CollectionFlags.HAS_NULL;
        }
        if (hasDifferentClass) {
            buffer.writeByte(bitmap |= CollectionFlags.NOT_SAME_TYPE | CollectionFlags.NOT_DECL_ELEMENT_TYPE);
        } else {
            if (elemClass == null) {
                elemClass = Object.class;
            }
            if (!this.fury.getConfig().isMetaShareEnabled() && elemClass == declareElementType) {
                buffer.writeByte(bitmap);
            } else {
                buffer.writeByte(bitmap |= CollectionFlags.NOT_DECL_ELEMENT_TYPE);
                ClassResolver classResolver = this.fury.getClassResolver();
                ClassInfo classInfo = classResolver.getClassInfo(elemClass, cache);
                classResolver.writeClass(buffer, classInfo);
            }
        }
        return bitmap;
    }

    @Override
    public void write(MemoryBuffer buffer, T value) {
        Collection collection = this.onCollectionWrite(buffer, value);
        int len = collection.size();
        if (len != 0) {
            this.writeElements(this.fury, buffer, collection);
        }
    }

    protected final void writeElements(Fury fury, MemoryBuffer buffer, Collection value) {
        int flags = this.writeElementsHeader(buffer, value);
        Serializer<?> serializer = this.elemSerializer;
        this.elemSerializer = null;
        if (serializer == null) {
            GenericType elemGenericType = this.getElementGenericType(fury);
            if (elemGenericType != null) {
                this.javaWriteWithGenerics(fury, buffer, value, elemGenericType, flags);
            } else {
                this.generalJavaWrite(fury, buffer, value, null, flags);
            }
        } else {
            AbstractCollectionSerializer.compatibleWrite(fury, buffer, value, serializer, flags);
        }
    }

    private static <T extends Collection> void compatibleWrite(Fury fury, MemoryBuffer buffer, T value, Serializer serializer, int flags) {
        if (serializer.needToWriteRef()) {
            for (Object elem : value) {
                fury.writeRef(buffer, elem, serializer);
            }
        } else {
            boolean hasNull;
            boolean bl = hasNull = (flags & CollectionFlags.HAS_NULL) == CollectionFlags.HAS_NULL;
            if (hasNull) {
                for (Object elem : value) {
                    if (elem == null) {
                        buffer.writeByte((byte)-3);
                        continue;
                    }
                    buffer.writeByte((byte)-1);
                    serializer.write(buffer, elem);
                }
            } else {
                for (Object elem : value) {
                    serializer.write(buffer, elem);
                }
            }
        }
    }

    private void javaWriteWithGenerics(Fury fury, MemoryBuffer buffer, Collection collection, GenericType elemGenericType, int flags) {
        boolean hasGenericParameters = elemGenericType.hasGenericParameters();
        if (hasGenericParameters) {
            fury.getGenerics().pushGenericType(elemGenericType);
        }
        if (elemGenericType.isMonomorphic()) {
            Serializer<?> serializer = elemGenericType.getSerializer(fury.getClassResolver());
            AbstractCollectionSerializer.writeSameTypeElements(fury, buffer, serializer, flags, collection);
        } else {
            this.generalJavaWrite(fury, buffer, collection, elemGenericType, flags);
        }
        if (hasGenericParameters) {
            fury.getGenerics().popGenericType();
        }
    }

    private void generalJavaWrite(Fury fury, MemoryBuffer buffer, Collection collection, GenericType elemGenericType, int flags) {
        if ((flags & CollectionFlags.NOT_SAME_TYPE) != CollectionFlags.NOT_SAME_TYPE) {
            Serializer<?> serializer;
            if ((flags & CollectionFlags.NOT_DECL_ELEMENT_TYPE) != CollectionFlags.NOT_DECL_ELEMENT_TYPE) {
                Preconditions.checkNotNull(elemGenericType);
                serializer = elemGenericType.getSerializer(fury.getClassResolver());
            } else {
                serializer = this.elementClassInfoHolder.getSerializer();
            }
            AbstractCollectionSerializer.writeSameTypeElements(fury, buffer, serializer, flags, collection);
        } else {
            AbstractCollectionSerializer.writeDifferentTypeElements(fury, buffer, flags, collection);
        }
    }

    private static <T extends Collection> void writeSameTypeElements(Fury fury, MemoryBuffer buffer, Serializer serializer, int flags, T collection) {
        fury.incDepth(1);
        if ((flags & CollectionFlags.TRACKING_REF) == CollectionFlags.TRACKING_REF) {
            RefResolver refResolver = fury.getRefResolver();
            for (Object elem : collection) {
                if (refResolver.writeRefOrNull(buffer, elem)) continue;
                serializer.write(buffer, elem);
            }
        } else if ((flags & CollectionFlags.HAS_NULL) != CollectionFlags.HAS_NULL) {
            for (Object elem : collection) {
                serializer.write(buffer, elem);
            }
        } else {
            for (Object elem : collection) {
                if (elem == null) {
                    buffer.writeByte((byte)-3);
                    continue;
                }
                buffer.writeByte((byte)-1);
                serializer.write(buffer, elem);
            }
        }
        fury.incDepth(-1);
    }

    private static <T extends Collection> void writeDifferentTypeElements(Fury fury, MemoryBuffer buffer, int flags, T collection) {
        if ((flags & CollectionFlags.TRACKING_REF) == CollectionFlags.TRACKING_REF) {
            for (Object elem : collection) {
                fury.writeRef(buffer, elem);
            }
        } else if ((flags & CollectionFlags.HAS_NULL) != CollectionFlags.HAS_NULL) {
            for (Object elem : collection) {
                fury.writeNonRef(buffer, elem);
            }
        } else {
            for (Object elem : collection) {
                fury.writeNullable(buffer, elem);
            }
        }
    }

    @Override
    public void xwrite(MemoryBuffer buffer, T value) {
        Collection collection = (Collection)value;
        int len = collection.size();
        buffer.writeVarUint32Small7(len);
        this.xwriteElements(this.fury, buffer, collection);
    }

    private void xwriteElements(Fury fury, MemoryBuffer buffer, Collection value) {
        GenericType elemGenericType = this.getElementGenericType(fury);
        if (elemGenericType != null) {
            boolean hasGenericParameters = elemGenericType.hasGenericParameters();
            if (hasGenericParameters) {
                fury.getGenerics().pushGenericType(elemGenericType);
            }
            if (elemGenericType.isMonomorphic()) {
                Serializer<?> elemSerializer = elemGenericType.getSerializer(fury.getClassResolver());
                for (Object elem : value) {
                    fury.xwriteRef(buffer, elem, elemSerializer);
                }
            } else {
                for (Object elem : value) {
                    fury.xwriteRef(buffer, elem);
                }
            }
            if (hasGenericParameters) {
                fury.getGenerics().popGenericType();
            }
        } else {
            for (Object elem : value) {
                fury.xwriteRef(buffer, elem);
            }
        }
    }

    @Override
    public abstract T read(MemoryBuffer var1);

    public Collection newCollection(MemoryBuffer buffer) {
        this.numElements = buffer.readVarUint32Small7();
        if (this.constructor == null) {
            this.constructor = ReflectionUtils.getCtrHandle(this.type, true);
        }
        try {
            Object instance = this.constructor.invoke();
            this.fury.getRefResolver().reference(instance);
            return (Collection)instance;
        }
        catch (Throwable e) {
            throw this.buildException(e);
        }
    }

    public Collection newCollection(Collection collection) {
        this.numElements = collection.size();
        if (this.constructor == null) {
            this.constructor = ReflectionUtils.getCtrHandle(this.type, true);
        }
        try {
            return this.constructor.invoke();
        }
        catch (Throwable e) {
            throw this.buildException(e);
        }
    }

    public void copyElements(Collection originCollection, Collection newCollection) {
        ClassResolver classResolver = this.fury.getClassResolver();
        for (Object element : originCollection) {
            ClassInfo classInfo;
            if (element != null && !(classInfo = classResolver.getClassInfo(element.getClass(), this.elementClassInfoHolder)).getSerializer().isImmutable()) {
                element = this.fury.copyObject(element, classInfo.getClassId());
            }
            newCollection.add(element);
        }
    }

    public void copyElements(Collection originCollection, Object[] elements) {
        int index = 0;
        ClassResolver classResolver = this.fury.getClassResolver();
        for (Object element : originCollection) {
            ClassInfo classInfo;
            if (element != null && !(classInfo = classResolver.getClassInfo(element.getClass(), this.elementClassInfoHolder)).getSerializer().isImmutable()) {
                element = this.fury.copyObject(element, classInfo.getSerializer());
            }
            elements[index++] = element;
        }
    }

    private RuntimeException buildException(Throwable e) {
        return new IllegalArgumentException("Please provide public no arguments constructor for class " + this.type, e);
    }

    public int getAndClearNumElements() {
        int size = this.numElements;
        this.numElements = -1;
        return size;
    }

    protected void setNumElements(int numElements) {
        this.numElements = numElements;
    }

    public abstract T onCollectionRead(Collection var1);

    protected void readElements(Fury fury, MemoryBuffer buffer, Collection collection, int numElements) {
        byte flags = buffer.readByte();
        Serializer<?> serializer = this.elemSerializer;
        this.elemSerializer = null;
        if (serializer == null) {
            GenericType elemGenericType = this.getElementGenericType(fury);
            if (elemGenericType != null) {
                this.javaReadWithGenerics(fury, buffer, collection, numElements, elemGenericType, flags);
            } else {
                this.generalJavaRead(fury, buffer, collection, numElements, flags, null);
            }
        } else {
            AbstractCollectionSerializer.compatibleRead(fury, buffer, collection, numElements, serializer, flags);
        }
    }

    private static void compatibleRead(Fury fury, MemoryBuffer buffer, Collection collection, int numElements, Serializer serializer, int flags) {
        if (serializer.needToWriteRef()) {
            for (int i = 0; i < numElements; ++i) {
                collection.add(fury.readRef(buffer, serializer));
            }
        } else if ((flags & CollectionFlags.HAS_NULL) == CollectionFlags.HAS_NULL) {
            for (int i = 0; i < numElements; ++i) {
                if (buffer.readByte() == -3) {
                    collection.add(null);
                    continue;
                }
                Object elem = serializer.read(buffer);
                collection.add(elem);
            }
        } else {
            for (int i = 0; i < numElements; ++i) {
                Object elem = serializer.read(buffer);
                collection.add(elem);
            }
        }
    }

    private void javaReadWithGenerics(Fury fury, MemoryBuffer buffer, Collection collection, int numElements, GenericType elemGenericType, int flags) {
        boolean hasGenericParameters = elemGenericType.hasGenericParameters();
        if (hasGenericParameters) {
            fury.getGenerics().pushGenericType(elemGenericType);
        }
        if (elemGenericType.isMonomorphic()) {
            Serializer<?> serializer = elemGenericType.getSerializer(fury.getClassResolver());
            AbstractCollectionSerializer.readSameTypeElements(fury, buffer, serializer, flags, collection, numElements);
        } else {
            this.generalJavaRead(fury, buffer, collection, numElements, flags, elemGenericType);
        }
        if (hasGenericParameters) {
            fury.getGenerics().popGenericType();
        }
    }

    private void generalJavaRead(Fury fury, MemoryBuffer buffer, Collection collection, int numElements, int flags, GenericType elemGenericType) {
        if ((flags & CollectionFlags.NOT_SAME_TYPE) != CollectionFlags.NOT_SAME_TYPE) {
            Serializer<Object> serializer;
            ClassResolver classResolver = fury.getClassResolver();
            if ((flags & CollectionFlags.NOT_DECL_ELEMENT_TYPE) == CollectionFlags.NOT_DECL_ELEMENT_TYPE) {
                serializer = classResolver.readClassInfo(buffer, this.elementClassInfoHolder).getSerializer();
            } else {
                Preconditions.checkNotNull(elemGenericType);
                serializer = elemGenericType.getSerializer(classResolver);
            }
            AbstractCollectionSerializer.readSameTypeElements(fury, buffer, serializer, flags, collection, numElements);
        } else {
            AbstractCollectionSerializer.readDifferentTypeElements(fury, buffer, flags, collection, numElements);
        }
    }

    private static <T extends Collection> void readSameTypeElements(Fury fury, MemoryBuffer buffer, Serializer serializer, int flags, T collection, int numElements) {
        fury.incDepth(1);
        if ((flags & CollectionFlags.TRACKING_REF) == CollectionFlags.TRACKING_REF) {
            for (int i = 0; i < numElements; ++i) {
                collection.add(fury.readRef(buffer, serializer));
            }
        } else if ((flags & CollectionFlags.HAS_NULL) != CollectionFlags.HAS_NULL) {
            for (int i = 0; i < numElements; ++i) {
                collection.add(serializer.read(buffer));
            }
        } else {
            for (int i = 0; i < numElements; ++i) {
                if (buffer.readByte() == -3) {
                    collection.add(null);
                    continue;
                }
                collection.add(serializer.read(buffer));
            }
        }
        fury.incDepth(-1);
    }

    private static <T extends Collection> void readDifferentTypeElements(Fury fury, MemoryBuffer buffer, int flags, T collection, int numElements) {
        if ((flags & CollectionFlags.TRACKING_REF) == CollectionFlags.TRACKING_REF) {
            for (int i = 0; i < numElements; ++i) {
                collection.add((Object)fury.readRef(buffer));
            }
        } else if ((flags & CollectionFlags.HAS_NULL) != CollectionFlags.HAS_NULL) {
            for (int i = 0; i < numElements; ++i) {
                collection.add((Object)fury.readNonRef(buffer));
            }
        } else {
            for (int i = 0; i < numElements; ++i) {
                collection.add((Object)fury.readNullable(buffer));
            }
        }
    }

    @Override
    public T xread(MemoryBuffer buffer) {
        Collection collection = this.newCollection(buffer);
        this.xreadElements(this.fury, buffer, collection, this.numElements);
        return this.onCollectionRead(collection);
    }

    public void xreadElements(Fury fury, MemoryBuffer buffer, Collection collection, int numElements) {
        GenericType elemGenericType = this.getElementGenericType(fury);
        if (elemGenericType != null) {
            boolean hasGenericParameters = elemGenericType.hasGenericParameters();
            if (hasGenericParameters) {
                fury.getGenerics().pushGenericType(elemGenericType);
            }
            if (elemGenericType.isMonomorphic()) {
                Serializer<?> elemSerializer = elemGenericType.getSerializer(fury.getClassResolver());
                for (int i = 0; i < numElements; ++i) {
                    Object elem = fury.xreadRefByNullableSerializer(buffer, elemSerializer);
                    collection.add(elem);
                }
            } else {
                for (int i = 0; i < numElements; ++i) {
                    Object elem = fury.xreadRef(buffer);
                    collection.add(elem);
                }
            }
            if (hasGenericParameters) {
                fury.getGenerics().popGenericType();
            }
        } else {
            for (int i = 0; i < numElements; ++i) {
                Object elem = fury.xreadRef(buffer);
                collection.add(elem);
            }
        }
    }
}

