/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.serializer.collection;

import com.google.common.collect.ImmutableMap;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;
import org.apache.fury.Fury;
import org.apache.fury.collection.IdentityMap;
import org.apache.fury.collection.Tuple2;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.reflect.ReflectionUtils;
import org.apache.fury.reflect.TypeRef;
import org.apache.fury.resolver.ClassInfo;
import org.apache.fury.resolver.ClassInfoHolder;
import org.apache.fury.resolver.ClassResolver;
import org.apache.fury.resolver.RefResolver;
import org.apache.fury.serializer.Serializer;
import org.apache.fury.serializer.collection.MapFlags;
import org.apache.fury.type.GenericType;
import org.apache.fury.type.Generics;
import org.apache.fury.type.TypeUtils;

public abstract class AbstractMapSerializer<T>
extends Serializer<T> {
    public static final int MAX_CHUNK_SIZE = 255;
    protected MethodHandle constructor;
    protected final boolean supportCodegenHook;
    private Serializer keySerializer;
    private Serializer valueSerializer;
    protected final ClassInfoHolder keyClassInfoWriteCache;
    protected final ClassInfoHolder keyClassInfoReadCache;
    protected final ClassInfoHolder valueClassInfoWriteCache;
    protected final ClassInfoHolder valueClassInfoReadCache;
    private final IdentityMap<GenericType, GenericType> partialGenericKVTypeMap;
    private final GenericType objType;
    private int numElements;
    private final ClassResolver classResolver;

    public AbstractMapSerializer(Fury fury, Class<T> cls) {
        this(fury, cls, !ReflectionUtils.isDynamicGeneratedCLass(cls));
    }

    public AbstractMapSerializer(Fury fury, Class<T> cls, boolean supportCodegenHook) {
        super(fury, cls);
        this.objType = this.fury.getClassResolver().buildGenericType((Type)((Object)Object.class));
        this.classResolver = fury.getClassResolver();
        this.supportCodegenHook = supportCodegenHook;
        this.keyClassInfoWriteCache = fury.getClassResolver().nilClassInfoHolder();
        this.keyClassInfoReadCache = fury.getClassResolver().nilClassInfoHolder();
        this.valueClassInfoWriteCache = fury.getClassResolver().nilClassInfoHolder();
        this.valueClassInfoReadCache = fury.getClassResolver().nilClassInfoHolder();
        this.partialGenericKVTypeMap = new IdentityMap();
    }

    public AbstractMapSerializer(Fury fury, Class<T> cls, boolean supportCodegenHook, boolean immutable) {
        super(fury, cls, immutable);
        this.objType = this.fury.getClassResolver().buildGenericType((Type)((Object)Object.class));
        this.classResolver = fury.getClassResolver();
        this.supportCodegenHook = supportCodegenHook;
        this.keyClassInfoWriteCache = fury.getClassResolver().nilClassInfoHolder();
        this.keyClassInfoReadCache = fury.getClassResolver().nilClassInfoHolder();
        this.valueClassInfoWriteCache = fury.getClassResolver().nilClassInfoHolder();
        this.valueClassInfoReadCache = fury.getClassResolver().nilClassInfoHolder();
        this.partialGenericKVTypeMap = new IdentityMap();
    }

    public void setKeySerializer(Serializer keySerializer) {
        this.keySerializer = keySerializer;
    }

    public void setValueSerializer(Serializer valueSerializer) {
        this.valueSerializer = valueSerializer;
    }

    @Override
    public void write(MemoryBuffer buffer, T value) {
        Map map = this.onMapWrite(buffer, value);
        Serializer keySerializer = this.keySerializer;
        Serializer valueSerializer = this.valueSerializer;
        this.keySerializer = null;
        this.valueSerializer = null;
        if (map.isEmpty()) {
            return;
        }
        ClassResolver classResolver = this.fury.getClassResolver();
        Iterator<Map.Entry<Object, Object>> iterator = map.entrySet().iterator();
        Map.Entry entry = iterator.next();
        while (entry != null) {
            if ((entry = this.writeJavaNullChunk(buffer, entry, iterator, keySerializer, valueSerializer)) == null) continue;
            if (keySerializer != null || valueSerializer != null) {
                entry = this.writeJavaChunk(classResolver, buffer, entry, iterator, keySerializer, valueSerializer);
                continue;
            }
            Generics generics = this.fury.getGenerics();
            GenericType genericType = generics.nextGenericType();
            if (genericType == null) {
                entry = this.writeJavaChunk(classResolver, buffer, entry, iterator, null, null);
                continue;
            }
            entry = this.writeJavaChunkGeneric(classResolver, generics, genericType, buffer, entry, iterator);
        }
    }

    @Override
    public void xwrite(MemoryBuffer buffer, T value) {
        Map map = this.onMapWrite(buffer, value);
        AbstractMapSerializer.xwriteElements(this.fury, buffer, map);
    }

    public final Map.Entry writeJavaNullChunk(MemoryBuffer buffer, Map.Entry entry, Iterator<Map.Entry<Object, Object>> iterator, Serializer keySerializer, Serializer valueSerializer) {
        while (true) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key != null) {
                if (value != null) {
                    return entry;
                }
                this.writeNullValueChunk(buffer, keySerializer, key);
            } else {
                this.writeNullKeyChunk(buffer, valueSerializer, value);
            }
            if (!iterator.hasNext()) break;
            entry = iterator.next();
        }
        return null;
    }

    private void writeNullValueChunk(MemoryBuffer buffer, Serializer keySerializer, Object key) {
        if (keySerializer != null) {
            if (keySerializer.needToWriteRef()) {
                buffer.writeByte(MapFlags.NULL_VALUE_KEY_DECL_TYPE_TRACKING_REF);
                this.fury.writeRef(buffer, key, keySerializer);
            } else {
                buffer.writeByte(MapFlags.NULL_VALUE_KEY_DECL_TYPE);
                keySerializer.write(buffer, key);
            }
        } else {
            buffer.writeByte(MapFlags.VALUE_HAS_NULL | MapFlags.TRACKING_KEY_REF);
            this.fury.writeRef(buffer, key, this.keyClassInfoWriteCache);
        }
    }

    private void writeNullKeyChunk(MemoryBuffer buffer, Serializer valueSerializer, Object value) {
        if (value != null) {
            if (valueSerializer != null) {
                if (valueSerializer.needToWriteRef()) {
                    buffer.writeByte(MapFlags.NULL_KEY_VALUE_DECL_TYPE_TRACKING_REF);
                    this.fury.writeRef(buffer, value, valueSerializer);
                } else {
                    buffer.writeByte(MapFlags.NULL_KEY_VALUE_DECL_TYPE);
                    valueSerializer.write(buffer, value);
                }
            } else {
                buffer.writeByte(MapFlags.KEY_HAS_NULL | MapFlags.TRACKING_VALUE_REF);
                this.fury.writeRef(buffer, value, this.valueClassInfoWriteCache);
            }
        } else {
            buffer.writeByte(MapFlags.KV_NULL);
        }
    }

    public final Map.Entry writeNullChunkKVFinalNoRef(MemoryBuffer buffer, Map.Entry entry, Iterator<Map.Entry<Object, Object>> iterator, Serializer keySerializer, Serializer valueSerializer) {
        while (true) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key != null) {
                if (value != null) {
                    return entry;
                }
                buffer.writeByte(MapFlags.NULL_VALUE_KEY_DECL_TYPE);
                keySerializer.write(buffer, key);
            } else {
                this.writeNullKeyChunk(buffer, valueSerializer, value);
            }
            if (!iterator.hasNext()) break;
            entry = iterator.next();
        }
        return null;
    }

    private Map.Entry writeJavaChunk(ClassResolver classResolver, MemoryBuffer buffer, Map.Entry<Object, Object> entry, Iterator<Map.Entry<Object, Object>> iterator, Serializer keySerializer, Serializer valueSerializer) {
        Object key = entry.getKey();
        Object value = entry.getValue();
        Class<?> keyType = key.getClass();
        Class<?> valueType = value.getClass();
        buffer.writeInt16((short)-1);
        int chunkSizeOffset = buffer.writerIndex() - 1;
        int chunkHeader = 0;
        if (keySerializer != null) {
            chunkHeader |= MapFlags.KEY_DECL_TYPE;
        } else {
            keySerializer = this.writeKeyClassInfo(classResolver, keyType, buffer);
        }
        if (valueSerializer != null) {
            chunkHeader |= MapFlags.VALUE_DECL_TYPE;
        } else {
            valueSerializer = this.writeValueClassInfo(classResolver, valueType, buffer);
        }
        boolean keyWriteRef = keySerializer.needToWriteRef();
        boolean valueWriteRef = valueSerializer.needToWriteRef();
        if (keyWriteRef) {
            chunkHeader |= MapFlags.TRACKING_KEY_REF;
        }
        if (valueWriteRef) {
            chunkHeader |= MapFlags.TRACKING_VALUE_REF;
        }
        buffer.putByte(chunkSizeOffset - 1, (byte)chunkHeader);
        RefResolver refResolver = this.fury.getRefResolver();
        int chunkSize = 0;
        while (key != null && value != null && key.getClass() == keyType && value.getClass() == valueType) {
            if (!keyWriteRef || !refResolver.writeRefOrNull(buffer, key)) {
                keySerializer.write(buffer, key);
            }
            if (!valueWriteRef || !refResolver.writeRefOrNull(buffer, value)) {
                valueSerializer.write(buffer, value);
            }
            ++chunkSize;
            if (!iterator.hasNext()) {
                entry = null;
                break;
            }
            entry = iterator.next();
            key = entry.getKey();
            value = entry.getValue();
            if (chunkSize != 255) continue;
        }
        buffer.putByte(chunkSizeOffset, (byte)chunkSize);
        return entry;
    }

    private Serializer writeKeyClassInfo(ClassResolver classResolver, Class keyType, MemoryBuffer buffer) {
        ClassInfo classInfo = classResolver.getClassInfo(keyType, this.keyClassInfoWriteCache);
        classResolver.writeClass(buffer, classInfo);
        return classInfo.getSerializer();
    }

    private Serializer writeValueClassInfo(ClassResolver classResolver, Class valueType, MemoryBuffer buffer) {
        ClassInfo classInfo = classResolver.getClassInfo(valueType, this.valueClassInfoWriteCache);
        classResolver.writeClass(buffer, classInfo);
        return classInfo.getSerializer();
    }

    private Map.Entry writeJavaChunkGeneric(ClassResolver classResolver, Generics generics, GenericType genericType, MemoryBuffer buffer, Map.Entry<Object, Object> entry, Iterator<Map.Entry<Object, Object>> iterator) {
        boolean valueWriteRef;
        Serializer<?> valueSerializer;
        Serializer<?> keySerializer;
        if (genericType.getTypeParametersCount() < 2) {
            genericType = this.getKVGenericType(genericType);
        }
        GenericType keyGenericType = genericType.getTypeParameter0();
        GenericType valueGenericType = genericType.getTypeParameter1();
        if (keyGenericType == this.objType && valueGenericType == this.objType) {
            return this.writeJavaChunk(classResolver, buffer, entry, iterator, null, null);
        }
        boolean keyGenericTypeFinal = keyGenericType.isMonomorphic();
        boolean valueGenericTypeFinal = valueGenericType.isMonomorphic();
        Object key = entry.getKey();
        Object value = entry.getValue();
        Class<?> keyType = key.getClass();
        Class<?> valueType = value.getClass();
        buffer.writeInt16((short)-1);
        int chunkSizeOffset = buffer.writerIndex() - 1;
        int chunkHeader = 0;
        if (keyGenericTypeFinal) {
            chunkHeader |= MapFlags.KEY_DECL_TYPE;
            keySerializer = keyGenericType.getSerializer(classResolver);
        } else {
            keySerializer = this.writeKeyClassInfo(classResolver, keyType, buffer);
        }
        if (valueGenericTypeFinal) {
            chunkHeader |= MapFlags.VALUE_DECL_TYPE;
            valueSerializer = valueGenericType.getSerializer(classResolver);
        } else {
            valueSerializer = this.writeValueClassInfo(classResolver, valueType, buffer);
        }
        boolean keyWriteRef = keySerializer.needToWriteRef();
        if (keyWriteRef) {
            chunkHeader |= MapFlags.TRACKING_KEY_REF;
        }
        if (valueWriteRef = valueSerializer.needToWriteRef()) {
            chunkHeader |= MapFlags.TRACKING_VALUE_REF;
        }
        buffer.putByte(chunkSizeOffset - 1, (byte)chunkHeader);
        RefResolver refResolver = this.fury.getRefResolver();
        int chunkSize = 0;
        while (key != null && value != null && key.getClass() == keyType && value.getClass() == valueType) {
            generics.pushGenericType(keyGenericType);
            if (!keyWriteRef || !refResolver.writeRefOrNull(buffer, key)) {
                this.fury.incDepth(1);
                keySerializer.write(buffer, key);
                this.fury.incDepth(-1);
            }
            generics.popGenericType();
            generics.pushGenericType(valueGenericType);
            if (!valueWriteRef || !refResolver.writeRefOrNull(buffer, value)) {
                this.fury.incDepth(1);
                valueSerializer.write(buffer, value);
                this.fury.incDepth(-1);
            }
            generics.popGenericType();
            ++chunkSize;
            if (!iterator.hasNext()) {
                entry = null;
                break;
            }
            entry = iterator.next();
            key = entry.getKey();
            value = entry.getValue();
            if (chunkSize != 255) continue;
        }
        buffer.putByte(chunkSizeOffset, (byte)chunkSize);
        return entry;
    }

    public static void xwriteElements(Fury fury, MemoryBuffer buffer, Map value) {
        Generics generics = fury.getGenerics();
        GenericType genericType = generics.nextGenericType();
        if (genericType == null || genericType.getTypeParametersCount() != 2) {
            Iterator iterator = value.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry object;
                Map.Entry entry = object = iterator.next();
                fury.xwriteRef(buffer, entry.getKey());
                fury.xwriteRef(buffer, entry.getValue());
            }
        } else {
            GenericType keyGenericType = genericType.getTypeParameter0();
            GenericType valueGenericType = genericType.getTypeParameter1();
            Serializer<?> keySerializer = keyGenericType.getSerializer(fury.getClassResolver());
            Serializer<?> valueSerializer = valueGenericType.getSerializer(fury.getClassResolver());
            if (!keyGenericType.hasGenericParameters() && !valueGenericType.hasGenericParameters()) {
                Iterator iterator = value.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry object;
                    Map.Entry entry = object = iterator.next();
                    AbstractMapSerializer.xwriteRefByNullableSerializer(fury, buffer, entry.getKey(), keySerializer);
                    AbstractMapSerializer.xwriteRefByNullableSerializer(fury, buffer, entry.getValue(), valueSerializer);
                }
            } else if (valueGenericType.hasGenericParameters()) {
                Iterator iterator = value.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry object;
                    Map.Entry entry = object = iterator.next();
                    AbstractMapSerializer.xwriteRefByNullableSerializer(fury, buffer, entry.getKey(), keySerializer);
                    generics.pushGenericType(valueGenericType);
                    AbstractMapSerializer.xwriteRefByNullableSerializer(fury, buffer, entry.getValue(), valueSerializer);
                    generics.popGenericType();
                }
            } else if (keyGenericType.hasGenericParameters()) {
                Iterator iterator = value.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry object;
                    Map.Entry entry = object = iterator.next();
                    generics.pushGenericType(keyGenericType);
                    AbstractMapSerializer.xwriteRefByNullableSerializer(fury, buffer, entry.getKey(), keySerializer);
                    generics.popGenericType();
                    AbstractMapSerializer.xwriteRefByNullableSerializer(fury, buffer, entry.getValue(), valueSerializer);
                }
            } else {
                Iterator iterator = value.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry object;
                    Map.Entry entry = object = iterator.next();
                    generics.pushGenericType(keyGenericType);
                    AbstractMapSerializer.xwriteRefByNullableSerializer(fury, buffer, entry.getKey(), keySerializer);
                    generics.pushGenericType(valueGenericType);
                    AbstractMapSerializer.xwriteRefByNullableSerializer(fury, buffer, entry.getValue(), valueSerializer);
                }
            }
            generics.popGenericType();
        }
    }

    public static <T> void xwriteRefByNullableSerializer(Fury fury, MemoryBuffer buffer, T obj, Serializer<T> serializer) {
        if (serializer == null) {
            fury.xwriteRef(buffer, obj);
        } else {
            fury.xwriteRef(buffer, obj, serializer);
        }
    }

    private GenericType getKVGenericType(GenericType genericType) {
        GenericType mapGenericType = this.partialGenericKVTypeMap.get(genericType);
        if (mapGenericType == null) {
            TypeRef<?> typeRef = genericType.getTypeRef();
            if (!TypeUtils.MAP_TYPE.isSupertypeOf(typeRef)) {
                mapGenericType = GenericType.build(TypeUtils.mapOf(Object.class, Object.class));
                this.partialGenericKVTypeMap.put(genericType, mapGenericType);
                return mapGenericType;
            }
            Tuple2<TypeRef<?>, TypeRef<?>> mapKeyValueType = TypeUtils.getMapKeyValueType(typeRef);
            mapGenericType = GenericType.build(TypeUtils.mapOf((TypeRef)mapKeyValueType.f0, (TypeRef)mapKeyValueType.f1));
            this.partialGenericKVTypeMap.put(genericType, mapGenericType);
        }
        return mapGenericType;
    }

    @Override
    public T xread(MemoryBuffer buffer) {
        Map map = this.newMap(buffer);
        AbstractMapSerializer.xreadElements(this.fury, buffer, map, this.numElements);
        return this.onMapRead(map);
    }

    protected <K, V> void copyEntry(Map<K, V> originMap, Map<K, V> newMap) {
        ClassResolver classResolver = this.fury.getClassResolver();
        for (Map.Entry<K, V> entry : originMap.entrySet()) {
            ClassInfo classInfo;
            V value;
            ClassInfo classInfo2;
            K key = entry.getKey();
            if (key != null && !(classInfo2 = classResolver.getClassInfo(key.getClass(), this.keyClassInfoWriteCache)).getSerializer().isImmutable()) {
                key = this.fury.copyObject(key, classInfo2.getClassId());
            }
            if ((value = entry.getValue()) != null && !(classInfo = classResolver.getClassInfo(value.getClass(), this.valueClassInfoWriteCache)).getSerializer().isImmutable()) {
                value = this.fury.copyObject(value, classInfo.getClassId());
            }
            newMap.put(key, value);
        }
    }

    protected <K, V> void copyEntry(Map<K, V> originMap, ImmutableMap.Builder<K, V> builder) {
        ClassResolver classResolver = this.fury.getClassResolver();
        for (Map.Entry<K, V> entry : originMap.entrySet()) {
            ClassInfo classInfo;
            V value;
            ClassInfo classInfo2;
            K key = entry.getKey();
            if (key != null && !(classInfo2 = classResolver.getClassInfo(key.getClass(), this.keyClassInfoWriteCache)).getSerializer().isImmutable()) {
                key = this.fury.copyObject(key, classInfo2.getClassId());
            }
            if ((value = entry.getValue()) != null && !(classInfo = classResolver.getClassInfo(value.getClass(), this.valueClassInfoWriteCache)).getSerializer().isImmutable()) {
                value = this.fury.copyObject(value, classInfo.getClassId());
            }
            builder.put(key, value);
        }
    }

    protected <K, V> void copyEntry(Map<K, V> originMap, Object[] elements) {
        ClassResolver classResolver = this.fury.getClassResolver();
        int index = 0;
        for (Map.Entry<K, V> entry : originMap.entrySet()) {
            ClassInfo classInfo;
            V value;
            ClassInfo classInfo2;
            K key = entry.getKey();
            if (key != null && !(classInfo2 = classResolver.getClassInfo(key.getClass(), this.keyClassInfoWriteCache)).getSerializer().isImmutable()) {
                key = this.fury.copyObject(key, classInfo2.getClassId());
            }
            if ((value = entry.getValue()) != null && !(classInfo = classResolver.getClassInfo(value.getClass(), this.valueClassInfoWriteCache)).getSerializer().isImmutable()) {
                value = this.fury.copyObject(value, classInfo.getClassId());
            }
            elements[index++] = key;
            elements[index++] = value;
        }
    }

    @Override
    public T read(MemoryBuffer buffer) {
        Map map = this.newMap(buffer);
        int size = this.getAndClearNumElements();
        this.readElements(buffer, size, map);
        return this.onMapRead(map);
    }

    public void readElements(MemoryBuffer buffer, int size, Map map) {
        Serializer keySerializer = this.keySerializer;
        Serializer valueSerializer = this.valueSerializer;
        this.keySerializer = null;
        this.valueSerializer = null;
        int chunkHeader = 0;
        if (size != 0) {
            chunkHeader = buffer.readUnsignedByte();
        }
        while (size > 0) {
            Generics generics;
            GenericType genericType;
            long sizeAndHeader = this.readJavaNullChunk(buffer, map, chunkHeader, size, keySerializer, valueSerializer);
            chunkHeader = (int)(sizeAndHeader & 0xFFL);
            size = (int)(sizeAndHeader >>> 8);
            if (size == 0) break;
            sizeAndHeader = keySerializer != null || valueSerializer != null ? this.readJavaChunk(this.fury, buffer, map, size, chunkHeader, keySerializer, valueSerializer) : ((genericType = (generics = this.fury.getGenerics()).nextGenericType()) == null ? this.readJavaChunk(this.fury, buffer, map, size, chunkHeader, null, null) : this.readJavaChunkGeneric(this.fury, generics, genericType, buffer, map, size, chunkHeader));
            chunkHeader = (int)(sizeAndHeader & 0xFFL);
            size = (int)(sizeAndHeader >>> 8);
        }
    }

    public long readJavaNullChunk(MemoryBuffer buffer, Map map, int chunkHeader, long size, Serializer keySerializer, Serializer valueSerializer) {
        while (true) {
            boolean valueHasNull;
            boolean keyHasNull = (chunkHeader & MapFlags.KEY_HAS_NULL) != 0;
            boolean bl = valueHasNull = (chunkHeader & MapFlags.VALUE_HAS_NULL) != 0;
            if (!keyHasNull) {
                boolean trackKeyRef;
                if (!valueHasNull) {
                    return size << 8 | (long)chunkHeader;
                }
                boolean bl2 = trackKeyRef = (chunkHeader & MapFlags.TRACKING_KEY_REF) != 0;
                Object key = (chunkHeader & MapFlags.KEY_DECL_TYPE) != 0 ? (trackKeyRef ? this.fury.readRef(buffer, keySerializer) : keySerializer.read(buffer)) : this.fury.readRef(buffer, this.keyClassInfoReadCache);
                map.put(key, null);
            } else {
                this.readNullKeyChunk(buffer, map, chunkHeader, valueSerializer, valueHasNull);
            }
            if (--size == 0L) {
                return 0L;
            }
            chunkHeader = buffer.readUnsignedByte();
        }
    }

    private void readNullKeyChunk(MemoryBuffer buffer, Map map, int chunkHeader, Serializer valueSerializer, boolean valueHasNull) {
        if (!valueHasNull) {
            boolean trackValueRef;
            boolean bl = trackValueRef = (chunkHeader & MapFlags.TRACKING_VALUE_REF) != 0;
            Object value = (chunkHeader & MapFlags.VALUE_DECL_TYPE) != 0 ? (trackValueRef ? this.fury.readRef(buffer, valueSerializer) : valueSerializer.read(buffer)) : this.fury.readRef(buffer, this.valueClassInfoReadCache);
            map.put(null, value);
        } else {
            map.put(null, null);
        }
    }

    public long readNullChunkKVFinalNoRef(MemoryBuffer buffer, Map map, int chunkHeader, long size, Serializer keySerializer, Serializer valueSerializer) {
        while (true) {
            boolean valueHasNull;
            boolean keyHasNull = (chunkHeader & MapFlags.KEY_HAS_NULL) != 0;
            boolean bl = valueHasNull = (chunkHeader & MapFlags.VALUE_HAS_NULL) != 0;
            if (!keyHasNull) {
                if (!valueHasNull) {
                    return size << 8 | (long)chunkHeader;
                }
                Object key = keySerializer.read(buffer);
                map.put(key, null);
            } else {
                this.readNullKeyChunk(buffer, map, chunkHeader, valueSerializer, valueHasNull);
            }
            if (size-- == 0L) {
                return 0L;
            }
            chunkHeader = buffer.readUnsignedByte();
        }
    }

    private long readJavaChunk(Fury fury, MemoryBuffer buffer, Map map, long size, int chunkHeader, Serializer keySerializer, Serializer valueSerializer) {
        boolean trackKeyRef = (chunkHeader & MapFlags.TRACKING_KEY_REF) != 0;
        boolean trackValueRef = (chunkHeader & MapFlags.TRACKING_VALUE_REF) != 0;
        boolean keyIsDeclaredType = (chunkHeader & MapFlags.KEY_DECL_TYPE) != 0;
        boolean valueIsDeclaredType = (chunkHeader & MapFlags.VALUE_DECL_TYPE) != 0;
        int chunkSize = buffer.readUnsignedByte();
        if (!keyIsDeclaredType) {
            keySerializer = this.classResolver.readClassInfo(buffer, this.keyClassInfoReadCache).getSerializer();
        }
        if (!valueIsDeclaredType) {
            valueSerializer = this.classResolver.readClassInfo(buffer, this.valueClassInfoReadCache).getSerializer();
        }
        for (int i = 0; i < chunkSize; ++i) {
            fury.incDepth(1);
            Object key = trackKeyRef ? fury.readRef(buffer, keySerializer) : keySerializer.read(buffer);
            Object value = trackValueRef ? fury.readRef(buffer, valueSerializer) : valueSerializer.read(buffer);
            fury.incDepth(-1);
            map.put(key, value);
            --size;
        }
        return size > 0L ? size << 8 | (long)buffer.readUnsignedByte() : 0L;
    }

    private long readJavaChunkGeneric(Fury fury, Generics generics, GenericType genericType, MemoryBuffer buffer, Map map, long size, int chunkHeader) {
        if (genericType.getTypeParametersCount() < 2) {
            genericType = this.getKVGenericType(genericType);
        }
        GenericType keyGenericType = genericType.getTypeParameter0();
        GenericType valueGenericType = genericType.getTypeParameter1();
        boolean trackKeyRef = (chunkHeader & MapFlags.TRACKING_KEY_REF) != 0;
        boolean trackValueRef = (chunkHeader & MapFlags.TRACKING_VALUE_REF) != 0;
        boolean keyIsDeclaredType = (chunkHeader & MapFlags.KEY_DECL_TYPE) != 0;
        boolean valueIsDeclaredType = (chunkHeader & MapFlags.VALUE_DECL_TYPE) != 0;
        int chunkSize = buffer.readUnsignedByte();
        Serializer<Object> keySerializer = !keyIsDeclaredType ? this.classResolver.readClassInfo(buffer, this.keyClassInfoReadCache).getSerializer() : keyGenericType.getSerializer(this.classResolver);
        Serializer<Object> valueSerializer = !valueIsDeclaredType ? this.classResolver.readClassInfo(buffer, this.valueClassInfoReadCache).getSerializer() : valueGenericType.getSerializer(this.classResolver);
        for (int i = 0; i < chunkSize; ++i) {
            generics.pushGenericType(keyGenericType);
            fury.incDepth(1);
            Object key = trackKeyRef ? fury.readRef(buffer, keySerializer) : keySerializer.read(buffer);
            fury.incDepth(-1);
            generics.popGenericType();
            generics.pushGenericType(valueGenericType);
            fury.incDepth(1);
            Object value = trackValueRef ? fury.readRef(buffer, valueSerializer) : valueSerializer.read(buffer);
            fury.incDepth(-1);
            generics.popGenericType();
            map.put(key, value);
            --size;
        }
        return size > 0L ? size << 8 | (long)buffer.readUnsignedByte() : 0L;
    }

    public static void xreadElements(Fury fury, MemoryBuffer buffer, Map map, int size) {
        Generics generics = fury.getGenerics();
        GenericType genericType = generics.nextGenericType();
        if (genericType == null || genericType.getTypeParametersCount() != 2) {
            for (int i = 0; i < size; ++i) {
                Object key = fury.xreadRef(buffer);
                Object value = fury.xreadRef(buffer);
                map.put(key, value);
            }
        } else {
            GenericType keyGenericType = genericType.getTypeParameter0();
            GenericType valueGenericType = genericType.getTypeParameter1();
            Serializer<?> keySerializer = keyGenericType.getSerializer(fury.getClassResolver());
            Serializer<?> valueSerializer = valueGenericType.getSerializer(fury.getClassResolver());
            if (!keyGenericType.hasGenericParameters() && !valueGenericType.hasGenericParameters()) {
                for (int i = 0; i < size; ++i) {
                    Object key = AbstractMapSerializer.xreadRefByNullableSerializer(fury, buffer, keySerializer);
                    Object value = AbstractMapSerializer.xreadRefByNullableSerializer(fury, buffer, valueSerializer);
                    map.put(key, value);
                }
            } else if (valueGenericType.hasGenericParameters()) {
                for (int i = 0; i < size; ++i) {
                    Object key = AbstractMapSerializer.xreadRefByNullableSerializer(fury, buffer, keySerializer);
                    generics.pushGenericType(valueGenericType);
                    Object value = AbstractMapSerializer.xreadRefByNullableSerializer(fury, buffer, valueSerializer);
                    generics.popGenericType();
                    map.put(key, value);
                }
            } else if (keyGenericType.hasGenericParameters()) {
                for (int i = 0; i < size; ++i) {
                    generics.pushGenericType(keyGenericType);
                    Object key = AbstractMapSerializer.xreadRefByNullableSerializer(fury, buffer, keySerializer);
                    generics.popGenericType();
                    Object value = AbstractMapSerializer.xreadRefByNullableSerializer(fury, buffer, valueSerializer);
                    map.put(key, value);
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    generics.pushGenericType(keyGenericType);
                    Object key = AbstractMapSerializer.xreadRefByNullableSerializer(fury, buffer, keySerializer);
                    generics.pushGenericType(valueGenericType);
                    Object value = AbstractMapSerializer.xreadRefByNullableSerializer(fury, buffer, valueSerializer);
                    map.put(key, value);
                }
            }
            generics.popGenericType();
        }
    }

    public static Object xreadRefByNullableSerializer(Fury fury, MemoryBuffer buffer, Serializer<?> serializer) {
        if (serializer == null) {
            return fury.xreadRef(buffer);
        }
        return fury.xreadRef(buffer, serializer);
    }

    public final boolean supportCodegenHook() {
        return this.supportCodegenHook;
    }

    public abstract Map onMapWrite(MemoryBuffer var1, T var2);

    public Map newMap(MemoryBuffer buffer) {
        this.numElements = buffer.readVarUint32Small7();
        if (this.constructor == null) {
            this.constructor = ReflectionUtils.getCtrHandle(this.type, true);
        }
        try {
            Map instance = this.constructor.invoke();
            this.fury.getRefResolver().reference(instance);
            return instance;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Please provide public no arguments constructor for class " + this.type, e);
        }
    }

    public Map newMap(Map map) {
        this.numElements = map.size();
        if (this.constructor == null) {
            this.constructor = ReflectionUtils.getCtrHandle(this.type, true);
        }
        try {
            return this.constructor.invoke();
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Please provide public no arguments constructor for class " + this.type, e);
        }
    }

    public int getAndClearNumElements() {
        int size = this.numElements;
        this.numElements = -1;
        return size;
    }

    public void setNumElements(int numElements) {
        this.numElements = numElements;
    }

    public abstract T onMapCopy(Map var1);

    public abstract T onMapRead(Map var1);
}

