/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.serializer.collection;

import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.fury.Fury;
import org.apache.fury.collection.LazyMap;
import org.apache.fury.config.Language;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.memory.Platform;
import org.apache.fury.reflect.ReflectionUtils;
import org.apache.fury.resolver.ClassInfo;
import org.apache.fury.resolver.ClassResolver;
import org.apache.fury.serializer.ReplaceResolveSerializer;
import org.apache.fury.serializer.Serializer;
import org.apache.fury.serializer.Serializers;
import org.apache.fury.serializer.StringSerializer;
import org.apache.fury.serializer.collection.AbstractMapSerializer;
import org.apache.fury.serializer.collection.MapSerializer;
import org.apache.fury.type.Type;
import org.apache.fury.util.Preconditions;

public class MapSerializers {
    public static void registerDefaultSerializers(Fury fury) {
        fury.registerSerializer(HashMap.class, new HashMapSerializer(fury));
        fury.getClassResolver().registerSerializer(LinkedHashMap.class, new LinkedHashMapSerializer(fury));
        fury.registerSerializer(TreeMap.class, new SortedMapSerializer<TreeMap>(fury, TreeMap.class));
        fury.registerSerializer(Collections.EMPTY_MAP.getClass(), new EmptyMapSerializer(fury, Collections.EMPTY_MAP.getClass()));
        fury.registerSerializer(Collections.emptySortedMap().getClass(), new EmptySortedMapSerializer(fury, Collections.emptySortedMap().getClass()));
        fury.registerSerializer(Collections.singletonMap(null, null).getClass(), new SingletonMapSerializer(fury, Collections.singletonMap(null, null).getClass()));
        fury.registerSerializer(ConcurrentHashMap.class, new ConcurrentHashMapSerializer(fury, ConcurrentHashMap.class));
        fury.registerSerializer(ConcurrentSkipListMap.class, new ConcurrentSkipListMapSerializer(fury, ConcurrentSkipListMap.class));
        fury.registerSerializer(EnumMap.class, new EnumMapSerializer(fury));
        fury.registerSerializer(LazyMap.class, new LazyMapSerializer(fury));
    }

    public static final class HashMapSerializer
    extends MapSerializer<HashMap> {
        public HashMapSerializer(Fury fury) {
            super(fury, HashMap.class, true);
        }

        @Override
        public short getXtypeId() {
            return Type.MAP.getId();
        }

        @Override
        public HashMap newMap(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            this.setNumElements(numElements);
            HashMap hashMap = new HashMap(numElements);
            this.fury.getRefResolver().reference(hashMap);
            return hashMap;
        }

        @Override
        public Map newMap(Map map) {
            return new HashMap(map.size());
        }
    }

    public static final class LinkedHashMapSerializer
    extends MapSerializer<LinkedHashMap> {
        public LinkedHashMapSerializer(Fury fury) {
            super(fury, LinkedHashMap.class, true);
        }

        @Override
        public short getXtypeId() {
            return Type.MAP.getId();
        }

        @Override
        public LinkedHashMap newMap(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            this.setNumElements(numElements);
            LinkedHashMap hashMap = new LinkedHashMap(numElements);
            this.fury.getRefResolver().reference(hashMap);
            return hashMap;
        }

        @Override
        public Map newMap(Map map) {
            return new LinkedHashMap(map.size());
        }
    }

    public static class SortedMapSerializer<T extends SortedMap>
    extends MapSerializer<T> {
        public SortedMapSerializer(Fury fury, Class<T> cls) {
            super(fury, cls, true);
            if (cls != TreeMap.class) {
                this.constructor = ReflectionUtils.getCtrHandle(cls, Comparator.class);
            }
        }

        @Override
        public Map onMapWrite(MemoryBuffer buffer, T value) {
            buffer.writeVarUint32Small7(value.size());
            this.fury.writeRef(buffer, value.comparator());
            return value;
        }

        @Override
        public Map newMap(MemoryBuffer buffer) {
            SortedMap map;
            this.setNumElements(buffer.readVarUint32Small7());
            Comparator comparator = (Comparator)this.fury.readRef(buffer);
            if (this.type == TreeMap.class) {
                map = new TreeMap(comparator);
            } else {
                try {
                    map = this.constructor.invoke(comparator);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            this.fury.getRefResolver().reference(map);
            return map;
        }

        @Override
        public Map newMap(Map originMap) {
            Map map;
            Comparator comparator = this.fury.copyObject(((SortedMap)originMap).comparator());
            if (this.type == TreeMap.class) {
                map = new TreeMap(comparator);
            } else {
                try {
                    map = this.constructor.invoke(comparator);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            return map;
        }
    }

    public static final class EmptyMapSerializer
    extends MapSerializer<Map<?, ?>> {
        public EmptyMapSerializer(Fury fury, Class<Map<?, ?>> cls) {
            super(fury, cls, false, true);
        }

        @Override
        public void write(MemoryBuffer buffer, Map<?, ?> value) {
        }

        @Override
        public short getXtypeId() {
            return -Type.MAP.getId();
        }

        @Override
        public void xwrite(MemoryBuffer buffer, Map<?, ?> value) {
            buffer.writeVarUint32Small7(0);
        }

        @Override
        public Map<?, ?> read(MemoryBuffer buffer) {
            return Collections.EMPTY_MAP;
        }

        @Override
        public Map<?, ?> xread(MemoryBuffer buffer) {
            buffer.readVarUint32Small7();
            return Collections.EMPTY_MAP;
        }
    }

    public static final class EmptySortedMapSerializer
    extends MapSerializer<SortedMap<?, ?>> {
        public EmptySortedMapSerializer(Fury fury, Class<SortedMap<?, ?>> cls) {
            super(fury, cls, false, true);
        }

        @Override
        public void write(MemoryBuffer buffer, SortedMap<?, ?> value) {
        }

        @Override
        public SortedMap<?, ?> read(MemoryBuffer buffer) {
            return Collections.emptySortedMap();
        }
    }

    public static final class SingletonMapSerializer
    extends MapSerializer<Map<?, ?>> {
        public SingletonMapSerializer(Fury fury, Class<Map<?, ?>> cls) {
            super(fury, cls, false);
        }

        @Override
        public Map<?, ?> copy(Map<?, ?> originMap) {
            Map.Entry<?, ?> entry = originMap.entrySet().iterator().next();
            return Collections.singletonMap(this.fury.copyObject(entry.getKey()), this.fury.copyObject(entry.getValue()));
        }

        @Override
        public void write(MemoryBuffer buffer, Map<?, ?> value) {
            Map.Entry<?, ?> entry = value.entrySet().iterator().next();
            this.fury.writeRef(buffer, entry.getKey());
            this.fury.writeRef(buffer, entry.getValue());
        }

        @Override
        public short getXtypeId() {
            return -Type.MAP.getId();
        }

        @Override
        public void xwrite(MemoryBuffer buffer, Map<?, ?> value) {
            buffer.writeVarUint32Small7(1);
            Map.Entry<?, ?> entry = value.entrySet().iterator().next();
            this.fury.xwriteRef(buffer, entry.getKey());
            this.fury.xwriteRef(buffer, entry.getValue());
        }

        @Override
        public Map<?, ?> read(MemoryBuffer buffer) {
            Object key = this.fury.readRef(buffer);
            Object value = this.fury.readRef(buffer);
            return Collections.singletonMap(key, value);
        }

        @Override
        public Map<?, ?> xread(MemoryBuffer buffer) {
            buffer.readVarUint32Small7();
            Object key = this.fury.xreadRef(buffer);
            Object value = this.fury.xreadRef(buffer);
            return Collections.singletonMap(key, value);
        }
    }

    public static final class ConcurrentHashMapSerializer
    extends MapSerializer<ConcurrentHashMap> {
        public ConcurrentHashMapSerializer(Fury fury, Class<ConcurrentHashMap> type) {
            super(fury, type, true);
        }

        @Override
        public ConcurrentHashMap newMap(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            this.setNumElements(numElements);
            ConcurrentHashMap map = new ConcurrentHashMap(numElements);
            this.fury.getRefResolver().reference(map);
            return map;
        }

        @Override
        public Map newMap(Map map) {
            return new ConcurrentHashMap(map.size());
        }

        @Override
        public short getXtypeId() {
            return 0;
        }
    }

    public static final class ConcurrentSkipListMapSerializer
    extends SortedMapSerializer<ConcurrentSkipListMap> {
        public ConcurrentSkipListMapSerializer(Fury fury, Class<ConcurrentSkipListMap> cls) {
            super(fury, cls);
        }

        @Override
        public ConcurrentSkipListMap newMap(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            this.setNumElements(numElements);
            Comparator comparator = (Comparator)this.fury.readRef(buffer);
            ConcurrentSkipListMap map = new ConcurrentSkipListMap(comparator);
            this.fury.getRefResolver().reference(map);
            return map;
        }

        @Override
        public Map newMap(Map originMap) {
            Comparator comparator = this.fury.copyObject(((ConcurrentSkipListMap)originMap).comparator());
            return new ConcurrentSkipListMap(comparator);
        }

        @Override
        public short getXtypeId() {
            return 0;
        }
    }

    public static class EnumMapSerializer
    extends MapSerializer<EnumMap> {
        private static final long keyTypeFieldOffset;

        public EnumMapSerializer(Fury fury) {
            super(fury, EnumMap.class, true);
        }

        @Override
        public Map onMapWrite(MemoryBuffer buffer, EnumMap value) {
            buffer.writeVarUint32Small7(value.size());
            Class keyType = (Class)Platform.getObject(value, keyTypeFieldOffset);
            this.fury.getClassResolver().writeClassAndUpdateCache(buffer, keyType);
            return value;
        }

        @Override
        public EnumMap newMap(MemoryBuffer buffer) {
            this.setNumElements(buffer.readVarUint32Small7());
            Class<?> keyType = this.fury.getClassResolver().readClassInfo(buffer).getCls();
            return new EnumMap(keyType);
        }

        @Override
        public EnumMap copy(EnumMap originMap) {
            return new EnumMap(originMap);
        }

        static {
            try {
                keyTypeFieldOffset = Platform.objectFieldOffset(EnumMap.class.getDeclaredField("keyType"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static final class LazyMapSerializer
    extends MapSerializer<LazyMap> {
        public LazyMapSerializer(Fury fury) {
            super(fury, LazyMap.class, true);
        }

        @Override
        public short getXtypeId() {
            return Type.MAP.getId();
        }

        @Override
        public LazyMap newMap(MemoryBuffer buffer) {
            int numElements = buffer.readVarUint32Small7();
            this.setNumElements(numElements);
            LazyMap map = new LazyMap(numElements);
            this.fury.getRefResolver().reference(map);
            return map;
        }

        @Override
        public Map newMap(Map map) {
            return new LazyMap(map.size());
        }
    }

    public static class JDKCompatibleMapSerializer<T>
    extends AbstractMapSerializer<T> {
        private final Serializer serializer;

        public JDKCompatibleMapSerializer(Fury fury, Class<T> cls) {
            super(fury, cls, false);
            Class serializerType = ClassResolver.useReplaceResolveSerializer(cls) ? ReplaceResolveSerializer.class : fury.getDefaultJDKStreamSerializerType();
            this.serializer = Serializers.newSerializer(fury, cls, serializerType);
        }

        @Override
        public Map onMapWrite(MemoryBuffer buffer, T value) {
            throw new IllegalStateException();
        }

        @Override
        public T onMapCopy(Map map) {
            throw new IllegalStateException();
        }

        @Override
        public T onMapRead(Map map) {
            throw new IllegalStateException();
        }

        @Override
        public T read(MemoryBuffer buffer) {
            return this.serializer.read(buffer);
        }

        @Override
        public void write(MemoryBuffer buffer, T value) {
            this.serializer.write(buffer, value);
        }

        @Override
        public T copy(T value) {
            return this.fury.copyObject(value, this.serializer);
        }
    }

    public static final class DefaultJavaMapSerializer<T>
    extends AbstractMapSerializer<T> {
        private Serializer<T> dataSerializer;

        public DefaultJavaMapSerializer(Fury fury, Class<T> cls) {
            super(fury, cls, false);
            Preconditions.checkArgument(fury.getLanguage() == Language.JAVA, "Python default map serializer should use " + MapSerializer.class);
            fury.getClassResolver().setSerializer(cls, this);
            Class<? extends Serializer> serializerClass = fury.getClassResolver().getObjectSerializerClass(cls, sc -> {
                this.dataSerializer = Serializers.newSerializer(fury, cls, sc);
            });
            this.dataSerializer = Serializers.newSerializer(fury, cls, serializerClass);
        }

        @Override
        public Map onMapWrite(MemoryBuffer buffer, T value) {
            throw new IllegalStateException();
        }

        @Override
        public T onMapCopy(Map map) {
            throw new IllegalStateException();
        }

        @Override
        public T onMapRead(Map map) {
            throw new IllegalStateException();
        }

        @Override
        public void write(MemoryBuffer buffer, T value) {
            this.dataSerializer.write(buffer, value);
        }

        @Override
        public T copy(T value) {
            return this.fury.copyObject(value, this.dataSerializer);
        }

        @Override
        public T read(MemoryBuffer buffer) {
            return this.dataSerializer.read(buffer);
        }
    }

    public static class StringKeyMapSerializer<T>
    extends MapSerializer<Map<String, T>> {
        public StringKeyMapSerializer(Fury fury, Class<Map<String, T>> cls) {
            super(fury, cls, false);
            this.setKeySerializer(new StringSerializer(fury));
        }

        @Override
        public void write(MemoryBuffer buffer, Map<String, T> value) {
            buffer.writeVarUint32Small7(value.size());
            for (Map.Entry<String, T> e : value.entrySet()) {
                this.fury.writeJavaStringRef(buffer, e.getKey());
                this.fury.writeRef(buffer, e.getValue());
            }
        }

        @Override
        public Map<String, T> read(MemoryBuffer buffer) {
            Map map = this.newMap(buffer);
            int numElements = this.getAndClearNumElements();
            for (int i = 0; i < numElements; ++i) {
                map.put(this.fury.readJavaStringRef(buffer), this.fury.readRef(buffer));
            }
            return map;
        }

        @Override
        protected <K, V> void copyEntry(Map<K, V> originMap, Map<K, V> newMap) {
            ClassResolver classResolver = this.fury.getClassResolver();
            for (Map.Entry<K, V> entry : originMap.entrySet()) {
                ClassInfo classInfo;
                V value = entry.getValue();
                if (value != null && !(classInfo = classResolver.getClassInfo(value.getClass(), this.valueClassInfoWriteCache)).getSerializer().isImmutable()) {
                    value = this.fury.copyObject(value, classInfo.getClassId());
                }
                newMap.put(entry.getKey(), value);
            }
        }
    }
}

