/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationSubmissionContextPBImpl;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.resourcemanager.RMFatalEvent;
import org.apache.hadoop.yarn.server.resourcemanager.RMFatalEventType;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreEventType;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreRemoveAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateUpdateAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateUpdateAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateVersionIncompatibleException;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.StoreFencedException;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.AMRMTokenSecretManagerState;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationAttemptStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AggregateAppResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class RMStateStore
extends AbstractService {
    protected static final String RM_APP_ROOT = "RMAppRoot";
    protected static final String RM_DT_SECRET_MANAGER_ROOT = "RMDTSecretManagerRoot";
    protected static final String DELEGATION_KEY_PREFIX = "DelegationKey_";
    protected static final String DELEGATION_TOKEN_PREFIX = "RMDelegationToken_";
    protected static final String DELEGATION_TOKEN_SEQUENCE_NUMBER_PREFIX = "RMDTSequenceNumber_";
    protected static final String AMRMTOKEN_SECRET_MANAGER_ROOT = "AMRMTokenSecretManagerRoot";
    protected static final String VERSION_NODE = "RMVersionNode";
    protected static final String EPOCH_NODE = "EpochNode";
    private ResourceManager resourceManager;
    public static final Log LOG = LogFactory.getLog(RMStateStore.class);
    private static final StateMachineFactory<RMStateStore, RMStateStoreState, RMStateStoreEventType, RMStateStoreEvent> stateMachineFactory = new StateMachineFactory((Enum)RMStateStoreState.DEFAULT).addTransition((Enum)RMStateStoreState.DEFAULT, (Enum)RMStateStoreState.DEFAULT, (Enum)RMStateStoreEventType.STORE_APP, (SingleArcTransition)new StoreAppTransition()).addTransition((Enum)RMStateStoreState.DEFAULT, (Enum)RMStateStoreState.DEFAULT, (Enum)RMStateStoreEventType.UPDATE_APP, (SingleArcTransition)new UpdateAppTransition()).addTransition((Enum)RMStateStoreState.DEFAULT, (Enum)RMStateStoreState.DEFAULT, (Enum)RMStateStoreEventType.REMOVE_APP, (SingleArcTransition)new RemoveAppTransition()).addTransition((Enum)RMStateStoreState.DEFAULT, (Enum)RMStateStoreState.DEFAULT, (Enum)RMStateStoreEventType.STORE_APP_ATTEMPT, (SingleArcTransition)new StoreAppAttemptTransition()).addTransition((Enum)RMStateStoreState.DEFAULT, (Enum)RMStateStoreState.DEFAULT, (Enum)RMStateStoreEventType.UPDATE_APP_ATTEMPT, (SingleArcTransition)new UpdateAppAttemptTransition());
    private final StateMachine<RMStateStoreState, RMStateStoreEventType, RMStateStoreEvent> stateMachine = stateMachineFactory.make((Object)this);
    private Dispatcher rmDispatcher;
    AsyncDispatcher dispatcher;
    public static final Text AM_RM_TOKEN_SERVICE = new Text("AM_RM_TOKEN_SERVICE");
    public static final Text AM_CLIENT_TOKEN_MASTER_KEY_NAME = new Text("YARN_CLIENT_TOKEN_MASTER_KEY");

    public RMStateStore() {
        super(RMStateStore.class.getName());
    }

    public void setRMDispatcher(Dispatcher dispatcher) {
        this.rmDispatcher = dispatcher;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.dispatcher = new AsyncDispatcher();
        this.dispatcher.init(conf);
        this.dispatcher.register(RMStateStoreEventType.class, (EventHandler)new ForwardingEventHandler());
        this.dispatcher.setDrainEventsOnStop();
        this.initInternal(conf);
    }

    protected void serviceStart() throws Exception {
        this.dispatcher.start();
        this.startInternal();
    }

    protected abstract void initInternal(Configuration var1) throws Exception;

    protected abstract void startInternal() throws Exception;

    protected void serviceStop() throws Exception {
        this.closeInternal();
        this.dispatcher.stop();
    }

    protected abstract void closeInternal() throws Exception;

    public void checkVersion() throws Exception {
        Version loadedVersion = this.loadVersion();
        LOG.info((Object)("Loaded RM state version info " + loadedVersion));
        if (loadedVersion != null && loadedVersion.equals((Object)this.getCurrentVersion())) {
            return;
        }
        if (loadedVersion == null) {
            loadedVersion = this.getCurrentVersion();
        }
        if (!loadedVersion.isCompatibleTo(this.getCurrentVersion())) {
            throw new RMStateVersionIncompatibleException("Expecting RM state version " + this.getCurrentVersion() + ", but loading version " + loadedVersion);
        }
        LOG.info((Object)("Storing RM state version info " + this.getCurrentVersion()));
        this.storeVersion();
    }

    protected abstract Version loadVersion() throws Exception;

    protected abstract void storeVersion() throws Exception;

    protected abstract Version getCurrentVersion();

    public abstract long getAndIncrementEpoch() throws Exception;

    public abstract RMState loadState() throws Exception;

    public synchronized void storeNewApplication(RMApp app) {
        ApplicationSubmissionContext context = app.getApplicationSubmissionContext();
        assert (context instanceof ApplicationSubmissionContextPBImpl);
        ApplicationState appState = new ApplicationState(app.getSubmitTime(), app.getStartTime(), context, app.getUser());
        this.dispatcher.getEventHandler().handle((Event)new RMStateStoreAppEvent(appState));
    }

    public synchronized void updateApplicationState(ApplicationState appState) {
        this.dispatcher.getEventHandler().handle((Event)new RMStateUpdateAppEvent(appState));
    }

    protected abstract void storeApplicationStateInternal(ApplicationId var1, ApplicationStateData var2) throws Exception;

    protected abstract void updateApplicationStateInternal(ApplicationId var1, ApplicationStateData var2) throws Exception;

    public synchronized void storeNewApplicationAttempt(RMAppAttempt appAttempt) {
        Credentials credentials = this.getCredentialsFromAppAttempt(appAttempt);
        AggregateAppResourceUsage resUsage = appAttempt.getRMAppAttemptMetrics().getAggregateAppResourceUsage();
        ApplicationAttemptState attemptState = new ApplicationAttemptState(appAttempt.getAppAttemptId(), appAttempt.getMasterContainer(), credentials, appAttempt.getStartTime(), resUsage.getMemorySeconds(), resUsage.getVcoreSeconds());
        this.dispatcher.getEventHandler().handle((Event)new RMStateStoreAppAttemptEvent(attemptState));
    }

    public synchronized void updateApplicationAttemptState(ApplicationAttemptState attemptState) {
        this.dispatcher.getEventHandler().handle((Event)new RMStateUpdateAppAttemptEvent(attemptState));
    }

    protected abstract void storeApplicationAttemptStateInternal(ApplicationAttemptId var1, ApplicationAttemptStateData var2) throws Exception;

    protected abstract void updateApplicationAttemptStateInternal(ApplicationAttemptId var1, ApplicationAttemptStateData var2) throws Exception;

    public synchronized void storeRMDelegationTokenAndSequenceNumber(RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate, int latestSequenceNumber) {
        try {
            this.storeRMDelegationTokenAndSequenceNumberState(rmDTIdentifier, renewDate, latestSequenceNumber);
        }
        catch (Exception e) {
            this.notifyStoreOperationFailed(e);
        }
    }

    protected abstract void storeRMDelegationTokenAndSequenceNumberState(RMDelegationTokenIdentifier var1, Long var2, int var3) throws Exception;

    public synchronized void removeRMDelegationToken(RMDelegationTokenIdentifier rmDTIdentifier, int sequenceNumber) {
        try {
            this.removeRMDelegationTokenState(rmDTIdentifier);
        }
        catch (Exception e) {
            this.notifyStoreOperationFailed(e);
        }
    }

    protected abstract void removeRMDelegationTokenState(RMDelegationTokenIdentifier var1) throws Exception;

    public synchronized void updateRMDelegationTokenAndSequenceNumber(RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate, int latestSequenceNumber) {
        try {
            this.updateRMDelegationTokenAndSequenceNumberInternal(rmDTIdentifier, renewDate, latestSequenceNumber);
        }
        catch (Exception e) {
            this.notifyStoreOperationFailed(e);
        }
    }

    protected abstract void updateRMDelegationTokenAndSequenceNumberInternal(RMDelegationTokenIdentifier var1, Long var2, int var3) throws Exception;

    public synchronized void storeRMDTMasterKey(DelegationKey delegationKey) {
        try {
            this.storeRMDTMasterKeyState(delegationKey);
        }
        catch (Exception e) {
            this.notifyStoreOperationFailed(e);
        }
    }

    protected abstract void storeRMDTMasterKeyState(DelegationKey var1) throws Exception;

    public synchronized void removeRMDTMasterKey(DelegationKey delegationKey) {
        try {
            this.removeRMDTMasterKeyState(delegationKey);
        }
        catch (Exception e) {
            this.notifyStoreOperationFailed(e);
        }
    }

    protected abstract void removeRMDTMasterKeyState(DelegationKey var1) throws Exception;

    public abstract void storeOrUpdateAMRMTokenSecretManagerState(AMRMTokenSecretManagerState var1, boolean var2);

    public synchronized void removeApplication(RMApp app) {
        ApplicationState appState = new ApplicationState(app.getSubmitTime(), app.getStartTime(), app.getApplicationSubmissionContext(), app.getUser());
        for (RMAppAttempt appAttempt : app.getAppAttempts().values()) {
            Credentials credentials = this.getCredentialsFromAppAttempt(appAttempt);
            ApplicationAttemptState attemptState = new ApplicationAttemptState(appAttempt.getAppAttemptId(), appAttempt.getMasterContainer(), credentials, appAttempt.getStartTime(), 0L, 0L);
            appState.attempts.put(attemptState.getAttemptId(), attemptState);
        }
        this.dispatcher.getEventHandler().handle((Event)new RMStateStoreRemoveAppEvent(appState));
    }

    protected abstract void removeApplicationStateInternal(ApplicationState var1) throws Exception;

    public Credentials getCredentialsFromAppAttempt(RMAppAttempt appAttempt) {
        Credentials credentials = new Credentials();
        SecretKey clientTokenMasterKey = appAttempt.getClientTokenMasterKey();
        if (clientTokenMasterKey != null) {
            credentials.addSecretKey(AM_CLIENT_TOKEN_MASTER_KEY_NAME, clientTokenMasterKey.getEncoded());
        }
        return credentials;
    }

    protected void handleStoreEvent(RMStateStoreEvent event) {
        try {
            this.stateMachine.doTransition(event.getType(), (Object)event);
        }
        catch (InvalidStateTransitonException e) {
            LOG.error((Object)"Can't handle this event at current state", (Throwable)e);
        }
    }

    protected void notifyStoreOperationFailed(Exception failureCause) {
        if (failureCause instanceof StoreFencedException) {
            Thread standByTransitionThread = new Thread(new StandByTransitionThread());
            standByTransitionThread.setName("StandByTransitionThread Handler");
            standByTransitionThread.start();
        } else {
            this.rmDispatcher.getEventHandler().handle((Event)new RMFatalEvent(RMFatalEventType.STATE_STORE_OP_FAILED, failureCause));
        }
    }

    private void notifyApplication(RMAppEvent event) {
        this.rmDispatcher.getEventHandler().handle((Event)event);
    }

    private void notifyApplicationAttempt(RMAppAttemptEvent event) {
        this.rmDispatcher.getEventHandler().handle((Event)event);
    }

    public abstract void deleteStore() throws Exception;

    public void setResourceManager(ResourceManager rm) {
        this.resourceManager = rm;
    }

    private class StandByTransitionThread
    implements Runnable {
        private StandByTransitionThread() {
        }

        @Override
        public void run() {
            LOG.info((Object)"RMStateStore has been fenced");
            RMStateStore.this.resourceManager.handleTransitionToStandBy();
        }
    }

    private final class ForwardingEventHandler
    implements EventHandler<RMStateStoreEvent> {
        private ForwardingEventHandler() {
        }

        public void handle(RMStateStoreEvent event) {
            RMStateStore.this.handleStoreEvent(event);
        }
    }

    public static class RMState {
        Map<ApplicationId, ApplicationState> appState = new TreeMap<ApplicationId, ApplicationState>();
        RMDTSecretManagerState rmSecretManagerState = new RMDTSecretManagerState();
        AMRMTokenSecretManagerState amrmTokenSecretManagerState = null;

        public Map<ApplicationId, ApplicationState> getApplicationState() {
            return this.appState;
        }

        public RMDTSecretManagerState getRMDTSecretManagerState() {
            return this.rmSecretManagerState;
        }

        public AMRMTokenSecretManagerState getAMRMTokenSecretManagerState() {
            return this.amrmTokenSecretManagerState;
        }
    }

    public static class RMDTSecretManagerState {
        Map<RMDelegationTokenIdentifier, Long> delegationTokenState = new HashMap<RMDelegationTokenIdentifier, Long>();
        Set<DelegationKey> masterKeyState = new HashSet<DelegationKey>();
        int dtSequenceNumber = 0;

        public Map<RMDelegationTokenIdentifier, Long> getTokenState() {
            return this.delegationTokenState;
        }

        public Set<DelegationKey> getMasterKeyState() {
            return this.masterKeyState;
        }

        public int getDTSequenceNumber() {
            return this.dtSequenceNumber;
        }
    }

    public static class ApplicationState {
        final ApplicationSubmissionContext context;
        final long submitTime;
        final long startTime;
        final String user;
        Map<ApplicationAttemptId, ApplicationAttemptState> attempts = new HashMap<ApplicationAttemptId, ApplicationAttemptState>();
        RMAppState state;
        String diagnostics;
        long finishTime;

        public ApplicationState(long submitTime, long startTime, ApplicationSubmissionContext context, String user) {
            this(submitTime, startTime, context, user, null, "", 0L);
        }

        public ApplicationState(long submitTime, long startTime, ApplicationSubmissionContext context, String user, RMAppState state, String diagnostics, long finishTime) {
            this.submitTime = submitTime;
            this.startTime = startTime;
            this.context = context;
            this.user = user;
            this.state = state;
            this.diagnostics = diagnostics == null ? "" : diagnostics;
            this.finishTime = finishTime;
        }

        public ApplicationId getAppId() {
            return this.context.getApplicationId();
        }

        public long getSubmitTime() {
            return this.submitTime;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public int getAttemptCount() {
            return this.attempts.size();
        }

        public ApplicationSubmissionContext getApplicationSubmissionContext() {
            return this.context;
        }

        public ApplicationAttemptState getAttempt(ApplicationAttemptId attemptId) {
            return this.attempts.get(attemptId);
        }

        public String getUser() {
            return this.user;
        }

        public RMAppState getState() {
            return this.state;
        }

        public String getDiagnostics() {
            return this.diagnostics;
        }

        public long getFinishTime() {
            return this.finishTime;
        }
    }

    public static class ApplicationAttemptState {
        final ApplicationAttemptId attemptId;
        final Container masterContainer;
        final Credentials appAttemptCredentials;
        long startTime = 0L;
        long finishTime = 0L;
        RMAppAttemptState state;
        String finalTrackingUrl = "N/A";
        String diagnostics;
        int exitStatus = -1000;
        FinalApplicationStatus amUnregisteredFinalStatus;
        long memorySeconds;
        long vcoreSeconds;

        public ApplicationAttemptState(ApplicationAttemptId attemptId, Container masterContainer, Credentials appAttemptCredentials, long startTime, long memorySeconds, long vcoreSeconds) {
            this(attemptId, masterContainer, appAttemptCredentials, startTime, null, null, "", null, -1000, 0L, memorySeconds, vcoreSeconds);
        }

        public ApplicationAttemptState(ApplicationAttemptId attemptId, Container masterContainer, Credentials appAttemptCredentials, long startTime, RMAppAttemptState state, String finalTrackingUrl, String diagnostics, FinalApplicationStatus amUnregisteredFinalStatus, int exitStatus, long finishTime, long memorySeconds, long vcoreSeconds) {
            this.attemptId = attemptId;
            this.masterContainer = masterContainer;
            this.appAttemptCredentials = appAttemptCredentials;
            this.startTime = startTime;
            this.state = state;
            this.finalTrackingUrl = finalTrackingUrl;
            this.diagnostics = diagnostics == null ? "" : diagnostics;
            this.amUnregisteredFinalStatus = amUnregisteredFinalStatus;
            this.exitStatus = exitStatus;
            this.finishTime = finishTime;
            this.memorySeconds = memorySeconds;
            this.vcoreSeconds = vcoreSeconds;
        }

        public Container getMasterContainer() {
            return this.masterContainer;
        }

        public ApplicationAttemptId getAttemptId() {
            return this.attemptId;
        }

        public Credentials getAppAttemptCredentials() {
            return this.appAttemptCredentials;
        }

        public RMAppAttemptState getState() {
            return this.state;
        }

        public String getFinalTrackingUrl() {
            return this.finalTrackingUrl;
        }

        public String getDiagnostics() {
            return this.diagnostics;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public FinalApplicationStatus getFinalApplicationStatus() {
            return this.amUnregisteredFinalStatus;
        }

        public int getAMContainerExitStatus() {
            return this.exitStatus;
        }

        public long getMemorySeconds() {
            return this.memorySeconds;
        }

        public long getVcoreSeconds() {
            return this.vcoreSeconds;
        }

        public long getFinishTime() {
            return this.finishTime;
        }
    }

    private static class UpdateAppAttemptTransition
    implements SingleArcTransition<RMStateStore, RMStateStoreEvent> {
        private UpdateAppAttemptTransition() {
        }

        public void transition(RMStateStore store, RMStateStoreEvent event) {
            if (!(event instanceof RMStateUpdateAppAttemptEvent)) {
                LOG.error((Object)("Illegal event type: " + ((Object)((Object)event)).getClass()));
                return;
            }
            ApplicationAttemptState attemptState = ((RMStateUpdateAppAttemptEvent)event).getAppAttemptState();
            try {
                ApplicationAttemptStateData attemptStateData = ApplicationAttemptStateData.newInstance(attemptState);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Updating info for attempt: " + attemptState.getAttemptId()));
                }
                store.updateApplicationAttemptStateInternal(attemptState.getAttemptId(), attemptStateData);
                store.notifyApplicationAttempt(new RMAppAttemptEvent(attemptState.getAttemptId(), RMAppAttemptEventType.ATTEMPT_UPDATE_SAVED));
            }
            catch (Exception e) {
                LOG.error((Object)("Error updating appAttempt: " + attemptState.getAttemptId()), (Throwable)e);
                store.notifyStoreOperationFailed(e);
            }
        }
    }

    private static class StoreAppAttemptTransition
    implements SingleArcTransition<RMStateStore, RMStateStoreEvent> {
        private StoreAppAttemptTransition() {
        }

        public void transition(RMStateStore store, RMStateStoreEvent event) {
            if (!(event instanceof RMStateStoreAppAttemptEvent)) {
                LOG.error((Object)("Illegal event type: " + ((Object)((Object)event)).getClass()));
                return;
            }
            ApplicationAttemptState attemptState = ((RMStateStoreAppAttemptEvent)event).getAppAttemptState();
            try {
                ApplicationAttemptStateData attemptStateData = ApplicationAttemptStateData.newInstance(attemptState);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Storing info for attempt: " + attemptState.getAttemptId()));
                }
                store.storeApplicationAttemptStateInternal(attemptState.getAttemptId(), attemptStateData);
                store.notifyApplicationAttempt(new RMAppAttemptEvent(attemptState.getAttemptId(), RMAppAttemptEventType.ATTEMPT_NEW_SAVED));
            }
            catch (Exception e) {
                LOG.error((Object)("Error storing appAttempt: " + attemptState.getAttemptId()), (Throwable)e);
                store.notifyStoreOperationFailed(e);
            }
        }
    }

    private static class RemoveAppTransition
    implements SingleArcTransition<RMStateStore, RMStateStoreEvent> {
        private RemoveAppTransition() {
        }

        public void transition(RMStateStore store, RMStateStoreEvent event) {
            if (!(event instanceof RMStateStoreRemoveAppEvent)) {
                LOG.error((Object)("Illegal event type: " + ((Object)((Object)event)).getClass()));
                return;
            }
            ApplicationState appState = ((RMStateStoreRemoveAppEvent)event).getAppState();
            ApplicationId appId = appState.getAppId();
            LOG.info((Object)("Removing info for app: " + appId));
            try {
                store.removeApplicationStateInternal(appState);
            }
            catch (Exception e) {
                LOG.error((Object)("Error removing app: " + appId), (Throwable)e);
                store.notifyStoreOperationFailed(e);
            }
        }
    }

    private static class UpdateAppTransition
    implements SingleArcTransition<RMStateStore, RMStateStoreEvent> {
        private UpdateAppTransition() {
        }

        public void transition(RMStateStore store, RMStateStoreEvent event) {
            if (!(event instanceof RMStateUpdateAppEvent)) {
                LOG.error((Object)("Illegal event type: " + ((Object)((Object)event)).getClass()));
                return;
            }
            ApplicationState appState = ((RMStateUpdateAppEvent)event).getAppState();
            ApplicationId appId = appState.getAppId();
            ApplicationStateData appStateData = ApplicationStateData.newInstance(appState);
            LOG.info((Object)("Updating info for app: " + appId));
            try {
                store.updateApplicationStateInternal(appId, appStateData);
                store.notifyApplication(new RMAppEvent(appId, RMAppEventType.APP_UPDATE_SAVED));
            }
            catch (Exception e) {
                LOG.error((Object)("Error updating app: " + appId), (Throwable)e);
                store.notifyStoreOperationFailed(e);
            }
        }
    }

    private static class StoreAppTransition
    implements SingleArcTransition<RMStateStore, RMStateStoreEvent> {
        private StoreAppTransition() {
        }

        public void transition(RMStateStore store, RMStateStoreEvent event) {
            if (!(event instanceof RMStateStoreAppEvent)) {
                LOG.error((Object)("Illegal event type: " + ((Object)((Object)event)).getClass()));
                return;
            }
            ApplicationState appState = ((RMStateStoreAppEvent)event).getAppState();
            ApplicationId appId = appState.getAppId();
            ApplicationStateData appStateData = ApplicationStateData.newInstance(appState);
            LOG.info((Object)("Storing info for app: " + appId));
            try {
                store.storeApplicationStateInternal(appId, appStateData);
                store.notifyApplication(new RMAppEvent(appId, RMAppEventType.APP_NEW_SAVED));
            }
            catch (Exception e) {
                LOG.error((Object)("Error storing app: " + appId), (Throwable)e);
                store.notifyStoreOperationFailed(e);
            }
        }
    }

    private static enum RMStateStoreState {
        DEFAULT;

    }
}

