/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.RpcCallback;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.SocketFactory;
import javax.security.sasl.SaslException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.exceptions.ConnectionClosingException;
import org.apache.hadoop.hbase.ipc.AbstractRpcClient;
import org.apache.hadoop.hbase.ipc.Call;
import org.apache.hadoop.hbase.ipc.ConnectionId;
import org.apache.hadoop.hbase.ipc.FailedServerException;
import org.apache.hadoop.hbase.ipc.FailedServers;
import org.apache.hadoop.hbase.ipc.FatalConnectionException;
import org.apache.hadoop.hbase.ipc.IPCUtil;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.RemoteWithExtrasException;
import org.apache.hadoop.hbase.ipc.StoppedRpcClientException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AuthenticationProtos;
import org.apache.hadoop.hbase.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.protobuf.generated.TracingProtos;
import org.apache.hadoop.hbase.security.AuthMethod;
import org.apache.hadoop.hbase.security.HBaseSaslRpcClient;
import org.apache.hadoop.hbase.security.SaslUtil;
import org.apache.hadoop.hbase.security.SecurityInfo;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenSelector;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ExceptionUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.PoolMap;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.SocketInputWrapper;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenSelector;
import org.apache.htrace.Span;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;

@InterfaceAudience.Private
public class RpcClientImpl
extends AbstractRpcClient {
    protected final AtomicInteger callIdCnt = new AtomicInteger();
    protected final PoolMap<ConnectionId, Connection> connections;
    protected final AtomicBoolean running = new AtomicBoolean(true);
    protected final FailedServers failedServers;
    protected final SocketFactory socketFactory;
    protected static final Map<AuthenticationProtos.TokenIdentifier.Kind, TokenSelector<? extends TokenIdentifier>> tokenHandlers = new HashMap<AuthenticationProtos.TokenIdentifier.Kind, TokenSelector<? extends TokenIdentifier>>();

    protected Connection createConnection(ConnectionId remoteId, Codec codec, CompressionCodec compressor) throws IOException {
        return new Connection(remoteId, codec, compressor);
    }

    RpcClientImpl(Configuration conf, String clusterId, SocketFactory factory) {
        this(conf, clusterId, factory, null);
    }

    RpcClientImpl(Configuration conf, String clusterId, SocketFactory factory, SocketAddress localAddr) {
        super(conf, clusterId, localAddr);
        this.socketFactory = factory;
        this.connections = new PoolMap(RpcClientImpl.getPoolType(conf), RpcClientImpl.getPoolSize(conf));
        this.failedServers = new FailedServers(conf);
    }

    public RpcClientImpl(Configuration conf, String clusterId) {
        this(conf, clusterId, NetUtils.getDefaultSocketFactory((Configuration)conf), null);
    }

    public RpcClientImpl(Configuration conf, String clusterId, SocketAddress localAddr) {
        this(conf, clusterId, NetUtils.getDefaultSocketFactory((Configuration)conf), localAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Stopping rpc client");
        }
        if (!this.running.compareAndSet(true, false)) {
            return;
        }
        HashSet<Connection> connsToClose = null;
        PoolMap<ConnectionId, Connection> poolMap = this.connections;
        synchronized (poolMap) {
            for (Connection conn : this.connections.values()) {
                conn.interrupt();
                if (conn.callSender != null) {
                    conn.callSender.interrupt();
                }
                if (conn.isAlive()) continue;
                if (connsToClose == null) {
                    connsToClose = new HashSet<Connection>();
                }
                connsToClose.add(conn);
            }
        }
        if (connsToClose != null) {
            for (Connection conn : connsToClose) {
                conn.markClosed(new InterruptedIOException("RpcClient is closing"));
                conn.close();
            }
        }
        while (!this.connections.isEmpty()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                LOG.info((Object)("Interrupted while stopping the client. We still have " + this.connections.size() + " connections."));
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Pair<Message, CellScanner> call(PayloadCarryingRpcController pcrc, Descriptors.MethodDescriptor md, Message param, Message returnType, User ticket, InetSocketAddress addr) throws IOException, InterruptedException {
        CallFuture cts;
        if (pcrc == null) {
            pcrc = new PayloadCarryingRpcController();
        }
        CellScanner cells = pcrc.cellScanner();
        Call call = new Call(this.callIdCnt.getAndIncrement(), md, param, cells, returnType, pcrc.getCallTimeout());
        final Connection connection = this.getConnection(ticket, call, addr);
        if (connection.callSender != null) {
            cts = connection.callSender.sendCall(call, pcrc.getPriority(), Trace.currentSpan());
            pcrc.notifyOnCancel(new RpcCallback<Object>(){

                public void run(Object parameter) {
                    connection.callSender.remove(cts);
                }
            });
            if (pcrc.isCanceled()) {
                call.callComplete();
                return new Pair((Object)call.response, (Object)call.cells);
            }
        } else {
            cts = null;
            connection.tracedWriteRequest(call, pcrc.getPriority(), Trace.currentSpan());
        }
        while (!call.done) {
            if (call.checkAndSetTimeout()) {
                if (cts == null) break;
                connection.callSender.remove(cts);
                break;
            }
            if (connection.shouldCloseConnection.get()) {
                throw new ConnectionClosingException("Call id=" + call.id + " on server " + addr + " aborted: connection is closing");
            }
            try {
                Call call2 = call;
                synchronized (call2) {
                    if (call.done) {
                        break;
                    }
                    call.wait(Math.min(call.remainingTime(), 1000) + 1);
                }
            }
            catch (InterruptedException e) {
                call.setException(new InterruptedIOException());
                if (cts != null) {
                    connection.callSender.remove(cts);
                }
                throw e;
            }
        }
        if (call.error != null) {
            if (call.error instanceof RemoteException) {
                call.error.fillInStackTrace();
                throw call.error;
            }
            throw this.wrapException(addr, call.error);
        }
        return new Pair((Object)call.response, (Object)call.cells);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelConnections(ServerName sn) {
        PoolMap<ConnectionId, Connection> poolMap = this.connections;
        synchronized (poolMap) {
            for (Connection connection : this.connections.values()) {
                if (!connection.isAlive() || connection.getRemoteAddress().getPort() != sn.getPort() || !connection.getRemoteAddress().getHostName().equals(sn.getHostname())) continue;
                LOG.info((Object)("The server on " + sn.toString() + " is dead - stopping the connection " + connection.remoteId));
                connection.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection getConnection(User ticket, Call call, InetSocketAddress addr) throws IOException {
        Connection connection;
        if (!this.running.get()) {
            throw new StoppedRpcClientException();
        }
        ConnectionId remoteId = new ConnectionId(ticket, call.md.getService().getName(), addr);
        PoolMap<ConnectionId, Connection> poolMap = this.connections;
        synchronized (poolMap) {
            connection = this.connections.get(remoteId);
            if (connection == null) {
                connection = this.createConnection(remoteId, this.codec, this.compressor);
                this.connections.put(remoteId, connection);
            }
        }
        return connection;
    }

    static {
        tokenHandlers.put(AuthenticationProtos.TokenIdentifier.Kind.HBASE_AUTH_TOKEN, new AuthenticationTokenSelector());
    }

    protected class Connection
    extends Thread {
        private RPCProtos.ConnectionHeader header;
        protected ConnectionId remoteId;
        protected Socket socket = null;
        protected DataInputStream in;
        protected DataOutputStream out;
        private Object outLock = new Object();
        private InetSocketAddress server;
        private String serverPrincipal;
        private AuthMethod authMethod;
        private boolean useSasl;
        private Token<? extends TokenIdentifier> token;
        private HBaseSaslRpcClient saslRpcClient;
        private int reloginMaxBackoff;
        private final Codec codec;
        private final CompressionCodec compressor;
        protected final ConcurrentSkipListMap<Integer, Call> calls = new ConcurrentSkipListMap();
        protected final AtomicBoolean shouldCloseConnection = new AtomicBoolean();
        protected final CallSender callSender;

        Connection(ConnectionId remoteId, Codec codec, CompressionCodec compressor) throws IOException {
            if (remoteId.getAddress().isUnresolved()) {
                throw new UnknownHostException("unknown host: " + remoteId.getAddress().getHostName());
            }
            this.server = remoteId.getAddress();
            this.codec = codec;
            this.compressor = compressor;
            UserGroupInformation ticket = remoteId.getTicket().getUGI();
            SecurityInfo securityInfo = SecurityInfo.getInfo(remoteId.getServiceName());
            this.useSasl = RpcClientImpl.this.userProvider.isHBaseSecurityEnabled();
            if (this.useSasl && securityInfo != null) {
                String serverKey;
                AuthenticationProtos.TokenIdentifier.Kind tokenKind = securityInfo.getTokenKind();
                if (tokenKind != null) {
                    TokenSelector<? extends TokenIdentifier> tokenSelector = tokenHandlers.get(tokenKind);
                    if (tokenSelector != null) {
                        this.token = tokenSelector.selectToken(new Text(RpcClientImpl.this.clusterId), ticket.getTokens());
                    } else if (AbstractRpcClient.LOG.isDebugEnabled()) {
                        AbstractRpcClient.LOG.debug((Object)("No token selector found for type " + tokenKind));
                    }
                }
                if ((serverKey = securityInfo.getServerPrincipal()) == null) {
                    throw new IOException("Can't obtain server Kerberos config key from SecurityInfo");
                }
                this.serverPrincipal = SecurityUtil.getServerPrincipal((String)RpcClientImpl.this.conf.get(serverKey), (String)this.server.getAddress().getCanonicalHostName().toLowerCase());
                if (AbstractRpcClient.LOG.isDebugEnabled()) {
                    AbstractRpcClient.LOG.debug((Object)("RPC Server Kerberos principal name for service=" + remoteId.getServiceName() + " is " + this.serverPrincipal));
                }
            }
            this.authMethod = !this.useSasl ? AuthMethod.SIMPLE : (this.token != null ? AuthMethod.DIGEST : AuthMethod.KERBEROS);
            if (AbstractRpcClient.LOG.isDebugEnabled()) {
                AbstractRpcClient.LOG.debug((Object)("Use " + (Object)((Object)this.authMethod) + " authentication for service " + remoteId.serviceName + ", sasl=" + this.useSasl));
            }
            this.reloginMaxBackoff = RpcClientImpl.this.conf.getInt("hbase.security.relogin.maxbackoff", 5000);
            this.remoteId = remoteId;
            RPCProtos.ConnectionHeader.Builder builder = RPCProtos.ConnectionHeader.newBuilder();
            builder.setServiceName(remoteId.getServiceName());
            RPCProtos.UserInformation userInfoPB = this.getUserInfo(ticket);
            if (userInfoPB != null) {
                builder.setUserInfo(userInfoPB);
            }
            if (this.codec != null) {
                builder.setCellBlockCodecClass(this.codec.getClass().getCanonicalName());
            }
            if (this.compressor != null) {
                builder.setCellBlockCompressorClass(this.compressor.getClass().getCanonicalName());
            }
            builder.setVersionInfo(ProtobufUtil.getVersionInfo());
            this.header = builder.build();
            this.setName("IPC Client (" + RpcClientImpl.this.socketFactory.hashCode() + ") connection to " + remoteId.getAddress().toString() + (ticket == null ? " from an unknown user" : " from " + ticket.getUserName()));
            this.setDaemon(true);
            if (RpcClientImpl.this.conf.getBoolean("hbase.ipc.client.specificThreadForWriting", false)) {
                this.callSender = new CallSender(this.getName(), RpcClientImpl.this.conf);
                this.callSender.start();
            } else {
                this.callSender = null;
            }
        }

        private RPCProtos.UserInformation getUserInfo(UserGroupInformation ugi) {
            if (ugi == null || this.authMethod == AuthMethod.DIGEST) {
                return null;
            }
            RPCProtos.UserInformation.Builder userInfoPB = RPCProtos.UserInformation.newBuilder();
            if (this.authMethod == AuthMethod.KERBEROS) {
                userInfoPB.setEffectiveUser(ugi.getUserName());
            } else if (this.authMethod == AuthMethod.SIMPLE) {
                userInfoPB.setEffectiveUser(ugi.getUserName());
                if (ugi.getRealUser() != null) {
                    userInfoPB.setRealUser(ugi.getRealUser().getUserName());
                }
            }
            return userInfoPB.build();
        }

        protected synchronized void setupConnection() throws IOException {
            int ioFailures = 0;
            int timeoutFailures = 0;
            while (true) {
                try {
                    this.socket = RpcClientImpl.this.socketFactory.createSocket();
                    this.socket.setTcpNoDelay(RpcClientImpl.this.tcpNoDelay);
                    this.socket.setKeepAlive(RpcClientImpl.this.tcpKeepAlive);
                    if (RpcClientImpl.this.localAddr != null) {
                        this.socket.bind(RpcClientImpl.this.localAddr);
                    }
                    NetUtils.connect((Socket)this.socket, (SocketAddress)this.remoteId.getAddress(), (int)RpcClientImpl.this.connectTO);
                    this.socket.setSoTimeout(RpcClientImpl.this.readTO);
                    return;
                }
                catch (SocketTimeoutException toe) {
                    int n = timeoutFailures;
                    timeoutFailures = (short)(timeoutFailures + 1);
                    this.handleConnectionFailure(n, RpcClientImpl.this.maxRetries, toe);
                    continue;
                }
                catch (IOException ie) {
                    int n = ioFailures;
                    ioFailures = (short)(ioFailures + 1);
                    this.handleConnectionFailure(n, RpcClientImpl.this.maxRetries, ie);
                    continue;
                }
                break;
            }
        }

        protected synchronized void closeConnection() {
            block14: {
                block13: {
                    block12: {
                        if (this.socket == null) {
                            return;
                        }
                        try {
                            if (this.socket.getOutputStream() != null) {
                                this.socket.getOutputStream().close();
                            }
                        }
                        catch (IOException ignored) {
                            if (!AbstractRpcClient.LOG.isTraceEnabled()) break block12;
                            AbstractRpcClient.LOG.trace((Object)"ignored", (Throwable)ignored);
                        }
                    }
                    try {
                        if (this.socket.getInputStream() != null) {
                            this.socket.getInputStream().close();
                        }
                    }
                    catch (IOException ignored) {
                        if (!AbstractRpcClient.LOG.isTraceEnabled()) break block13;
                        AbstractRpcClient.LOG.trace((Object)"ignored", (Throwable)ignored);
                    }
                }
                try {
                    if (this.socket.getChannel() != null) {
                        this.socket.getChannel().close();
                    }
                }
                catch (IOException ignored) {
                    if (!AbstractRpcClient.LOG.isTraceEnabled()) break block14;
                    AbstractRpcClient.LOG.trace((Object)"ignored", (Throwable)ignored);
                }
            }
            try {
                this.socket.close();
            }
            catch (IOException e) {
                AbstractRpcClient.LOG.warn((Object)"Not able to close a socket", (Throwable)e);
            }
            this.socket = null;
        }

        private void handleConnectionFailure(int curRetries, int maxRetries, IOException ioe) throws IOException {
            this.closeConnection();
            if (curRetries >= maxRetries || ExceptionUtil.isInterrupt((Throwable)ioe)) {
                throw ioe;
            }
            try {
                Thread.sleep(RpcClientImpl.this.failureSleep);
            }
            catch (InterruptedException ie) {
                ExceptionUtil.rethrowIfInterrupt((Throwable)ie);
            }
            AbstractRpcClient.LOG.info((Object)("Retrying connect to server: " + this.remoteId.getAddress() + " after sleeping " + RpcClientImpl.this.failureSleep + "ms. Already tried " + curRetries + " time(s)."));
        }

        private void checkIsOpen() throws IOException {
            if (this.shouldCloseConnection.get()) {
                throw new ConnectionClosingException(this.getName() + " is closing");
            }
        }

        protected synchronized boolean waitForWork() throws InterruptedException {
            long waitUntil = EnvironmentEdgeManager.currentTime() + (long)RpcClientImpl.this.minIdleTimeBeforeClose;
            while (!this.shouldCloseConnection.get()) {
                if (!RpcClientImpl.this.running.get()) {
                    this.markClosed(new IOException("stopped with " + this.calls.size() + " pending request(s)"));
                    return false;
                }
                if (!this.calls.isEmpty()) {
                    return true;
                }
                if (EnvironmentEdgeManager.currentTime() >= waitUntil) {
                    this.markClosed(new IOException("idle connection closed with " + this.calls.size() + " pending request(s)"));
                    return false;
                }
                this.wait(Math.min(RpcClientImpl.this.minIdleTimeBeforeClose, 1000));
            }
            return false;
        }

        public InetSocketAddress getRemoteAddress() {
            return this.remoteId.getAddress();
        }

        @Override
        public void run() {
            if (AbstractRpcClient.LOG.isTraceEnabled()) {
                AbstractRpcClient.LOG.trace((Object)(this.getName() + ": starting, connections " + RpcClientImpl.this.connections.size()));
            }
            try {
                while (this.waitForWork()) {
                    this.readResponse();
                }
            }
            catch (InterruptedException t) {
                if (AbstractRpcClient.LOG.isTraceEnabled()) {
                    AbstractRpcClient.LOG.trace((Object)(this.getName() + ": interrupted while waiting for call responses"));
                }
                this.markClosed(ExceptionUtil.asInterrupt((Throwable)t));
            }
            catch (Throwable t) {
                if (AbstractRpcClient.LOG.isDebugEnabled()) {
                    AbstractRpcClient.LOG.debug((Object)(this.getName() + ": unexpected throwable while waiting for call responses"), t);
                }
                this.markClosed(new IOException("Unexpected throwable while waiting call responses", t));
            }
            this.close();
            if (AbstractRpcClient.LOG.isTraceEnabled()) {
                AbstractRpcClient.LOG.trace((Object)(this.getName() + ": stopped, connections " + RpcClientImpl.this.connections.size()));
            }
        }

        private synchronized void disposeSasl() {
            if (this.saslRpcClient != null) {
                try {
                    this.saslRpcClient.dispose();
                    this.saslRpcClient = null;
                }
                catch (IOException ioe) {
                    AbstractRpcClient.LOG.error((Object)"Error disposing of SASL client", (Throwable)ioe);
                }
            }
        }

        private synchronized boolean shouldAuthenticateOverKrb() throws IOException {
            UserGroupInformation loginUser = UserGroupInformation.getLoginUser();
            UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
            UserGroupInformation realUser = currentUser.getRealUser();
            return this.authMethod == AuthMethod.KERBEROS && loginUser != null && loginUser.hasKerberosCredentials() && (loginUser.equals((Object)currentUser) || loginUser.equals((Object)realUser));
        }

        private synchronized boolean setupSaslConnection(InputStream in2, OutputStream out2) throws IOException {
            this.saslRpcClient = new HBaseSaslRpcClient(this.authMethod, this.token, this.serverPrincipal, RpcClientImpl.this.fallbackAllowed, RpcClientImpl.this.conf.get("hbase.rpc.protection", SaslUtil.QualityOfProtection.AUTHENTICATION.name().toLowerCase()));
            return this.saslRpcClient.saslConnect(in2, out2);
        }

        private synchronized void handleSaslConnectionFailure(final int currRetries, final int maxRetries, final Exception ex, final Random rand, UserGroupInformation user) throws IOException, InterruptedException {
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IOException, InterruptedException {
                    Connection.this.closeConnection();
                    if (Connection.this.shouldAuthenticateOverKrb()) {
                        if (currRetries < maxRetries) {
                            if (AbstractRpcClient.LOG.isDebugEnabled()) {
                                AbstractRpcClient.LOG.debug((Object)("Exception encountered while connecting to the server : " + ex));
                            }
                            if (UserGroupInformation.isLoginKeytabBased()) {
                                UserGroupInformation.getLoginUser().reloginFromKeytab();
                            } else {
                                UserGroupInformation.getLoginUser().reloginFromTicketCache();
                            }
                            Connection.this.disposeSasl();
                            Thread.sleep(rand.nextInt(Connection.this.reloginMaxBackoff) + 1);
                            return null;
                        }
                        String msg = "Couldn't setup connection for " + UserGroupInformation.getLoginUser().getUserName() + " to " + Connection.this.serverPrincipal;
                        AbstractRpcClient.LOG.warn((Object)msg, (Throwable)ex);
                        throw (IOException)new IOException(msg).initCause(ex);
                    }
                    AbstractRpcClient.LOG.warn((Object)("Exception encountered while connecting to the server : " + ex));
                    if (ex instanceof RemoteException) {
                        throw (RemoteException)ex;
                    }
                    if (ex instanceof SaslException) {
                        String msg = "SASL authentication failed. The most likely cause is missing or invalid credentials. Consider 'kinit'.";
                        AbstractRpcClient.LOG.fatal((Object)msg, (Throwable)ex);
                        throw new RuntimeException(msg, ex);
                    }
                    throw new IOException(ex);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void setupIOstreams() throws IOException {
            if (this.socket != null) {
                return;
            }
            if (this.shouldCloseConnection.get()) {
                throw new ConnectionClosingException("This connection is closing");
            }
            if (RpcClientImpl.this.failedServers.isFailedServer(this.remoteId.getAddress())) {
                if (AbstractRpcClient.LOG.isDebugEnabled()) {
                    AbstractRpcClient.LOG.debug((Object)("Not trying to connect to " + this.server + " this server is in the failed servers list"));
                }
                FailedServerException e = new FailedServerException("This server is in the failed servers list: " + this.server);
                this.markClosed((IOException)((Object)e));
                this.close();
                throw e;
            }
            try {
                OutputStream outStream;
                Object inStream;
                block19: {
                    boolean continueSasl;
                    if (AbstractRpcClient.LOG.isDebugEnabled()) {
                        AbstractRpcClient.LOG.debug((Object)("Connecting to " + this.server));
                    }
                    int numRetries = 0;
                    int MAX_RETRIES = 5;
                    Random rand = null;
                    while (true) {
                        this.setupConnection();
                        inStream = NetUtils.getInputStream((Socket)this.socket);
                        outStream = NetUtils.getOutputStream((Socket)this.socket, (long)RpcClientImpl.this.writeTO);
                        this.writeConnectionHeaderPreamble(outStream);
                        if (!this.useSasl) break block19;
                        SocketInputWrapper in2 = inStream;
                        OutputStream out2 = outStream;
                        UserGroupInformation ticket = this.remoteId.getTicket().getUGI();
                        if (this.authMethod == AuthMethod.KERBEROS && ticket != null && ticket.getRealUser() != null) {
                            ticket = ticket.getRealUser();
                        }
                        if (ticket == null) {
                            throw new FatalConnectionException("ticket/user is null");
                        }
                        try {
                            continueSasl = (Boolean)ticket.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Boolean>((InputStream)in2, out2){
                                final /* synthetic */ InputStream val$in2;
                                final /* synthetic */ OutputStream val$out2;
                                {
                                    this.val$in2 = inputStream;
                                    this.val$out2 = outputStream;
                                }

                                @Override
                                public Boolean run() throws IOException {
                                    return Connection.this.setupSaslConnection(this.val$in2, this.val$out2);
                                }
                            });
                        }
                        catch (Exception ex) {
                            ExceptionUtil.rethrowIfInterrupt((Throwable)ex);
                            if (rand == null) {
                                rand = new Random();
                            }
                            int n = numRetries;
                            numRetries = (short)(numRetries + 1);
                            this.handleSaslConnectionFailure(n, 5, ex, rand, ticket);
                            continue;
                        }
                        break;
                    }
                    if (continueSasl) {
                        inStream = this.saslRpcClient.getInputStream((InputStream)inStream);
                        outStream = this.saslRpcClient.getOutputStream(outStream);
                    } else {
                        this.authMethod = AuthMethod.SIMPLE;
                        this.useSasl = false;
                    }
                }
                this.in = new DataInputStream(new BufferedInputStream((InputStream)inStream));
                Object object = this.outLock;
                synchronized (object) {
                    this.out = new DataOutputStream(new BufferedOutputStream(outStream));
                }
                this.writeConnectionHeader();
                this.start();
                return;
            }
            catch (Throwable t) {
                Object e = ExceptionUtil.asInterrupt((Throwable)t);
                if (e == null) {
                    RpcClientImpl.this.failedServers.addToFailedServers(this.remoteId.address);
                    e = t instanceof LinkageError ? new DoNotRetryIOException(t) : (t instanceof IOException ? (IOException)t : new IOException("Could not set up IO Streams to " + this.server, t));
                }
                this.markClosed((IOException)e);
                this.close();
                throw e;
            }
        }

        private void writeConnectionHeaderPreamble(OutputStream outStream) throws IOException {
            int rpcHeaderLen = HConstants.RPC_HEADER.length;
            byte[] preamble = new byte[rpcHeaderLen + 2];
            System.arraycopy(HConstants.RPC_HEADER, 0, preamble, 0, rpcHeaderLen);
            preamble[rpcHeaderLen] = 0;
            preamble[rpcHeaderLen + 1] = this.authMethod.code;
            outStream.write(preamble);
            outStream.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void writeConnectionHeader() throws IOException {
            Object object = this.outLock;
            synchronized (object) {
                this.out.writeInt(this.header.getSerializedSize());
                this.header.writeTo((OutputStream)this.out);
                this.out.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void close() {
            if (!this.shouldCloseConnection.get()) {
                AbstractRpcClient.LOG.error((Object)(this.getName() + ": the connection is not in the closed state"));
                return;
            }
            Object object = RpcClientImpl.this.connections;
            synchronized (object) {
                RpcClientImpl.this.connections.removeValue(this.remoteId, this);
            }
            object = this.outLock;
            synchronized (object) {
                if (this.out != null) {
                    IOUtils.closeStream((Closeable)this.out);
                    this.out = null;
                }
            }
            IOUtils.closeStream((Closeable)this.in);
            this.in = null;
            if (this.socket != null) {
                try {
                    this.socket.close();
                    this.socket = null;
                }
                catch (IOException e) {
                    AbstractRpcClient.LOG.error((Object)"Error while closing socket", (Throwable)e);
                }
            }
            this.disposeSasl();
            if (AbstractRpcClient.LOG.isTraceEnabled()) {
                AbstractRpcClient.LOG.trace((Object)(this.getName() + ": closing ipc connection to " + this.server));
            }
            this.cleanupCalls(true);
            if (AbstractRpcClient.LOG.isTraceEnabled()) {
                AbstractRpcClient.LOG.trace((Object)(this.getName() + ": ipc connection to " + this.server + " closed"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void tracedWriteRequest(Call call, int priority, Span span) throws IOException {
            try (TraceScope ts = Trace.startSpan((String)"RpcClientImpl.tracedWriteRequest", (Span)span);){
                this.writeRequest(call, priority, span);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeRequest(Call call, int priority, Span span) throws IOException {
            RPCProtos.RequestHeader.Builder builder = RPCProtos.RequestHeader.newBuilder();
            builder.setCallId(call.id);
            if (span != null) {
                builder.setTraceInfo(TracingProtos.RPCTInfo.newBuilder().setParentId(span.getSpanId()).setTraceId(span.getTraceId()));
            }
            builder.setMethodName(call.md.getName());
            builder.setRequestParam(call.param != null);
            ByteBuffer cellBlock = RpcClientImpl.this.ipcUtil.buildCellBlock(this.codec, this.compressor, call.cells);
            if (cellBlock != null) {
                RPCProtos.CellBlockMeta.Builder cellBlockBuilder = RPCProtos.CellBlockMeta.newBuilder();
                cellBlockBuilder.setLength(cellBlock.limit());
                builder.setCellBlockMeta(cellBlockBuilder.build());
            }
            if (priority != 0) {
                builder.setPriority(priority);
            }
            RPCProtos.RequestHeader header = builder.build();
            this.setupIOstreams();
            this.checkIsOpen();
            IOException writeException = null;
            Object object = this.outLock;
            synchronized (object) {
                if (Thread.interrupted()) {
                    throw new InterruptedIOException();
                }
                this.calls.put(call.id, call);
                this.checkIsOpen();
                try {
                    IPCUtil.write(this.out, (Message)header, call.param, cellBlock);
                }
                catch (IOException e) {
                    this.shouldCloseConnection.set(true);
                    writeException = e;
                    this.interrupt();
                }
            }
            if (writeException != null) {
                this.markClosed(writeException);
                this.close();
            }
            object = this;
            synchronized (object) {
                this.notifyAll();
            }
            if (writeException != null) {
                throw writeException;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void readResponse() {
            if (this.shouldCloseConnection.get()) {
                return;
            }
            Call call = null;
            boolean expectedCall = false;
            try {
                int totalSize = this.in.readInt();
                RPCProtos.ResponseHeader responseHeader = RPCProtos.ResponseHeader.parseDelimitedFrom((InputStream)this.in);
                int id = responseHeader.getCallId();
                call = this.calls.remove(id);
                boolean bl = expectedCall = call != null && !call.done;
                if (!expectedCall) {
                    int readSoFar = IPCUtil.getTotalSizeWhenWrittenDelimited(new Message[]{responseHeader});
                    int whatIsLeftToRead = totalSize - readSoFar;
                    IOUtils.skipFully((InputStream)this.in, (long)whatIsLeftToRead);
                    return;
                }
                if (responseHeader.hasException()) {
                    RPCProtos.ExceptionResponse exceptionResponse = responseHeader.getException();
                    RemoteException re = this.createRemoteException(exceptionResponse);
                    call.setException((IOException)re);
                    if (this.isFatalConnectionException(exceptionResponse)) {
                        this.markClosed((IOException)re);
                    }
                } else {
                    Message value = null;
                    if (call.responseDefaultType != null) {
                        Message.Builder builder = call.responseDefaultType.newBuilderForType();
                        ProtobufUtil.mergeDelimitedFrom(builder, this.in);
                        value = builder.build();
                    }
                    CellScanner cellBlockScanner = null;
                    if (responseHeader.hasCellBlockMeta()) {
                        int size = responseHeader.getCellBlockMeta().getLength();
                        byte[] cellBlock = new byte[size];
                        IOUtils.readFully((InputStream)this.in, (byte[])cellBlock, (int)0, (int)cellBlock.length);
                        cellBlockScanner = RpcClientImpl.this.ipcUtil.createCellScanner(this.codec, this.compressor, cellBlock);
                    }
                    call.setResponse(value, cellBlockScanner);
                }
            }
            catch (IOException e) {
                if (expectedCall) {
                    call.setException(e);
                }
                if (e instanceof SocketTimeoutException) {
                    if (AbstractRpcClient.LOG.isTraceEnabled()) {
                        AbstractRpcClient.LOG.trace((Object)"ignored", (Throwable)e);
                    }
                } else {
                    this.markClosed(e);
                }
            }
            finally {
                this.cleanupCalls(false);
            }
        }

        private boolean isFatalConnectionException(RPCProtos.ExceptionResponse e) {
            return e.getExceptionClassName().equals(FatalConnectionException.class.getName());
        }

        private RemoteException createRemoteException(RPCProtos.ExceptionResponse e) {
            String innerExceptionClassName = e.getExceptionClassName();
            boolean doNotRetry = e.getDoNotRetry();
            return e.hasHostname() ? new RemoteWithExtrasException(innerExceptionClassName, e.getStackTrace(), e.getHostname(), e.getPort(), doNotRetry) : new RemoteWithExtrasException(innerExceptionClassName, e.getStackTrace(), doNotRetry);
        }

        protected synchronized boolean markClosed(IOException e) {
            if (e == null) {
                throw new NullPointerException();
            }
            boolean ret = this.shouldCloseConnection.compareAndSet(false, true);
            if (ret) {
                if (AbstractRpcClient.LOG.isTraceEnabled()) {
                    AbstractRpcClient.LOG.trace((Object)(this.getName() + ": marking at should close, reason: " + e.getMessage()));
                }
                if (this.callSender != null) {
                    this.callSender.close();
                }
                this.notifyAll();
            }
            return ret;
        }

        protected synchronized void cleanupCalls(boolean allCalls) {
            Iterator<Map.Entry<Integer, Call>> itor = this.calls.entrySet().iterator();
            while (itor.hasNext()) {
                Call c = itor.next().getValue();
                if (c.done) {
                    itor.remove();
                    continue;
                }
                if (allCalls) {
                    long waitTime = EnvironmentEdgeManager.currentTime() - c.getStartTime();
                    ConnectionClosingException ie = new ConnectionClosingException("Connection to " + this.getRemoteAddress() + " is closing. Call id=" + c.id + ", waitTime=" + waitTime);
                    c.setException(ie);
                    itor.remove();
                    continue;
                }
                if (!c.checkAndSetTimeout()) break;
                itor.remove();
            }
        }

        private class CallSender
        extends Thread
        implements Closeable {
            protected final BlockingQueue<CallFuture> callsToWrite;

            public CallFuture sendCall(Call call, int priority, Span span) throws InterruptedException, IOException {
                CallFuture cts = new CallFuture(call, priority, span);
                if (!this.callsToWrite.offer(cts)) {
                    throw new IOException("Can't add the call " + call.id + " to the write queue. callsToWrite.size()=" + this.callsToWrite.size());
                }
                Connection.this.checkIsOpen();
                return cts;
            }

            @Override
            public void close() {
                assert (Connection.this.shouldCloseConnection.get());
                this.callsToWrite.offer(CallFuture.DEATH_PILL);
            }

            CallSender(String name, Configuration conf) {
                int queueSize = conf.getInt("hbase.ipc.client.write.queueSize", 1000);
                this.callsToWrite = new ArrayBlockingQueue<CallFuture>(queueSize);
                this.setDaemon(true);
                this.setName(name + " - writer");
            }

            public void remove(CallFuture cts) {
                this.callsToWrite.remove(cts);
                Connection.this.calls.remove(cts.call.id);
                cts.call.callComplete();
            }

            @Override
            public void run() {
                while (!Connection.this.shouldCloseConnection.get()) {
                    CallFuture cts = null;
                    try {
                        cts = this.callsToWrite.take();
                    }
                    catch (InterruptedException e) {
                        Connection.this.markClosed(new InterruptedIOException());
                    }
                    if (cts == null || cts == CallFuture.DEATH_PILL) {
                        assert (Connection.this.shouldCloseConnection.get());
                        break;
                    }
                    if (cts.call.done || cts.call.checkAndSetTimeout()) continue;
                    try {
                        Connection.this.tracedWriteRequest(cts.call, cts.priority, cts.span);
                    }
                    catch (IOException e) {
                        if (AbstractRpcClient.LOG.isDebugEnabled()) {
                            AbstractRpcClient.LOG.debug((Object)("call write error for call #" + cts.call.id + ", message =" + e.getMessage()));
                        }
                        cts.call.setException(e);
                        Connection.this.markClosed(e);
                    }
                }
                this.cleanup();
            }

            private void cleanup() {
                CallFuture cts;
                assert (Connection.this.shouldCloseConnection.get());
                ConnectionClosingException ie = new ConnectionClosingException("Connection to " + Connection.this.server + " is closing.");
                while ((cts = (CallFuture)this.callsToWrite.poll()) != null) {
                    if (cts.call == null || cts.call.done) continue;
                    cts.call.setException(ie);
                }
            }
        }
    }

    private static class CallFuture {
        final Call call;
        final int priority;
        final Span span;
        static final CallFuture DEATH_PILL = new CallFuture(null, -1, null);

        CallFuture(Call call, int priority, Span span) {
            this.call = call;
            this.priority = priority;
            this.span = span;
        }
    }
}

